/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.replication;

import java.io.IOException;
import java.sql.DriverManager;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellBuilderFactory;
import org.apache.hadoop.hbase.CellBuilderType;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.replication.ChainWALEntryFilter;
import org.apache.hadoop.hbase.replication.WALEntryFilter;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALKeyImpl;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.hbase.index.wal.IndexedKeyValue;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.mapreduce.util.ConnectionUtil;
import org.apache.phoenix.replication.SystemCatalogWALEntryFilter;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class SystemCatalogWALEntryFilterIT
extends ParallelStatsDisabledIT {
    private static final byte[] REGION = Bytes.toBytes((String)"REGION");
    private static final UUID uuid = UUID.randomUUID();
    private static final String TENANT_ID = "1234567";
    private static final byte[] TENANT_BYTES = Bytes.toBytes((String)"1234567");
    private static final byte[] DEFAULT_TENANT_BYTES = null;
    private static final String SCHEMA_NAME = "SYSTEMCATALOGWALSCHEMA";
    private static final String TENANT_VIEW_NAME = SystemCatalogWALEntryFilterIT.generateUniqueName();
    private static final String NONTENANT_VIEW_NAME = SystemCatalogWALEntryFilterIT.generateUniqueName();
    private static final byte[] VIEW_COLUMN_FAMILY_BYTES = Bytes.toBytes((String)"0");
    private static final String VIEW_COLUMN_NAME = "OLD_VALUE_VIEW";
    private static final String CREATE_TENANT_VIEW_SQL = "CREATE VIEW IF NOT EXISTS  SYSTEMCATALOGWALSCHEMA." + TENANT_VIEW_NAME + "(" + "OLD_VALUE_VIEW" + " varchar)  AS SELECT * FROM " + "ENTITY_HISTORY" + " WHERE OLD_VALUE like 'E%'";
    private static final String CREATE_NONTENANT_VIEW_SQL = "CREATE VIEW IF NOT EXISTS  SYSTEMCATALOGWALSCHEMA." + NONTENANT_VIEW_NAME + "(" + "OLD_VALUE_VIEW" + " varchar)  AS SELECT * FROM " + "ENTITY_HISTORY" + " WHERE OLD_VALUE like 'E%'";
    private static final String DROP_TENANT_VIEW_SQL = "DROP VIEW IF EXISTS SYSTEMCATALOGWALSCHEMA." + TENANT_VIEW_NAME;
    private static final String DROP_NONTENANT_VIEW_SQL = "DROP VIEW IF EXISTS SYSTEMCATALOGWALSCHEMA." + NONTENANT_VIEW_NAME;
    private static PTable catalogTable;
    private static PTable childLinkTable;
    private static WALKeyImpl walKeyCatalog;
    private static WALKeyImpl walKeyChildLink;
    private static TableName systemCatalogTableName;
    private static TableName systemChildLinkTableName;

    @BeforeClass
    public static synchronized void setup() throws Exception {
        SystemCatalogWALEntryFilterIT.setUpTestDriver(ReadOnlyProps.EMPTY_PROPS);
        Properties tenantProperties = new Properties();
        tenantProperties.setProperty("TenantId", TENANT_ID);
        try (PhoenixConnection connection = (PhoenixConnection)ConnectionUtil.getInputConnection((Configuration)SystemCatalogWALEntryFilterIT.getUtility().getConfiguration(), (Properties)tenantProperties);){
            SystemCatalogWALEntryFilterIT.ensureTableCreated(SystemCatalogWALEntryFilterIT.getUrl(), "ENTITY_HISTORY");
            connection.createStatement().execute(CREATE_TENANT_VIEW_SQL);
            catalogTable = connection.getTable(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME);
            childLinkTable = connection.getTable(PhoenixDatabaseMetaData.SYSTEM_CHILD_LINK_NAME);
            walKeyCatalog = new WALKeyImpl(REGION, TableName.valueOf((String)PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME), 0L, 0L, uuid);
            walKeyChildLink = new WALKeyImpl(REGION, TableName.valueOf((String)PhoenixDatabaseMetaData.SYSTEM_CHILD_LINK_NAME), 0L, 0L, uuid);
        }
        Assert.assertNotNull((Object)catalogTable);
        SystemCatalogWALEntryFilterIT.createNonTenantView();
    }

    @AfterClass
    public static synchronized void tearDown() throws Exception {
        SystemCatalogWALEntryFilterIT.dropTenantView();
        SystemCatalogWALEntryFilterIT.dropNonTenantView();
    }

    @Test
    public void testOtherTablesAutoPass() throws Exception {
        WAL.Entry entry = new WAL.Entry(new WALKeyImpl(REGION, TableName.valueOf((String)"ENTITY_HISTORY"), System.currentTimeMillis()), new WALEdit());
        entry.getEdit().add(CellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow(Bytes.toBytes((String)"foo")).setType(Cell.Type.Put).build());
        SystemCatalogWALEntryFilter filter = new SystemCatalogWALEntryFilter();
        Assert.assertEquals((long)1L, (long)filter.filter(entry).getEdit().size());
    }

    @Test
    public void testSystemCatalogWALEntryFilter() throws Exception {
        Get tenantGetCatalog = this.getGet(catalogTable, TENANT_BYTES, TENANT_VIEW_NAME);
        Get nonTenantGetCatalog = this.getGet(catalogTable, DEFAULT_TENANT_BYTES, NONTENANT_VIEW_NAME);
        WAL.Entry nonTenantEntryCatalog = this.getEntry(systemCatalogTableName, nonTenantGetCatalog);
        WAL.Entry tenantEntryCatalog = this.getEntry(systemCatalogTableName, tenantGetCatalog);
        int tenantRowCount = this.getAndAssertCountInEdit(tenantEntryCatalog, true);
        Assert.assertTrue((tenantRowCount > 0 ? 1 : 0) != 0);
        SystemCatalogWALEntryFilter filter = new SystemCatalogWALEntryFilter();
        ChainWALEntryFilter chainWALEntryFilter = new ChainWALEntryFilter(new WALEntryFilter[]{filter});
        Assert.assertTrue((nonTenantEntryCatalog.getEdit().size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Non tenant edits for system catalog should not get filtered", (boolean)chainWALEntryFilter.filter(nonTenantEntryCatalog).getEdit().isEmpty());
        WAL.Entry filteredTenantEntryCatalog = chainWALEntryFilter.filter(tenantEntryCatalog);
        Assert.assertNotNull((String)"Tenant view was filtered when it shouldn't be!", (Object)filteredTenantEntryCatalog);
        Assert.assertEquals((String)"Not all data for replicated for tenant", (long)tenantRowCount, (long)this.getAndAssertCountInEdit(filteredTenantEntryCatalog, true));
        WALEdit comboEdit = new WALEdit();
        nonTenantEntryCatalog = this.getEntry(systemCatalogTableName, nonTenantGetCatalog);
        tenantEntryCatalog = this.getEntry(systemCatalogTableName, tenantGetCatalog);
        comboEdit.getCells().addAll(nonTenantEntryCatalog.getEdit().getCells());
        comboEdit.getCells().addAll(tenantEntryCatalog.getEdit().getCells());
        WAL.Entry comboEntry = new WAL.Entry(walKeyCatalog, comboEdit);
        Assert.assertEquals((long)(tenantEntryCatalog.getEdit().size() + nonTenantEntryCatalog.getEdit().size()), (long)comboEntry.getEdit().size());
        Assert.assertEquals((long)tenantEntryCatalog.getEdit().size(), (long)chainWALEntryFilter.filter(comboEntry).getEdit().size());
    }

    @Test
    public void testSystemChildLinkWALEntryFilter() throws Exception {
        Get tenantGetChildLink = this.getGetChildLink(childLinkTable, TENANT_BYTES, TENANT_VIEW_NAME);
        Get nonTenantGetChildLink = this.getGetChildLink(childLinkTable, DEFAULT_TENANT_BYTES, NONTENANT_VIEW_NAME);
        WAL.Entry tenantEntryChildLink = this.getEntry(systemChildLinkTableName, tenantGetChildLink);
        WAL.Entry nonTenantEntryChildLink = this.getEntry(systemChildLinkTableName, nonTenantGetChildLink);
        int tenantRowCount = this.getAndAssertCountInEdit(tenantEntryChildLink, true);
        Assert.assertTrue((tenantRowCount > 0 ? 1 : 0) != 0);
        SystemCatalogWALEntryFilter filter = new SystemCatalogWALEntryFilter();
        ChainWALEntryFilter chainWALEntryFilter = new ChainWALEntryFilter(new WALEntryFilter[]{filter});
        Assert.assertTrue((nonTenantEntryChildLink.getEdit().size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Non tenant edits for system child link should not get filtered", (boolean)chainWALEntryFilter.filter(nonTenantEntryChildLink).getEdit().isEmpty());
        WAL.Entry filteredTenantEntryChildLink = chainWALEntryFilter.filter(tenantEntryChildLink);
        Assert.assertNotNull((String)"Tenant view was filtered when it shouldn't be!", (Object)filteredTenantEntryChildLink);
        Assert.assertEquals((String)"Not all data for replicated for tenant", (long)tenantRowCount, (long)this.getAndAssertCountInEdit(filteredTenantEntryChildLink, true));
        WALEdit comboEdit = new WALEdit();
        comboEdit.getCells().addAll(nonTenantEntryChildLink.getEdit().getCells());
        comboEdit.getCells().addAll(tenantEntryChildLink.getEdit().getCells());
        WAL.Entry comboEntry = new WAL.Entry(walKeyChildLink, comboEdit);
        Assert.assertEquals((long)(tenantEntryChildLink.getEdit().size() + nonTenantEntryChildLink.getEdit().size()), (long)comboEntry.getEdit().size());
        Assert.assertEquals((long)tenantEntryChildLink.getEdit().size(), (long)chainWALEntryFilter.filter(comboEntry).getEdit().size());
    }

    @Test
    public void testDeleteMarkerForParentChildLink() throws Exception {
        WAL.Entry childLinkEntry = this.getEntry(systemChildLinkTableName, new Scan(), false);
        int tenantRowCount = this.getAndAssertCountInEdit(childLinkEntry, true);
        int nonTenantRowCount = this.getAndAssertCountInEdit(childLinkEntry, false);
        Assert.assertTrue((tenantRowCount > 0 && nonTenantRowCount > 0 ? 1 : 0) != 0);
        SystemCatalogWALEntryFilterIT.dropTenantView();
        SystemCatalogWALEntryFilterIT.dropNonTenantView();
        SystemCatalogWALEntryFilter filter = new SystemCatalogWALEntryFilter();
        ChainWALEntryFilter chainWALEntryFilter = new ChainWALEntryFilter(new WALEntryFilter[]{filter});
        childLinkEntry = this.getEntry(systemChildLinkTableName, new Scan(), false);
        int tenantDeleteCountBeforeFilter = this.getDeleteFamilyCellCountInEntry(childLinkEntry, true);
        int nonTenantDeleteCountBeforeFilter = this.getDeleteFamilyCellCountInEntry(childLinkEntry, false);
        Assert.assertTrue((tenantDeleteCountBeforeFilter > 0 && nonTenantDeleteCountBeforeFilter > 0 ? 1 : 0) != 0);
        WAL.Entry filteredEntry = chainWALEntryFilter.filter(childLinkEntry);
        int tenantDeleteCountAfterFilter = this.getDeleteFamilyCellCountInEntry(filteredEntry, true);
        int nonTenantDeleteCountAfterFilter = this.getDeleteFamilyCellCountInEntry(filteredEntry, false);
        Assert.assertTrue((tenantDeleteCountAfterFilter == tenantDeleteCountBeforeFilter && nonTenantDeleteCountAfterFilter == 0 ? 1 : 0) != 0);
        SystemCatalogWALEntryFilterIT.createTenantView();
        SystemCatalogWALEntryFilterIT.createNonTenantView();
    }

    private Get getGet(PTable catalogTable, byte[] tenantId, String viewName) {
        byte[][] tenantKeyParts = new byte[][]{tenantId, Bytes.toBytes((String)SCHEMA_NAME.toUpperCase()), Bytes.toBytes((String)viewName.toUpperCase()), Bytes.toBytes((String)VIEW_COLUMN_NAME), VIEW_COLUMN_FAMILY_BYTES};
        ImmutableBytesWritable key = new ImmutableBytesWritable();
        catalogTable.newKey(key, (byte[][])tenantKeyParts);
        return new Get(key.copyBytes());
    }

    private Get getGetChildLink(PTable catalogTable, byte[] tenantId, String viewName) {
        byte[][] tenantKeyParts = new byte[][]{ByteUtil.EMPTY_BYTE_ARRAY, ByteUtil.EMPTY_BYTE_ARRAY, Bytes.toBytes((String)"ENTITY_HISTORY"), tenantId, Bytes.toBytes((String)("SYSTEMCATALOGWALSCHEMA." + viewName.toUpperCase()))};
        ImmutableBytesWritable key = new ImmutableBytesWritable();
        catalogTable.newKey(key, (byte[][])tenantKeyParts);
        return new Get(key.copyBytes());
    }

    private boolean isTenantOwnedCell(Cell cell, String tenantId) {
        String row = Bytes.toString((byte[])cell.getRowArray(), (int)cell.getRowOffset(), (int)cell.getRowLength());
        boolean isTenantIdLeading = row.startsWith(tenantId);
        boolean isChildLinkForTenantId = row.contains(tenantId) && CellUtil.matchingQualifier((Cell)cell, (byte[])PhoenixDatabaseMetaData.LINK_TYPE_BYTES);
        boolean isDeleteMarkerForLinkRow = row.contains(tenantId) && cell.getType() == Cell.Type.DeleteFamily;
        return isTenantIdLeading || isChildLinkForTenantId || isDeleteMarkerForLinkRow;
    }

    private int getAndAssertCountInEdit(WAL.Entry entry, boolean tenantOwned) {
        int tenantCount = 0;
        int nonTenantCount = 0;
        for (Cell cell : entry.getEdit().getCells()) {
            if (this.isTenantOwnedCell(cell, TENANT_ID)) {
                ++tenantCount;
                continue;
            }
            ++nonTenantCount;
        }
        int count = tenantOwned ? tenantCount : nonTenantCount;
        Assert.assertTrue((count > 0 ? 1 : 0) != 0);
        return count;
    }

    private int getDeleteFamilyCellCountInEntry(WAL.Entry entry, boolean tenantOwned) {
        int tenantCount = 0;
        int nonTenantCount = 0;
        for (Cell cell : entry.getEdit().getCells()) {
            if (cell.getType() != Cell.Type.DeleteFamily) continue;
            if (this.isTenantOwnedCell(cell, TENANT_ID)) {
                ++tenantCount;
                continue;
            }
            ++nonTenantCount;
        }
        return tenantOwned ? tenantCount : nonTenantCount;
    }

    private WAL.Entry getEntry(TableName tableName, Get get) throws IOException {
        WAL.Entry entry = null;
        try (Connection conn = ConnectionFactory.createConnection((Configuration)SystemCatalogWALEntryFilterIT.getUtility().getConfiguration());){
            Table htable = conn.getTable(tableName);
            Result result = htable.get(get);
            WALEdit edit = new WALEdit();
            if (result != null) {
                List cellList = result.listCells();
                Assert.assertNotNull((String)String.format("Didn't retrieve any cells from table %s", tableName.getNameAsString()), (Object)cellList);
                for (Cell c : cellList) {
                    edit.add(c);
                }
            }
            Assert.assertTrue((String)String.format("Didn't retrieve any cells from table %s", tableName.getNameAsString()), (edit.getCells().size() > 0 ? 1 : 0) != 0);
            WALKeyImpl key = new WALKeyImpl(REGION, tableName, 0L, 0L, uuid);
            entry = new WAL.Entry(key, edit);
        }
        return entry;
    }

    private WAL.Entry getEntry(TableName tableName, Scan scan, boolean addIndexedKeyValueCell) throws IOException {
        WAL.Entry entry = null;
        try (Connection conn = ConnectionFactory.createConnection((Configuration)SystemCatalogWALEntryFilterIT.getUtility().getConfiguration());){
            Table htable = conn.getTable(tableName);
            scan.setRaw(true);
            ResultScanner scanner = htable.getScanner(scan);
            WALEdit edit = new WALEdit();
            if (addIndexedKeyValueCell) {
                edit.add((Cell)new IndexedKeyValue());
            }
            for (Result r : scanner) {
                if (r == null) continue;
                List cellList = r.listCells();
                for (Cell c : cellList) {
                    edit.add(c);
                }
            }
            Assert.assertFalse((String)"No WALEdits were loaded!", (boolean)edit.isEmpty());
            WALKeyImpl key = new WALKeyImpl(REGION, tableName, 0L, 0L, uuid);
            entry = new WAL.Entry(key, edit);
        }
        return entry;
    }

    private static void dropTenantView() throws Exception {
        Properties tenantProperties = new Properties();
        tenantProperties.setProperty("TenantId", TENANT_ID);
        try (java.sql.Connection connection = DriverManager.getConnection(SystemCatalogWALEntryFilterIT.getUrl(), tenantProperties);){
            connection.createStatement().execute(DROP_TENANT_VIEW_SQL);
            connection.commit();
        }
    }

    private static void dropNonTenantView() throws Exception {
        try (java.sql.Connection connection = DriverManager.getConnection(SystemCatalogWALEntryFilterIT.getUrl());){
            connection.createStatement().execute(DROP_NONTENANT_VIEW_SQL);
        }
    }

    private static void createTenantView() throws Exception {
        Properties tenantProperties = new Properties();
        tenantProperties.setProperty("TenantId", TENANT_ID);
        try (java.sql.Connection connection = DriverManager.getConnection(SystemCatalogWALEntryFilterIT.getUrl(), tenantProperties);){
            connection.createStatement().execute(CREATE_TENANT_VIEW_SQL);
            connection.commit();
        }
    }

    private static void createNonTenantView() throws Exception {
        try (java.sql.Connection connection = DriverManager.getConnection(SystemCatalogWALEntryFilterIT.getUrl());){
            connection.createStatement().execute(CREATE_NONTENANT_VIEW_SQL);
            connection.commit();
        }
    }

    static {
        walKeyCatalog = null;
        walKeyChildLink = null;
        systemCatalogTableName = TableName.valueOf((String)PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME);
        systemChildLinkTableName = TableName.valueOf((String)PhoenixDatabaseMetaData.SYSTEM_CHILD_LINK_NAME);
    }
}

