/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.query;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.phoenix.query.PropertyNotAllowedException;
import org.apache.phoenix.query.PropertyPolicy;

public class TestPropertyPolicy
implements PropertyPolicy {
    static final Set<String> propertiesKeyDisAllowed = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("DisallowedProperty")));

    public void evaluate(Properties properties) throws PropertyNotAllowedException {
        Properties offendingProperties = new Properties();
        for (Object k : properties.keySet()) {
            if (!propertiesKeyDisAllowed.contains(k)) continue;
            offendingProperties.put(k, properties.getProperty((String)k));
        }
        if (offendingProperties.size() > 0) {
            throw new PropertyNotAllowedException(offendingProperties);
        }
    }
}

