/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.query;

import java.lang.ref.WeakReference;
import java.sql.DriverManager;
import java.util.Properties;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.phoenix.iterate.RenewLeaseOnlyTableIterator;
import org.apache.phoenix.iterate.TableResultIterator;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.query.BaseConnectionlessQueryTest;
import org.apache.phoenix.query.ConnectionQueryServicesImpl;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;

public class ScannerLeaseRenewalTest
extends BaseConnectionlessQueryTest {
    @Test
    public void testRenewLeaseTaskBehavior() throws Exception {
        PhoenixConnection pconn = DriverManager.getConnection(ScannerLeaseRenewalTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES)).unwrap(PhoenixConnection.class);
        LinkedBlockingQueue<WeakReference<PhoenixConnection>> connectionsQueue = new LinkedBlockingQueue<WeakReference<PhoenixConnection>>();
        connectionsQueue.add(new WeakReference<PhoenixConnection>(pconn));
        int numLeaseRenewals = 4;
        int skipRenewLeaseCount = 2;
        int failToAcquireLockAt = 3;
        RenewLeaseOnlyTableIterator itr = new RenewLeaseOnlyTableIterator(numLeaseRenewals, skipRenewLeaseCount, failToAcquireLockAt, -1);
        LinkedBlockingQueue scannerQueue = pconn.getScanners();
        scannerQueue.add(new WeakReference<RenewLeaseOnlyTableIterator>(itr));
        ConnectionQueryServicesImpl.RenewLeaseTask task = new ConnectionQueryServicesImpl.RenewLeaseTask(connectionsQueue);
        Assert.assertTrue((connectionsQueue.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((scannerQueue.size() == 1 ? 1 : 0) != 0);
        task.run();
        Assert.assertTrue((connectionsQueue.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((scannerQueue.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)TableResultIterator.RenewLeaseStatus.RENEWED, (Object)itr.getLastRenewLeaseStatus());
        task.run();
        Assert.assertTrue((scannerQueue.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((connectionsQueue.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)TableResultIterator.RenewLeaseStatus.THRESHOLD_NOT_REACHED, (Object)itr.getLastRenewLeaseStatus());
        task.run();
        Assert.assertTrue((scannerQueue.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((connectionsQueue.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)TableResultIterator.RenewLeaseStatus.LOCK_NOT_ACQUIRED, (Object)itr.getLastRenewLeaseStatus());
        task.run();
        Assert.assertTrue((scannerQueue.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((connectionsQueue.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)TableResultIterator.RenewLeaseStatus.RENEWED, (Object)itr.getLastRenewLeaseStatus());
        task.run();
        Assert.assertTrue((scannerQueue.size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((connectionsQueue.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)TableResultIterator.RenewLeaseStatus.CLOSED, (Object)itr.getLastRenewLeaseStatus());
        pconn.close();
        task.run();
        Assert.assertTrue((scannerQueue.size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Closing the connection should have removed it from the queue", (connectionsQueue.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testRenewLeaseTaskBehaviorOnError() throws Exception {
        PhoenixConnection pconn = DriverManager.getConnection(ScannerLeaseRenewalTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES)).unwrap(PhoenixConnection.class);
        LinkedBlockingQueue<WeakReference<PhoenixConnection>> connectionsQueue = new LinkedBlockingQueue<WeakReference<PhoenixConnection>>();
        connectionsQueue.add(new WeakReference<PhoenixConnection>(pconn));
        int numLeaseRenewals = 4;
        int lockNotAcquiredAt = 1;
        int thresholdNotReachedCount = 2;
        int failLeaseRenewalAt = 3;
        RenewLeaseOnlyTableIterator itr = new RenewLeaseOnlyTableIterator(numLeaseRenewals, thresholdNotReachedCount, lockNotAcquiredAt, failLeaseRenewalAt);
        LinkedBlockingQueue scannerQueue = pconn.getScanners();
        scannerQueue.add(new WeakReference<RenewLeaseOnlyTableIterator>(itr));
        ConnectionQueryServicesImpl.RenewLeaseTask task = new ConnectionQueryServicesImpl.RenewLeaseTask(connectionsQueue);
        Assert.assertTrue((connectionsQueue.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((scannerQueue.size() == 1 ? 1 : 0) != 0);
        task.run();
        Assert.assertTrue((connectionsQueue.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((scannerQueue.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)TableResultIterator.RenewLeaseStatus.LOCK_NOT_ACQUIRED, (Object)itr.getLastRenewLeaseStatus());
        task.run();
        Assert.assertTrue((scannerQueue.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((connectionsQueue.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)TableResultIterator.RenewLeaseStatus.THRESHOLD_NOT_REACHED, (Object)itr.getLastRenewLeaseStatus());
        task.run();
        Assert.assertTrue((scannerQueue.size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((connectionsQueue.size() == 0 ? 1 : 0) != 0);
        pconn.close();
        task.run();
        Assert.assertTrue((scannerQueue.size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Closing the connection should have removed it from the queue", (connectionsQueue.size() == 0 ? 1 : 0) != 0);
    }
}

