/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.query;

import org.apache.hadoop.hbase.regionserver.wal.IndexedWALEditCodec;
import org.apache.phoenix.query.BaseQueryServicesImpl;
import org.apache.phoenix.query.QueryServicesOptions;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.TestUtil;

public final class QueryServicesTestImpl
extends BaseQueryServicesImpl {
    private static final int DEFAULT_THREAD_POOL_SIZE = 10;
    private static final int DEFAULT_MAX_MEMORY_PERC = 30;
    private static final int DEFAULT_THREAD_TIMEOUT_MS = 300000;
    private static final int DEFAULT_SPOOL_THRESHOLD_BYTES = 0x100000;
    private static final int DEFAULT_MAX_TENANT_MEMORY_PERC = 100;
    private static final int DEFAULT_MAX_SERVER_CACHE_TIME_TO_LIVE_MS = 3600000;
    private static final long DEFAULT_MAX_HASH_CACHE_SIZE = 0xA00000L;
    private static final boolean DEFAULT_DROP_METADATA = false;
    private static final int DEFAULT_MASTER_INFO_PORT = -1;
    private static final int DEFAULT_REGIONSERVER_INFO_PORT = -1;
    private static final int DEFAULT_REGIONSERVER_LEASE_PERIOD_MS = 9000000;
    private static final int DEFAULT_RPC_TIMEOUT_MS = 9000000;
    private static final String DEFAULT_WAL_EDIT_CODEC = IndexedWALEditCodec.class.getName();
    public static final long DEFAULT_MAX_SERVER_METADATA_CACHE_SIZE = 0x400000L;
    public static final long DEFAULT_MAX_CLIENT_METADATA_CACHE_SIZE = 0x200000L;
    public static final int DEFAULT_MIN_STATS_UPDATE_FREQ_MS = 0;
    public static final boolean DEFAULT_EXPLAIN_CHUNK_COUNT = false;
    public static final boolean DEFAULT_EXPLAIN_ROW_COUNT = false;
    public static final String DEFAULT_EXTRA_JDBC_ARGUMENTS = "test=true";
    private static final boolean DEFAULT_RUN_UPDATE_STATS_ASYNC = false;
    private static final boolean DEFAULT_COMMIT_STATS_ASYNC = false;
    public static final int DEFAULT_INDEX_HANDLER_COUNT = 5;
    public static final int DEFAULT_METADATA_HANDLER_COUNT = 5;
    public static final int DEFAULT_HCONNECTION_POOL_CORE_SIZE = 10;
    public static final int DEFAULT_HCONNECTION_POOL_MAX_SIZE = 10;
    public static final int DEFAULT_HTABLE_MAX_THREADS = 10;
    public static final long DEFAULT_INDEX_POPULATION_WAIT_TIME = 0L;
    public static final long DEFAULT_SEQUENCE_CACHE_SIZE = 3L;
    public static final boolean DEFAULT_TRANSACTIONS_ENABLED = true;
    public static final int DEFAULT_AGGREGATE_CHUNK_SIZE_INCREASE = 1000;
    public static final long DEFAULT_INDEX_REBUILD_TASK_INITIAL_DELAY = Long.MAX_VALUE;
    public static final int DEFAULT_TXN_TIMEOUT_SECONDS = 30;
    public static final int DEFAULT_SEQUENCE_TABLE_SALT_BUCKETS = 4;
    public static final boolean DEFAULT_FORCE_ROWKEY_ORDER = true;

    public QueryServicesTestImpl(ReadOnlyProps defaultProps) {
        this(defaultProps, ReadOnlyProps.EMPTY_PROPS);
    }

    private static QueryServicesOptions getDefaultServicesOptions() {
        try {
            String txSnapshotDir = TestUtil.createTempDirectory().toString();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create tx snapshot directory", e);
        }
        return QueryServicesOptions.withDefaults().setSequenceCacheSize(3L).setTransactionsEnabled(true).setExplainChunkCount(false).setExplainRowCount(false).setSequenceSaltBuckets(4).setMinStatsUpdateFrequencyMs(0).setThreadPoolSize(10).setMaxMemoryPerc(30).setThreadTimeoutMs(300000).setClientSpoolThresholdBytes(0x100000L).setServerSpoolThresholdBytes(0x100000L).setSpoolDirectory(QueryServicesOptions.DEFAULT_SPOOL_DIRECTORY).setMaxTenantMemoryPerc(100).setMaxServerCacheSize(0xA00000L).setMaxServerCacheTTLMs(3600000).setMasterInfoPort(-1).setRegionServerInfoPort(-1).setRegionServerLeasePeriodMs(9000000).setRpcTimeoutMs(9000000).setWALEditCodec(DEFAULT_WAL_EDIT_CODEC).setDropMetaData(false).setMaxClientMetaDataCacheSize(0x200000L).setMaxServerMetaDataCacheSize(0x400000L).setForceRowKeyOrder(true).setExtraJDBCArguments(DEFAULT_EXTRA_JDBC_ARGUMENTS).setRunUpdateStatsAsync(false).setCommitStatsAsync(false).setIndexHandlerCount(5).setMetadataHandlerCount(5).setHConnectionPoolCoreSize(10).setHConnectionPoolMaxSize(10).setMaxThreadsPerHTable(10).setDefaultIndexPopulationWaitTime(0L).setIndexRebuildTaskInitialDelay(Long.MAX_VALUE).set("phoenix.aggregate.chunk_size_increase", 1000);
    }

    public QueryServicesTestImpl(ReadOnlyProps defaultProps, ReadOnlyProps overrideProps) {
        super(defaultProps, QueryServicesTestImpl.getDefaultServicesOptions().setAll(overrideProps));
    }
}

