/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.query;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.thirdparty.com.google.common.base.Joiner;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.thirdparty.com.google.common.collect.Sets;
import org.apache.phoenix.thirdparty.com.google.common.collect.Table;
import org.apache.phoenix.thirdparty.com.google.common.collect.TreeBasedTable;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhoenixTestBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(PhoenixTestBuilder.class);
    private static final int MAX_SUFFIX_VALUE = 1000000;
    private static AtomicInteger NAME_SUFFIX = new AtomicInteger(0);

    private static String generateUniqueName() {
        int nextName = NAME_SUFFIX.incrementAndGet();
        if (nextName >= 1000000) {
            throw new IllegalStateException("Used up all unique names");
        }
        return "T" + Integer.toString(1000000 + nextName).substring(1);
    }

    private static String getColumnsAsString(List<String> columns, List<String> types, boolean isPK) {
        assert (columns.size() == types.size());
        Joiner columnJoiner = Joiner.on((String)",");
        Joiner typeJoiner = Joiner.on((String)" ");
        ArrayList columnDefinitions = Lists.newArrayList();
        for (int colIndex = 0; colIndex < columns.size(); ++colIndex) {
            String column = columns.get(colIndex);
            String datatype = types.get(colIndex);
            if (column == null || column.isEmpty()) continue;
            String columnWithType = isPK ? typeJoiner.join((Object)column, (Object)datatype, new Object[]{"NOT NULL"}) : typeJoiner.join((Object)column, (Object)datatype, new Object[0]);
            columnDefinitions.add(columnWithType);
        }
        return columnJoiner.join((Iterable)columnDefinitions);
    }

    private static String getPKColumnsWithSort(List<String> pkColumns, List<String> sortTypes) {
        assert (sortTypes == null || sortTypes.size() == pkColumns.size());
        Joiner pkColumnJoiner = Joiner.on((String)",");
        Joiner sortTypeJoiner = Joiner.on((String)" ");
        ArrayList pkColumnDefinitions = Lists.newArrayList();
        for (int colIndex = 0; colIndex < pkColumns.size(); ++colIndex) {
            String sorttype;
            String column = pkColumns.get(colIndex);
            String string = sorttype = sortTypes == null ? null : sortTypes.get(colIndex);
            if (column == null || column.isEmpty()) continue;
            String columnWithSortType = sorttype == null || sorttype.isEmpty() ? column : sortTypeJoiner.join((Object)column, (Object)sorttype, new Object[0]);
            pkColumnDefinitions.add(columnWithSortType);
        }
        return pkColumnJoiner.join((Iterable)pkColumnDefinitions);
    }

    private static String getFQColumnsAsString(List<String> columns, List<String> families) {
        Joiner columnJoiner = Joiner.on((String)",");
        return columnJoiner.join(PhoenixTestBuilder.getFQColumnsAsList(columns, families));
    }

    private static List<String> getFQColumnsAsList(List<String> columns, List<String> families) {
        assert (columns.size() == families.size());
        Joiner familyJoiner = Joiner.on((String)".");
        ArrayList columnDefinitions = Lists.newArrayList();
        int colIndex = 0;
        for (String family : families) {
            String column;
            if ((column = columns.get(colIndex++)) == null || column.isEmpty()) continue;
            columnDefinitions.add(family != null && !family.isEmpty() ? familyJoiner.join((Object)family, (Object)column, new Object[0]) : column);
        }
        return columnDefinitions;
    }

    private static String getFQColumnsAsString(List<String> columns, List<String> families, List<String> types) {
        Joiner columnJoiner = Joiner.on((String)",");
        return columnJoiner.join(PhoenixTestBuilder.getFQColumnsAsList(columns, families, types));
    }

    private static List<String> getFQColumnsAsList(List<String> columns, List<String> families, List<String> types) {
        assert (columns.size() == families.size());
        Joiner familyJoiner = Joiner.on((String)".");
        Joiner typeJoiner = Joiner.on((String)" ");
        ArrayList columnDefinitions = Lists.newArrayList();
        int colIndex = 0;
        for (String family : families) {
            String column = columns.get(colIndex);
            String datatype = types.get(colIndex);
            ++colIndex;
            if (column == null || column.isEmpty()) continue;
            String columnWithType = typeJoiner.join((Object)column, (Object)datatype, new Object[0]);
            columnDefinitions.add(family != null && !family.isEmpty() ? familyJoiner.join((Object)family, (Object)columnWithType, new Object[0]) : columnWithType);
        }
        return columnDefinitions;
    }

    public static class SchemaBuilder {
        private static final AtomicInteger TENANT_COUNTER = new AtomicInteger(0);
        boolean tableEnabled = false;
        boolean globalViewEnabled = false;
        boolean tenantViewEnabled = false;
        boolean tableIndexEnabled = false;
        boolean globalViewIndexEnabled = false;
        boolean tenantViewIndexEnabled = false;
        boolean tableCreated = false;
        boolean globalViewCreated = false;
        boolean tenantViewCreated = false;
        boolean tableIndexCreated = false;
        boolean globalViewIndexCreated = false;
        boolean tenantViewIndexCreated = false;
        String url;
        String entityKeyPrefix;
        private String entityTableName;
        private String entityGlobalViewName;
        private String entityTenantViewName;
        private String entityTableIndexName;
        private String entityGlobalViewIndexName;
        private String entityTenantViewIndexName;
        PTable baseTable;
        ConnectOptions connectOptions;
        TableOptions tableOptions;
        GlobalViewOptions globalViewOptions;
        TenantViewOptions tenantViewOptions;
        TableIndexOptions tableIndexOptions;
        GlobalViewIndexOptions globalViewIndexOptions;
        TenantViewIndexOptions tenantViewIndexOptions;
        OtherOptions otherOptions;
        DataOptions dataOptions;

        public SchemaBuilder(String url) {
            this.url = url;
        }

        public PTable getBaseTable() {
            return this.baseTable;
        }

        public void setBaseTable(PTable baseTable) {
            this.baseTable = baseTable;
        }

        public String getUrl() {
            return this.url;
        }

        public boolean isTableEnabled() {
            return this.tableEnabled;
        }

        public boolean isGlobalViewEnabled() {
            return this.globalViewEnabled;
        }

        public boolean isTenantViewEnabled() {
            return this.tenantViewEnabled;
        }

        public boolean isTableIndexEnabled() {
            return this.tableIndexEnabled;
        }

        public boolean isGlobalViewIndexEnabled() {
            return this.globalViewIndexEnabled;
        }

        public boolean isTenantViewIndexEnabled() {
            return this.tenantViewIndexEnabled;
        }

        public void setTableCreated() {
            this.tableCreated = true;
        }

        public boolean isTableCreated() {
            return this.tableCreated;
        }

        public boolean isGlobalViewCreated() {
            return this.globalViewCreated;
        }

        public boolean isTenantViewCreated() {
            return this.tenantViewCreated;
        }

        public boolean isTableIndexCreated() {
            return this.tableIndexCreated;
        }

        public boolean isGlobalViewIndexCreated() {
            return this.globalViewIndexCreated;
        }

        public boolean isTenantViewIndexCreated() {
            return this.tenantViewIndexCreated;
        }

        public String getEntityKeyPrefix() {
            return this.entityKeyPrefix;
        }

        public String getEntityTableName() {
            return this.entityTableName;
        }

        public String getEntityGlobalViewName() {
            return this.entityGlobalViewName;
        }

        public String getEntityTenantViewName() {
            return this.entityTenantViewName;
        }

        public String getEntityTableIndexName() {
            return this.entityTableIndexName;
        }

        public String getEntityGlobalViewIndexName() {
            return this.entityGlobalViewIndexName;
        }

        public String getEntityTenantViewIndexName() {
            return this.entityTenantViewIndexName;
        }

        public String getPhysicalTableName(boolean isNamespaceEnabled) {
            return SchemaUtil.getPhysicalTableName((byte[])Bytes.toBytes((String)this.getEntityTableName()), (boolean)isNamespaceEnabled).getNameAsString();
        }

        public String getPhysicalTableIndexName(boolean isNamespaceEnabled) {
            return SchemaUtil.getPhysicalTableName((byte[])Bytes.toBytes((String)this.getEntityTableIndexName()), (boolean)isNamespaceEnabled).getNameAsString();
        }

        public ConnectOptions getConnectOptions() {
            return this.connectOptions;
        }

        public TableOptions getTableOptions() {
            return this.tableOptions;
        }

        public GlobalViewOptions getGlobalViewOptions() {
            return this.globalViewOptions;
        }

        public TenantViewOptions getTenantViewOptions() {
            return this.tenantViewOptions;
        }

        public TableIndexOptions getTableIndexOptions() {
            return this.tableIndexOptions;
        }

        public GlobalViewIndexOptions getGlobalViewIndexOptions() {
            return this.globalViewIndexOptions;
        }

        public TenantViewIndexOptions getTenantViewIndexOptions() {
            return this.tenantViewIndexOptions;
        }

        public OtherOptions getOtherOptions() {
            return this.otherOptions;
        }

        public DataOptions getDataOptions() {
            return this.dataOptions;
        }

        public SchemaBuilder withTableDefaults() {
            this.tableEnabled = true;
            this.tableCreated = false;
            this.tableOptions = TableOptions.withDefaults();
            return this;
        }

        public SchemaBuilder withTableOptions(TableOptions options) {
            this.tableEnabled = true;
            this.tableCreated = false;
            this.tableOptions = options;
            return this;
        }

        public SchemaBuilder withSimpleGlobalView() {
            this.globalViewEnabled = true;
            this.globalViewCreated = false;
            this.globalViewOptions = new GlobalViewOptions();
            return this;
        }

        public SchemaBuilder withGlobalViewDefaults() {
            this.globalViewEnabled = true;
            this.globalViewCreated = false;
            this.globalViewOptions = GlobalViewOptions.withDefaults();
            return this;
        }

        public SchemaBuilder withGlobalViewOptions(GlobalViewOptions options) {
            this.globalViewEnabled = true;
            this.globalViewCreated = false;
            this.globalViewOptions = options;
            return this;
        }

        public SchemaBuilder withSimpleTenantView() {
            this.tenantViewEnabled = true;
            this.tenantViewCreated = false;
            this.tenantViewOptions = new TenantViewOptions();
            return this;
        }

        public SchemaBuilder withTenantViewDefaults() {
            this.tenantViewEnabled = true;
            this.tenantViewCreated = false;
            this.tenantViewOptions = TenantViewOptions.withDefaults();
            return this;
        }

        public SchemaBuilder withTenantViewOptions(TenantViewOptions options) {
            this.tenantViewEnabled = true;
            this.tenantViewCreated = false;
            this.tenantViewOptions = options;
            return this;
        }

        public SchemaBuilder withTableIndexDefaults() {
            this.tableIndexEnabled = true;
            this.tableIndexCreated = false;
            this.tableIndexOptions = TableIndexOptions.withDefaults();
            return this;
        }

        public SchemaBuilder withTableIndexOptions(TableIndexOptions options) {
            this.tableIndexEnabled = true;
            this.tableIndexCreated = false;
            this.tableIndexOptions = options;
            return this;
        }

        public SchemaBuilder withGlobalViewIndexDefaults() {
            this.globalViewIndexEnabled = true;
            this.globalViewIndexCreated = false;
            this.globalViewIndexOptions = GlobalViewIndexOptions.withDefaults();
            return this;
        }

        public SchemaBuilder withGlobalViewIndexOptions(GlobalViewIndexOptions options) {
            this.globalViewIndexEnabled = true;
            this.globalViewIndexCreated = false;
            this.globalViewIndexOptions = options;
            return this;
        }

        public SchemaBuilder withTenantViewIndexDefaults() {
            this.tenantViewIndexEnabled = true;
            this.tenantViewIndexCreated = false;
            this.tenantViewIndexOptions = TenantViewIndexOptions.withDefaults();
            return this;
        }

        public SchemaBuilder withTenantViewIndexOptions(TenantViewIndexOptions options) {
            this.tenantViewIndexEnabled = true;
            this.tenantViewIndexCreated = false;
            this.tenantViewIndexOptions = options;
            return this;
        }

        public SchemaBuilder withOtherDefaults() {
            this.otherOptions = OtherOptions.withDefaults();
            return this;
        }

        public SchemaBuilder withOtherOptions(OtherOptions otherOptions) {
            this.otherOptions = otherOptions;
            return this;
        }

        public SchemaBuilder withDataOptionsDefaults() {
            this.dataOptions = DataOptions.withDefaults();
            return this;
        }

        public SchemaBuilder withDataOptions(DataOptions dataOptions) {
            this.dataOptions = dataOptions;
            return this;
        }

        public SchemaBuilder withConnectOptions(ConnectOptions connectOptions) {
            this.connectOptions = connectOptions;
            return this;
        }

        public SchemaBuilder withConnectDefaults() {
            this.connectOptions = new ConnectOptions();
            return this;
        }

        public void buildWithNewTenant() throws Exception {
            this.tenantViewCreated = false;
            this.tenantViewIndexCreated = false;
            if (this.dataOptions == null) {
                this.dataOptions = DataOptions.withDefaults();
            }
            this.dataOptions.tenantId = this.dataOptions.tenantId == null || this.dataOptions.tenantId.isEmpty() ? String.format(this.dataOptions.tenantIdFormat, TENANT_COUNTER.incrementAndGet(), this.dataOptions.uniqueName) : this.dataOptions.tenantId;
            this.build();
        }

        public void buildNewView() throws Exception {
            this.tenantViewCreated = false;
            this.tenantViewIndexCreated = false;
            if (this.dataOptions == null) {
                this.dataOptions = DataOptions.withDefaults();
            }
            this.dataOptions.viewNumber = this.getDataOptions().getNextViewNumber();
            this.build();
        }

        public void build() throws Exception {
            if (this.otherOptions == null) {
                this.otherOptions = OtherOptions.withDefaults();
            }
            if (this.dataOptions == null) {
                this.dataOptions = DataOptions.withDefaults();
            }
            if (this.connectOptions == null) {
                this.connectOptions = new ConnectOptions();
            }
            if (this.globalViewOptions == null) {
                this.globalViewOptions = new GlobalViewOptions();
            }
            if (this.globalViewIndexOptions == null) {
                this.globalViewIndexOptions = new GlobalViewIndexOptions();
            }
            if (this.tenantViewOptions == null) {
                this.tenantViewOptions = new TenantViewOptions();
            }
            if (this.tenantViewIndexOptions == null) {
                this.tenantViewIndexOptions = new TenantViewIndexOptions();
            }
            if (this.connectOptions.useGlobalConnectionOnly && this.connectOptions.useTenantConnectionForGlobalView) {
                throw new IllegalArgumentException("useTenantConnectionForGlobalView and useGlobalConnectionOnly both cannot be true");
            }
            String tableName = SchemaUtil.normalizeIdentifier((String)this.dataOptions.getTableName());
            String globalViewName = SchemaUtil.normalizeIdentifier((String)this.dataOptions.getGlobalViewName());
            String tableSchemaNameToUse = "";
            String globalViewSchemaNameToUse = this.globalViewOptions.getSchemaName();
            String tenantViewSchemaNameToUse = this.tenantViewOptions.getSchemaName();
            if (this.dataOptions.getSchemaName() != null && !this.dataOptions.getSchemaName().isEmpty()) {
                tableSchemaNameToUse = this.dataOptions.getSchemaName();
                globalViewSchemaNameToUse = this.dataOptions.getSchemaName();
                tenantViewSchemaNameToUse = this.dataOptions.getSchemaName();
            } else {
                tableSchemaNameToUse = this.tableOptions.getSchemaName();
            }
            String tableSchemaName = this.tableEnabled ? SchemaUtil.normalizeIdentifier((String)tableSchemaNameToUse) : "";
            String globalViewSchemaName = this.globalViewEnabled ? SchemaUtil.normalizeIdentifier((String)globalViewSchemaNameToUse) : "";
            String tenantViewSchemaName = this.tenantViewEnabled ? SchemaUtil.normalizeIdentifier((String)tenantViewSchemaNameToUse) : "";
            this.entityTableName = SchemaUtil.getTableName((String)tableSchemaName, (String)tableName);
            this.entityGlobalViewName = SchemaUtil.getTableName((String)globalViewSchemaName, (String)globalViewName);
            this.entityKeyPrefix = this.dataOptions.getKeyPrefix() != null && !this.dataOptions.getKeyPrefix().isEmpty() ? this.dataOptions.getKeyPrefix() : (this.connectOptions.useGlobalConnectionOnly ? String.format("Z%02d", this.dataOptions.getViewNumber()) : (this.tenantViewEnabled && !this.globalViewEnabled ? String.format("Z%02d", this.dataOptions.getViewNumber()) : "ECZ"));
            String tenantViewName = this.dataOptions.getTenantViewName() != null && !this.dataOptions.getTenantViewName().isEmpty() ? this.dataOptions.getTenantViewName() : SchemaUtil.normalizeIdentifier((String)this.entityKeyPrefix);
            this.entityTenantViewName = SchemaUtil.getTableName((String)tenantViewSchemaName, (String)tenantViewName);
            String globalViewCondition = this.globalViewOptions.globalViewCondition != null && !this.globalViewOptions.globalViewCondition.isEmpty() ? this.globalViewOptions.getGlobalViewCondition() : String.format("SELECT * FROM %s WHERE %s = '%s'", this.entityTableName, this.tableOptions.getTablePKColumns().get(1), this.entityKeyPrefix);
            String schemaName = SchemaUtil.getSchemaNameFromFullName((String)this.entityTableName);
            try (Connection globalConnection = this.getGlobalConnection();){
                if (this.tableEnabled && !this.tableCreated) {
                    globalConnection.createStatement().execute(this.buildCreateTableStmt(this.entityTableName));
                    this.tableCreated = true;
                    PTableKey tableKey = new PTableKey(null, SchemaUtil.normalizeFullTableName((String)this.entityTableName));
                    this.setBaseTable(globalConnection.unwrap(PhoenixConnection.class).getTable(tableKey));
                }
                if (this.tableIndexEnabled && !this.tableIndexCreated) {
                    String indexOnTableName = SchemaUtil.normalizeIdentifier((String)String.format("IDX_%s", SchemaUtil.normalizeIdentifier((String)tableName)));
                    globalConnection.createStatement().execute(this.buildCreateIndexStmt(indexOnTableName, this.entityTableName, this.tableIndexOptions.isLocal, this.tableIndexOptions.tableIndexColumns, this.tableIndexOptions.tableIncludeColumns, this.tableIndexOptions.indexProps));
                    this.tableIndexCreated = true;
                    this.entityTableIndexName = SchemaUtil.getTableName((String)schemaName, (String)indexOnTableName);
                }
            }
            var13_13 = null;
            try (Connection globalViewConnection = this.getGlobalViewConnection();){
                if (this.globalViewEnabled && !this.globalViewCreated) {
                    globalViewConnection.createStatement().execute(this.buildCreateGlobalViewStmt(this.entityGlobalViewName, globalViewCondition));
                    this.globalViewCreated = true;
                }
                if (this.globalViewIndexEnabled && !this.globalViewIndexCreated) {
                    String indexOnGlobalViewName = String.format("IDX_%s", SchemaUtil.normalizeIdentifier((String)globalViewName));
                    globalViewConnection.createStatement().execute(this.buildCreateIndexStmt(indexOnGlobalViewName, this.entityGlobalViewName, this.globalViewIndexOptions.isLocal, this.globalViewIndexOptions.globalViewIndexColumns, this.globalViewIndexOptions.globalViewIncludeColumns, this.globalViewIndexOptions.indexProps));
                    this.globalViewIndexCreated = true;
                    this.entityGlobalViewIndexName = SchemaUtil.getTableName((String)schemaName, (String)indexOnGlobalViewName);
                }
            }
            catch (Throwable indexOnGlobalViewName) {
                var13_13 = indexOnGlobalViewName;
                throw indexOnGlobalViewName;
            }
            var13_13 = null;
            try (Connection tenantConnection = this.getTenantConnection();){
                if (this.tenantViewEnabled && !this.tenantViewCreated) {
                    String tenantViewCondition;
                    boolean hasTenantViewCondition;
                    boolean bl = hasTenantViewCondition = this.tenantViewOptions.getTenantViewCondition() != null && !this.tenantViewOptions.getTenantViewCondition().isEmpty();
                    if (this.globalViewEnabled) {
                        tenantViewCondition = hasTenantViewCondition ? this.tenantViewOptions.getTenantViewCondition() : String.format("SELECT * FROM %s", this.entityGlobalViewName);
                    } else if (this.tableEnabled) {
                        tenantViewCondition = hasTenantViewCondition ? this.tenantViewOptions.getTenantViewCondition() : String.format("SELECT * FROM %s WHERE KP = '%s'", this.entityTableName, this.entityKeyPrefix);
                    } else {
                        throw new IllegalStateException("Tenant View must be based on tables or global view");
                    }
                    tenantConnection.createStatement().execute(this.buildCreateTenantViewStmt(this.entityTenantViewName, tenantViewCondition));
                    this.tenantViewCreated = true;
                }
                if (this.tenantViewIndexEnabled && !this.tenantViewIndexCreated) {
                    String indexOnTenantViewName = String.format("IDX_%s", this.entityKeyPrefix);
                    tenantConnection.createStatement().execute(this.buildCreateIndexStmt(indexOnTenantViewName, this.entityTenantViewName, this.tenantViewIndexOptions.isLocal, this.tenantViewIndexOptions.tenantViewIndexColumns, this.tenantViewIndexOptions.tenantViewIncludeColumns, this.tenantViewIndexOptions.indexProps));
                    this.tenantViewIndexCreated = true;
                    this.entityTenantViewIndexName = SchemaUtil.getTableName((String)schemaName, (String)indexOnTenantViewName);
                }
            }
            catch (Throwable throwable) {
                var13_13 = throwable;
                throw throwable;
            }
        }

        private String buildCreateIndexStmt(String indexName, String onEntityName, boolean isLocal, List<String> indexColumns, List<String> includeColumns, String indexProps) {
            StringBuilder statement = new StringBuilder();
            statement.append(isLocal ? "CREATE LOCAL INDEX IF NOT EXISTS " : "CREATE INDEX IF NOT EXISTS ").append(indexName).append(" ON ").append(onEntityName).append("(").append(Joiner.on((String)",").join(indexColumns)).append(") ").append(includeColumns.isEmpty() ? "" : "INCLUDE (" + Joiner.on((String)",").join(includeColumns) + ") ").append(indexProps.isEmpty() ? "" : indexProps);
            LOGGER.info(statement.toString());
            return statement.toString();
        }

        private String buildCreateTableStmt(String fullTableName) {
            String prop;
            boolean hasAppendedTableProps;
            StringBuilder statement = new StringBuilder();
            StringBuilder tableDefinition = new StringBuilder();
            if (!this.tableOptions.tablePKColumns.isEmpty() || !this.tableOptions.tableColumns.isEmpty()) {
                tableDefinition.append("(");
                if (!this.tableOptions.tablePKColumns.isEmpty()) {
                    tableDefinition.append(PhoenixTestBuilder.getColumnsAsString(this.tableOptions.tablePKColumns, this.tableOptions.tablePKColumnTypes, true));
                }
                if (!this.tableOptions.tableColumns.isEmpty()) {
                    tableDefinition.append(this.tableOptions.tablePKColumns.isEmpty() ? "" : ",").append(PhoenixTestBuilder.getFQColumnsAsString(this.tableOptions.tableColumns, this.otherOptions.tableCFs, this.tableOptions.tableColumnTypes));
                }
                if (!this.tableOptions.tablePKColumns.isEmpty()) {
                    tableDefinition.append(" CONSTRAINT pk PRIMARY KEY ").append("(").append(PhoenixTestBuilder.getPKColumnsWithSort(this.tableOptions.tablePKColumns, this.tableOptions.tablePKColumnSort)).append(")");
                }
                tableDefinition.append(")");
            }
            statement.append("CREATE TABLE IF NOT EXISTS ").append(fullTableName).append(tableDefinition.toString()).append(" ").append(this.tableOptions.tableProps.isEmpty() ? "" : this.tableOptions.tableProps);
            boolean bl = hasAppendedTableProps = !this.tableOptions.tableProps.isEmpty();
            if (this.tableOptions.isMultiTenant()) {
                statement.append(hasAppendedTableProps ? ", MULTI_TENANT=true" : "MULTI_TENANT=true");
                hasAppendedTableProps = true;
            }
            if (this.tableOptions.getSaltBuckets() != null) {
                prop = "SALT_BUCKETS=" + this.tableOptions.getSaltBuckets();
                statement.append(hasAppendedTableProps ? ", " + prop : prop);
                hasAppendedTableProps = true;
            }
            if (this.tableOptions.isImmutable()) {
                prop = "IMMUTABLE_ROWS=true";
                statement.append(hasAppendedTableProps ? ", " + prop : prop);
                hasAppendedTableProps = true;
            }
            if (this.tableOptions.isChangeDetectionEnabled()) {
                prop = "CHANGE_DETECTION_ENABLED=true";
                statement.append(hasAppendedTableProps ? ", " + prop : prop);
                hasAppendedTableProps = true;
            }
            LOGGER.info(statement.toString());
            return statement.toString();
        }

        private String buildCreateGlobalViewStmt(String fullGlobalViewName, String globalViewCondition) {
            StringBuilder statement = new StringBuilder();
            StringBuilder viewDefinition = new StringBuilder();
            if (!this.globalViewOptions.globalViewPKColumns.isEmpty() || !this.globalViewOptions.globalViewColumns.isEmpty()) {
                viewDefinition.append("(");
                if (!this.globalViewOptions.globalViewPKColumns.isEmpty()) {
                    viewDefinition.append(PhoenixTestBuilder.getColumnsAsString(this.globalViewOptions.globalViewPKColumns, this.globalViewOptions.globalViewPKColumnTypes, true));
                }
                if (!this.globalViewOptions.globalViewColumns.isEmpty()) {
                    viewDefinition.append(this.globalViewOptions.globalViewPKColumns.isEmpty() ? "" : ",").append(PhoenixTestBuilder.getFQColumnsAsString(this.globalViewOptions.globalViewColumns, this.otherOptions.globalViewCFs, this.globalViewOptions.globalViewColumnTypes));
                }
                if (!this.globalViewOptions.globalViewPKColumns.isEmpty()) {
                    viewDefinition.append(" CONSTRAINT pk PRIMARY KEY ").append("(").append(PhoenixTestBuilder.getPKColumnsWithSort(this.globalViewOptions.globalViewPKColumns, this.globalViewOptions.globalViewPKColumnSort)).append(")");
                }
                viewDefinition.append(")");
            }
            statement.append("CREATE VIEW IF NOT EXISTS ").append(fullGlobalViewName).append(viewDefinition.toString()).append(" AS ").append(globalViewCondition).append(" ").append(this.globalViewOptions.tableProps.isEmpty() ? "" : this.globalViewOptions.tableProps);
            if (this.globalViewOptions.isChangeDetectionEnabled()) {
                if (!this.globalViewOptions.tableProps.isEmpty()) {
                    statement.append(", ");
                }
                statement.append("CHANGE_DETECTION_ENABLED=true");
            }
            LOGGER.info(statement.toString());
            return statement.toString();
        }

        private String buildCreateTenantViewStmt(String fullTenantViewName, String tenantViewCondition) {
            StringBuilder statement = new StringBuilder();
            StringBuilder viewDefinition = new StringBuilder();
            if (!this.tenantViewOptions.tenantViewPKColumns.isEmpty() || !this.tenantViewOptions.tenantViewColumns.isEmpty()) {
                viewDefinition.append("(");
                if (!this.tenantViewOptions.tenantViewPKColumns.isEmpty()) {
                    viewDefinition.append(PhoenixTestBuilder.getColumnsAsString(this.tenantViewOptions.tenantViewPKColumns, this.tenantViewOptions.tenantViewPKColumnTypes, true));
                }
                if (!this.tenantViewOptions.tenantViewColumns.isEmpty()) {
                    viewDefinition.append(this.tenantViewOptions.tenantViewPKColumns.isEmpty() ? "" : ",").append(PhoenixTestBuilder.getFQColumnsAsString(this.tenantViewOptions.tenantViewColumns, this.otherOptions.tenantViewCFs, this.tenantViewOptions.tenantViewColumnTypes));
                }
                if (!this.tenantViewOptions.tenantViewPKColumns.isEmpty()) {
                    viewDefinition.append(" CONSTRAINT pk PRIMARY KEY ").append("(").append(PhoenixTestBuilder.getPKColumnsWithSort(this.tenantViewOptions.tenantViewPKColumns, this.tenantViewOptions.tenantViewPKColumnSort)).append(")");
                }
                viewDefinition.append(")");
            }
            statement.append("CREATE VIEW IF NOT EXISTS ").append(fullTenantViewName).append(viewDefinition.toString()).append(" AS ").append(tenantViewCondition).append(" ").append(this.tenantViewOptions.tableProps.isEmpty() ? "" : this.tenantViewOptions.tableProps);
            if (this.tenantViewOptions.isChangeDetectionEnabled()) {
                if (!this.tenantViewOptions.tableProps.isEmpty()) {
                    statement.append(", ");
                }
                statement.append("CHANGE_DETECTION_ENABLED=true");
            }
            LOGGER.info(statement.toString());
            return statement.toString();
        }

        Connection getGlobalConnection() throws SQLException {
            return this.getPhoenixConnection(this.getUrl());
        }

        Connection getGlobalViewConnection() throws SQLException {
            return this.getPhoenixConnection(this.connectOptions.useTenantConnectionForGlobalView ? this.getUrl() + ';' + "TenantId" + '=' + this.dataOptions.getTenantId() : this.getUrl());
        }

        Connection getTenantConnection() throws SQLException {
            return this.getPhoenixConnection(this.connectOptions.useGlobalConnectionOnly ? this.getUrl() : this.getUrl() + ';' + "TenantId" + '=' + this.dataOptions.getTenantId());
        }

        Connection getPhoenixConnection(String url) throws SQLException {
            return this.getPhoenixConnection(url, this.connectOptions.connectProps);
        }

        Connection getPhoenixConnection(String url, Properties props) throws SQLException {
            Connection phoenixConnection;
            if (props == null) {
                Properties connProps = PropertiesUtil.deepCopy((Properties)this.connectOptions.connectProps);
                phoenixConnection = DriverManager.getConnection(url, connProps);
            } else {
                phoenixConnection = DriverManager.getConnection(url, props);
            }
            phoenixConnection.setAutoCommit(true);
            return phoenixConnection;
        }

        public static class DataOptions {
            String uniqueName = "";
            String uniqueNamePrefix = "";
            String tenantIdFormat = "00D0t%04d%s";
            String keyPrefix = "";
            int viewNumber = 0;
            AtomicInteger viewCounter = new AtomicInteger(0);
            String tenantId = "";
            String schemaName = "TEST_ENTITY";
            String tableName = "";
            String globalViewName = "";
            String tenantViewName = "";

            public static DataOptions withPrefix(String prefix) {
                DataOptions options = new DataOptions();
                options.uniqueNamePrefix = prefix;
                options.uniqueName = PhoenixTestBuilder.generateUniqueName().substring(1);
                options.viewCounter = new AtomicInteger(0);
                options.tableName = String.format("T_%s_%s", options.uniqueNamePrefix, options.uniqueName);
                options.globalViewName = String.format("GV_%s_%s", options.uniqueNamePrefix, options.uniqueName);
                return options;
            }

            public static DataOptions withDefaults() {
                DataOptions options = new DataOptions();
                options.uniqueName = PhoenixTestBuilder.generateUniqueName().substring(1);
                options.viewCounter = new AtomicInteger(0);
                options.tableName = String.format("T_%s", options.uniqueName);
                options.globalViewName = String.format("GV_%s", options.uniqueName);
                return options;
            }

            public int getNextViewNumber() {
                this.viewNumber = this.viewCounter.incrementAndGet();
                return this.viewNumber;
            }

            public String getNextTenantId() {
                this.tenantId = String.format(this.tenantIdFormat, TENANT_COUNTER.incrementAndGet(), this.uniqueName);
                return this.tenantId;
            }

            public int getTenantNumber() {
                return TENANT_COUNTER.get();
            }

            public int getNextTenantNumber() {
                return TENANT_COUNTER.incrementAndGet();
            }

            public int getViewNumber() {
                return this.viewNumber;
            }

            public String getTenantIdFormat() {
                return this.tenantIdFormat;
            }

            public void setTenantIdFormat(String tenantIdFormat) {
                this.tenantIdFormat = tenantIdFormat;
            }

            public String getUniqueName() {
                return this.uniqueName;
            }

            public void setUniqueName(String uniqueName) {
                this.uniqueName = uniqueName;
            }

            public String getTenantId() {
                if (this.tenantId == null || this.tenantId.isEmpty()) {
                    return this.getNextTenantId();
                }
                return this.tenantId;
            }

            public void setTenantId(String tenantId) {
                this.tenantId = tenantId;
            }

            public String getUniqueNamePrefix() {
                return this.uniqueNamePrefix;
            }

            public void setUniqueNamePrefix(String uniqueNamePrefix) {
                this.uniqueNamePrefix = uniqueNamePrefix;
            }

            public String getKeyPrefix() {
                return this.keyPrefix;
            }

            public void setKeyPrefix(String keyPrefix) {
                this.keyPrefix = keyPrefix;
            }

            public void setViewNumber(int viewNumber) {
                this.viewNumber = viewNumber;
            }

            public AtomicInteger getViewCounter() {
                return this.viewCounter;
            }

            public void setViewCounter(AtomicInteger viewCounter) {
                this.viewCounter = viewCounter;
            }

            public String getTableName() {
                return this.tableName;
            }

            public void setTableName(String tableName) {
                this.tableName = tableName;
            }

            public String getGlobalViewName() {
                return this.globalViewName;
            }

            public void setGlobalViewName(String globalViewName) {
                this.globalViewName = globalViewName;
            }

            public String getTenantViewName() {
                return this.tenantViewName;
            }

            public void setTenantViewName(String tenantViewName) {
                this.tenantViewName = tenantViewName;
            }

            public String getSchemaName() {
                return this.schemaName;
            }

            public void setSchemaName(String schemaName) {
                this.schemaName = schemaName;
            }
        }

        public static class OtherOptions {
            String testName;
            List<String> tableCFs = Lists.newArrayList();
            List<String> globalViewCFs = Lists.newArrayList();
            List<String> tenantViewCFs = Lists.newArrayList();

            public static OtherOptions withDefaults() {
                OtherOptions options = new OtherOptions();
                options.tableCFs = Lists.newArrayList(DDLDefaults.TABLE_COLUMN_FAMILIES);
                options.globalViewCFs = Lists.newArrayList(DDLDefaults.GLOBAL_VIEW_COLUMN_FAMILIES);
                options.tenantViewCFs = Lists.newArrayList(DDLDefaults.TENANT_VIEW_COLUMN_FAMILIES);
                return options;
            }

            public String getTestName() {
                return this.testName;
            }

            public void setTestName(String testName) {
                this.testName = testName;
            }

            public List<String> getTableCFs() {
                return this.tableCFs;
            }

            public void setTableCFs(List<String> tableCFs) {
                this.tableCFs = tableCFs;
            }

            public List<String> getGlobalViewCFs() {
                return this.globalViewCFs;
            }

            public void setGlobalViewCFs(List<String> globalViewCFs) {
                this.globalViewCFs = globalViewCFs;
            }

            public List<String> getTenantViewCFs() {
                return this.tenantViewCFs;
            }

            public void setTenantViewCFs(List<String> tenantViewCFs) {
                this.tenantViewCFs = tenantViewCFs;
            }
        }

        public static class TenantViewIndexOptions {
            List<String> tenantViewIndexColumns = Lists.newArrayList();
            List<String> tenantViewIncludeColumns = Lists.newArrayList();
            boolean isLocal = false;
            String indexProps = "";

            public static TenantViewIndexOptions withDefaults() {
                TenantViewIndexOptions options = new TenantViewIndexOptions();
                options.tenantViewIndexColumns = Lists.newArrayList(DDLDefaults.TENANT_VIEW_INDEX_COLUMNS);
                options.tenantViewIncludeColumns = Lists.newArrayList(DDLDefaults.TENANT_VIEW_INCLUDE_COLUMNS);
                options.indexProps = "";
                return options;
            }

            public List<String> getTenantViewIndexColumns() {
                return this.tenantViewIndexColumns;
            }

            public void setTenantViewIndexColumns(List<String> tenantViewIndexColumns) {
                this.tenantViewIndexColumns = tenantViewIndexColumns;
            }

            public List<String> getTenantViewIncludeColumns() {
                return this.tenantViewIncludeColumns;
            }

            public void setTenantViewIncludeColumns(List<String> tenantViewIncludeColumns) {
                this.tenantViewIncludeColumns = tenantViewIncludeColumns;
            }

            public boolean isLocal() {
                return this.isLocal;
            }

            public void setLocal(boolean local) {
                this.isLocal = local;
            }

            public String getIndexProps() {
                return this.indexProps;
            }

            public void setIndexProps(String indexProps) {
                this.indexProps = indexProps;
            }
        }

        public static class GlobalViewIndexOptions {
            List<String> globalViewIndexColumns = Lists.newArrayList();
            List<String> globalViewIncludeColumns = Lists.newArrayList();
            boolean isLocal = false;
            String indexProps = "";

            public static GlobalViewIndexOptions withDefaults() {
                GlobalViewIndexOptions options = new GlobalViewIndexOptions();
                options.globalViewIndexColumns = Lists.newArrayList(DDLDefaults.GLOBAL_VIEW_INDEX_COLUMNS);
                options.globalViewIncludeColumns = Lists.newArrayList(DDLDefaults.GLOBAL_VIEW_INCLUDE_COLUMNS);
                options.indexProps = "";
                return options;
            }

            public List<String> getGlobalViewIndexColumns() {
                return this.globalViewIndexColumns;
            }

            public void setGlobalViewIndexColumns(List<String> globalViewIndexColumns) {
                this.globalViewIndexColumns = globalViewIndexColumns;
            }

            public List<String> getGlobalViewIncludeColumns() {
                return this.globalViewIncludeColumns;
            }

            public void setGlobalViewIncludeColumns(List<String> globalViewIncludeColumns) {
                this.globalViewIncludeColumns = globalViewIncludeColumns;
            }

            public boolean isLocal() {
                return this.isLocal;
            }

            public void setLocal(boolean local) {
                this.isLocal = local;
            }

            public String getIndexProps() {
                return this.indexProps;
            }

            public void setIndexProps(String indexProps) {
                this.indexProps = indexProps;
            }
        }

        public static class TableIndexOptions {
            List<String> tableIndexColumns = Lists.newArrayList();
            List<String> tableIncludeColumns = Lists.newArrayList();
            boolean isLocal = false;
            String indexProps = "";

            public static TableIndexOptions withDefaults() {
                TableIndexOptions options = new TableIndexOptions();
                options.tableIndexColumns = Lists.newArrayList(DDLDefaults.TABLE_INDEX_COLUMNS);
                options.tableIncludeColumns = Lists.newArrayList(DDLDefaults.TABLE_INCLUDE_COLUMNS);
                options.indexProps = "";
                return options;
            }

            public List<String> getTableIndexColumns() {
                return this.tableIndexColumns;
            }

            public void setTableIndexColumns(List<String> tableIndexColumns) {
                this.tableIndexColumns = tableIndexColumns;
            }

            public List<String> getTableIncludeColumns() {
                return this.tableIncludeColumns;
            }

            public void setTableIncludeColumns(List<String> tableIncludeColumns) {
                this.tableIncludeColumns = tableIncludeColumns;
            }

            public boolean isLocal() {
                return this.isLocal;
            }

            public void setLocal(boolean local) {
                this.isLocal = local;
            }

            public String getIndexProps() {
                return this.indexProps;
            }

            public void setIndexProps(String indexProps) {
                this.indexProps = indexProps;
            }
        }

        public static class TenantViewOptions {
            String schemaName = "TEST_ENTITY";
            List<String> tenantViewColumns = Lists.newArrayList();
            List<String> tenantViewColumnTypes = Lists.newArrayList();
            List<String> tenantViewPKColumns = Lists.newArrayList();
            List<String> tenantViewPKColumnTypes = Lists.newArrayList();
            List<String> tenantViewPKColumnSort;
            String tenantViewCondition;
            String tableProps = "";
            boolean isChangeDetectionEnabled = false;

            public static TenantViewOptions withDefaults() {
                TenantViewOptions options = new TenantViewOptions();
                options.schemaName = "TEST_ENTITY";
                options.tenantViewColumns = Lists.newArrayList(DDLDefaults.TENANT_VIEW_COLUMNS);
                options.tenantViewColumnTypes = Lists.newArrayList(DDLDefaults.COLUMN_TYPES);
                options.tenantViewPKColumns = Lists.newArrayList(DDLDefaults.TENANT_VIEW_PK_COLUMNS);
                options.tenantViewPKColumnTypes = Lists.newArrayList(DDLDefaults.TENANT_VIEW_PK_TYPES);
                options.tableProps = "";
                options.tenantViewCondition = "";
                return options;
            }

            public String getSchemaName() {
                return this.schemaName;
            }

            public void setSchemaName(String schemaName) {
                this.schemaName = schemaName;
            }

            public List<String> getTenantViewColumns() {
                return this.tenantViewColumns;
            }

            public void setTenantViewColumns(List<String> tenantViewColumns) {
                this.tenantViewColumns = tenantViewColumns;
            }

            public List<String> getTenantViewColumnTypes() {
                return this.tenantViewColumnTypes;
            }

            public void setTenantViewColumnTypes(List<String> tenantViewColumnTypes) {
                this.tenantViewColumnTypes = tenantViewColumnTypes;
            }

            public List<String> getTenantViewPKColumns() {
                return this.tenantViewPKColumns;
            }

            public void setTenantViewPKColumns(List<String> tenantViewPKColumns) {
                this.tenantViewPKColumns = tenantViewPKColumns;
            }

            public List<String> getTenantViewPKColumnTypes() {
                return this.tenantViewPKColumnTypes;
            }

            public void setTenantViewPKColumnTypes(List<String> tenantViewPKColumnTypes) {
                this.tenantViewPKColumnTypes = tenantViewPKColumnTypes;
            }

            public List<String> getTenantViewPKColumnSort() {
                return this.tenantViewPKColumnSort;
            }

            public void setTenantViewPKColumnSort(List<String> tenantViewPKColumnSort) {
                this.tenantViewPKColumnSort = tenantViewPKColumnSort;
            }

            public String getTableProps() {
                return this.tableProps;
            }

            public void setTableProps(String tableProps) {
                this.tableProps = tableProps;
            }

            public String getTenantViewCondition() {
                return this.tenantViewCondition;
            }

            public void setTenantViewCondition(String tenantViewCondition) {
                this.tenantViewCondition = tenantViewCondition;
            }

            public boolean isChangeDetectionEnabled() {
                return this.isChangeDetectionEnabled;
            }

            public void setChangeDetectionEnabled(boolean changeDetectionEnabled) {
                this.isChangeDetectionEnabled = changeDetectionEnabled;
            }
        }

        public static class GlobalViewOptions {
            String schemaName = "TEST_ENTITY";
            List<String> globalViewColumns = Lists.newArrayList();
            List<String> globalViewColumnTypes = Lists.newArrayList();
            List<String> globalViewPKColumns = Lists.newArrayList();
            List<String> globalViewPKColumnTypes = Lists.newArrayList();
            List<String> globalViewPKColumnSort;
            String tableProps = "";
            String globalViewCondition;
            boolean isChangeDetectionEnabled = false;

            public static GlobalViewOptions withDefaults() {
                GlobalViewOptions options = new GlobalViewOptions();
                options.schemaName = "TEST_ENTITY";
                options.globalViewColumns = Lists.newArrayList(DDLDefaults.GLOBAL_VIEW_COLUMNS);
                options.globalViewColumnTypes = Lists.newArrayList(DDLDefaults.COLUMN_TYPES);
                options.globalViewPKColumns = Lists.newArrayList(DDLDefaults.GLOBAL_VIEW_PK_COLUMNS);
                options.globalViewPKColumnTypes = Lists.newArrayList(DDLDefaults.GLOBAL_VIEW_PK_TYPES);
                options.tableProps = "";
                options.globalViewCondition = "";
                return options;
            }

            public String getSchemaName() {
                return this.schemaName;
            }

            public void setSchemaName(String schemaName) {
                this.schemaName = schemaName;
            }

            public List<String> getGlobalViewColumns() {
                return this.globalViewColumns;
            }

            public void setGlobalViewColumns(List<String> globalViewColumns) {
                this.globalViewColumns = globalViewColumns;
            }

            public List<String> getGlobalViewColumnTypes() {
                return this.globalViewColumnTypes;
            }

            public void setGlobalViewColumnTypes(List<String> globalViewColumnTypes) {
                this.globalViewColumnTypes = globalViewColumnTypes;
            }

            public List<String> getGlobalViewPKColumns() {
                return this.globalViewPKColumns;
            }

            public void setGlobalViewPKColumns(List<String> globalViewPKColumns) {
                this.globalViewPKColumns = globalViewPKColumns;
            }

            public List<String> getGlobalViewPKColumnTypes() {
                return this.globalViewPKColumnTypes;
            }

            public void setGlobalViewPKColumnTypes(List<String> globalViewPKColumnTypes) {
                this.globalViewPKColumnTypes = globalViewPKColumnTypes;
            }

            public List<String> getGlobalViewPKColumnSort() {
                return this.globalViewPKColumnSort;
            }

            public void setGlobalViewPKColumnSort(List<String> globalViewPKColumnSort) {
                this.globalViewPKColumnSort = globalViewPKColumnSort;
            }

            public String getTableProps() {
                return this.tableProps;
            }

            public void setTableProps(String tableProps) {
                this.tableProps = tableProps;
            }

            public String getGlobalViewCondition() {
                return this.globalViewCondition;
            }

            public void setGlobalViewCondition(String globalViewCondition) {
                this.globalViewCondition = globalViewCondition;
            }

            public boolean isChangeDetectionEnabled() {
                return this.isChangeDetectionEnabled;
            }

            public void setChangeDetectionEnabled(boolean changeDetectionEnabled) {
                this.isChangeDetectionEnabled = changeDetectionEnabled;
            }
        }

        public static class TableOptions {
            String schemaName = "TEST_ENTITY";
            List<String> tableColumns = Lists.newArrayList();
            List<String> tableColumnTypes = Lists.newArrayList();
            List<String> tablePKColumns = Lists.newArrayList();
            List<String> tablePKColumnTypes = Lists.newArrayList();
            List<String> tablePKColumnSort;
            String tableProps = "COLUMN_ENCODED_BYTES=0,DEFAULT_COLUMN_FAMILY='Z'";
            boolean isMultiTenant = true;
            Integer saltBuckets = null;
            boolean isImmutable = false;
            boolean isChangeDetectionEnabled = false;

            public static TableOptions withDefaults() {
                TableOptions options = new TableOptions();
                options.schemaName = "TEST_ENTITY";
                options.tableColumns = Lists.newArrayList(DDLDefaults.TABLE_COLUMNS);
                options.tableColumnTypes = Lists.newArrayList(DDLDefaults.COLUMN_TYPES);
                options.tablePKColumns = Lists.newArrayList(DDLDefaults.TABLE_PK_COLUMNS);
                options.tablePKColumnTypes = Lists.newArrayList(DDLDefaults.TABLE_PK_TYPES);
                options.tableProps = "COLUMN_ENCODED_BYTES=0,DEFAULT_COLUMN_FAMILY='Z'";
                return options;
            }

            public String getSchemaName() {
                return this.schemaName;
            }

            public void setSchemaName(String schemaName) {
                this.schemaName = schemaName;
            }

            public List<String> getTableColumns() {
                return this.tableColumns;
            }

            public void setTableColumns(List<String> tableColumns) {
                this.tableColumns = tableColumns;
            }

            public List<String> getTableColumnTypes() {
                return this.tableColumnTypes;
            }

            public void setTableColumnTypes(List<String> tableColumnTypes) {
                this.tableColumnTypes = tableColumnTypes;
            }

            public List<String> getTablePKColumns() {
                return this.tablePKColumns;
            }

            public void setTablePKColumns(List<String> tablePKColumns) {
                this.tablePKColumns = tablePKColumns;
            }

            public List<String> getTablePKColumnTypes() {
                return this.tablePKColumnTypes;
            }

            public void setTablePKColumnTypes(List<String> tablePKColumnTypes) {
                this.tablePKColumnTypes = tablePKColumnTypes;
            }

            public List<String> getTablePKColumnSort() {
                return this.tablePKColumnSort;
            }

            public void setTablePKColumnSort(List<String> tablePKColumnSort) {
                this.tablePKColumnSort = tablePKColumnSort;
            }

            public String getTableProps() {
                return this.tableProps;
            }

            public void setTableProps(String tableProps) {
                this.tableProps = tableProps;
            }

            public boolean isMultiTenant() {
                return this.isMultiTenant;
            }

            public void setMultiTenant(boolean isMultiTenant) {
                this.isMultiTenant = isMultiTenant;
            }

            public Integer getSaltBuckets() {
                return this.saltBuckets;
            }

            public void setSaltBuckets(Integer saltBuckets) {
                this.saltBuckets = saltBuckets;
            }

            public boolean isImmutable() {
                return this.isImmutable;
            }

            public void setImmutable(boolean immutable) {
                this.isImmutable = immutable;
                if (this.tableProps.equals("COLUMN_ENCODED_BYTES=0,DEFAULT_COLUMN_FAMILY='Z'")) {
                    this.tableProps = "DEFAULT_COLUMN_FAMILY='Z'";
                }
            }

            public boolean isChangeDetectionEnabled() {
                return this.isChangeDetectionEnabled;
            }

            public void setChangeDetectionEnabled(boolean changeDetectionEnabled) {
                this.isChangeDetectionEnabled = changeDetectionEnabled;
            }
        }

        public static class ConnectOptions {
            Properties connectProps = new Properties();
            boolean useGlobalConnectionOnly = false;
            boolean useTenantConnectionForGlobalView = false;

            public Properties getConnectProps() {
                return this.connectProps;
            }

            public void setConnectProps(Properties connectProps) {
                this.connectProps = connectProps;
            }

            public boolean isUseGlobalConnectionOnly() {
                return this.useGlobalConnectionOnly;
            }

            public void setUseGlobalConnectionOnly(boolean useGlobalConnectionOnly) {
                this.useGlobalConnectionOnly = useGlobalConnectionOnly;
            }

            public boolean isUseTenantConnectionForGlobalView() {
                return this.useTenantConnectionForGlobalView;
            }

            public void setUseTenantConnectionForGlobalView(boolean useTenantConnectionForGlobalView) {
                this.useTenantConnectionForGlobalView = useTenantConnectionForGlobalView;
            }
        }
    }

    public static class DDLDefaults {
        public static final int MAX_ROWS = 10000;
        public static final List<String> TABLE_PK_TYPES = Arrays.asList("CHAR(15)", "CHAR(3)");
        public static final List<String> GLOBAL_VIEW_PK_TYPES = Arrays.asList("CHAR(15)");
        public static final List<String> TENANT_VIEW_PK_TYPES = Arrays.asList("CHAR(15)");
        public static final List<String> COLUMN_TYPES = Arrays.asList("VARCHAR", "VARCHAR", "VARCHAR");
        public static final List<String> TABLE_COLUMNS = Arrays.asList("COL1", "COL2", "COL3");
        public static final List<String> GLOBAL_VIEW_COLUMNS = Arrays.asList("COL4", "COL5", "COL6");
        public static final List<String> TENANT_VIEW_COLUMNS = Arrays.asList("COL7", "COL8", "COL9");
        public static final List<String> TABLE_COLUMN_FAMILIES = Arrays.asList(null, null, null);
        public static final List<String> GLOBAL_VIEW_COLUMN_FAMILIES = Arrays.asList(null, null, null);
        public static final List<String> TENANT_VIEW_COLUMN_FAMILIES = Arrays.asList(null, null, null);
        public static final List<String> TABLE_PK_COLUMNS = Arrays.asList("OID", "KP");
        public static final List<String> GLOBAL_VIEW_PK_COLUMNS = Arrays.asList("ID");
        public static final List<String> TENANT_VIEW_PK_COLUMNS = Arrays.asList("ZID");
        public static final List<String> TABLE_INDEX_COLUMNS = Arrays.asList("COL1");
        public static final List<String> TABLE_INCLUDE_COLUMNS = Arrays.asList("COL3");
        public static final List<String> GLOBAL_VIEW_INDEX_COLUMNS = Arrays.asList("COL4");
        public static final List<String> GLOBAL_VIEW_INCLUDE_COLUMNS = Arrays.asList("COL6");
        public static final List<String> TENANT_VIEW_INDEX_COLUMNS = Arrays.asList("COL9");
        public static final List<String> TENANT_VIEW_INCLUDE_COLUMNS = Arrays.asList("COL7");
        public static final String DEFAULT_MUTABLE_TABLE_PROPS = "COLUMN_ENCODED_BYTES=0,DEFAULT_COLUMN_FAMILY='Z'";
        public static final String DEFAULT_IMMUTABLE_TABLE_PROPS = "DEFAULT_COLUMN_FAMILY='Z'";
        public static final String DEFAULT_TABLE_INDEX_PROPS = "";
        public static final String DEFAULT_GLOBAL_VIEW_PROPS = "";
        public static final String DEFAULT_GLOBAL_VIEW_INDEX_PROPS = "";
        public static final String DEFAULT_TENANT_VIEW_PROPS = "";
        public static final String DEFAULT_TENANT_VIEW_INDEX_PROPS = "";
        public static final String DEFAULT_KP = "ECZ";
        public static final String DEFAULT_SCHEMA_NAME = "TEST_ENTITY";
        public static final String DEFAULT_TENANT_ID_FMT = "00D0t%04d%s";
        public static final String DEFAULT_ALT_TENANT_ID_FMT = "00T0t%04d%s";
        public static final String DEFAULT_UNIQUE_PREFIX_TABLE_NAME_FMT = "T_%s_%s";
        public static final String DEFAULT_UNIQUE_PREFIX_GLOBAL_VIEW_NAME_FMT = "GV_%s_%s";
        public static final String DEFAULT_UNIQUE_TABLE_NAME_FMT = "T_%s";
        public static final String DEFAULT_UNIQUE_GLOBAL_VIEW_NAME_FMT = "GV_%s";
        public static final String DEFAULT_CONNECT_URL = "jdbc:phoenix:localhost";
    }

    public static class BasicDataWriter
    extends AbstractDataWriter {
        List<String> upsertColumns = Lists.newArrayList();
        List<Integer> columnPositionsToUpdate = Lists.newArrayList();
        DataSupplier dataSupplier;
        Connection connection;
        String targetEntity;
        List<String> rowKeyColumns;

        @Override
        public List<String> getUpsertColumns() {
            return this.upsertColumns;
        }

        @Override
        public void setUpsertColumns(List<String> upsertColumns) {
            this.upsertColumns = upsertColumns;
        }

        @Override
        public List<Integer> getColumnPositionsToUpdate() {
            return this.columnPositionsToUpdate;
        }

        @Override
        public void setColumnPositionsToUpdate(List<Integer> columnPositionsToUpdate) {
            this.columnPositionsToUpdate = columnPositionsToUpdate;
        }

        @Override
        public Connection getConnection() {
            return this.connection;
        }

        @Override
        public void setConnection(Connection connection) {
            this.connection = connection;
        }

        @Override
        public String getTargetEntity() {
            return this.targetEntity;
        }

        @Override
        public void setTargetEntity(String targetEntity) {
            this.targetEntity = targetEntity;
        }

        @Override
        public List<String> getRowKeyColumns() {
            return this.rowKeyColumns;
        }

        @Override
        public void setRowKeyColumns(List<String> rowKeyColumns) {
            this.rowKeyColumns = rowKeyColumns;
        }

        @Override
        public DataSupplier getTestDataSupplier() {
            return this.dataSupplier;
        }

        @Override
        public void setDataSupplier(DataSupplier dataSupplier) {
            this.dataSupplier = dataSupplier;
        }
    }

    public static abstract class AbstractDataWriter
    implements DataWriter {
        Table<String, String, Object> dataTable = TreeBasedTable.create();

        @Override
        public Table<String, String, Object> getDataTable() {
            return this.dataTable;
        }

        @Override
        public List<Object> upsertRow(int rowIndex) throws Exception {
            ArrayList upsertColumns = Lists.newArrayList();
            ArrayList upsertValues = Lists.newArrayList();
            List<Object> rowValues = null;
            rowValues = this.getTestDataSupplier().getValues(rowIndex);
            if (this.getColumnPositionsToUpdate().isEmpty()) {
                upsertColumns.addAll(this.getUpsertColumns());
                upsertValues.addAll(rowValues);
            } else {
                List<String> columnsToUpdate = this.getUpsertColumns();
                for (int i : this.getColumnPositionsToUpdate()) {
                    upsertColumns.add(columnsToUpdate.get(i));
                    upsertValues.add(rowValues.get(i));
                }
            }
            StringBuilder buf = new StringBuilder("UPSERT INTO ");
            buf.append(this.getTargetEntity());
            buf.append(" (").append(Joiner.on((String)",").join((Iterable)upsertColumns)).append(") VALUES(");
            for (int i = 0; i < upsertValues.size(); ++i) {
                buf.append("?,");
            }
            buf.setCharAt(buf.length() - 1, ')');
            LOGGER.debug(buf.toString());
            Connection connection = this.getConnection();
            try (PreparedStatement stmt = connection.prepareStatement(buf.toString());){
                for (int i = 0; i < upsertValues.size(); ++i) {
                    stmt.setObject(i + 1, upsertValues.get(i));
                }
                stmt.execute();
                connection.commit();
            }
            return upsertValues;
        }

        @Override
        public void upsertRows(int startRowIndex, int numRows) throws Exception {
            this.dataTable.clear();
            this.dataTable = TreeBasedTable.create();
            ArrayList upsertColumns = Lists.newArrayList();
            ArrayList rowKeyPositions = Lists.newArrayList();
            boolean isFullRowUpdate = this.getColumnPositionsToUpdate().isEmpty();
            if (isFullRowUpdate) {
                upsertColumns.addAll(this.getUpsertColumns());
            } else {
                List<String> tmpColumns = this.getUpsertColumns();
                for (int i : this.getColumnPositionsToUpdate()) {
                    upsertColumns.add(tmpColumns.get(i));
                }
            }
            HashSet rowKeys = this.getRowKeyColumns() == null || this.getRowKeyColumns().isEmpty() ? Sets.newHashSet(this.getUpsertColumns()) : Sets.newHashSet(this.getRowKeyColumns());
            StringBuilder buf = new StringBuilder("UPSERT INTO ");
            buf.append(this.getTargetEntity());
            buf.append(" (").append(Joiner.on((String)",").join((Iterable)upsertColumns)).append(") VALUES(");
            for (int i = 0; i < upsertColumns.size(); ++i) {
                buf.append("?,");
                if (!rowKeys.contains(upsertColumns.get(i))) continue;
                rowKeyPositions.add(i);
            }
            buf.setCharAt(buf.length() - 1, ')');
            LOGGER.debug(buf.toString());
            Connection connection = this.getConnection();
            try (PreparedStatement stmt = connection.prepareStatement(buf.toString());){
                for (int r = startRowIndex; r < startRowIndex + numRows; ++r) {
                    ArrayList upsertValues = Lists.newArrayList();
                    List<Object> rowValues = null;
                    rowValues = this.getTestDataSupplier().getValues(r);
                    if (isFullRowUpdate) {
                        upsertValues.addAll(rowValues);
                    } else {
                        for (int c : this.getColumnPositionsToUpdate()) {
                            upsertValues.add(rowValues.get(c));
                        }
                    }
                    ArrayList rowKeyParts = Lists.newArrayList();
                    Iterator c = rowKeyPositions.iterator();
                    while (c.hasNext()) {
                        int position = (Integer)c.next();
                        if (upsertValues.get(position) == null) continue;
                        rowKeyParts.add(upsertValues.get(position).toString());
                    }
                    String rowKey = Joiner.on((String)"-").join((Iterable)rowKeyParts);
                    for (int v = 0; v < upsertValues.size(); ++v) {
                        stmt.setObject(v + 1, upsertValues.get(v));
                        if (upsertValues.get(v) == null) continue;
                        this.dataTable.put((Object)rowKey, upsertColumns.get(v), upsertValues.get(v));
                    }
                    stmt.addBatch();
                }
                stmt.executeBatch();
                connection.commit();
            }
        }
    }

    public static class BasicDataReader
    extends AbstractDataReader {
        Connection connection;
        String targetEntity;
        String dmlStatement;
        List<String> validationColumns;
        List<String> rowKeyColumns;

        @Override
        public String getDML() {
            return this.dmlStatement;
        }

        @Override
        public String setDML(String dmlStatement) {
            this.dmlStatement = dmlStatement;
            return this.dmlStatement;
        }

        @Override
        public List<String> getValidationColumns() {
            return this.validationColumns;
        }

        @Override
        public void setValidationColumns(List<String> validationColumns) {
            this.validationColumns = validationColumns;
        }

        @Override
        public List<String> getRowKeyColumns() {
            return this.rowKeyColumns;
        }

        @Override
        public void setRowKeyColumns(List<String> rowKeyColumns) {
            this.rowKeyColumns = rowKeyColumns;
        }

        @Override
        public Connection getConnection() {
            return this.connection;
        }

        @Override
        public void setConnection(Connection connection) {
            this.connection = connection;
        }

        @Override
        public String getTargetEntity() {
            return this.targetEntity;
        }

        @Override
        public void setTargetEntity(String targetEntity) {
            this.targetEntity = targetEntity;
        }
    }

    public static abstract class AbstractDataReader
    implements DataReader {
        Table<String, String, Object> dataTable = TreeBasedTable.create();

        @Override
        public Table<String, String, Object> getDataTable() {
            return this.dataTable;
        }

        @Override
        public void readRows() throws SQLException {
            this.dataTable.clear();
            this.dataTable = TreeBasedTable.create();
            String sql = this.getDML();
            Connection connection = this.getConnection();
            try (Statement stmt = connection.createStatement();){
                PhoenixStatement pstmt = stmt.unwrap(PhoenixStatement.class);
                ResultSet rs = pstmt.executeQuery(sql);
                List<String> cols = this.getValidationColumns();
                ArrayList values = Lists.newArrayList();
                HashSet rowKeys = this.getRowKeyColumns() == null || this.getRowKeyColumns().isEmpty() ? Sets.newHashSet() : Sets.newHashSet(this.getRowKeyColumns());
                ArrayList rowKeyParts = Lists.newArrayList();
                while (rs.next()) {
                    for (String col : cols) {
                        Object val = rs.getObject(col);
                        values.add(val);
                        if (rowKeys.isEmpty()) {
                            rowKeyParts.add(val.toString());
                            continue;
                        }
                        if (!rowKeys.contains(col)) continue;
                        rowKeyParts.add(val.toString());
                    }
                    String rowKey = Joiner.on((String)"-").join((Iterable)rowKeyParts);
                    for (int v = 0; v < values.size(); ++v) {
                        this.dataTable.put((Object)rowKey, (Object)cols.get(v), values.get(v));
                    }
                    values.clear();
                    rowKeyParts.clear();
                }
                LOGGER.info(String.format("########## sql: %s => rows: %d", sql, this.dataTable.rowKeySet().size()));
            }
            catch (SQLException e) {
                LOGGER.error(String.format(" Error [%s] initializing Reader. ", e.getMessage()));
                throw e;
            }
        }
    }

    public static interface DataWriter {
        public List<String> getUpsertColumns();

        public void setUpsertColumns(List<String> var1);

        public List<Integer> getColumnPositionsToUpdate();

        public void setColumnPositionsToUpdate(List<Integer> var1);

        public Connection getConnection();

        public void setConnection(Connection var1);

        public String getTargetEntity();

        public void setTargetEntity(String var1);

        public List<String> getRowKeyColumns();

        public void setRowKeyColumns(List<String> var1);

        public DataSupplier getTestDataSupplier();

        public void setDataSupplier(DataSupplier var1);

        public List<Object> upsertRow(int var1) throws Exception;

        public void upsertRows(int var1, int var2) throws Exception;

        public Table<String, String, Object> getDataTable();
    }

    public static interface DataReader {
        public List<String> getValidationColumns();

        public void setValidationColumns(List<String> var1);

        public List<String> getRowKeyColumns();

        public void setRowKeyColumns(List<String> var1);

        public Connection getConnection();

        public void setConnection(Connection var1);

        public String getTargetEntity();

        public void setTargetEntity(String var1);

        public String getDML();

        public String setDML(String var1);

        public void readRows() throws SQLException;

        public Table<String, String, Object> getDataTable();
    }

    public static interface DataSupplier {
        public List<Object> getValues(int var1) throws Exception;
    }
}

