/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.query;

import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.query.GuidePostsCacheImpl;
import org.apache.phoenix.query.HBaseFactoryProvider;
import org.apache.phoenix.query.PhoenixStatsCacheLoader;
import org.apache.phoenix.query.PhoenixStatsLoader;
import org.apache.phoenix.schema.stats.GuidePostsInfo;
import org.apache.phoenix.schema.stats.GuidePostsKey;
import org.apache.phoenix.thirdparty.com.google.common.cache.CacheBuilder;
import org.apache.phoenix.thirdparty.com.google.common.cache.CacheLoader;
import org.apache.phoenix.thirdparty.com.google.common.cache.LoadingCache;
import org.apache.phoenix.thirdparty.com.google.common.cache.RemovalListener;
import org.apache.phoenix.thirdparty.com.google.common.cache.Weigher;
import org.apache.phoenix.util.ByteUtil;
import org.junit.Assert;
import org.junit.Test;

public class PhoenixStatsCacheLoaderTest {
    GuidePostsInfo getStats(LoadingCache<GuidePostsKey, GuidePostsInfo> cache, GuidePostsKey guidePostsKey) {
        GuidePostsInfo guidePostsInfo;
        try {
            guidePostsInfo = (GuidePostsInfo)cache.get((Object)guidePostsKey);
        }
        catch (ExecutionException e) {
            Assert.assertFalse((boolean)true);
            return GuidePostsInfo.NO_GUIDEPOST;
        }
        return guidePostsInfo;
    }

    void sleep(int x) {
        try {
            Thread.sleep(x);
        }
        catch (InterruptedException e) {
            Assert.assertFalse((boolean)true);
        }
    }

    @Test
    public void testStatsBeingAutomaticallyRefreshed() {
        ExecutorService executor = Executors.newFixedThreadPool(4);
        CountDownLatch firstTimeRefreshedSignal = new CountDownLatch(1);
        CountDownLatch secondTimeRefreshedSignal = new CountDownLatch(2);
        Configuration config = HBaseFactoryProvider.getConfigurationFactory().getConfiguration();
        LoadingCache cache = CacheBuilder.newBuilder().refreshAfterWrite(100L, TimeUnit.MILLISECONDS).maximumWeight(0x10000000L).weigher((Weigher)new Weigher<GuidePostsKey, GuidePostsInfo>(){

            public int weigh(GuidePostsKey key, GuidePostsInfo info) {
                return info.getEstimatedSize();
            }
        }).removalListener((RemovalListener)new GuidePostsCacheImpl.PhoenixStatsCacheRemovalListener()).build((CacheLoader)new PhoenixStatsCacheLoader((PhoenixStatsLoader)new TestStatsLoaderImpl(firstTimeRefreshedSignal, secondTimeRefreshedSignal), config));
        try {
            GuidePostsKey guidePostsKey = new GuidePostsKey(new byte[4], new byte[4]);
            GuidePostsInfo guidePostsInfo = this.getStats((LoadingCache<GuidePostsKey, GuidePostsInfo>)cache, guidePostsKey);
            Assert.assertTrue((guidePostsInfo.getMaxLength() == 1 ? 1 : 0) != 0);
            this.sleep(150);
            guidePostsInfo = this.getStats((LoadingCache<GuidePostsKey, GuidePostsInfo>)cache, guidePostsKey);
            Assert.assertTrue((guidePostsInfo.getMaxLength() >= 1 ? 1 : 0) != 0);
            firstTimeRefreshedSignal.await();
            this.sleep(150);
            guidePostsInfo = this.getStats((LoadingCache<GuidePostsKey, GuidePostsInfo>)cache, guidePostsKey);
            Assert.assertTrue((guidePostsInfo.getMaxLength() >= 2 ? 1 : 0) != 0);
            secondTimeRefreshedSignal.await();
        }
        catch (InterruptedException e) {
            Assert.assertFalse((boolean)true);
        }
    }

    protected class TestStatsLoaderImpl
    implements PhoenixStatsLoader {
        private int maxLength = 1;
        private final CountDownLatch firstTimeRefreshedSignal;
        private final CountDownLatch secondTimeRefreshedSignal;

        public TestStatsLoaderImpl(CountDownLatch firstTimeRefreshedSignal, CountDownLatch secondTimeRefreshedSignal) {
            this.firstTimeRefreshedSignal = firstTimeRefreshedSignal;
            this.secondTimeRefreshedSignal = secondTimeRefreshedSignal;
        }

        public boolean needsLoad() {
            return true;
        }

        public GuidePostsInfo loadStats(GuidePostsKey statsKey) throws Exception {
            return new GuidePostsInfo(Collections.emptyList(), new ImmutableBytesWritable(ByteUtil.EMPTY_BYTE_ARRAY), Collections.emptyList(), this.maxLength++, 0, Collections.emptyList());
        }

        public GuidePostsInfo loadStats(GuidePostsKey statsKey, GuidePostsInfo prevGuidepostInfo) throws Exception {
            this.firstTimeRefreshedSignal.countDown();
            this.secondTimeRefreshedSignal.countDown();
            return new GuidePostsInfo(Collections.emptyList(), new ImmutableBytesWritable(ByteUtil.EMPTY_BYTE_ARRAY), Collections.emptyList(), this.maxLength++, 0, Collections.emptyList());
        }
    }
}

