/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.query;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparatorImpl;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.query.BaseConnectionlessQueryTest;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PDate;
import org.apache.phoenix.util.PhoenixRuntime;
import org.junit.Assert;
import org.junit.Test;

public class OrderByTest
extends BaseConnectionlessQueryTest {
    @Test
    public void testSortOrderForSingleDescVarLengthCol() throws SQLException {
        Connection conn = DriverManager.getConnection(OrderByTest.getUrl());
        conn.createStatement().execute("CREATE TABLE t (k VARCHAR PRIMARY KEY DESC)");
        conn.createStatement().execute("UPSERT INTO t VALUES ('a')");
        conn.createStatement().execute("UPSERT INTO t VALUES ('ab')");
        Iterator dataIterator = PhoenixRuntime.getUncommittedDataIterator((Connection)conn);
        List kvs = (List)((Pair)dataIterator.next()).getSecond();
        Collections.sort(kvs, CellComparatorImpl.COMPARATOR);
        Cell first = (Cell)kvs.get(0);
        Assert.assertEquals((Object)"ab", (Object)Bytes.toString((byte[])SortOrder.invert((byte[])first.getRowArray(), (int)first.getRowOffset(), (int)(first.getRowLength() - 1))));
        Cell second = (Cell)kvs.get(1);
        Assert.assertEquals((Object)"a", (Object)Bytes.toString((byte[])SortOrder.invert((byte[])second.getRowArray(), (int)second.getRowOffset(), (int)(second.getRowLength() - 1))));
    }

    @Test
    public void testSortOrderForLeadingDescVarLengthColWithNullFollowing() throws SQLException {
        Connection conn = DriverManager.getConnection(OrderByTest.getUrl());
        conn.createStatement().execute("CREATE TABLE t (k1 VARCHAR, k2 VARCHAR, CONSTRAINT pk PRIMARY KEY (k1 DESC,k2))");
        conn.createStatement().execute("UPSERT INTO t VALUES ('a')");
        conn.createStatement().execute("UPSERT INTO t VALUES ('ab')");
        Iterator dataIterator = PhoenixRuntime.getUncommittedDataIterator((Connection)conn);
        List kvs = (List)((Pair)dataIterator.next()).getSecond();
        Collections.sort(kvs, CellComparatorImpl.COMPARATOR);
        Cell first = (Cell)kvs.get(0);
        Assert.assertEquals((Object)"ab", (Object)Bytes.toString((byte[])SortOrder.invert((byte[])first.getRowArray(), (int)first.getRowOffset(), (int)(first.getRowLength() - 1))));
        Cell second = (Cell)kvs.get(1);
        Assert.assertEquals((Object)"a", (Object)Bytes.toString((byte[])SortOrder.invert((byte[])second.getRowArray(), (int)second.getRowOffset(), (int)(second.getRowLength() - 1))));
    }

    @Test
    public void testSortOrderForLeadingDescVarLengthColWithNonNullFollowing() throws SQLException {
        Connection conn = DriverManager.getConnection(OrderByTest.getUrl());
        conn.createStatement().execute("CREATE TABLE t (k1 VARCHAR, k2 VARCHAR NOT NULL, CONSTRAINT pk PRIMARY KEY (k1 DESC,k2))");
        conn.createStatement().execute("UPSERT INTO t VALUES ('a','x')");
        conn.createStatement().execute("UPSERT INTO t VALUES ('ab', 'x')");
        Iterator dataIterator = PhoenixRuntime.getUncommittedDataIterator((Connection)conn);
        List kvs = (List)((Pair)dataIterator.next()).getSecond();
        Collections.sort(kvs, CellComparatorImpl.COMPARATOR);
        Cell first = (Cell)kvs.get(0);
        Assert.assertEquals((Object)"ab", (Object)Bytes.toString((byte[])SortOrder.invert((byte[])first.getRowArray(), (int)first.getRowOffset(), (int)2)));
        Cell second = (Cell)kvs.get(1);
        Assert.assertEquals((Object)"a", (Object)Bytes.toString((byte[])SortOrder.invert((byte[])second.getRowArray(), (int)second.getRowOffset(), (int)1)));
    }

    @Test
    public void testSortOrderForSingleDescTimestampCol() throws SQLException {
        Connection conn = DriverManager.getConnection(OrderByTest.getUrl());
        conn.createStatement().execute("CREATE TABLE t (k TIMESTAMP PRIMARY KEY DESC)");
        conn.createStatement().execute("UPSERT INTO t VALUES ('2016-01-04 13:11:51.631')");
        Iterator dataIterator = PhoenixRuntime.getUncommittedDataIterator((Connection)conn);
        List kvs = (List)((Pair)dataIterator.next()).getSecond();
        Collections.sort(kvs, CellComparatorImpl.COMPARATOR);
        Cell first = (Cell)kvs.get(0);
        long millisDeserialized = PDate.INSTANCE.getCodec().decodeLong(first.getRowArray(), first.getRowOffset(), SortOrder.DESC);
        Assert.assertEquals((long)1451913111631L, (long)millisDeserialized);
    }
}

