/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.query;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.monitoring.GlobalClientMetrics;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.schema.PMetaData;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.schema.PTableRef;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.TableNotFoundException;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.RunUntilFailure;
import org.apache.phoenix.util.ValidateLastDDLTimestampUtil;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=RunUntilFailure.class)
@Category(value={NeedsOwnMiniClusterTest.class})
public class MetaDataCachingIT
extends BaseTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetaDataCachingIT.class);
    private final Random RAND = new Random(11L);
    private boolean isLastDDLTimestampValidationEnabled = ValidateLastDDLTimestampUtil.getValidateLastDdlTimestampEnabled((Configuration)config);

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap props = Maps.newHashMapWithExpectedSize((int)1);
        props.put("phoenix.client.maxMetaDataCacheSize", "50000");
        props.put("phoenix.table.client.cache.encoding", "object");
        MetaDataCachingIT.setUpTestDriver(new ReadOnlyProps(props.entrySet().iterator()));
    }

    protected void createTable(Connection conn, String tableName, long updateCacheFrequency) throws SQLException {
        conn.createStatement().execute("CREATE TABLE " + tableName + "(k INTEGER NOT NULL PRIMARY KEY, v1 INTEGER, v2 INTEGER, v3 VARCHAR, v4 Date,  v5 BIGINT, v6 SMALLINT)" + (updateCacheFrequency == 0L ? "" : "UPDATE_CACHE_FREQUENCY=" + updateCacheFrequency));
    }

    private void upsert(Connection conn, String tableName) throws SQLException {
        conn.createStatement().execute("UPSERT INTO " + tableName + " (k, v1, v1) VALUES (" + this.RAND.nextInt() + ", " + this.RAND.nextInt() + ", " + this.RAND.nextInt() + ")");
        conn.commit();
    }

    private void query(Connection conn, String tableName) throws SQLException {
        ResultSet rs = conn.createStatement().executeQuery("SELECT COUNT(*) FROM " + tableName);
        rs.next();
    }

    private String[] simulateWorkload(String testName, final int numTables, int numThreads, final int numMaxDML) throws Exception {
        int i;
        final String[] tableNames = new String[numTables];
        for (int i2 = 0; i2 < numTables; ++i2) {
            tableNames[i2] = MetaDataCachingIT.generateUniqueName();
            try (Connection conn = DriverManager.getConnection(MetaDataCachingIT.getUrl());){
                this.createTable(conn, tableNames[i2], i2 % 2 == 0 ? 0L : 100000L);
                continue;
            }
        }
        final CountDownLatch doneSignal = new CountDownLatch(numThreads);
        Runnable[] runnables = new Runnable[numThreads];
        for (i = 0; i < numThreads; ++i) {
            runnables[i] = new Runnable(){

                @Override
                public void run() {
                    try (Connection conn = DriverManager.getConnection(BaseTest.getUrl());){
                        for (int i = 0; i < numMaxDML; ++i) {
                            MetaDataCachingIT.this.upsert(conn, tableNames[MetaDataCachingIT.this.RAND.nextInt(numTables)]);
                            MetaDataCachingIT.this.query(conn, tableNames[MetaDataCachingIT.this.RAND.nextInt(numTables)]);
                        }
                    }
                    catch (SQLException e) {
                        throw new RuntimeException(e);
                    }
                    finally {
                        doneSignal.countDown();
                    }
                }
            };
        }
        for (i = 0; i < numThreads; ++i) {
            Thread t = new Thread(runnables[i]);
            t.start();
        }
        Assert.assertTrue((String)("Ran out of time for test " + testName), (boolean)doneSignal.await(120L, TimeUnit.SECONDS));
        return tableNames;
    }

    @Test
    public void testSystemTablesAreInCache() throws Exception {
        this.simulateWorkload("testSystemTablesAreInCache", 10, 10, 10);
        try (Connection conn = DriverManager.getConnection(MetaDataCachingIT.getUrl());){
            ResultSet rs = conn.getMetaData().getTables("", null, null, new String[]{PTableType.SYSTEM.toString()});
            PMetaData pMetaData = conn.unwrap(PhoenixConnection.class).getMetaDataCache();
            while (rs.next()) {
                String tableName = rs.getString("TABLE_SCHEM") + "." + rs.getString("TABLE_NAME");
                try {
                    pMetaData.getTableRef(new PTableKey(null, tableName));
                }
                catch (TableNotFoundException e) {
                    Assert.fail((String)("System table " + tableName + " should be in the cache"));
                }
            }
        }
    }

    @Test
    public void testGlobalClientCacheMetrics() throws Exception {
        int numThreads = 5;
        int numTables = 1;
        int numMaxDML = 2;
        GlobalClientMetrics.GLOBAL_CLIENT_METADATA_CACHE_MISS_COUNTER.getMetric().reset();
        GlobalClientMetrics.GLOBAL_CLIENT_METADATA_CACHE_HIT_COUNTER.getMetric().reset();
        this.simulateWorkload("testGlobalClientCacheMetrics", numTables, numThreads, numMaxDML);
        int numExpectedMisses = 1;
        if (this.isLastDDLTimestampValidationEnabled) {
            numExpectedMisses += 2;
        }
        Assert.assertEquals((String)"Incorrect number of client metadata cache misses", (long)numExpectedMisses, (long)GlobalClientMetrics.GLOBAL_CLIENT_METADATA_CACHE_MISS_COUNTER.getMetric().getValue());
        Assert.assertTrue((String)"number of total metadata cache hits (server+client) should be more than or equal to client cache hits", ((long)(3 * numMaxDML * numThreads) <= GlobalClientMetrics.GLOBAL_CLIENT_METADATA_CACHE_HIT_COUNTER.getMetric().getValue() ? 1 : 0) != 0);
    }

    @Ignore
    @Test
    public void testCacheShouldBeUsedOnlyForConfiguredTables() throws Exception {
        String[] tableNames = this.simulateWorkload("testCacheShouldBeUsedOnlyForConfiguredTables", 25, 10, 4);
        try (Connection conn = DriverManager.getConnection(MetaDataCachingIT.getUrl());){
            int hitCount = 0;
            for (int i = 0; i < tableNames.length; ++i) {
                PMetaData metaDataCache = conn.unwrap(PhoenixConnection.class).getMetaDataCache();
                PTableRef tableRef = null;
                try {
                    tableRef = metaDataCache.getTableRef(new PTableKey(null, tableNames[i]));
                }
                catch (TableNotFoundException tableNotFoundException) {
                    // empty catch block
                }
                if (i % 2 == 0) {
                    Assert.assertTrue((tableRef == null ? 1 : 0) != 0);
                    continue;
                }
                if (tableRef == null) continue;
                ++hitCount;
            }
            Assert.assertTrue((hitCount > 0 ? 1 : 0) != 0);
        }
    }
}

