/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.query;

import java.sql.Connection;
import java.sql.DriverManager;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.monitoring.GlobalClientMetrics;
import org.apache.phoenix.query.MetaDataCachingIT;
import org.apache.phoenix.util.RunUntilFailure;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=RunUntilFailure.class)
@Category(value={NeedsOwnMiniClusterTest.class})
public class MetaDataCacheMetricsIT
extends MetaDataCachingIT {
    @Test
    public void testGlobalClientCacheMetricsOfCreateAndDropTable() throws Exception {
        GlobalClientMetrics.GLOBAL_CLIENT_METADATA_CACHE_ADD_COUNTER.getMetric().reset();
        GlobalClientMetrics.GLOBAL_CLIENT_METADATA_CACHE_REMOVAL_COUNTER.getMetric().reset();
        GlobalClientMetrics.GLOBAL_CLIENT_METADATA_CACHE_ESTIMATED_USED_SIZE.getMetric().reset();
        String tableName = MetaDataCacheMetricsIT.generateUniqueName();
        try (PhoenixConnection conn = (PhoenixConnection)DriverManager.getConnection(MetaDataCacheMetricsIT.getUrl());){
            long prevCacheAddCount = GlobalClientMetrics.GLOBAL_CLIENT_METADATA_CACHE_ADD_COUNTER.getMetric().getValue();
            long prevEstimatedUsedCacheSize = GlobalClientMetrics.GLOBAL_CLIENT_METADATA_CACHE_ESTIMATED_USED_SIZE.getMetric().getValue();
            this.createTable((Connection)conn, tableName, 0L);
            Assert.assertEquals((String)"Incorrect number of client metadata cache adds", (long)(prevCacheAddCount + 1L), (long)GlobalClientMetrics.GLOBAL_CLIENT_METADATA_CACHE_ADD_COUNTER.getMetric().getValue());
            long currEstimatedUsedCacheSize = GlobalClientMetrics.GLOBAL_CLIENT_METADATA_CACHE_ESTIMATED_USED_SIZE.getMetric().getValue();
            int tableEstimatedSize = conn.getTable(tableName).getEstimatedSize();
            Assert.assertTrue((String)String.format("Incorrect estimated used size of client metadata cache after creating table %s: tableEstimatedSize=%d, prevEstimatedUsedCacheSize=%d,  currEstimatedUsedCacheSize=%d", tableName, tableEstimatedSize, prevEstimatedUsedCacheSize, currEstimatedUsedCacheSize), (currEstimatedUsedCacheSize >= prevEstimatedUsedCacheSize + (long)tableEstimatedSize ? 1 : 0) != 0);
            long prevCacheRemovalCount = GlobalClientMetrics.GLOBAL_CLIENT_METADATA_CACHE_REMOVAL_COUNTER.getMetric().getValue();
            prevEstimatedUsedCacheSize = currEstimatedUsedCacheSize;
            conn.createStatement().execute("DROP TABLE " + tableName);
            currEstimatedUsedCacheSize = GlobalClientMetrics.GLOBAL_CLIENT_METADATA_CACHE_ESTIMATED_USED_SIZE.getMetric().getValue();
            Assert.assertEquals((String)"Incorrect number of client metadata cache removals", (long)(prevCacheRemovalCount + 1L), (long)GlobalClientMetrics.GLOBAL_CLIENT_METADATA_CACHE_REMOVAL_COUNTER.getMetric().getValue());
            Assert.assertTrue((String)String.format("Incorrect estimated used size of client metadata cache after dropping table %s: tableEstimatedSize=%d, prevEstimatedUsedCacheSize=%d, currEstimatedUsedCacheSize=%d", tableName, tableEstimatedSize, prevEstimatedUsedCacheSize, currEstimatedUsedCacheSize), (currEstimatedUsedCacheSize < prevEstimatedUsedCacheSize && currEstimatedUsedCacheSize >= prevEstimatedUsedCacheSize - (long)tableEstimatedSize ? 1 : 0) != 0);
        }
    }

    @Override
    @Test
    public void testSystemTablesAreInCache() throws Exception {
    }

    @Override
    @Test
    public void testGlobalClientCacheMetrics() throws Exception {
    }
}

