/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import junit.framework.TestCase;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.junit.Test;

public class KeyRangeMoreTest
extends TestCase {
    @Test
    public void testListIntersectWithOneResultRange() throws Exception {
        for (boolean addEmptyRange : new boolean[]{true, false}) {
            this.doTestListIntersectWithOneResultRange(0, 200, 3, 1, 180, 2, addEmptyRange);
            this.doTestListIntersectWithOneResultRange(1, 180, 2, 0, 200, 3, addEmptyRange);
            this.doTestListIntersectWithOneResultRange(1, 180, 3, 0, 200, 2, addEmptyRange);
            this.doTestListIntersectWithOneResultRange(0, 200, 2, 1, 180, 3, addEmptyRange);
            this.doTestListIntersectWithOneResultRange(0, 200, 3, 1, 180, 100, addEmptyRange);
            this.doTestListIntersectWithOneResultRange(1, 180, 100, 0, 200, 3, addEmptyRange);
            this.doTestListIntersectWithOneResultRange(1, 180, 3, 0, 200, 100, addEmptyRange);
            this.doTestListIntersectWithOneResultRange(0, 200, 100, 1, 180, 3, addEmptyRange);
        }
    }

    private void doTestListIntersectWithOneResultRange(int start1, int end1, int step1, int start2, int end2, int step2, boolean addEmptyRange) throws Exception {
        int i;
        ArrayList<KeyRange> rowKeyRanges1 = new ArrayList<KeyRange>();
        ArrayList<KeyRange> rowKeyRanges2 = new ArrayList<KeyRange>();
        for (i = start1; i <= end1; ++i) {
            rowKeyRanges1.add(PInteger.INSTANCE.getKeyRange(PInteger.INSTANCE.toBytes((Object)i), true, PInteger.INSTANCE.toBytes((Object)(i + step1)), true, SortOrder.ASC));
        }
        if (addEmptyRange) {
            rowKeyRanges1.add(KeyRange.EMPTY_RANGE);
        }
        for (i = start2; i <= end2; ++i) {
            rowKeyRanges2.add(PInteger.INSTANCE.getKeyRange(PInteger.INSTANCE.toBytes((Object)i), true, PInteger.INSTANCE.toBytes((Object)(i + step2)), true, SortOrder.ASC));
        }
        if (addEmptyRange) {
            rowKeyRanges2.add(KeyRange.EMPTY_RANGE);
        }
        int maxStart = Math.max(start1, start2);
        int minEnd = Math.min(end1 + step1, end2 + step2);
        List<KeyRange> expected = Arrays.asList(KeyRange.getKeyRange((byte[])PInteger.INSTANCE.toBytes((Object)maxStart), (boolean)true, (byte[])PInteger.INSTANCE.toBytes((Object)minEnd), (boolean)true));
        KeyRangeMoreTest.listIntersectAndAssert(rowKeyRanges1, rowKeyRanges2, expected);
    }

    @Test
    public void testListIntersectWithMultiResultRange() throws Exception {
        for (boolean addEmptyRange : new boolean[]{true, false}) {
            this.doTestListIntersectWithMultiResultRange(1, 100, 3, 4, 120, 6, addEmptyRange);
            this.doTestListIntersectWithMultiResultRange(4, 120, 6, 1, 100, 3, addEmptyRange);
            this.doTestListIntersectWithMultiResultRange(1, 200, 3, 5, 240, 10, addEmptyRange);
            this.doTestListIntersectWithMultiResultRange(5, 240, 10, 1, 200, 3, addEmptyRange);
        }
    }

    private void doTestListIntersectWithMultiResultRange(int start1, int count1, int step1, int start2, int count2, int step2, boolean addEmptyRange) throws Exception {
        int i;
        ArrayList<KeyRange> rowKeyRanges1 = new ArrayList<KeyRange>();
        ArrayList<KeyRange> rowKeyRanges2 = new ArrayList<KeyRange>();
        for (i = 1; i <= count1; ++i) {
            rowKeyRanges1.add(PInteger.INSTANCE.getKeyRange(PInteger.INSTANCE.toBytes((Object)(start1 + (i - 1) * (step1 + 1))), true, PInteger.INSTANCE.toBytes((Object)(start1 + i * (step1 + 1) - 1)), true, SortOrder.ASC));
        }
        if (addEmptyRange) {
            rowKeyRanges1.add(KeyRange.EMPTY_RANGE);
        }
        for (i = 1; i <= count2; ++i) {
            rowKeyRanges2.add(PInteger.INSTANCE.getKeyRange(PInteger.INSTANCE.toBytes((Object)(start2 + (i - 1) * (step2 + 1))), true, PInteger.INSTANCE.toBytes((Object)(start2 + i * (step2 + 1) - 1)), true, SortOrder.ASC));
        }
        if (addEmptyRange) {
            rowKeyRanges2.add(KeyRange.EMPTY_RANGE);
        }
        int maxStart = Math.max(start1, start2);
        int minEnd = Math.min(start1 + count1 * (step1 + 1) - 1, start2 + count2 * (step2 + 1) - 1);
        for (int i2 = 0; i2 < 200; ++i2) {
            List result = KeyRange.intersect(rowKeyRanges1, rowKeyRanges2);
            this.assertResult(result, maxStart, minEnd);
            result = KeyRange.intersect(rowKeyRanges2, rowKeyRanges1);
            this.assertResult(result, maxStart, minEnd);
            Collections.shuffle(rowKeyRanges1);
            Collections.shuffle(rowKeyRanges2);
        }
    }

    private void assertResult(List<KeyRange> result, int start, int end) {
        int expectStart = start;
        for (KeyRange rowKeyRange : result) {
            byte[] lowerRange = rowKeyRange.getLowerRange();
            KeyRangeMoreTest.assertTrue((boolean)Bytes.equals((byte[])lowerRange, (byte[])PInteger.INSTANCE.toBytes((Object)expectStart)));
            byte[] upperRange = rowKeyRange.getUpperRange();
            expectStart = (Integer)PInteger.INSTANCE.toObject(upperRange) + 1;
        }
        KeyRangeMoreTest.assertTrue((expectStart - 1 == end ? 1 : 0) != 0);
    }

    @Test
    public void testListIntersectForPoint() throws Exception {
        for (boolean addEmptyRange : new boolean[]{true, false}) {
            int i;
            ArrayList<KeyRange> rowKeyRanges1 = new ArrayList<KeyRange>();
            ArrayList<KeyRange> rowKeyRanges2 = new ArrayList<KeyRange>();
            for (i = 0; i <= 300; i += 2) {
                rowKeyRanges1.add(KeyRange.getKeyRange((byte[])PInteger.INSTANCE.toBytes((Object)i)));
            }
            if (addEmptyRange) {
                rowKeyRanges1.add(KeyRange.EMPTY_RANGE);
            }
            for (i = 0; i <= 300; i += 3) {
                rowKeyRanges2.add(KeyRange.getKeyRange((byte[])PInteger.INSTANCE.toBytes((Object)i)));
            }
            if (addEmptyRange) {
                rowKeyRanges2.add(KeyRange.EMPTY_RANGE);
            }
            ArrayList<KeyRange> expected = new ArrayList<KeyRange>();
            for (int i2 = 0; i2 <= 300; i2 += 6) {
                expected.add(KeyRange.getKeyRange((byte[])PInteger.INSTANCE.toBytes((Object)i2)));
            }
            KeyRangeMoreTest.listIntersectAndAssert(rowKeyRanges1, rowKeyRanges2, expected);
        }
    }

    @Test
    public void testListIntersectForBoundary() throws Exception {
        List<KeyRange> rowKeyRanges1 = Arrays.asList(KeyRange.EVERYTHING_RANGE);
        List<KeyRange> rowKeyRanges2 = new ArrayList<KeyRange>();
        for (int i = 0; i <= 100; i += 4) {
            rowKeyRanges2.add(PInteger.INSTANCE.getKeyRange(PInteger.INSTANCE.toBytes((Object)i), true, PInteger.INSTANCE.toBytes((Object)(i + 2)), true, SortOrder.ASC));
        }
        List<KeyRange> expected = new ArrayList<KeyRange>(rowKeyRanges2);
        KeyRangeMoreTest.listIntersectAndAssert(rowKeyRanges1, rowKeyRanges2, expected);
        rowKeyRanges1 = Arrays.asList(KeyRange.EMPTY_RANGE);
        rowKeyRanges2 = new ArrayList<KeyRange>(expected);
        KeyRangeMoreTest.listIntersectAndAssert(rowKeyRanges1, rowKeyRanges2, Arrays.asList(KeyRange.EMPTY_RANGE));
        KeyRangeMoreTest.listIntersectAndAssert(Arrays.asList(KeyRange.EMPTY_RANGE), Arrays.asList(KeyRange.EVERYTHING_RANGE), Arrays.asList(KeyRange.EMPTY_RANGE));
        rowKeyRanges1 = KeyRangeMoreTest.createKeyRangeList(Arrays.asList(2, 5, 8, Integer.MAX_VALUE), Arrays.asList(true, true, true, false));
        rowKeyRanges2 = KeyRangeMoreTest.createKeyRangeList(Arrays.asList(Integer.MIN_VALUE, 4, 7, 10, 13, 14, 19, Integer.MAX_VALUE), Arrays.asList(false, true, true, true, true, true, true, false));
        expected = KeyRangeMoreTest.createKeyRangeList(Arrays.asList(2, 4, 8, 10, 13, 14, 19, Integer.MAX_VALUE), Arrays.asList(true, true, true, true, true, true, true, false));
        KeyRangeMoreTest.listIntersectAndAssert(rowKeyRanges1, rowKeyRanges2, expected);
        rowKeyRanges1 = KeyRangeMoreTest.createKeyRangeList(Arrays.asList(3, 5, 5, 6), Arrays.asList(true, false, true, false));
        rowKeyRanges2 = KeyRangeMoreTest.createKeyRangeList(Arrays.asList(3, 5, 6, 7), Arrays.asList(true, true, true, true));
        expected = KeyRangeMoreTest.createKeyRangeList(Arrays.asList(3, 5), Arrays.asList(true, true));
        KeyRangeMoreTest.listIntersectAndAssert(rowKeyRanges1, rowKeyRanges2, expected);
    }

    @Test
    public void testKeyRangeCompareUpperRange() throws Exception {
        List<KeyRange> rowKeyRanges1 = KeyRangeMoreTest.createKeyRangeListWithFixedLowerRange(Arrays.asList(Integer.MAX_VALUE, Integer.MAX_VALUE, 10000, 1001, 1000, 1000, 1000, 1000, 1000), Arrays.asList(false, false, true, true, true, true, false, true, false));
        List<KeyRange> rowKeyRanges2 = KeyRangeMoreTest.createKeyRangeListWithFixedLowerRange(Arrays.asList(Integer.MAX_VALUE, 10000, Integer.MAX_VALUE, 1000, 1001, 1000, 1000, 1000, 1000), Arrays.asList(false, false, false, true, true, true, false, false, true));
        List<Integer> expectedResults = Arrays.asList(0, 1, -1, 1, -1, 0, 0, 1, -1);
        KeyRangeMoreTest.assertEquals((int)rowKeyRanges1.size(), (int)rowKeyRanges2.size());
        KeyRangeMoreTest.assertEquals((int)rowKeyRanges1.size(), (int)expectedResults.size());
        for (int i = 0; i < expectedResults.size(); ++i) {
            int compareResult = KeyRange.compareUpperRange((KeyRange)rowKeyRanges1.get(i), (KeyRange)rowKeyRanges2.get(i));
            KeyRangeMoreTest.assertEquals((int)expectedResults.get(i), (int)compareResult);
        }
    }

    private static List<KeyRange> createKeyRangeListWithFixedLowerRange(List<Integer> keys, List<Boolean> boundaryConditions) {
        KeyRangeMoreTest.assertEquals((int)keys.size(), (int)boundaryConditions.size());
        ArrayList newKeys = Lists.newArrayListWithCapacity((int)(keys.size() * 2));
        ArrayList newBoundaryConditions = Lists.newArrayListWithCapacity((int)(boundaryConditions.size() * 2));
        for (int i = 0; i < keys.size(); ++i) {
            newKeys.add(0);
            newBoundaryConditions.add(true);
            newKeys.add(keys.get(i));
            newBoundaryConditions.add(boundaryConditions.get(i));
        }
        return KeyRangeMoreTest.createKeyRangeList(newKeys, newBoundaryConditions);
    }

    private static List<KeyRange> createKeyRangeList(List<Integer> keys, List<Boolean> boundaryConditions) {
        KeyRangeMoreTest.assertEquals((int)keys.size(), (int)boundaryConditions.size());
        KeyRangeMoreTest.assertTrue((keys.size() % 2 == 0 ? 1 : 0) != 0);
        int size = keys.size() / 2;
        ArrayList keyRangeList = Lists.newArrayListWithCapacity((int)size);
        for (int i = 0; i < size; ++i) {
            byte[] startKey = keys.get(2 * i).equals(Integer.MIN_VALUE) ? KeyRange.UNBOUND : PInteger.INSTANCE.toBytes((Object)keys.get(2 * i));
            byte[] endKey = keys.get(2 * i + 1).equals(Integer.MAX_VALUE) ? KeyRange.UNBOUND : PInteger.INSTANCE.toBytes((Object)keys.get(2 * i + 1));
            keyRangeList.add(PInteger.INSTANCE.getKeyRange(startKey, boundaryConditions.get(2 * i).booleanValue(), endKey, boundaryConditions.get(2 * i + 1).booleanValue(), SortOrder.ASC));
        }
        return keyRangeList;
    }

    private static void listIntersectAndAssert(List<KeyRange> rowKeyRanges1, List<KeyRange> rowKeyRanges2, List<KeyRange> expected) {
        for (int i = 0; i < 200; ++i) {
            List result = KeyRange.intersect(rowKeyRanges1, rowKeyRanges2);
            KeyRangeMoreTest.assertEquals(expected, (Object)result);
            result = KeyRange.intersect(rowKeyRanges2, rowKeyRanges1);
            KeyRangeMoreTest.assertEquals(expected, (Object)result);
            Collections.shuffle(rowKeyRanges1);
            Collections.shuffle(rowKeyRanges2);
        }
    }
}

