/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.query;

import java.util.Arrays;
import java.util.Collection;
import junit.framework.TestCase;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PChar;
import org.apache.phoenix.schema.types.PDate;
import org.apache.phoenix.util.DateUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class KeyRangeIntersectTest
extends TestCase {
    private final KeyRange a;
    private final KeyRange b;
    private final KeyRange intersection;

    public KeyRangeIntersectTest(KeyRange a, KeyRange b, KeyRange intersection) {
        this.a = a;
        this.b = b;
        this.intersection = intersection;
    }

    @Parameterized.Parameters(name="intersection of {0} and {1} is {2}")
    public static synchronized Collection<?> data() {
        return Arrays.asList({PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"C"), true, Bytes.toBytes((String)"E"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"D"), true, Bytes.toBytes((String)"F"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"D"), true, Bytes.toBytes((String)"E"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"C"), true, Bytes.toBytes((String)"E"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"D"), false, Bytes.toBytes((String)"F"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"D"), false, Bytes.toBytes((String)"E"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"C"), true, Bytes.toBytes((String)"E"), false, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"D"), false, Bytes.toBytes((String)"F"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"D"), false, Bytes.toBytes((String)"E"), false, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"C"), true, Bytes.toBytes((String)"E"), false, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"E"), false, Bytes.toBytes((String)"F"), true, SortOrder.ASC), KeyRange.EMPTY_RANGE}, {KeyRange.EVERYTHING_RANGE, PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"E"), false, Bytes.toBytes((String)"F"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"E"), false, Bytes.toBytes((String)"F"), true, SortOrder.ASC)}, {KeyRange.EVERYTHING_RANGE, KeyRange.EVERYTHING_RANGE, KeyRange.EVERYTHING_RANGE}, {KeyRange.EMPTY_RANGE, KeyRange.EVERYTHING_RANGE, KeyRange.EMPTY_RANGE}, {KeyRange.EMPTY_RANGE, PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"E"), false, Bytes.toBytes((String)"F"), true, SortOrder.ASC), KeyRange.EMPTY_RANGE}, {PDate.INSTANCE.getKeyRange(PDate.INSTANCE.toBytes((Object)DateUtil.parseDate((String)"2011-01-01")), true, PDate.INSTANCE.toBytes((Object)DateUtil.parseDate((String)"2016-01-01")), true, SortOrder.ASC), PDate.INSTANCE.getKeyRange(PDate.INSTANCE.toBytes((Object)DateUtil.parseDate((String)"2012-10-21")), false, PDate.INSTANCE.toBytes((Object)DateUtil.parseDate((String)"2016-10-31")), false, SortOrder.ASC), PDate.INSTANCE.getKeyRange(PDate.INSTANCE.toBytes((Object)DateUtil.parseDate((String)"2012-10-21")), false, PDate.INSTANCE.toBytes((Object)DateUtil.parseDate((String)"2016-01-01")), true, SortOrder.ASC)});
    }

    @Test
    public void intersect() {
        KeyRangeIntersectTest.assertEquals((Object)this.intersection, (Object)this.a.intersect(this.b));
        KeyRangeIntersectTest.assertEquals((Object)this.intersection, (Object)this.b.intersect(this.a));
    }
}

