/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PChar;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class KeyRangeCoalesceTest
extends TestCase {
    private static final Random RANDOM = new Random(1L);
    private final List<KeyRange> expected;
    private final List<KeyRange> input;

    public KeyRangeCoalesceTest(List<KeyRange> expected, List<KeyRange> input) {
        this.expected = expected;
        this.input = input;
    }

    @Parameterized.Parameters(name="{0} coalesces to {1}")
    public static synchronized Collection<?> data() {
        return Arrays.asList({KeyRangeCoalesceTest.expect(KeyRange.EMPTY_RANGE), KeyRangeCoalesceTest.input(new KeyRange[0])}, {KeyRangeCoalesceTest.expect(PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"C"), true, Bytes.toBytes((String)"E"), true, SortOrder.ASC)), KeyRangeCoalesceTest.input(PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"C"), true, Bytes.toBytes((String)"E"), true, SortOrder.ASC))}, {KeyRangeCoalesceTest.expect(PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"C"), true, Bytes.toBytes((String)"E"), true, SortOrder.ASC)), KeyRangeCoalesceTest.input(PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"C"), true, Bytes.toBytes((String)"D"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"D"), true, Bytes.toBytes((String)"E"), true, SortOrder.ASC))}, {KeyRangeCoalesceTest.expect(PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"C"), true, Bytes.toBytes((String)"Z"), true, SortOrder.ASC)), KeyRangeCoalesceTest.input(PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"C"), true, Bytes.toBytes((String)"D"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"D"), true, Bytes.toBytes((String)"E"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"D"), true, Bytes.toBytes((String)"Z"), true, SortOrder.ASC))}, {KeyRangeCoalesceTest.expect(PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"B"), true, Bytes.toBytes((String)"Z"), true, SortOrder.ASC)), KeyRangeCoalesceTest.input(PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"C"), true, Bytes.toBytes((String)"D"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"B"), true, Bytes.toBytes((String)"E"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"D"), true, Bytes.toBytes((String)"Z"), true, SortOrder.ASC))}, {KeyRangeCoalesceTest.expect(PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"B"), true, Bytes.toBytes((String)"Z"), true, SortOrder.ASC)), KeyRangeCoalesceTest.input(PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"C"), true, Bytes.toBytes((String)"D"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"B"), true, Bytes.toBytes((String)"Z"), false, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"D"), true, Bytes.toBytes((String)"Z"), true, SortOrder.ASC))}, {KeyRangeCoalesceTest.expect(PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"A"), true, Bytes.toBytes((String)"A"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"B"), true, Bytes.toBytes((String)"Z"), false, SortOrder.ASC)), KeyRangeCoalesceTest.input(PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"A"), true, Bytes.toBytes((String)"A"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"B"), true, Bytes.toBytes((String)"Z"), false, SortOrder.ASC))}, {KeyRangeCoalesceTest.expect(PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"A"), true, Bytes.toBytes((String)"B"), false, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"B"), false, Bytes.toBytes((String)"Z"), false, SortOrder.ASC)), KeyRangeCoalesceTest.input(PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"A"), true, Bytes.toBytes((String)"B"), false, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"B"), false, Bytes.toBytes((String)"Z"), false, SortOrder.ASC))}, {KeyRangeCoalesceTest.expect(PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"A"), true, Bytes.toBytes((String)"Z"), false, SortOrder.ASC)), KeyRangeCoalesceTest.input(PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"A"), true, Bytes.toBytes((String)"B"), false, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"B"), true, Bytes.toBytes((String)"Z"), false, SortOrder.ASC))}, {KeyRangeCoalesceTest.expect(KeyRange.EVERYTHING_RANGE), KeyRangeCoalesceTest.input(KeyRange.EVERYTHING_RANGE, KeyRange.EVERYTHING_RANGE)}, {KeyRangeCoalesceTest.expect(KeyRange.EVERYTHING_RANGE), KeyRangeCoalesceTest.input(KeyRange.EVERYTHING_RANGE)}, {KeyRangeCoalesceTest.expect(KeyRange.EVERYTHING_RANGE), KeyRangeCoalesceTest.input(KeyRange.EMPTY_RANGE, KeyRange.EVERYTHING_RANGE, KeyRange.EVERYTHING_RANGE)}, {KeyRangeCoalesceTest.expect(KeyRange.EMPTY_RANGE), KeyRangeCoalesceTest.input(KeyRange.EMPTY_RANGE)});
    }

    @Test
    public void coalesce() {
        KeyRangeCoalesceTest.assertEquals(this.expected, (Object)KeyRange.coalesce(this.input));
        ArrayList<KeyRange> tmp = new ArrayList<KeyRange>(this.input);
        Collections.reverse(tmp);
        KeyRangeCoalesceTest.assertEquals(this.expected, (Object)KeyRange.coalesce(this.input));
        Collections.shuffle(tmp, RANDOM);
        KeyRangeCoalesceTest.assertEquals(this.expected, (Object)KeyRange.coalesce(this.input));
    }

    private static final List<KeyRange> expect(KeyRange ... kr) {
        return Arrays.asList(kr);
    }

    private static final List<KeyRange> input(KeyRange ... kr) {
        return Arrays.asList(kr);
    }
}

