/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.query;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.compile.ScanRanges;
import org.apache.phoenix.iterate.BaseResultIterators;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.query.BaseConnectionlessQueryTest;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.schema.RowKeySchema;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PSmallint;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.PhoenixRuntime;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class KeyRangeClipTest
extends BaseConnectionlessQueryTest {
    private final RowKeySchema schema;
    private final KeyRange input;
    private final KeyRange expectedOutput;
    private final int clipTo;

    private static byte[] getRange(PhoenixConnection pconn, List<Object> startValues) throws SQLException {
        byte[] lowerRange;
        if (startValues == null) {
            lowerRange = KeyRange.UNBOUND;
        } else {
            String upsertValues = StringUtils.repeat((String)"?,", (int)startValues.size()).substring(0, startValues.size() * 2 - 1);
            String upsertStmt = "UPSERT INTO T VALUES(" + upsertValues + ")";
            PreparedStatement stmt = pconn.prepareStatement(upsertStmt);
            for (int i = 0; i < startValues.size(); ++i) {
                stmt.setObject(i + 1, startValues.get(i));
            }
            stmt.execute();
            Cell startCell = (Cell)((List)((Pair)PhoenixRuntime.getUncommittedDataIterator((Connection)pconn).next()).getSecond()).get(0);
            lowerRange = CellUtil.cloneRow((Cell)startCell);
            pconn.rollback();
        }
        return lowerRange;
    }

    public KeyRangeClipTest(String tableDef, List<Object> startValues, List<Object> endValues, int clipTo, KeyRange expectedOutput) throws SQLException {
        PhoenixConnection pconn = DriverManager.getConnection(KeyRangeClipTest.getUrl()).unwrap(PhoenixConnection.class);
        pconn.createStatement().execute("CREATE TABLE T(" + tableDef + ")");
        PTable table = pconn.getMetaDataCache().getTableRef(new PTableKey(null, "T")).getTable();
        this.schema = table.getRowKeySchema();
        byte[] lowerRange = KeyRangeClipTest.getRange(pconn, startValues);
        byte[] upperRange = KeyRangeClipTest.getRange(pconn, endValues);
        this.input = KeyRange.getKeyRange((byte[])lowerRange, (byte[])upperRange);
        this.expectedOutput = expectedOutput;
        this.clipTo = clipTo;
    }

    @After
    public void cleanup() throws SQLException {
        PhoenixConnection pconn = DriverManager.getConnection(KeyRangeClipTest.getUrl()).unwrap(PhoenixConnection.class);
        pconn.createStatement().execute("DROP TABLE T");
    }

    @Test
    public void test() {
        ScanRanges scanRanges = ScanRanges.create((RowKeySchema)this.schema, Collections.singletonList(Collections.singletonList(this.input)), (int[])new int[]{this.schema.getFieldCount() - 1}, null, (boolean)false, (int)-1);
        ScanRanges clippedRange = BaseResultIterators.computePrefixScanRanges((ScanRanges)scanRanges, (int)this.clipTo);
        Assert.assertEquals((Object)this.expectedOutput, (Object)clippedRange.getScanRange());
    }

    @Parameterized.Parameters(name="KeyRangeClipTest_{0}")
    public static synchronized Collection<Object> data() {
        ArrayList testCases = Lists.newArrayList();
        testCases.add(Lists.newArrayList((Object[])new Object[]{"A VARCHAR NOT NULL, B VARCHAR, C VARCHAR, CONSTRAINT PK PRIMARY KEY (A,B,C)", Lists.newArrayList((Object[])new String[]{"XY", null, "Z"}), null, 2, KeyRange.getKeyRange((byte[])Bytes.toBytes((String)"XY"), (boolean)true, (byte[])KeyRange.UNBOUND, (boolean)false)}).toArray());
        testCases.add(Lists.newArrayList((Object[])new Object[]{"A VARCHAR NOT NULL, B VARCHAR, C VARCHAR, CONSTRAINT PK PRIMARY KEY (A,B,C)", null, Lists.newArrayList((Object[])new String[]{"XY", null, "Z"}), 2, KeyRange.getKeyRange((byte[])ByteUtil.nextKey((byte[])QueryConstants.SEPARATOR_BYTE_ARRAY), (boolean)true, (byte[])ByteUtil.nextKey((byte[])ByteUtil.concat((byte[])Bytes.toBytes((String)"XY"), (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY, QueryConstants.SEPARATOR_BYTE_ARRAY, QueryConstants.SEPARATOR_BYTE_ARRAY})), (boolean)false)}).toArray());
        testCases.add(Lists.newArrayList((Object[])new Object[]{"A VARCHAR NOT NULL, B VARCHAR, C VARCHAR, D VARCHAR, CONSTRAINT PK PRIMARY KEY (A,B,C,D)", Lists.newArrayList((Object[])new String[]{"XY", null, null, "Z"}), null, 3, KeyRange.getKeyRange((byte[])Bytes.toBytes((String)"XY"), (boolean)true, (byte[])KeyRange.UNBOUND, (boolean)false)}).toArray());
        testCases.add(Lists.newArrayList((Object[])new Object[]{"A VARCHAR NOT NULL, B VARCHAR, C VARCHAR, D VARCHAR, CONSTRAINT PK PRIMARY KEY (A,B,C,D)", null, Lists.newArrayList((Object[])new String[]{"XY", null, null, "Z"}), 3, KeyRange.getKeyRange((byte[])ByteUtil.nextKey((byte[])QueryConstants.SEPARATOR_BYTE_ARRAY), (boolean)true, (byte[])ByteUtil.nextKey((byte[])ByteUtil.concat((byte[])Bytes.toBytes((String)"XY"), (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY, QueryConstants.SEPARATOR_BYTE_ARRAY, QueryConstants.SEPARATOR_BYTE_ARRAY, QueryConstants.SEPARATOR_BYTE_ARRAY})), (boolean)false)}).toArray());
        testCases.add(Lists.newArrayList((Object[])new Object[]{"A CHAR(1) NOT NULL, B CHAR(1) NOT NULL, C CHAR(1) NOT NULL, CONSTRAINT PK PRIMARY KEY (A,B,C)", Lists.newArrayList((Object[])new String[]{"A", "B", "C"}), Lists.newArrayList((Object[])new String[]{"C", "D", "E"}), 2, KeyRange.getKeyRange((byte[])Bytes.toBytes((String)"AB"), (boolean)true, (byte[])ByteUtil.nextKey((byte[])Bytes.toBytes((String)"CD")), (boolean)false)}).toArray());
        testCases.add(Lists.newArrayList((Object[])new Object[]{"A VARCHAR NOT NULL, B VARCHAR, C SMALLINT NOT NULL, D VARCHAR, CONSTRAINT PK PRIMARY KEY (A,B,C,D)", Lists.newArrayList((Object[])new Object[]{"XY", null, 1, "Z"}), null, 3, KeyRange.getKeyRange((byte[])ByteUtil.concat((byte[])Bytes.toBytes((String)"XY"), (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY, QueryConstants.SEPARATOR_BYTE_ARRAY, PSmallint.INSTANCE.toBytes((Object)1)}), (boolean)true, (byte[])KeyRange.UNBOUND, (boolean)false)}).toArray());
        testCases.add(Lists.newArrayList((Object[])new Object[]{"A VARCHAR NOT NULL, B BIGINT NOT NULL, C VARCHAR, CONSTRAINT PK PRIMARY KEY (A,B DESC,C)", Lists.newArrayList((Object[])new Object[]{"XYZ", 1, "Z"}), null, 2, KeyRange.getKeyRange((byte[])ByteUtil.concat((byte[])Bytes.toBytes((String)"XYZ"), (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY, PLong.INSTANCE.toBytes((Object)1, SortOrder.DESC)}), (boolean)true, (byte[])KeyRange.UNBOUND, (boolean)false)}).toArray());
        testCases.add(Lists.newArrayList((Object[])new Object[]{"A VARCHAR NOT NULL, B VARCHAR, C VARCHAR, CONSTRAINT PK PRIMARY KEY (A DESC,B,C)", null, Lists.newArrayList((Object[])new String[]{"XY", null, "Z"}), 3, KeyRange.getKeyRange((byte[])ByteUtil.nextKey((byte[])QueryConstants.SEPARATOR_BYTE_ARRAY), (boolean)true, (byte[])ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)"XY", SortOrder.DESC), (byte[][])new byte[][]{QueryConstants.DESC_SEPARATOR_BYTE_ARRAY, QueryConstants.SEPARATOR_BYTE_ARRAY, Bytes.toBytes((String)"Z")}), (boolean)false)}).toArray());
        return testCases;
    }
}

