/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.query;

import org.apache.hadoop.conf.Configuration;
import org.apache.phoenix.exception.PhoenixNonRetryableRuntimeException;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.query.GuidePostsCache;
import org.apache.phoenix.query.GuidePostsCacheFactory;
import org.apache.phoenix.query.GuidePostsCacheProvider;
import org.apache.phoenix.query.GuidePostsCacheWrapper;
import org.apache.phoenix.query.PhoenixStatsLoader;
import org.apache.phoenix.util.ReadOnlyProps;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class GuidePostsCacheProviderTest {
    static GuidePostsCache testCache = null;
    static PhoenixStatsLoader phoenixStatsLoader = null;
    private GuidePostsCacheProvider helper;

    @Before
    public void init() {
        TestGuidePostsCacheFactory.count = 0;
        this.helper = new GuidePostsCacheProvider();
    }

    @Test(expected=NullPointerException.class)
    public void loadAndGetGuidePostsCacheFactoryNullStringFailure() {
        this.helper.loadAndGetGuidePostsCacheFactory(null);
    }

    @Test(expected=PhoenixNonRetryableRuntimeException.class)
    public void loadAndGetGuidePostsCacheFactoryBadStringFailure() {
        this.helper.loadAndGetGuidePostsCacheFactory("not a class");
    }

    @Test(expected=PhoenixNonRetryableRuntimeException.class)
    public void loadAndGetGuidePostsCacheFactoryNonImplementingClassFailure() {
        this.helper.loadAndGetGuidePostsCacheFactory(Object.class.getTypeName());
    }

    @Test
    public void loadAndGetGuidePostsCacheFactoryTestFactory() {
        GuidePostsCacheFactory factory = this.helper.loadAndGetGuidePostsCacheFactory(TestGuidePostsCacheFactory.class.getTypeName());
        Assert.assertTrue((boolean)(factory instanceof TestGuidePostsCacheFactory));
    }

    @Test
    public void getSingletonSimpleTest() {
        GuidePostsCacheFactory factory1 = this.helper.loadAndGetGuidePostsCacheFactory(TestGuidePostsCacheFactory.class.getTypeName());
        Assert.assertTrue((boolean)(factory1 instanceof TestGuidePostsCacheFactory));
        GuidePostsCacheFactory factory2 = this.helper.loadAndGetGuidePostsCacheFactory(TestGuidePostsCacheFactory.class.getTypeName());
        Assert.assertTrue((boolean)(factory2 instanceof TestGuidePostsCacheFactory));
        Assert.assertEquals((Object)factory1, (Object)factory2);
        Assert.assertEquals((long)1L, (long)TestGuidePostsCacheFactory.count);
    }

    @Test
    public void getGuidePostsCacheWrapper() {
        testCache = (GuidePostsCache)Mockito.mock(GuidePostsCache.class);
        ConnectionQueryServices mockQueryServices = (ConnectionQueryServices)Mockito.mock(ConnectionQueryServices.class);
        Configuration mockConfiguration = (Configuration)Mockito.mock(Configuration.class);
        GuidePostsCacheWrapper value = this.helper.getGuidePostsCache(TestGuidePostsCacheFactory.class.getTypeName(), mockQueryServices, mockConfiguration);
        value.invalidateAll();
        ((GuidePostsCache)Mockito.verify((Object)testCache, (VerificationMode)Mockito.atLeastOnce())).invalidateAll();
    }

    public static class TestGuidePostsCacheFactory
    implements GuidePostsCacheFactory {
        public static volatile int count = 0;

        public TestGuidePostsCacheFactory() {
            ++count;
        }

        public PhoenixStatsLoader getPhoenixStatsLoader(ConnectionQueryServices clientConnectionQueryServices, ReadOnlyProps readOnlyProps, Configuration config) {
            return phoenixStatsLoader;
        }

        public GuidePostsCache getGuidePostsCache(PhoenixStatsLoader phoenixStatsLoader, Configuration config) {
            return testCache;
        }
    }
}

