/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.query.DelegateCell;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.tuple.EncodedColumnQualiferCellsList;
import org.junit.Assert;
import org.junit.Test;

public class EncodedColumnQualifierCellsListTest {
    private static final byte[] row = Bytes.toBytes((String)"row");
    private static final byte[] cf = Bytes.toBytes((String)"cf");

    @Test
    public void testIterator() {
        EncodedColumnQualiferCellsList list = new EncodedColumnQualiferCellsList(11, 16, PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS);
        Cell[] cells = new Cell[7];
        int i = 0;
        this.populateListAndArray((List<Cell>)list, cells);
        Iterator itr = list.iterator();
        Assert.assertTrue((boolean)itr.hasNext());
        i = 0;
        while (itr.hasNext()) {
            Assert.assertEquals((Object)cells[i++], itr.next());
        }
        Assert.assertEquals((long)7L, (long)list.size());
        itr = list.iterator();
        i = 0;
        int numRemoved = 0;
        try {
            itr.remove();
            Assert.fail((String)"Remove not allowed till next() is called");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        while (itr.hasNext()) {
            Assert.assertEquals((Object)cells[i++], itr.next());
            itr.remove();
            ++numRemoved;
        }
        Assert.assertEquals((String)"Number of elements removed should have been the size of the list", (long)7L, (long)numRemoved);
    }

    @Test
    public void testSize() {
        EncodedColumnQualiferCellsList list = new EncodedColumnQualiferCellsList(11, 16, PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS);
        Assert.assertEquals((long)0L, (long)list.size());
        this.populateList((List<Cell>)list);
        Assert.assertEquals((long)7L, (long)list.size());
        int originalSize = list.size();
        Iterator itr = list.iterator();
        while (itr.hasNext()) {
            itr.next();
            itr.remove();
            Assert.assertEquals((long)(--originalSize), (long)list.size());
        }
    }

    @Test
    public void testIsEmpty() throws Exception {
        EncodedColumnQualiferCellsList list = new EncodedColumnQualiferCellsList(11, 16, PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS);
        Assert.assertTrue((boolean)list.isEmpty());
        this.populateList((List<Cell>)list);
        Assert.assertFalse((boolean)list.isEmpty());
        Iterator itr = list.iterator();
        while (itr.hasNext()) {
            itr.next();
            itr.remove();
            if (!itr.hasNext()) continue;
            Assert.assertFalse((boolean)list.isEmpty());
        }
        Assert.assertTrue((boolean)list.isEmpty());
    }

    @Test
    public void testContains() throws Exception {
        EncodedColumnQualiferCellsList list = new EncodedColumnQualiferCellsList(11, 16, PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS);
        Cell[] cells = new Cell[7];
        this.populateListAndArray((List<Cell>)list, cells);
        for (Cell c : cells) {
            Assert.assertTrue((boolean)list.contains((Object)c));
        }
        Assert.assertFalse((boolean)list.contains((Object)KeyValueUtil.createFirstOnRow((byte[])row, (byte[])cf, (byte[])PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS.encode(13))));
    }

    @Test
    public void testToArrayWithParam() throws Exception {
        EncodedColumnQualiferCellsList list = new EncodedColumnQualiferCellsList(11, 16, PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS);
        Object[] cells = new Cell[7];
        this.populateListAndArray((List<Cell>)list, (Cell[])cells);
        Object[] array = (Cell[])list.toArray((Object[])new Cell[0]);
        Assert.assertTrue((boolean)Arrays.equals(cells, array));
    }

    @Test
    public void testToArrayWithoutParam() throws Exception {
        EncodedColumnQualiferCellsList list = new EncodedColumnQualiferCellsList(11, 16, PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS);
        Object[] cells = new Cell[7];
        this.populateListAndArray((List<Cell>)list, (Cell[])cells);
        Object[] array = list.toArray();
        Assert.assertTrue((boolean)Arrays.equals(cells, array));
    }

    @Test
    public void testRemove() throws Exception {
        EncodedColumnQualiferCellsList list = new EncodedColumnQualiferCellsList(11, 16, PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS);
        Cell[] cells = new Cell[7];
        this.populateListAndArray((List<Cell>)list, cells);
        Assert.assertTrue((boolean)list.remove((Object)cells[0]));
        Assert.assertEquals((long)6L, (long)list.size());
        Assert.assertTrue((boolean)list.remove((Object)cells[6]));
        Assert.assertEquals((long)5L, (long)list.size());
        Assert.assertTrue((boolean)list.remove((Object)cells[3]));
        Assert.assertEquals((long)4L, (long)list.size());
        Assert.assertFalse((boolean)list.remove((Object)KeyValueUtil.createFirstOnRow((byte[])row, (byte[])cf, (byte[])PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS.encode(13))));
        Assert.assertEquals((long)4L, (long)list.size());
    }

    @Test
    public void testContainsAll() throws Exception {
        EncodedColumnQualiferCellsList list1 = new EncodedColumnQualiferCellsList(11, 16, PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS);
        this.populateList((List<Cell>)list1);
        EncodedColumnQualiferCellsList list2 = new EncodedColumnQualiferCellsList(11, 16, PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS);
        this.populateList((List<Cell>)list2);
        Assert.assertTrue((boolean)list1.containsAll((Collection)list2));
        list2.remove((Object)KeyValueUtil.createFirstOnRow((byte[])row, (byte[])cf, (byte[])PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS.encode(11)));
        Assert.assertTrue((boolean)list1.containsAll((Collection)list2));
        Assert.assertFalse((boolean)list2.containsAll((Collection)list1));
        list2.add((Cell)KeyValueUtil.createFirstOnRow((byte[])row, (byte[])cf, (byte[])PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS.encode(13)));
        Assert.assertFalse((boolean)list1.containsAll((Collection)list2));
        Assert.assertFalse((boolean)list2.containsAll((Collection)list1));
        ArrayList<Cell> arrayList = new ArrayList<Cell>();
        this.populateList(arrayList);
        Assert.assertTrue((boolean)list1.containsAll(arrayList));
    }

    @Test
    public void testAddAll() throws Exception {
        EncodedColumnQualiferCellsList list1 = new EncodedColumnQualiferCellsList(11, 16, PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS);
        this.populateList((List<Cell>)list1);
        EncodedColumnQualiferCellsList list2 = new EncodedColumnQualiferCellsList(11, 16, PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS);
        this.populateList((List<Cell>)list2);
        Assert.assertTrue((boolean)list1.addAll((Collection)list2));
    }

    @Test
    public void testAddAllAtIndexFails() throws Exception {
        EncodedColumnQualiferCellsList list = new EncodedColumnQualiferCellsList(11, 16, PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS);
        this.populateList((List<Cell>)list);
        try {
            list.addAll(0, new ArrayList());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testRemoveAll() throws Exception {
        EncodedColumnQualiferCellsList list1 = new EncodedColumnQualiferCellsList(11, 16, PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS);
        this.populateList((List<Cell>)list1);
        ArrayList<Cell> list2 = new ArrayList<Cell>();
        this.populateList(list2);
        Assert.assertTrue((boolean)list1.removeAll(list2));
        Assert.assertTrue((boolean)list1.isEmpty());
        Assert.assertFalse((boolean)list2.isEmpty());
    }

    @Test
    public void testRetainAll() throws Exception {
        EncodedColumnQualiferCellsList list1 = new EncodedColumnQualiferCellsList(11, 16, PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS);
        this.populateList((List<Cell>)list1);
        EncodedColumnQualiferCellsList list2 = new EncodedColumnQualiferCellsList(11, 16, PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS);
        this.populateList((List<Cell>)list2);
        Assert.assertFalse((boolean)list1.retainAll((Collection)list2));
        list2.remove((Object)KeyValueUtil.createFirstOnRow((byte[])row, (byte[])cf, (byte[])PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS.encode(12)));
        Assert.assertTrue((boolean)list1.retainAll((Collection)list2));
        Assert.assertEquals((long)list1.size(), (long)list2.size());
        for (Cell c : list1) {
            Assert.assertTrue((boolean)list2.contains((Object)c));
        }
    }

    @Test
    public void testClear() throws Exception {
        EncodedColumnQualiferCellsList list = new EncodedColumnQualiferCellsList(11, 16, PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS);
        this.populateList((List<Cell>)list);
        list.clear();
        Assert.assertTrue((boolean)list.isEmpty());
        Assert.assertEquals((long)0L, (long)list.size());
    }

    @Test
    public void testGetIndex() throws Exception {
        EncodedColumnQualiferCellsList list = new EncodedColumnQualiferCellsList(11, 16, PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS);
        Cell[] cells = new Cell[7];
        this.populateListAndArray((List<Cell>)list, cells);
        for (int i = 0; i < cells.length; ++i) {
            Assert.assertEquals((Object)cells[i], (Object)list.get(i));
        }
    }

    @Test
    public void testIndexOf() throws Exception {
        EncodedColumnQualiferCellsList list = new EncodedColumnQualiferCellsList(11, 16, PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS);
        Cell[] cells = new Cell[7];
        this.populateListAndArray((List<Cell>)list, cells);
        for (int i = 0; i < cells.length; ++i) {
            Assert.assertEquals((long)i, (long)list.indexOf((Object)cells[i]));
        }
    }

    @Test
    public void testLastIndexOf() throws Exception {
        EncodedColumnQualiferCellsList list = new EncodedColumnQualiferCellsList(11, 16, PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS);
        Cell[] cells = new Cell[7];
        this.populateListAndArray((List<Cell>)list, cells);
        for (int i = 0; i < cells.length; ++i) {
            Assert.assertEquals((long)i, (long)list.lastIndexOf((Object)cells[i]));
        }
    }

    @Test
    public void testListIterator() throws Exception {
        EncodedColumnQualiferCellsList list = new EncodedColumnQualiferCellsList(11, 16, PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS);
        Cell[] cells = new Cell[7];
        int i = 0;
        this.populateListAndArray((List<Cell>)list, cells);
        ListIterator itr = list.listIterator();
        Assert.assertTrue((boolean)itr.hasNext());
        i = 0;
        while (itr.hasNext()) {
            Assert.assertEquals((Object)cells[i++], itr.next());
        }
        Assert.assertEquals((long)7L, (long)list.size());
        itr = list.listIterator();
        i = 0;
        int numRemoved = 0;
        try {
            itr.remove();
            Assert.fail((String)"Remove not allowed till next() is called");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        while (itr.hasNext()) {
            Assert.assertEquals((Object)cells[i++], itr.next());
            itr.remove();
            ++numRemoved;
        }
        Assert.assertEquals((String)"Number of elements removed should have been the size of the list", (long)7L, (long)numRemoved);
        Assert.assertTrue((boolean)list.isEmpty());
    }

    @Test
    public void testListIteratorSet() {
        Cell c;
        EncodedColumnQualiferCellsList list = new EncodedColumnQualiferCellsList(11, 16, PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS);
        Cell[] array = new Cell[7];
        this.populateListAndArray((List<Cell>)list, array);
        ListIterator itr = list.listIterator();
        Cell validCell = array[4];
        Cell invalidCell = array[5];
        String validCellName = "Valid Cell";
        String invalidCellName = "Invalid Cell";
        DelegateCell validReplacementCell = new DelegateCell(validCell, validCellName);
        DelegateCell invalidReplacementCell = new DelegateCell(invalidCell, invalidCellName);
        int i = 0;
        while (itr.hasNext()) {
            c = (Cell)itr.next();
            if (i == 4) {
                itr.set(validReplacementCell);
            }
            if (i == 6) {
                try {
                    itr.set(invalidReplacementCell);
                    Assert.fail((String)("This should have failed since " + invalidReplacementCell + " cannot be added where " + c + " is."));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            ++i;
        }
        itr = list.listIterator();
        i = 0;
        while (itr.hasNext()) {
            c = (Cell)itr.next();
            if (i == 4) {
                Assert.assertEquals((Object)validCellName, (Object)c.toString());
            }
            if (i == 6) {
                Assert.assertNotEquals((Object)invalidCellName, (Object)c.toString());
            }
            ++i;
        }
    }

    @Test
    public void testListIteratorNextAndPrevious() throws Exception {
        EncodedColumnQualiferCellsList list = new EncodedColumnQualiferCellsList(11, 16, PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS);
        Cell[] array = new Cell[7];
        this.populateListAndArray((List<Cell>)list, array);
        ListIterator itr = list.listIterator();
        try {
            itr.previous();
            Assert.fail((String)"Call to itr.previous() should have failed since the iterator hasn't been moved forward yet");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        Cell c = (Cell)itr.next();
        Cell d = (Cell)itr.previous();
        Cell e = (Cell)itr.next();
        Cell f = (Cell)itr.previous();
        Assert.assertTrue((c.equals(d) && c.equals(f) && c.equals(e) ? 1 : 0) != 0);
        itr = list.listIterator();
        int i = 0;
        Assert.assertEquals((Object)array[i++], itr.next());
        Assert.assertEquals((Object)array[i++], itr.next());
        Assert.assertEquals((Object)array[i++], itr.next());
        Assert.assertEquals((Object)array[--i], itr.previous());
        Assert.assertEquals((Object)array[--i], itr.previous());
        Assert.assertEquals((Object)array[i++], itr.next());
        while (itr.hasNext()) {
            itr.next();
        }
        i = 6;
        while (itr.hasPrevious()) {
            Assert.assertEquals((Object)array[i--], itr.previous());
        }
        Assert.assertEquals((String)"Not all elements navigated using previous()", (long)-1L, (long)i);
        i = 0;
        while (itr.hasNext()) {
            Assert.assertEquals((Object)array[i++], itr.next());
        }
        Assert.assertEquals((String)"Not all elements navigated using next()", (long)7L, (long)i);
    }

    @Test
    public void testSetNull() throws Exception {
        EncodedColumnQualiferCellsList list = new EncodedColumnQualiferCellsList(11, 16, PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS);
        try {
            list.add(null);
            Assert.fail((String)"Adding null elements to the list is not allowed");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testFailFastIterator() throws Exception {
        EncodedColumnQualiferCellsList list = new EncodedColumnQualiferCellsList(11, 16, PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS);
        this.populateList((List<Cell>)list);
        int i = 0;
        Iterator itr = list.iterator();
        while (itr.hasNext()) {
            ++i;
            try {
                itr.next();
                list.add((Cell)KeyValueUtil.createFirstOnRow((byte[])row, (byte[])cf, (byte[])PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS.encode(0)));
                if (i != 2) continue;
                Assert.fail((String)"ConcurrentModificationException should have been thrown as the list is being modified while being iterated through");
            }
            catch (ConcurrentModificationException expected) {
                Assert.assertEquals((String)"Exception should have been thrown when getting the second element", (long)2L, (long)i);
                break;
            }
        }
    }

    @Test
    public void testFailFastListIterator() throws Exception {
        EncodedColumnQualiferCellsList list = new EncodedColumnQualiferCellsList(11, 16, PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS);
        this.populateList((List<Cell>)list);
        ListIterator itr = list.listIterator();
        itr.next();
        list.add((Cell)KeyValueUtil.createFirstOnRow((byte[])row, (byte[])cf, (byte[])PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS.encode(0)));
        try {
            itr.next();
            Assert.fail((String)"ConcurrentModificationException should have been thrown as the list was modified without using iterator");
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        list = new EncodedColumnQualiferCellsList(11, 16, PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS);
        this.populateList((List<Cell>)list);
        itr = list.listIterator();
        itr.next();
        itr.next();
        itr.remove();
        itr.next();
        list.remove((Object)KeyValueUtil.createFirstOnRow((byte[])row, (byte[])cf, (byte[])PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS.encode(0)));
        try {
            itr.next();
            Assert.fail((String)"ConcurrentModificationException should have been thrown as the list was modified without using iterator");
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    private void populateListAndArray(List<Cell> list, Cell[] cells) {
        cells[0] = KeyValueUtil.createFirstOnRow((byte[])row, (byte[])cf, (byte[])PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS.encode(0));
        list.add(cells[0]);
        cells[1] = KeyValueUtil.createFirstOnRow((byte[])row, (byte[])cf, (byte[])PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS.encode(5));
        list.add(cells[1]);
        cells[2] = KeyValueUtil.createFirstOnRow((byte[])row, (byte[])cf, (byte[])PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS.encode(10));
        list.add(cells[2]);
        cells[6] = KeyValueUtil.createFirstOnRow((byte[])row, (byte[])cf, (byte[])PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS.encode(16));
        list.add(cells[6]);
        cells[4] = KeyValueUtil.createFirstOnRow((byte[])row, (byte[])cf, (byte[])PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS.encode(12));
        list.add(cells[4]);
        cells[5] = KeyValueUtil.createFirstOnRow((byte[])row, (byte[])cf, (byte[])PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS.encode(14));
        list.add(cells[5]);
        cells[3] = KeyValueUtil.createFirstOnRow((byte[])row, (byte[])cf, (byte[])PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS.encode(11));
        list.add(cells[3]);
    }

    private void populateList(List<Cell> list) {
        list.add((Cell)KeyValueUtil.createFirstOnRow((byte[])row, (byte[])cf, (byte[])PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS.encode(0)));
        list.add((Cell)KeyValueUtil.createFirstOnRow((byte[])row, (byte[])cf, (byte[])PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS.encode(5)));
        list.add((Cell)KeyValueUtil.createFirstOnRow((byte[])row, (byte[])cf, (byte[])PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS.encode(10)));
        list.add((Cell)KeyValueUtil.createFirstOnRow((byte[])row, (byte[])cf, (byte[])PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS.encode(16)));
        list.add((Cell)KeyValueUtil.createFirstOnRow((byte[])row, (byte[])cf, (byte[])PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS.encode(12)));
        list.add((Cell)KeyValueUtil.createFirstOnRow((byte[])row, (byte[])cf, (byte[])PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS.encode(14)));
        list.add((Cell)KeyValueUtil.createFirstOnRow((byte[])row, (byte[])cf, (byte[])PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS.encode(11)));
    }
}

