/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.query;

import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.SystemExitRule;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDriver;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.schema.SaltingUtil;
import org.apache.phoenix.schema.types.PChar;
import org.apache.phoenix.schema.types.PDate;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.PhoenixRuntime;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

public class ConnectionlessTest {
    private static final int saltBuckets = 200;
    private static final String orgId = "00D300000000XHP";
    private static final String keyPrefix1 = "111";
    private static final String keyPrefix2 = "112";
    private static final String entityHistoryId1 = "123456789012";
    private static final String entityHistoryId2 = "987654321098";
    private static final String name1 = "Eli";
    private static final String name2 = "Simon";
    private static final Date now = new Date(System.currentTimeMillis());
    private static final byte[] unsaltedRowKey1 = ByteUtil.concat((byte[])PChar.INSTANCE.toBytes((Object)"00D300000000XHP"), (byte[][])new byte[][]{PChar.INSTANCE.toBytes((Object)"111"), PChar.INSTANCE.toBytes((Object)"123456789012")});
    private static final byte[] unsaltedRowKey2 = ByteUtil.concat((byte[])PChar.INSTANCE.toBytes((Object)"00D300000000XHP"), (byte[][])new byte[][]{PChar.INSTANCE.toBytes((Object)"112"), PChar.INSTANCE.toBytes((Object)"987654321098")});
    private static final byte[] saltedRowKey1 = ByteUtil.concat((byte[])new byte[]{SaltingUtil.getSaltingByte((byte[])unsaltedRowKey1, (int)0, (int)unsaltedRowKey1.length, (int)200)}, (byte[][])new byte[][]{unsaltedRowKey1});
    private static final byte[] saltedRowKey2 = ByteUtil.concat((byte[])new byte[]{SaltingUtil.getSaltingByte((byte[])unsaltedRowKey2, (int)0, (int)unsaltedRowKey2.length, (int)200)}, (byte[][])new byte[][]{unsaltedRowKey2});
    @ClassRule
    public static final SystemExitRule SYSTEM_EXIT_RULE = new SystemExitRule();

    private static String getUrl() {
        return "jdbc:phoenix:none";
    }

    @BeforeClass
    public static synchronized void verifyDriverRegistered() throws SQLException {
        Assert.assertTrue((DriverManager.getDriver(ConnectionlessTest.getUrl()) == PhoenixDriver.INSTANCE ? 1 : 0) != 0);
    }

    @Test
    public void testConnectionlessUpsert() throws Exception {
        this.testConnectionlessUpsert(null);
    }

    @Test
    public void testSaltedConnectionlessUpsert() throws Exception {
        this.testConnectionlessUpsert(200);
    }

    private void testConnectionlessUpsert(Integer saltBuckets) throws Exception {
        byte[] expectedRowKey2;
        String dmlStmt = "create table core.entity_history(\n    organization_id char(15) not null, \n    key_prefix char(3) not null,\n    entity_history_id char(12) not null,\n    created_by varchar,\n    created_date date\n    CONSTRAINT pk PRIMARY KEY (organization_id, key_prefix, entity_history_id) ) COLUMN_ENCODED_BYTES=4 " + (saltBuckets == null ? "" : " , " + "SALT_BUCKETS=" + saltBuckets);
        Properties props = new Properties();
        Connection conn = DriverManager.getConnection(ConnectionlessTest.getUrl(), props);
        PreparedStatement statement = conn.prepareStatement(dmlStmt);
        statement.execute();
        String upsertStmt = "upsert into core.entity_history(organization_id,key_prefix,entity_history_id, created_by, created_date)\nvalues(?,?,?,?,?)";
        statement = conn.prepareStatement(upsertStmt);
        statement.setString(1, orgId);
        statement.setString(2, keyPrefix2);
        statement.setString(3, entityHistoryId2);
        statement.setString(4, name2);
        statement.setDate(5, now);
        statement.execute();
        statement.setString(1, orgId);
        statement.setString(2, keyPrefix1);
        statement.setString(3, entityHistoryId1);
        statement.setString(4, name1);
        statement.setDate(5, now);
        statement.execute();
        Iterator dataIterator = PhoenixRuntime.getUncommittedDataIterator((Connection)conn);
        Iterator<Cell> iterator = ((List)((Pair)dataIterator.next()).getSecond()).iterator();
        byte[] expectedRowKey1 = saltBuckets == null ? unsaltedRowKey1 : saltedRowKey1;
        byte[] byArray = expectedRowKey2 = saltBuckets == null ? unsaltedRowKey2 : saltedRowKey2;
        if (Bytes.compareTo((byte[])expectedRowKey1, (byte[])expectedRowKey2) < 0) {
            ConnectionlessTest.assertRow1(iterator, expectedRowKey1);
            ConnectionlessTest.assertRow2(iterator, expectedRowKey2);
        } else {
            ConnectionlessTest.assertRow2(iterator, expectedRowKey2);
            ConnectionlessTest.assertRow1(iterator, expectedRowKey1);
        }
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertFalse((boolean)dataIterator.hasNext());
        conn.rollback();
    }

    private static void assertRow1(Iterator<Cell> iterator, byte[] expectedRowKey1) {
        Assert.assertTrue((boolean)iterator.hasNext());
        Cell kv = iterator.next();
        Assert.assertArrayEquals((byte[])expectedRowKey1, (byte[])CellUtil.cloneRow((Cell)kv));
        Assert.assertEquals((Object)"x", (Object)PVarchar.INSTANCE.toObject(CellUtil.cloneValue((Cell)kv)));
        kv = iterator.next();
        Assert.assertArrayEquals((byte[])expectedRowKey1, (byte[])CellUtil.cloneRow((Cell)kv));
        Assert.assertEquals((Object)name1, (Object)PVarchar.INSTANCE.toObject(CellUtil.cloneValue((Cell)kv)));
        Assert.assertTrue((boolean)iterator.hasNext());
        kv = iterator.next();
        Assert.assertArrayEquals((byte[])expectedRowKey1, (byte[])CellUtil.cloneRow((Cell)kv));
        Assert.assertEquals((Object)now, (Object)PDate.INSTANCE.toObject(CellUtil.cloneValue((Cell)kv)));
    }

    private static void assertRow2(Iterator<Cell> iterator, byte[] expectedRowKey2) {
        Cell kv = iterator.next();
        Assert.assertArrayEquals((byte[])expectedRowKey2, (byte[])CellUtil.cloneRow((Cell)kv));
        Assert.assertEquals((Object)"x", (Object)PVarchar.INSTANCE.toObject(CellUtil.cloneValue((Cell)kv)));
        Assert.assertTrue((boolean)iterator.hasNext());
        kv = iterator.next();
        Assert.assertArrayEquals((byte[])expectedRowKey2, (byte[])CellUtil.cloneRow((Cell)kv));
        Assert.assertEquals((Object)name2, (Object)PVarchar.INSTANCE.toObject(CellUtil.cloneValue((Cell)kv)));
        Assert.assertTrue((boolean)iterator.hasNext());
        kv = iterator.next();
        Assert.assertArrayEquals((byte[])expectedRowKey2, (byte[])CellUtil.cloneRow((Cell)kv));
        Assert.assertEquals((Object)now, (Object)PDate.INSTANCE.toObject(CellUtil.cloneValue((Cell)kv)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleConnectionQueryServices() throws Exception {
        String url1 = ConnectionlessTest.getUrl();
        String url2 = url1 + ':' + ':' + ':' + "LongRunningQueries";
        try (Connection conn1 = DriverManager.getConnection(url1);){
            Assert.assertEquals((Object)"", (Object)conn1.getMetaData().getUserName());
            try (Connection conn2 = DriverManager.getConnection(url2);){
                Assert.assertEquals((Object)"LongRunningQueries", (Object)conn2.getMetaData().getUserName());
                ConnectionQueryServices cqs1 = conn1.unwrap(PhoenixConnection.class).getQueryServices();
                ConnectionQueryServices cqs2 = conn2.unwrap(PhoenixConnection.class).getQueryServices();
                Assert.assertTrue((cqs1 != cqs2 ? 1 : 0) != 0);
                try (Connection conn3 = DriverManager.getConnection(url1);){
                    ConnectionQueryServices cqs3 = conn3.unwrap(PhoenixConnection.class).getQueryServices();
                    Assert.assertTrue((cqs1 == cqs3 ? 1 : 0) != 0);
                    try (Connection conn4 = DriverManager.getConnection(url2);){
                        ConnectionQueryServices cqs4 = conn4.unwrap(PhoenixConnection.class).getQueryServices();
                        Assert.assertTrue((cqs2 == cqs4 ? 1 : 0) != 0);
                    }
                }
            }
        }
    }
}

