/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.query;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Table;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.end2end.ServerMetadataCacheTestImpl;
import org.apache.phoenix.jdbc.ConnectionInfo;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDriver;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.query.ConfigurationFactory;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.query.HBaseFactoryProvider;
import org.apache.phoenix.util.InstanceResolver;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={NeedsOwnMiniClusterTest.class})
public class ConnectionQueryServicesImplThreadPoolIT
extends BaseTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionQueryServicesImplThreadPoolIT.class);
    private AtomicInteger counter = new AtomicInteger();
    private static HBaseTestingUtility hbaseTestUtil;
    private String tableName;
    private static final String CONN_QUERY_SERVICE_CREATE_TABLE = "CONN_QUERY_SERVICE_CREATE_TABLE";
    private static final String CONN_QUERY_SERVICE_1 = "CONN_QUERY_SERVICE_1";
    private static final String CONN_QUERY_SERVICE_2 = "CONN_QUERY_SERVICE_2";
    private static final int TEST_CQSI_THREAD_POOL_KEEP_ALIVE_SECONDS = 13;
    private static final int TEST_CQSI_THREAD_POOL_CORE_POOL_SIZE = 17;
    private static final int TEST_CQSI_THREAD_POOL_MAX_THREADS = 19;
    private static final int TEST_CQSI_THREAD_POOL_MAX_QUEUE = 23;

    @BeforeClass
    public static void doSetup() throws Exception {
        InstanceResolver.clearSingletons();
        InstanceResolver.getSingleton(ConfigurationFactory.class, (Object)new ConfigurationFactory(){

            public Configuration getConfiguration() {
                Configuration conf = HBaseConfiguration.create();
                conf.set("phoenix.cqsi.thread.pool.enabled", Boolean.toString(true));
                conf.set("phoenix.cqsi.thread.pool.keepalive.seconds", Integer.toString(13));
                conf.set("phoenix.cqsi.thread.pool.core.size", Integer.toString(17));
                conf.set("phoenix.cqsi.thread.pool.max.threads", Integer.toString(19));
                conf.set("phoenix.cqsi.thread.pool.max.queue", Integer.toString(23));
                conf.set("phoenix.cqsi.thread.pool.allow.core.thread.timeout", Boolean.toString(true));
                return conf;
            }

            public Configuration getConfiguration(Configuration confToClone) {
                Configuration conf = HBaseConfiguration.create();
                conf.set("phoenix.cqsi.thread.pool.enabled", Boolean.toString(true));
                conf.set("phoenix.cqsi.thread.pool.keepalive.seconds", Integer.toString(13));
                conf.set("phoenix.cqsi.thread.pool.core.size", Integer.toString(17));
                conf.set("phoenix.cqsi.thread.pool.max.threads", Integer.toString(19));
                conf.set("phoenix.cqsi.thread.pool.max.queue", Integer.toString(23));
                conf.set("phoenix.cqsi.thread.pool.allow.core.thread.timeout", Boolean.toString(true));
                Configuration copy = new Configuration(conf);
                copy.addResource(confToClone);
                return copy;
            }
        });
        Configuration conf = HBaseFactoryProvider.getConfigurationFactory().getConfiguration();
        hbaseTestUtil = new HBaseTestingUtility(conf);
        ConnectionQueryServicesImplThreadPoolIT.setUpConfigForMiniCluster(conf);
        hbaseTestUtil.startMiniCluster();
        String zkQuorum = "localhost:" + hbaseTestUtil.getZkCluster().getClientPort();
        url = "jdbc:phoenix:" + zkQuorum;
        DriverManager.registerDriver((Driver)PhoenixDriver.INSTANCE);
    }

    @AfterClass
    public static void tearDownMiniCluster() {
        try {
            if (hbaseTestUtil != null) {
                hbaseTestUtil.shutdownMiniCluster();
            }
        }
        catch (Exception exception) {
        }
        finally {
            ServerMetadataCacheTestImpl.resetCache();
        }
    }

    @Before
    public void setUp() throws Exception {
        this.tableName = ConnectionQueryServicesImplThreadPoolIT.generateUniqueName();
        this.createTable(this.tableName);
    }

    private String connUrlWithPrincipal(String principalName) throws SQLException {
        return ConnectionInfo.create((String)url, null, null).withPrincipal(principalName).toUrl();
    }

    @Test
    public void checkHTableThreadPoolExecutorSame() throws Exception {
        Table table = this.createCQSI(null).getTable(this.tableName.getBytes());
        Assert.assertTrue((boolean)(table instanceof HTable));
        HTable hTable = (HTable)table;
        Field props = hTable.getClass().getDeclaredField("pool");
        props.setAccessible(true);
        this.validateThreadPoolExecutor((ThreadPoolExecutor)props.get(hTable));
    }

    @Test
    public void checkHConnectionThreadPoolExecutorSame() throws Exception {
        ClusterConnection conn1 = this.extractConnectionFromCQSI(this.createCQSI("hello"));
        ThreadPoolExecutor threadPoolExecutor1FromConnection = ConnectionQueryServicesImplThreadPoolIT.extractBatchPool(conn1);
        ConnectionQueryServices connQueryServices2 = this.createCQSI("bye");
        ThreadPoolExecutor threadPoolExecutor2 = ConnectionQueryServicesImplThreadPoolIT.extractThreadPoolExecutorFromCQSI(connQueryServices2);
        ClusterConnection conn2 = this.extractConnectionFromCQSI(this.createCQSI("bye"));
        ThreadPoolExecutor threadPoolExecutor2FromConnection = ConnectionQueryServicesImplThreadPoolIT.extractBatchPool(conn2);
        Assert.assertSame((Object)threadPoolExecutor2, (Object)threadPoolExecutor2FromConnection);
        Assert.assertNotSame((Object)threadPoolExecutor1FromConnection, (Object)threadPoolExecutor2FromConnection);
        this.validateThreadPoolExecutor(threadPoolExecutor1FromConnection);
        this.validateThreadPoolExecutor(threadPoolExecutor2FromConnection);
        this.validateThreadPoolExecutor(threadPoolExecutor2);
    }

    private static ThreadPoolExecutor extractBatchPool(ClusterConnection conn) throws NoSuchFieldException, IllegalAccessException {
        Field batchPoolField = conn.getClass().getDeclaredField("batchPool");
        batchPoolField.setAccessible(true);
        return (ThreadPoolExecutor)batchPoolField.get(conn);
    }

    @Test
    public void testMultipleCQSIThreadPoolsInParallel() throws Exception {
        ConnectionQueryServices cqsiExternal1 = this.createCQSI(CONN_QUERY_SERVICE_1);
        ConnectionQueryServices cqsiExternal2 = this.createCQSI(CONN_QUERY_SERVICE_2);
        Thread cqsiThread1 = new Thread(() -> {
            try {
                ConnectionQueryServices cqsi = this.createCQSI(CONN_QUERY_SERVICE_1);
                this.checkSameThreadPool(cqsiExternal1, cqsi);
                this.checkDifferentThreadPool(cqsiExternal2, cqsi);
                this.validateThreadPoolExecutor(ConnectionQueryServicesImplThreadPoolIT.extractThreadPoolExecutorFromCQSI(cqsi));
                this.counter.incrementAndGet();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        Thread cqsiThread2 = new Thread(() -> {
            try {
                ConnectionQueryServices cqsi = this.createCQSI(CONN_QUERY_SERVICE_1);
                this.checkSameThreadPool(cqsiExternal1, cqsi);
                this.checkDifferentThreadPool(cqsiExternal2, cqsi);
                this.validateThreadPoolExecutor(ConnectionQueryServicesImplThreadPoolIT.extractThreadPoolExecutorFromCQSI(cqsi));
                this.counter.incrementAndGet();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        Thread cqsiThread3 = new Thread(() -> {
            try {
                ConnectionQueryServices cqsi = this.createCQSI(CONN_QUERY_SERVICE_2);
                this.checkSameThreadPool(cqsiExternal2, cqsi);
                this.checkDifferentThreadPool(cqsiExternal1, cqsi);
                this.validateThreadPoolExecutor(ConnectionQueryServicesImplThreadPoolIT.extractThreadPoolExecutorFromCQSI(cqsi));
                this.counter.incrementAndGet();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        Thread cqsiThread4 = new Thread(() -> {
            try {
                ConnectionQueryServices cqsi = this.createCQSI(CONN_QUERY_SERVICE_2);
                this.checkSameThreadPool(cqsiExternal2, cqsi);
                this.checkDifferentThreadPool(cqsiExternal1, cqsi);
                this.validateThreadPoolExecutor(ConnectionQueryServicesImplThreadPoolIT.extractThreadPoolExecutorFromCQSI(cqsi));
                this.counter.incrementAndGet();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        cqsiThread1.start();
        cqsiThread2.start();
        cqsiThread3.start();
        cqsiThread4.start();
        cqsiThread1.join();
        cqsiThread2.join();
        cqsiThread3.join();
        cqsiThread4.join();
        Assert.assertEquals((long)4L, (long)this.counter.get());
    }

    private void checkSameThreadPool(ConnectionQueryServices cqsi1, ConnectionQueryServices cqsi2) throws NoSuchFieldException, IllegalAccessException {
        Assert.assertSame((Object)ConnectionQueryServicesImplThreadPoolIT.extractThreadPoolExecutorFromCQSI(cqsi1), (Object)ConnectionQueryServicesImplThreadPoolIT.extractThreadPoolExecutorFromCQSI(cqsi2));
    }

    private void checkDifferentThreadPool(ConnectionQueryServices cqsi1, ConnectionQueryServices cqsi2) throws NoSuchFieldException, IllegalAccessException {
        Assert.assertNotSame((Object)ConnectionQueryServicesImplThreadPoolIT.extractThreadPoolExecutorFromCQSI(cqsi1), (Object)ConnectionQueryServicesImplThreadPoolIT.extractThreadPoolExecutorFromCQSI(cqsi2));
    }

    private ConnectionQueryServices createCQSI(String serviceName) throws SQLException {
        String principalURL = this.connUrlWithPrincipal(serviceName);
        Connection conn = DriverManager.getConnection(principalURL);
        return conn.unwrap(PhoenixConnection.class).getQueryServices();
    }

    private void validateThreadPoolExecutor(ThreadPoolExecutor threadPoolExecutor) {
        Assert.assertEquals((long)13L, (long)threadPoolExecutor.getKeepAliveTime(TimeUnit.SECONDS));
        Assert.assertEquals((long)17L, (long)threadPoolExecutor.getCorePoolSize());
        Assert.assertEquals((long)19L, (long)threadPoolExecutor.getMaximumPoolSize());
        Assert.assertEquals((long)23L, (long)threadPoolExecutor.getQueue().remainingCapacity());
    }

    private void createTable(String tableName) throws SQLException {
        String CREATE_TABLE_DDL = "CREATE TABLE IF NOT EXISTS %s (K VARCHAR(10) NOT NULL PRIMARY KEY, V VARCHAR)";
        String princURL = this.connUrlWithPrincipal(CONN_QUERY_SERVICE_CREATE_TABLE);
        LOGGER.info("Connection Query Service : CONN_QUERY_SERVICE_CREATE_TABLE URL : " + princURL);
        try (Connection conn = DriverManager.getConnection(princURL);
             Statement stmt = conn.createStatement();){
            stmt.execute(String.format(CREATE_TABLE_DDL, tableName));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    private ClusterConnection extractConnectionFromCQSI(ConnectionQueryServices cqsi) throws NoSuchFieldException, IllegalAccessException {
        Field connectionField1 = cqsi.getClass().getDeclaredField("connection");
        connectionField1.setAccessible(true);
        return (ClusterConnection)connectionField1.get(cqsi);
    }
}

