/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.query;

import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotEnabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.phoenix.SystemExitRule;
import org.apache.phoenix.exception.PhoenixIOException;
import org.apache.phoenix.jdbc.ConnectionInfo;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.monitoring.GlobalClientMetrics;
import org.apache.phoenix.query.ConnectionQueryServicesImpl;
import org.apache.phoenix.query.GuidePostsCacheWrapper;
import org.apache.phoenix.query.QueryServices;
import org.apache.phoenix.util.ReadOnlyProps;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class ConnectionQueryServicesImplTest {
    private static final PhoenixIOException PHOENIX_IO_EXCEPTION = new PhoenixIOException((Throwable)new Exception("Test exception"));
    private TableDescriptor sysMutexTableDescCorrectTTL = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)PhoenixDatabaseMetaData.SYSTEM_MUTEX_NAME)).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])PhoenixDatabaseMetaData.SYSTEM_MUTEX_FAMILY_NAME_BYTES).setTimeToLive(900).build()).build();
    @ClassRule
    public static final SystemExitRule SYSTEM_EXIT_RULE = new SystemExitRule();
    @Mock
    private ConnectionQueryServicesImpl mockCqs;
    @Mock
    private Admin mockAdmin;
    @Mock
    private ReadOnlyProps readOnlyProps;
    @Mock
    private Connection mockConn;
    @Mock
    private Table mockTable;
    @Mock
    private GuidePostsCacheWrapper mockTableStatsCache;
    public static final TableDescriptorBuilder SYS_TASK_TDB = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)PhoenixDatabaseMetaData.SYSTEM_TASK_NAME));
    public static final TableDescriptorBuilder SYS_TASK_TDB_SP = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)PhoenixDatabaseMetaData.SYSTEM_TASK_NAME)).setRegionSplitPolicyClassName("abc");

    @Before
    public void setup() throws IOException, NoSuchFieldException, IllegalAccessException, SQLException {
        MockitoAnnotations.initMocks((Object)this);
        Field props = ConnectionQueryServicesImpl.class.getDeclaredField("props");
        props.setAccessible(true);
        props.set(this.mockCqs, this.readOnlyProps);
        props = ConnectionQueryServicesImpl.class.getDeclaredField("connection");
        props.setAccessible(true);
        props.set(this.mockCqs, this.mockConn);
        props = ConnectionQueryServicesImpl.class.getDeclaredField("tableStatsCache");
        props.setAccessible(true);
        props.set(this.mockCqs, this.mockTableStatsCache);
        Mockito.when((Object)this.mockCqs.checkIfSysMutexExistsAndModifyTTLIfRequired(this.mockAdmin)).thenCallRealMethod();
        Mockito.when((Object)this.mockCqs.updateAndConfirmSplitPolicyForTask(SYS_TASK_TDB)).thenCallRealMethod();
        Mockito.when((Object)this.mockCqs.updateAndConfirmSplitPolicyForTask(SYS_TASK_TDB_SP)).thenCallRealMethod();
        Mockito.when((Object)this.mockCqs.getSysMutexTable()).thenCallRealMethod();
        Mockito.when((Object)this.mockCqs.getAdmin()).thenCallRealMethod();
        Mockito.when((Object)this.mockCqs.getTable((byte[])Mockito.any())).thenCallRealMethod();
        Mockito.when((Object)this.mockCqs.getTableIfExists((byte[])Mockito.any())).thenCallRealMethod();
        ((ConnectionQueryServicesImpl)Mockito.doCallRealMethod().when((Object)this.mockCqs)).dropTables((List)Mockito.any());
    }

    @Test
    public void testCQSIThreadPoolCreation() throws SQLException, NoSuchFieldException, IllegalAccessException {
        QueryServices mockQueryServices = (QueryServices)Mockito.mock(QueryServices.class);
        ReadOnlyProps readOnlyProps = ConnectionQueryServicesImplTest.createCQSIThreadPoolReadOnlyProps();
        Mockito.when((Object)mockQueryServices.getProps()).thenReturn((Object)readOnlyProps);
        ConnectionInfo mockConnectionInfo = (ConnectionInfo)Mockito.mock(ConnectionInfo.class);
        Mockito.when((Object)mockConnectionInfo.asProps()).thenReturn((Object)readOnlyProps);
        Properties properties = new Properties();
        ConnectionQueryServicesImpl cqs = new ConnectionQueryServicesImpl(mockQueryServices, mockConnectionInfo, properties);
        Field props = cqs.getClass().getDeclaredField("threadPoolExecutor");
        props.setAccessible(true);
        ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)props.get(cqs);
        Assert.assertNotNull((Object)threadPoolExecutor);
        Assert.assertEquals((long)readOnlyProps.getInt("phoenix.cqsi.thread.pool.core.size", -1), (long)threadPoolExecutor.getCorePoolSize());
        Assert.assertEquals((long)readOnlyProps.getInt("phoenix.cqsi.thread.pool.max.threads", -1), (long)threadPoolExecutor.getMaximumPoolSize());
        Assert.assertEquals(LinkedBlockingQueue.class, threadPoolExecutor.getQueue().getClass());
        Assert.assertEquals((long)readOnlyProps.getInt("phoenix.cqsi.thread.pool.max.queue", -1), (long)threadPoolExecutor.getQueue().remainingCapacity());
        Assert.assertEquals((long)readOnlyProps.getInt("phoenix.cqsi.thread.pool.keepalive.seconds", -1), (long)threadPoolExecutor.getKeepAliveTime(TimeUnit.SECONDS));
        Assert.assertTrue((boolean)threadPoolExecutor.allowsCoreThreadTimeOut());
    }

    private static ReadOnlyProps createCQSIThreadPoolReadOnlyProps() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("phoenix.cqsi.thread.pool.enabled", Boolean.toString(true));
        props.put("phoenix.cqsi.thread.pool.keepalive.seconds", Integer.toString(13));
        props.put("phoenix.cqsi.thread.pool.core.size", Integer.toString(17));
        props.put("phoenix.cqsi.thread.pool.max.threads", Integer.toString(19));
        props.put("phoenix.cqsi.thread.pool.max.queue", Integer.toString(23));
        props.put("phoenix.cqsi.thread.pool.allow.core.thread.timeout", Boolean.toString(true));
        return new ReadOnlyProps(props);
    }

    @Test
    public void testExceptionHandlingOnSystemNamespaceCreation() throws Exception {
        Mockito.when((Object)this.mockCqs.createSchema((List)ArgumentMatchers.any(List.class), ArgumentMatchers.anyString())).thenCallRealMethod();
        ((ConnectionQueryServicesImpl)Mockito.doCallRealMethod().when((Object)this.mockCqs)).ensureSystemTablesMigratedToSystemNamespace();
        ((ConnectionQueryServicesImpl)Mockito.doNothing().when((Object)this.mockCqs)).createSysMutexTableIfNotExists((Admin)ArgumentMatchers.any(Admin.class));
        Mockito.when((Object)this.mockCqs.getSystemTableNamesInDefaultNamespace((Admin)ArgumentMatchers.any(Admin.class))).thenReturn(Collections.emptyList());
        ((ConnectionQueryServicesImpl)Mockito.doThrow((Throwable[])new Throwable[]{PHOENIX_IO_EXCEPTION}).when((Object)this.mockCqs)).ensureNamespaceCreated(ArgumentMatchers.anyString());
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("phoenix.schema.isNamespaceMappingEnabled", "true");
        Mockito.when((Object)this.mockCqs.getProps()).thenReturn((Object)new ReadOnlyProps(props));
        this.mockCqs.ensureSystemTablesMigratedToSystemNamespace();
        ((ConnectionQueryServicesImpl)Mockito.verify((Object)this.mockCqs)).getSystemTableNamesInDefaultNamespace((Admin)ArgumentMatchers.any());
        try {
            this.mockCqs.createSchema(Collections.emptyList(), "");
        }
        catch (PhoenixIOException e) {
            Assert.assertEquals((Object)((Object)PHOENIX_IO_EXCEPTION), (Object)((Object)e));
        }
    }

    @Test
    public void testGetNextRegionStartKey() {
        RegionInfo mockHRegionInfo = (RegionInfo)Mockito.mock(RegionInfo.class);
        RegionInfo mockPrevHRegionInfo = (RegionInfo)Mockito.mock(RegionInfo.class);
        HRegionLocation mockRegionLocation = (HRegionLocation)Mockito.mock(HRegionLocation.class);
        HRegionLocation mockPrevRegionLocation = (HRegionLocation)Mockito.mock(HRegionLocation.class);
        ConnectionQueryServicesImpl mockCqsi = (ConnectionQueryServicesImpl)Mockito.mock(ConnectionQueryServicesImpl.class, (Answer)Mockito.CALLS_REAL_METHODS);
        byte[] corruptedStartAndEndKey = "0x3000".getBytes();
        byte[] corruptedDecreasingKey = "0x2999".getBytes();
        byte[] corruptedNewEndKey = "0x3001".getBytes();
        byte[] notCorruptedStartKey = "0x2999".getBytes();
        byte[] notCorruptedEndKey = "0x3000".getBytes();
        byte[] notCorruptedNewKey = "0x3001".getBytes();
        byte[] mockTableName = "dummyTable".getBytes();
        Mockito.when((Object)mockRegionLocation.getRegion()).thenReturn((Object)mockHRegionInfo);
        Mockito.when((Object)mockHRegionInfo.getRegionName()).thenReturn((Object)mockTableName);
        Mockito.when((Object)mockPrevRegionLocation.getRegion()).thenReturn((Object)mockPrevHRegionInfo);
        Mockito.when((Object)mockPrevHRegionInfo.getRegionName()).thenReturn((Object)mockTableName);
        GlobalClientMetrics.GLOBAL_HBASE_COUNTER_METADATA_INCONSISTENCY.getMetric().reset();
        Mockito.when((Object)mockHRegionInfo.getStartKey()).thenReturn((Object)corruptedStartAndEndKey);
        Mockito.when((Object)mockHRegionInfo.getEndKey()).thenReturn((Object)corruptedStartAndEndKey);
        Mockito.when((Object)mockPrevHRegionInfo.getEndKey()).thenReturn((Object)corruptedStartAndEndKey);
        this.testGetNextRegionStartKey(mockCqsi, mockRegionLocation, corruptedStartAndEndKey, true, mockPrevRegionLocation);
        GlobalClientMetrics.GLOBAL_HBASE_COUNTER_METADATA_INCONSISTENCY.getMetric().reset();
        Mockito.when((Object)mockHRegionInfo.getStartKey()).thenReturn((Object)corruptedStartAndEndKey);
        Mockito.when((Object)mockHRegionInfo.getEndKey()).thenReturn((Object)corruptedDecreasingKey);
        Mockito.when((Object)mockPrevHRegionInfo.getEndKey()).thenReturn((Object)corruptedStartAndEndKey);
        this.testGetNextRegionStartKey(mockCqsi, mockRegionLocation, corruptedStartAndEndKey, true, mockPrevRegionLocation);
        GlobalClientMetrics.GLOBAL_HBASE_COUNTER_METADATA_INCONSISTENCY.getMetric().reset();
        Mockito.when((Object)mockHRegionInfo.getStartKey()).thenReturn((Object)corruptedDecreasingKey);
        Mockito.when((Object)mockHRegionInfo.getEndKey()).thenReturn((Object)corruptedNewEndKey);
        Mockito.when((Object)mockPrevHRegionInfo.getEndKey()).thenReturn((Object)corruptedStartAndEndKey);
        this.testGetNextRegionStartKey(mockCqsi, mockRegionLocation, corruptedStartAndEndKey, true, mockPrevRegionLocation);
        GlobalClientMetrics.GLOBAL_HBASE_COUNTER_METADATA_INCONSISTENCY.getMetric().reset();
        Mockito.when((Object)mockHRegionInfo.getStartKey()).thenReturn((Object)corruptedStartAndEndKey);
        Mockito.when((Object)mockHRegionInfo.getEndKey()).thenReturn((Object)corruptedNewEndKey);
        Mockito.when((Object)mockPrevHRegionInfo.getEndKey()).thenReturn((Object)corruptedDecreasingKey);
        this.testGetNextRegionStartKey(mockCqsi, mockRegionLocation, corruptedDecreasingKey, true, mockPrevRegionLocation);
        GlobalClientMetrics.GLOBAL_HBASE_COUNTER_METADATA_INCONSISTENCY.getMetric().reset();
        Mockito.when((Object)mockHRegionInfo.getStartKey()).thenReturn((Object)corruptedDecreasingKey);
        Mockito.when((Object)mockHRegionInfo.getEndKey()).thenReturn((Object)corruptedNewEndKey);
        Mockito.when((Object)mockPrevHRegionInfo.getEndKey()).thenReturn((Object)corruptedStartAndEndKey);
        this.testGetNextRegionStartKey(mockCqsi, mockRegionLocation, corruptedStartAndEndKey, true, mockPrevRegionLocation);
        GlobalClientMetrics.GLOBAL_HBASE_COUNTER_METADATA_INCONSISTENCY.getMetric().reset();
        Mockito.when((Object)mockHRegionInfo.getStartKey()).thenReturn((Object)corruptedStartAndEndKey);
        Mockito.when((Object)mockHRegionInfo.getEndKey()).thenReturn((Object)notCorruptedNewKey);
        Mockito.when((Object)mockPrevHRegionInfo.getEndKey()).thenReturn((Object)notCorruptedEndKey);
        this.testGetNextRegionStartKey(mockCqsi, mockRegionLocation, notCorruptedEndKey, false, mockPrevRegionLocation);
        GlobalClientMetrics.GLOBAL_HBASE_COUNTER_METADATA_INCONSISTENCY.getMetric().reset();
        Mockito.when((Object)mockHRegionInfo.getStartKey()).thenReturn((Object)HConstants.EMPTY_START_ROW);
        Mockito.when((Object)mockHRegionInfo.getEndKey()).thenReturn((Object)notCorruptedEndKey);
        this.testGetNextRegionStartKey(mockCqsi, mockRegionLocation, HConstants.EMPTY_START_ROW, false, null);
        GlobalClientMetrics.GLOBAL_HBASE_COUNTER_METADATA_INCONSISTENCY.getMetric().reset();
        Mockito.when((Object)mockHRegionInfo.getStartKey()).thenReturn((Object)notCorruptedStartKey);
        Mockito.when((Object)mockHRegionInfo.getEndKey()).thenReturn((Object)HConstants.EMPTY_END_ROW);
        this.testGetNextRegionStartKey(mockCqsi, mockRegionLocation, notCorruptedStartKey, false, null);
    }

    private void testGetNextRegionStartKey(ConnectionQueryServicesImpl mockCqsi, HRegionLocation mockRegionLocation, byte[] key, boolean isCorrupted, HRegionLocation mockPrevRegionLocation) {
        mockCqsi.getNextRegionStartKey(mockRegionLocation, key, mockPrevRegionLocation);
        Assert.assertEquals((long)(isCorrupted ? 1L : 0L), (long)GlobalClientMetrics.GLOBAL_HBASE_COUNTER_METADATA_INCONSISTENCY.getMetric().getValue());
    }

    @Test
    public void testSysMutexCheckReturnsFalseWhenTableAbsent() throws Exception {
        ((Admin)Mockito.doThrow((Throwable[])new Throwable[]{new TableNotFoundException()}).when((Object)this.mockAdmin)).getDescriptor(TableName.valueOf((String)PhoenixDatabaseMetaData.SYSTEM_MUTEX_NAME));
        ((Admin)Mockito.doThrow((Throwable[])new Throwable[]{new TableNotFoundException()}).when((Object)this.mockAdmin)).getDescriptor(TableName.valueOf((String)"SYSTEM", (String)"MUTEX"));
        Assert.assertFalse((boolean)this.mockCqs.checkIfSysMutexExistsAndModifyTTLIfRequired(this.mockAdmin));
    }

    @Test
    public void testSysMutexCheckModifiesTTLWhenWrong() throws Exception {
        TableDescriptor sysMutexTableDescWrongTTL = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)PhoenixDatabaseMetaData.SYSTEM_MUTEX_NAME)).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])PhoenixDatabaseMetaData.SYSTEM_MUTEX_FAMILY_NAME_BYTES).setTimeToLive(Integer.MAX_VALUE).build()).build();
        Mockito.when((Object)this.mockAdmin.getDescriptor(TableName.valueOf((String)PhoenixDatabaseMetaData.SYSTEM_MUTEX_NAME))).thenReturn((Object)sysMutexTableDescWrongTTL);
        Assert.assertTrue((boolean)this.mockCqs.checkIfSysMutexExistsAndModifyTTLIfRequired(this.mockAdmin));
        ((Admin)Mockito.verify((Object)this.mockAdmin, (VerificationMode)Mockito.times((int)1))).modifyTable(this.sysMutexTableDescCorrectTTL);
    }

    @Test
    public void testSysMutexCheckDoesNotModifyTableDescWhenTTLCorrect() throws Exception {
        Mockito.when((Object)this.mockAdmin.getDescriptor(TableName.valueOf((String)PhoenixDatabaseMetaData.SYSTEM_MUTEX_NAME))).thenReturn((Object)this.sysMutexTableDescCorrectTTL);
        Assert.assertTrue((boolean)this.mockCqs.checkIfSysMutexExistsAndModifyTTLIfRequired(this.mockAdmin));
        ((Admin)Mockito.verify((Object)this.mockAdmin, (VerificationMode)Mockito.times((int)0))).modifyTable((TableDescriptor)ArgumentMatchers.any(TableDescriptor.class));
    }

    @Test
    public void testSysTaskSplitPolicy() throws Exception {
        Assert.assertTrue((boolean)this.mockCqs.updateAndConfirmSplitPolicyForTask(SYS_TASK_TDB));
        Assert.assertFalse((boolean)this.mockCqs.updateAndConfirmSplitPolicyForTask(SYS_TASK_TDB));
    }

    @Test
    public void testSysTaskSplitPolicyWithError() {
        try {
            this.mockCqs.updateAndConfirmSplitPolicyForTask(SYS_TASK_TDB_SP);
            Assert.fail((String)"Split policy for SYSTEM.TASK cannot be updated");
        }
        catch (SQLException e) {
            Assert.assertEquals((Object)"ERROR 908 (43M19): REGION SPLIT POLICY is incorrect. Region split policy for table TASK is expected to be among: [null, org.apache.phoenix.schema.SystemTaskSplitPolicy] , actual split policy: abc tableName=SYSTEM.TASK", (Object)e.getMessage());
        }
    }

    @Test
    public void testGetSysMutexTableWithName() throws Exception {
        Mockito.when((Object)this.mockAdmin.tableExists((TableName)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.when((Object)this.mockConn.getAdmin()).thenReturn((Object)this.mockAdmin);
        Mockito.when((Object)this.mockConn.getTable((TableName)ArgumentMatchers.eq((Object)TableName.valueOf((String)"SYSTEM.MUTEX")))).thenReturn((Object)this.mockTable);
        Assert.assertSame((Object)this.mockCqs.getSysMutexTable(), (Object)this.mockTable);
        ((Admin)Mockito.verify((Object)this.mockAdmin, (VerificationMode)Mockito.times((int)1))).tableExists((TableName)ArgumentMatchers.any());
        ((Connection)Mockito.verify((Object)this.mockConn, (VerificationMode)Mockito.times((int)1))).getAdmin();
        ((Connection)Mockito.verify((Object)this.mockConn, (VerificationMode)Mockito.times((int)1))).getTable((TableName)ArgumentMatchers.eq((Object)TableName.valueOf((String)"SYSTEM.MUTEX")));
    }

    @Test
    public void testGetSysMutexTableWithNamespace() throws Exception {
        Mockito.when((Object)this.mockAdmin.tableExists((TableName)ArgumentMatchers.any())).thenReturn((Object)false);
        Mockito.when((Object)this.mockConn.getAdmin()).thenReturn((Object)this.mockAdmin);
        Mockito.when((Object)this.mockConn.getTable((TableName)ArgumentMatchers.eq((Object)TableName.valueOf((String)"SYSTEM:MUTEX")))).thenReturn((Object)this.mockTable);
        Assert.assertSame((Object)this.mockCqs.getSysMutexTable(), (Object)this.mockTable);
        ((Admin)Mockito.verify((Object)this.mockAdmin, (VerificationMode)Mockito.times((int)1))).tableExists((TableName)ArgumentMatchers.any());
        ((Connection)Mockito.verify((Object)this.mockConn, (VerificationMode)Mockito.times((int)1))).getAdmin();
        ((Connection)Mockito.verify((Object)this.mockConn, (VerificationMode)Mockito.times((int)1))).getTable((TableName)ArgumentMatchers.eq((Object)TableName.valueOf((String)"SYSTEM:MUTEX")));
    }

    @Test
    public void testDropTablesAlreadyDisabled() throws Exception {
        Mockito.when((Object)this.mockConn.getAdmin()).thenReturn((Object)this.mockAdmin);
        ((Admin)Mockito.doThrow((Throwable[])new Throwable[]{new TableNotEnabledException()}).when((Object)this.mockAdmin)).disableTable((TableName)ArgumentMatchers.any());
        ((Admin)Mockito.doNothing().when((Object)this.mockAdmin)).deleteTable((TableName)ArgumentMatchers.any());
        this.mockCqs.dropTables(Collections.singletonList("TEST_TABLE".getBytes(StandardCharsets.UTF_8)));
        ((Admin)Mockito.verify((Object)this.mockAdmin, (VerificationMode)Mockito.times((int)1))).disableTable(TableName.valueOf((String)"TEST_TABLE"));
        ((Admin)Mockito.verify((Object)this.mockAdmin, (VerificationMode)Mockito.times((int)1))).deleteTable(TableName.valueOf((String)"TEST_TABLE"));
        ((Connection)Mockito.verify((Object)this.mockConn)).getAdmin();
    }

    @Test
    public void testDropTablesTableEnabled() throws Exception {
        Mockito.when((Object)this.mockConn.getAdmin()).thenReturn((Object)this.mockAdmin);
        ((Admin)Mockito.doNothing().when((Object)this.mockAdmin)).disableTable((TableName)ArgumentMatchers.any());
        ((Admin)Mockito.doNothing().when((Object)this.mockAdmin)).deleteTable((TableName)ArgumentMatchers.any());
        ((GuidePostsCacheWrapper)Mockito.doNothing().when((Object)this.mockTableStatsCache)).invalidateAll();
        this.mockCqs.dropTables(Collections.singletonList("TEST_TABLE".getBytes(StandardCharsets.UTF_8)));
        ((Admin)Mockito.verify((Object)this.mockAdmin, (VerificationMode)Mockito.times((int)1))).disableTable(TableName.valueOf((String)"TEST_TABLE"));
        ((Admin)Mockito.verify((Object)this.mockAdmin, (VerificationMode)Mockito.times((int)1))).deleteTable(TableName.valueOf((String)"TEST_TABLE"));
        ((Connection)Mockito.verify((Object)this.mockConn)).getAdmin();
    }
}

