/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.query;

import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixEmbeddedDriver;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.jdbc.PhoenixTestDriver;
import org.apache.phoenix.parse.BindableStatement;
import org.apache.phoenix.parse.SQLParser;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.schema.ColumnRef;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.TestUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;

public class BaseConnectionlessQueryTest
extends BaseTest {
    public static PTable ATABLE;
    public static Expression ORGANIZATION_ID;
    public static Expression ENTITY_ID;
    public static Expression A_INTEGER;
    public static Expression A_STRING;
    public static Expression B_STRING;
    public static Expression A_DATE;
    public static Expression A_TIME;
    public static Expression A_TIMESTAMP;
    public static Expression X_DECIMAL;
    protected static PhoenixTestDriver driver;

    protected static String getUrl() {
        return "jdbc:phoenix:none;test=true";
    }

    protected static String getUrl(String tenantId) {
        return BaseConnectionlessQueryTest.getUrl() + ';' + "TenantId" + '=' + tenantId;
    }

    private static void startServer(String url) throws Exception {
        Assert.assertNull((Object)((Object)driver));
        if (PhoenixEmbeddedDriver.isTestUrl((String)url)) {
            HashMap props = Maps.newHashMapWithExpectedSize((int)1);
            driver = BaseConnectionlessQueryTest.initDriver(new ReadOnlyProps((Map)props));
            Assert.assertTrue((DriverManager.getDriver(url) == driver ? 1 : 0) != 0);
            driver.connect(url, PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));
        }
    }

    protected static synchronized PhoenixTestDriver initDriver(ReadOnlyProps props) throws Exception {
        if (driver == null) {
            driver = new PhoenixTestDriver(props);
            DriverManager.registerDriver((Driver)((Object)driver));
        }
        return driver;
    }

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        BaseConnectionlessQueryTest.startServer(BaseConnectionlessQueryTest.getUrl());
        BaseConnectionlessQueryTest.ensureTableCreated(BaseConnectionlessQueryTest.getUrl(), "ATABLE");
        BaseConnectionlessQueryTest.ensureTableCreated(BaseConnectionlessQueryTest.getUrl(), "ENTITY_HISTORY");
        BaseConnectionlessQueryTest.ensureTableCreated(BaseConnectionlessQueryTest.getUrl(), "FUNKY_NAMES");
        BaseConnectionlessQueryTest.ensureTableCreated(BaseConnectionlessQueryTest.getUrl(), "PTSDB");
        BaseConnectionlessQueryTest.ensureTableCreated(BaseConnectionlessQueryTest.getUrl(), "PTSDB2");
        BaseConnectionlessQueryTest.ensureTableCreated(BaseConnectionlessQueryTest.getUrl(), "PTSDB3");
        BaseConnectionlessQueryTest.ensureTableCreated(BaseConnectionlessQueryTest.getUrl(), "MULTI_CF");
        BaseConnectionlessQueryTest.ensureTableCreated(BaseConnectionlessQueryTest.getUrl(), "TABLE_WITH_ARRAY");
        Properties props = new Properties();
        props.setProperty("CurrentSCN", Long.toString(Long.MAX_VALUE));
        try (PhoenixConnection conn = DriverManager.getConnection("jdbc:phoenix:none;test=true", props).unwrap(PhoenixConnection.class);){
            PTable table;
            ATABLE = table = conn.getTable(new PTableKey(null, "ATABLE"));
            ORGANIZATION_ID = new ColumnRef(new TableRef(table), table.getColumnForColumnName("ORGANIZATION_ID").getPosition()).newColumnExpression();
            ENTITY_ID = new ColumnRef(new TableRef(table), table.getColumnForColumnName("ENTITY_ID").getPosition()).newColumnExpression();
            A_INTEGER = new ColumnRef(new TableRef(table), table.getColumnForColumnName("A_INTEGER").getPosition()).newColumnExpression();
            A_STRING = new ColumnRef(new TableRef(table), table.getColumnForColumnName("A_STRING").getPosition()).newColumnExpression();
            B_STRING = new ColumnRef(new TableRef(table), table.getColumnForColumnName("B_STRING").getPosition()).newColumnExpression();
            A_DATE = new ColumnRef(new TableRef(table), table.getColumnForColumnName("A_DATE").getPosition()).newColumnExpression();
            A_TIME = new ColumnRef(new TableRef(table), table.getColumnForColumnName("A_TIME").getPosition()).newColumnExpression();
            A_TIMESTAMP = new ColumnRef(new TableRef(table), table.getColumnForColumnName("A_TIMESTAMP").getPosition()).newColumnExpression();
            X_DECIMAL = new ColumnRef(new TableRef(table), table.getColumnForColumnName("X_DECIMAL").getPosition()).newColumnExpression();
        }
    }

    @AfterClass
    public static synchronized void doTeardown() throws Exception {
        if (driver != null) {
            try {
                driver.close();
            }
            finally {
                PhoenixTestDriver driver = BaseConnectionlessQueryTest.driver;
                BaseConnectionlessQueryTest.driver = null;
                DriverManager.deregisterDriver((Driver)((Object)driver));
            }
        }
    }

    protected static void assertRoundtrip(String sql) throws SQLException {
        SQLParser parser = new SQLParser(sql);
        BindableStatement stmt = null;
        stmt = parser.parseStatement();
        if (stmt.getOperation() != PhoenixStatement.Operation.QUERY) {
            return;
        }
        String newSQL = stmt.toString();
        SQLParser newParser = new SQLParser(newSQL);
        BindableStatement newStmt = null;
        try {
            newStmt = newParser.parseStatement();
        }
        catch (SQLException e) {
            Assert.fail((String)("Unable to parse new:\n" + newSQL));
        }
        Assert.assertEquals((String)("Expected equality:\n" + sql + "\n" + newSQL), (Object)stmt, (Object)newStmt);
    }
}

