/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import java.util.List;
import org.apache.phoenix.parse.AliasedNode;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.PhoenixRowTimestampParseNode;
import org.apache.phoenix.parse.SQLParser;
import org.junit.Assert;
import org.junit.Test;

public class PhoenixRowTimestampFunctionTest {
    @Test
    public void testExpressionWithPhoenixRowTimestamp() throws Exception {
        ParseNode parseNode = SQLParser.parseCondition((String)"(PHOENIX_ROW_TIMESTAMP() = PK2)");
        boolean hasPhoenixRowTimestampParseNode = false;
        for (ParseNode childNode : parseNode.getChildren()) {
            if (!childNode.getClass().isAssignableFrom(PhoenixRowTimestampParseNode.class)) continue;
            Assert.assertEquals((long)0L, (long)childNode.getChildren().size());
            hasPhoenixRowTimestampParseNode = true;
        }
        Assert.assertTrue((boolean)hasPhoenixRowTimestampParseNode);
    }

    @Test
    public void testExpressionWithPhoenixRowTimestampWithParams() throws Exception {
        ParseNode parseNode = SQLParser.parseCondition((String)"(PHOENIX_ROW_TIMESTAMP(COL1) = PK2)");
        for (ParseNode childNode : parseNode.getChildren()) {
            Assert.assertFalse((String)"PhoenixRowTimestampFunction does not take any parameters", (boolean)childNode.getClass().isAssignableFrom(PhoenixRowTimestampParseNode.class));
        }
    }

    @Test
    public void testSelectWithPhoenixRowTimestamp() throws Exception {
        SQLParser parser = new SQLParser("SELECT PHOENIX_ROW_TIMESTAMP() FROM xyz");
        List nodes = parser.parseQuery().getSelect();
        Assert.assertEquals((long)1L, (long)nodes.size());
        Assert.assertTrue((String)"PHOENIX_ROW_TIMESTAMP() should parse to PhoenixRowTimestampParseNode", (boolean)((AliasedNode)nodes.get(0)).getNode().getClass().isAssignableFrom(PhoenixRowTimestampParseNode.class));
        Assert.assertEquals((long)0L, (long)((AliasedNode)nodes.get(0)).getNode().getChildren().size());
    }
}

