/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import org.apache.phoenix.parse.CastParseNode;
import org.apache.phoenix.parse.ColumnParseNode;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.TableName;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.schema.types.PLong;
import org.junit.Assert;
import org.junit.Test;

public class CastParseNodeTest {
    @Test
    public void testToSQL() {
        ColumnParseNode columnParseNode = new ColumnParseNode(TableName.create((String)"SCHEMA1", (String)"TABLE1"), "V");
        CastParseNode castParseNode = new CastParseNode((ParseNode)columnParseNode, (PDataType)PLong.INSTANCE, null, null, false);
        StringBuilder stringBuilder = new StringBuilder();
        castParseNode.toSQL(null, stringBuilder);
        Assert.assertEquals((Object)" CAST(TABLE1.V AS BIGINT)", (Object)stringBuilder.toString());
    }

    @Test
    public void testToSQL_WithLengthAndScale() {
        ColumnParseNode columnParseNode = new ColumnParseNode(TableName.create((String)"SCHEMA1", (String)"TABLE1"), "V");
        CastParseNode castParseNode = new CastParseNode((ParseNode)columnParseNode, (PDataType)PDecimal.INSTANCE, Integer.valueOf(5), Integer.valueOf(3), false);
        StringBuilder stringBuilder = new StringBuilder();
        castParseNode.toSQL(null, stringBuilder);
        Assert.assertEquals((Object)" CAST(TABLE1.V AS DECIMAL(5,3))", (Object)stringBuilder.toString());
    }

    @Test
    public void testToSQL_ArrayType() {
        ColumnParseNode columnParseNode = new ColumnParseNode(TableName.create((String)"SCHEMA1", (String)"TABLE1"), "V");
        CastParseNode castParseNode = new CastParseNode((ParseNode)columnParseNode, (PDataType)PLong.INSTANCE, null, null, true);
        StringBuilder stringBuilder = new StringBuilder();
        castParseNode.toSQL(null, stringBuilder);
        Assert.assertEquals((Object)" CAST(TABLE1.V AS BIGINT ARRAY)", (Object)stringBuilder.toString());
    }
}

