/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.function.ScalarFunction;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PVarchar;
import org.junit.Assert;
import org.junit.Test;

public class BuiltInFunctionInfoTest {
    private static FunctionParseNode.BuiltInFunctionInfo getBuiltInFunctionInfo(Class<? extends ScalarFunction> funcClass) {
        return new FunctionParseNode.BuiltInFunctionInfo(funcClass, funcClass.getAnnotation(FunctionParseNode.BuiltInFunction.class));
    }

    @Test
    public void testConstruct_NoDefaultArgs() {
        FunctionParseNode.BuiltInFunctionInfo funcInfo = BuiltInFunctionInfoTest.getBuiltInFunctionInfo(NoDefaultArgsFunction.class);
        Assert.assertEquals((long)2L, (long)funcInfo.getArgs().length);
        Assert.assertEquals((long)2L, (long)funcInfo.getRequiredArgCount());
        Assert.assertEquals((Object)"NO_DEFAULT_ARGS", (Object)funcInfo.getName());
    }

    @Test
    public void testConstruct_WithOneDefaultArg() {
        FunctionParseNode.BuiltInFunctionInfo funcInfo = BuiltInFunctionInfoTest.getBuiltInFunctionInfo(WithOneDefaultArg.class);
        Assert.assertEquals((long)3L, (long)funcInfo.getArgs().length);
        Assert.assertEquals((long)2L, (long)funcInfo.getRequiredArgCount());
        Assert.assertEquals((Object)"WITH_ONE_DEFAULT_ARG", (Object)funcInfo.getName());
    }

    @Test
    public void testConstruct_WithMultipleDefaultArgs() {
        FunctionParseNode.BuiltInFunctionInfo funcInfo = BuiltInFunctionInfoTest.getBuiltInFunctionInfo(WithMultipleDefaultArgs.class);
        Assert.assertEquals((long)3L, (long)funcInfo.getArgs().length);
        Assert.assertEquals((long)1L, (long)funcInfo.getRequiredArgCount());
        Assert.assertEquals((Object)"WITH_MULTIPLE_DEFAULT_ARGS", (Object)funcInfo.getName());
    }

    @FunctionParseNode.BuiltInFunction(name="WITH_MULTIPLE_DEFAULT_ARGS", args={@FunctionParseNode.Argument(allowedTypes={PVarchar.class}), @FunctionParseNode.Argument(allowedTypes={PVarchar.class}, defaultValue="'a'"), @FunctionParseNode.Argument(allowedTypes={PVarchar.class}, defaultValue="'b'")})
    static class WithMultipleDefaultArgs
    extends BaseFunctionAdapter {
        public WithMultipleDefaultArgs(List<Expression> ignoreChildren) {
            super("WITH_MULTIPLE_DEFAULT_ARGS");
        }
    }

    @FunctionParseNode.BuiltInFunction(name="WITH_ONE_DEFAULT_ARG", args={@FunctionParseNode.Argument(allowedTypes={PVarchar.class}), @FunctionParseNode.Argument(allowedTypes={PVarchar.class}), @FunctionParseNode.Argument(allowedTypes={PVarchar.class}, defaultValue="'a'")})
    static class WithOneDefaultArg
    extends BaseFunctionAdapter {
        public WithOneDefaultArg(List<Expression> ignoreChildren) {
            super("WITH_ONE_DEFAULT_ARG");
        }
    }

    @FunctionParseNode.BuiltInFunction(name="NO_DEFAULT_ARGS", args={@FunctionParseNode.Argument(allowedTypes={PVarchar.class}), @FunctionParseNode.Argument(allowedTypes={PVarchar.class})})
    static class NoDefaultArgsFunction
    extends BaseFunctionAdapter {
        public NoDefaultArgsFunction(List<Expression> ignoreChildren) {
            super("NO_DEFAULT_ARGS");
        }
    }

    private static class BaseFunctionAdapter
    extends ScalarFunction {
        private final String name;

        BaseFunctionAdapter(String name) {
            this.name = name;
        }

        public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
            throw new UnsupportedOperationException("Can't evalulate a BaseTestFunction");
        }

        public PDataType getDataType() {
            return PVarchar.INSTANCE;
        }

        public String getName() {
            return this.name;
        }
    }
}

