/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.monitoring.connectionqueryservice;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.phoenix.monitoring.ConnectionQueryServicesMetric;
import org.apache.phoenix.monitoring.MetricType;
import org.apache.phoenix.monitoring.connectionqueryservice.ConnectionQueryServicesMetricsManager;
import org.junit.Assert;

public class ConnectionQueryServicesNameMetricsTest {
    public static final String[] connectionQueryServiceNames = new String[]{"USE_CASE_1", "USE_CASE_2", "USE_CASE_3"};
    public static Map<String, Map<MetricType, Long>>[] connectionQueryServiceNameMetricMap = new Map[connectionQueryServiceNames.length];
    public static final long[] openPhoenixConnCounter = new long[]{1L, 1L, 1L};
    public static final long[] openInternalPhoenixConnCounter = new long[]{1L, 1L, 1L};
    public static final long[] phoenixConnThrottledCounter = new long[]{1L, 2L, 3L};

    public void populateMetrics() {
        int i;
        for (i = 0; i < connectionQueryServiceNameMetricMap.length; ++i) {
            ConnectionQueryServicesNameMetricsTest.connectionQueryServiceNameMetricMap[i] = new HashMap<String, Map<MetricType, Long>>();
        }
        for (i = 0; i < connectionQueryServiceNames.length; ++i) {
            HashMap<MetricType, Long> metrics = new HashMap<MetricType, Long>();
            metrics.put(MetricType.OPEN_PHOENIX_CONNECTIONS_COUNTER, openPhoenixConnCounter[i]);
            metrics.put(MetricType.OPEN_INTERNAL_PHOENIX_CONNECTIONS_COUNTER, openInternalPhoenixConnCounter[i]);
            metrics.put(MetricType.PHOENIX_CONNECTIONS_THROTTLED_COUNTER, phoenixConnThrottledCounter[i]);
            connectionQueryServiceNameMetricMap[i].put(connectionQueryServiceNames[i], metrics);
        }
    }

    public void verfiyCountOfConnectionQueryServices(int noOfConnectionQueryServiceName) {
        Map map = ConnectionQueryServicesMetricsManager.getAllConnectionQueryServicesMetrics();
        Assert.assertFalse((map == null || map.isEmpty() ? 1 : 0) != 0);
        for (int i = 0; i < noOfConnectionQueryServiceName; ++i) {
            Assert.assertTrue((boolean)map.containsKey(connectionQueryServiceNames[i]));
            List connectionQueryServiceNameMetric = (List)map.get(connectionQueryServiceNames[i]);
            for (ConnectionQueryServicesMetric metric : connectionQueryServiceNameMetric) {
                if (metric.getMetricType().equals((Object)MetricType.OPEN_PHOENIX_CONNECTIONS_COUNTER)) {
                    Assert.assertEquals((long)openPhoenixConnCounter[i], (long)metric.getValue());
                }
                if (metric.getMetricType().equals((Object)MetricType.OPEN_INTERNAL_PHOENIX_CONNECTIONS_COUNTER)) {
                    Assert.assertEquals((long)openInternalPhoenixConnCounter[i], (long)metric.getValue());
                }
                if (!metric.getMetricType().equals((Object)MetricType.PHOENIX_CONNECTIONS_THROTTLED_COUNTER)) continue;
                Assert.assertEquals((long)phoenixConnThrottledCounter[i], (long)metric.getValue());
            }
        }
    }
}

