/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.monitoring.connectionqueryservice;

import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.phoenix.monitoring.MetricType;
import org.apache.phoenix.monitoring.connectionqueryservice.ConnectionQueryServicesHistogram;
import org.apache.phoenix.monitoring.connectionqueryservice.ConnectionQueryServicesMetricsManager;
import org.apache.phoenix.monitoring.connectionqueryservice.ConnectionQueryServicesNameMetricsTest;
import org.apache.phoenix.query.QueryServicesOptions;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class ConnectionQueryServicesMetricsManagerTest {
    public boolean verifyMetricsReset() {
        Map map = ConnectionQueryServicesMetricsManager.getAllConnectionQueryServicesMetrics();
        return map != null && map.isEmpty();
    }

    public boolean verifyConnectionQueryServiceNamesExists(String connectionQueryServiceName) {
        Map map = ConnectionQueryServicesMetricsManager.getAllConnectionQueryServicesMetrics();
        return map != null && map.containsKey(connectionQueryServiceName);
    }

    @Test
    public void testConnectionQueryServiceMetricsForUpdateMetricsMethod() {
        QueryServicesOptions options = QueryServicesOptions.withDefaults();
        options.setConnectionQueryServiceMetricsEnabled();
        ConnectionQueryServicesMetricsManager connectionQueryServicesMetricsManager = new ConnectionQueryServicesMetricsManager(options);
        ConnectionQueryServicesMetricsManager.setInstance((ConnectionQueryServicesMetricsManager)connectionQueryServicesMetricsManager);
        ConnectionQueryServicesNameMetricsTest testData = new ConnectionQueryServicesNameMetricsTest();
        testData.populateMetrics();
        for (int i = 0; i < ConnectionQueryServicesNameMetricsTest.connectionQueryServiceNames.length; ++i) {
            ConnectionQueryServicesMetricsManager.updateMetrics((String)ConnectionQueryServicesNameMetricsTest.connectionQueryServiceNames[i], (MetricType)MetricType.OPEN_PHOENIX_CONNECTIONS_COUNTER, (long)ConnectionQueryServicesNameMetricsTest.openPhoenixConnCounter[i]);
            ConnectionQueryServicesMetricsManager.updateMetrics((String)ConnectionQueryServicesNameMetricsTest.connectionQueryServiceNames[i], (MetricType)MetricType.OPEN_INTERNAL_PHOENIX_CONNECTIONS_COUNTER, (long)ConnectionQueryServicesNameMetricsTest.openInternalPhoenixConnCounter[i]);
            ConnectionQueryServicesMetricsManager.updateMetrics((String)ConnectionQueryServicesNameMetricsTest.connectionQueryServiceNames[i], (MetricType)MetricType.PHOENIX_CONNECTIONS_THROTTLED_COUNTER, (long)ConnectionQueryServicesNameMetricsTest.phoenixConnThrottledCounter[i]);
        }
        testData.verfiyCountOfConnectionQueryServices(ConnectionQueryServicesNameMetricsTest.connectionQueryServiceNames.length);
        ConnectionQueryServicesMetricsManager.clearAllConnectionQueryServiceMetrics();
        Assert.assertTrue((boolean)this.verifyMetricsReset());
    }

    @Test
    public void testHistogramMetricsForOpenPhoenixConnectionCounter() {
        String connectionQueryServiceName = "USE_CASE_1";
        Configuration conf = new Configuration();
        conf.set("phoenix.conn.query.service.histogram.size.ranges", "3, 6, 9");
        QueryServicesOptions mockOptions = (QueryServicesOptions)Mockito.mock(QueryServicesOptions.class);
        ((QueryServicesOptions)Mockito.doReturn((Object)true).when((Object)mockOptions)).isConnectionQueryServiceMetricsEnabled();
        ((QueryServicesOptions)Mockito.doReturn((Object)conf).when((Object)mockOptions)).getConfiguration();
        ConnectionQueryServicesMetricsManager connectionQueryServicesMetricsManager = new ConnectionQueryServicesMetricsManager(mockOptions);
        ConnectionQueryServicesMetricsManager.setInstance((ConnectionQueryServicesMetricsManager)connectionQueryServicesMetricsManager);
        for (int i = 0; i < 9; ++i) {
            this.updateMetricsAndHistogram(i + 1, connectionQueryServiceName);
        }
        ConnectionQueryServicesHistogram connectionQueryServicesHistogram = ConnectionQueryServicesMetricsManager.getConnectionQueryServiceOpenConnectionHistogram((String)connectionQueryServiceName);
        Map openPhoenixConnMap = connectionQueryServicesHistogram.getRangeHistogramDistribution().getRangeDistributionMap();
        for (Long count : openPhoenixConnMap.values()) {
            Assert.assertEquals((Object)new Long(3L), (Object)count);
        }
    }

    private void updateMetricsAndHistogram(long counter, String connectionQueryServiceName) {
        ConnectionQueryServicesMetricsManager.updateMetrics((String)connectionQueryServiceName, (MetricType)MetricType.OPEN_PHOENIX_CONNECTIONS_COUNTER, (long)counter);
        ConnectionQueryServicesMetricsManager.updateConnectionQueryServiceOpenConnectionHistogram((long)counter, (String)connectionQueryServiceName);
    }
}

