/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.monitoring;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.monitoring.LatencyHistogram;
import org.apache.phoenix.monitoring.MetricType;
import org.apache.phoenix.monitoring.MutationMetricQueue;
import org.apache.phoenix.monitoring.SizeHistogram;
import org.apache.phoenix.monitoring.TableLevelMetricsTestData;
import org.apache.phoenix.monitoring.TableMetricsManager;
import org.apache.phoenix.query.QueryServicesOptions;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TableMetricsManagerTest {
    public boolean verifyMetricsReset() {
        Map map = TableMetricsManager.getTableMetricsMethod();
        return map != null && map.isEmpty();
    }

    public boolean verifyTableNamesExists(String tableName) {
        Map map = TableMetricsManager.getTableMetricsMethod();
        return map != null && map.containsKey(tableName);
    }

    @Test
    public void testVerifyTableLevelMetricsMutilpleThreads() throws Exception {
        QueryServicesOptions options = QueryServicesOptions.withDefaults();
        options.setTableLevelMetricsEnabled();
        String tableNamesList = TableLevelMetricsTestData.tableNames[0] + "," + TableLevelMetricsTestData.tableNames[1] + "," + TableLevelMetricsTestData.tableNames[2];
        options.setAllowedListForTableLevelMetrics(tableNamesList);
        TableMetricsManager tableMetricsManager = new TableMetricsManager(options);
        TableMetricsManager.setInstance((TableMetricsManager)tableMetricsManager);
        TableLevelMetricsTestData testData = new TableLevelMetricsTestData();
        TableLevelMetricsTestData.populateMetrics();
        ExecutorService executorService = Executors.newFixedThreadPool(TableLevelMetricsTestData.tableNames.length, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = Executors.defaultThreadFactory().newThread(r);
                t.setDaemon(true);
                t.setPriority(1);
                return t;
            }
        });
        ArrayList futureList = Lists.newArrayListWithExpectedSize((int)TableLevelMetricsTestData.tableNames.length);
        for (int i = 0; i < TableLevelMetricsTestData.tableNames.length; ++i) {
            futureList.add(executorService.submit(new PushMetrics(TableLevelMetricsTestData.tableMetricsMap[i])));
        }
        executorService.shutdown();
        executorService.awaitTermination(10L, TimeUnit.SECONDS);
        testData.verifyMetricsInjection(TableLevelMetricsTestData.tableNames.length);
        TableMetricsManager.clearTableLevelMetricsMethod();
        Assert.assertTrue((boolean)this.verifyMetricsReset());
    }

    @Test
    public void testTableMetricsForPushMetricsFromConnInstanceMethod() {
        QueryServicesOptions options = QueryServicesOptions.withDefaults();
        options.setTableLevelMetricsEnabled();
        String tableNamesList = TableLevelMetricsTestData.tableNames[0] + "," + TableLevelMetricsTestData.tableNames[1] + "," + TableLevelMetricsTestData.tableNames[2];
        options.setAllowedListForTableLevelMetrics(tableNamesList);
        TableMetricsManager tableMetricsManager = new TableMetricsManager(options);
        TableMetricsManager.setInstance((TableMetricsManager)tableMetricsManager);
        TableLevelMetricsTestData testData = new TableLevelMetricsTestData();
        TableLevelMetricsTestData.populateMetrics();
        for (int i = 0; i < TableLevelMetricsTestData.tableNames.length; ++i) {
            TableMetricsManager.pushMetricsFromConnInstanceMethod(TableLevelMetricsTestData.tableMetricsMap[i]);
        }
        testData.verifyMetricsInjection(3);
        TableMetricsManager.clearTableLevelMetricsMethod();
        Assert.assertTrue((boolean)this.verifyMetricsReset());
    }

    @Test
    public void testTableMetricsForUpdateMetricsMethod() {
        QueryServicesOptions options = QueryServicesOptions.withDefaults();
        options.setTableLevelMetricsEnabled();
        TableMetricsManager tableMetricsManager = new TableMetricsManager(options);
        TableMetricsManager.setInstance((TableMetricsManager)tableMetricsManager);
        TableLevelMetricsTestData testData = new TableLevelMetricsTestData();
        for (int i = 0; i < TableLevelMetricsTestData.tableNames.length; ++i) {
            TableMetricsManager.updateMetricsMethod((String)TableLevelMetricsTestData.tableNames[i], (MetricType)MetricType.MUTATION_BATCH_SIZE, (long)TableLevelMetricsTestData.mutationBatchSizeCounter[i]);
            TableMetricsManager.updateMetricsMethod((String)TableLevelMetricsTestData.tableNames[i], (MetricType)MetricType.UPSERT_MUTATION_SQL_COUNTER, (long)TableLevelMetricsTestData.upsertMutationSqlCounter[i]);
            TableMetricsManager.updateMetricsMethod((String)TableLevelMetricsTestData.tableNames[i], (MetricType)MetricType.UPSERT_MUTATION_BYTES, (long)TableLevelMetricsTestData.upsertMutationBytesCounter[i]);
            TableMetricsManager.updateMetricsMethod((String)TableLevelMetricsTestData.tableNames[i], (MetricType)MetricType.DELETE_MUTATION_SQL_COUNTER, (long)TableLevelMetricsTestData.deleteMutationSqlCounter[i]);
            TableMetricsManager.updateMetricsMethod((String)TableLevelMetricsTestData.tableNames[i], (MetricType)MetricType.DELETE_MUTATION_BYTES, (long)TableLevelMetricsTestData.deleteMutationByesCounter[i]);
            TableMetricsManager.updateMetricsMethod((String)TableLevelMetricsTestData.tableNames[i], (MetricType)MetricType.MUTATION_SQL_COUNTER, (long)TableLevelMetricsTestData.mutationSqlCounter[i]);
            TableMetricsManager.updateMetricsMethod((String)TableLevelMetricsTestData.tableNames[i], (MetricType)MetricType.MUTATION_COMMIT_TIME, (long)TableLevelMetricsTestData.mutationSqlCommitTimeCounter[i]);
            TableMetricsManager.updateMetricsMethod((String)TableLevelMetricsTestData.tableNames[i], (MetricType)MetricType.TASK_END_TO_END_TIME, (long)TableLevelMetricsTestData.taskEndToEndTimeCounter[i]);
            TableMetricsManager.updateMetricsMethod((String)TableLevelMetricsTestData.tableNames[i], (MetricType)MetricType.COUNT_ROWS_SCANNED, (long)TableLevelMetricsTestData.countRowsScannedCounter[i]);
            TableMetricsManager.updateMetricsMethod((String)TableLevelMetricsTestData.tableNames[i], (MetricType)MetricType.QUERY_FAILED_COUNTER, (long)TableLevelMetricsTestData.queryFailedCounter[i]);
            TableMetricsManager.updateMetricsMethod((String)TableLevelMetricsTestData.tableNames[i], (MetricType)MetricType.QUERY_TIMEOUT_COUNTER, (long)TableLevelMetricsTestData.queryTimeOutCounter[i]);
            TableMetricsManager.updateMetricsMethod((String)TableLevelMetricsTestData.tableNames[i], (MetricType)MetricType.SCAN_BYTES, (long)TableLevelMetricsTestData.scanBytesCounter[i]);
            TableMetricsManager.updateMetricsMethod((String)TableLevelMetricsTestData.tableNames[i], (MetricType)MetricType.SELECT_POINTLOOKUP_SUCCESS_SQL_COUNTER, (long)TableLevelMetricsTestData.selectPointLookUpSuccessCounter[i]);
            TableMetricsManager.updateMetricsMethod((String)TableLevelMetricsTestData.tableNames[i], (MetricType)MetricType.SELECT_POINTLOOKUP_FAILED_SQL_COUNTER, (long)TableLevelMetricsTestData.selectPointLookUpFailedCounter[i]);
            TableMetricsManager.updateMetricsMethod((String)TableLevelMetricsTestData.tableNames[i], (MetricType)MetricType.SELECT_SQL_QUERY_TIME, (long)TableLevelMetricsTestData.selectSqlQueryTimeCounter[i]);
            TableMetricsManager.updateMetricsMethod((String)TableLevelMetricsTestData.tableNames[i], (MetricType)MetricType.SELECT_SCAN_FAILED_SQL_COUNTER, (long)TableLevelMetricsTestData.selectScanFailedCounter[i]);
            TableMetricsManager.updateMetricsMethod((String)TableLevelMetricsTestData.tableNames[i], (MetricType)MetricType.SELECT_SCAN_SUCCESS_SQL_COUNTER, (long)TableLevelMetricsTestData.selectScanSuccessCounter[i]);
            TableMetricsManager.updateMetricsForSystemCatalogTableMethod((String)TableLevelMetricsTestData.tableNames[i], (MetricType)MetricType.NUM_SYSTEM_TABLE_RPC_SUCCESS, (long)TableLevelMetricsTestData.numRpcSuccessCallsSystemCatalog[i]);
            TableMetricsManager.updateMetricsForSystemCatalogTableMethod((String)TableLevelMetricsTestData.tableNames[i], (MetricType)MetricType.NUM_SYSTEM_TABLE_RPC_FAILURES, (long)TableLevelMetricsTestData.numRpcFailureCallsSystemCatalog[i]);
            TableMetricsManager.updateMetricsForSystemCatalogTableMethod((String)TableLevelMetricsTestData.tableNames[i], (MetricType)MetricType.TIME_SPENT_IN_SYSTEM_TABLE_RPC_CALLS, (long)TableLevelMetricsTestData.timeTakenForRpcCallsSystemCatalog[i]);
        }
        testData.verifyMetricsInjection(3);
        TableMetricsManager.clearTableLevelMetricsMethod();
        Assert.assertTrue((boolean)this.verifyMetricsReset());
    }

    @Test
    public void testTableMetricsForPushMetricsFromConnInstanceMethodWithAllowedTables() {
        QueryServicesOptions options = QueryServicesOptions.withDefaults();
        options.setTableLevelMetricsEnabled();
        String tableNamesList = TableLevelMetricsTestData.tableNames[0] + "," + TableLevelMetricsTestData.tableNames[1];
        options.setAllowedListForTableLevelMetrics(tableNamesList);
        TableMetricsManager tableMetricsManager = new TableMetricsManager(options);
        TableMetricsManager.setInstance((TableMetricsManager)tableMetricsManager);
        TableLevelMetricsTestData testData = new TableLevelMetricsTestData();
        TableLevelMetricsTestData.populateMetrics();
        for (int i = 0; i < TableLevelMetricsTestData.tableNames.length; ++i) {
            TableMetricsManager.pushMetricsFromConnInstanceMethod(TableLevelMetricsTestData.tableMetricsMap[i]);
        }
        testData.verifyMetricsInjection(2);
        Assert.assertFalse((boolean)this.verifyTableNamesExists(TableLevelMetricsTestData.tableNames[2]));
    }

    @Test
    public void testHistogramMetricsForUpsertMutations() {
        String tableName = "TEST-TABLE";
        Configuration conf = new Configuration();
        conf.set("phoenix.histogram.latency.ranges", "2,5,8");
        conf.set("phoenix.histogram.size.ranges", "10, 100, 1000");
        QueryServicesOptions mockOptions = (QueryServicesOptions)Mockito.mock(QueryServicesOptions.class);
        ((QueryServicesOptions)Mockito.doReturn((Object)true).when((Object)mockOptions)).isTableLevelMetricsEnabled();
        ((QueryServicesOptions)Mockito.doReturn((Object)tableName).when((Object)mockOptions)).getAllowedListTableNames();
        ((QueryServicesOptions)Mockito.doReturn((Object)conf).when((Object)mockOptions)).getConfiguration();
        TableMetricsManager tableMetricsManager = new TableMetricsManager(mockOptions);
        TableMetricsManager.setInstance((TableMetricsManager)tableMetricsManager);
        TableMetricsManager.updateLatencyHistogramForMutations((String)tableName, (long)1L, (boolean)true);
        MutationMetricQueue.MutationMetric metric = new MutationMetricQueue.MutationMetric(0L, 5L, 0L, 0L, 0L, 0L, 0L, 1L, 0L, 5L, 0L, 0L, 0L, 0L, 0L, 0L, 0L);
        TableMetricsManager.updateSizeHistogramMetricsForMutations((String)tableName, (long)metric.getTotalMutationsSizeBytes().getValue(), (boolean)true);
        TableMetricsManager.updateLatencyHistogramForMutations((String)tableName, (long)2L, (boolean)true);
        metric = new MutationMetricQueue.MutationMetric(0L, 10L, 0L, 0L, 0L, 0L, 0L, 1L, 0L, 10L, 0L, 0L, 0L, 0L, 0L, 0L, 0L);
        TableMetricsManager.updateSizeHistogramMetricsForMutations((String)tableName, (long)metric.getTotalMutationsSizeBytes().getValue(), (boolean)true);
        TableMetricsManager.updateLatencyHistogramForMutations((String)tableName, (long)4L, (boolean)true);
        metric = new MutationMetricQueue.MutationMetric(0L, 50L, 0L, 0L, 0L, 0L, 0L, 1L, 0L, 50L, 0L, 0L, 0L, 0L, 0L, 0L, 0L);
        TableMetricsManager.updateSizeHistogramMetricsForMutations((String)tableName, (long)metric.getTotalMutationsSizeBytes().getValue(), (boolean)true);
        TableMetricsManager.updateLatencyHistogramForMutations((String)tableName, (long)5L, (boolean)true);
        metric = new MutationMetricQueue.MutationMetric(0L, 100L, 0L, 0L, 0L, 0L, 0L, 1L, 0L, 100L, 0L, 0L, 0L, 0L, 0L, 0L, 0L);
        TableMetricsManager.updateSizeHistogramMetricsForMutations((String)tableName, (long)metric.getTotalMutationsSizeBytes().getValue(), (boolean)true);
        TableMetricsManager.updateLatencyHistogramForMutations((String)tableName, (long)6L, (boolean)true);
        metric = new MutationMetricQueue.MutationMetric(0L, 500L, 0L, 0L, 0L, 0L, 0L, 1L, 0L, 500L, 0L, 0L, 0L, 0L, 0L, 0L, 0L);
        TableMetricsManager.updateSizeHistogramMetricsForMutations((String)tableName, (long)metric.getTotalMutationsSizeBytes().getValue(), (boolean)true);
        TableMetricsManager.updateLatencyHistogramForMutations((String)tableName, (long)8L, (boolean)true);
        metric = new MutationMetricQueue.MutationMetric(0L, 1000L, 0L, 0L, 0L, 0L, 0L, 1L, 0L, 1000L, 0L, 0L, 0L, 0L, 0L, 0L, 0L);
        TableMetricsManager.updateSizeHistogramMetricsForMutations((String)tableName, (long)metric.getTotalMutationsSizeBytes().getValue(), (boolean)true);
        LatencyHistogram latencyHistogram = TableMetricsManager.getUpsertLatencyHistogramForTable((String)tableName);
        SizeHistogram sizeHistogram = TableMetricsManager.getUpsertSizeHistogramForTable((String)tableName);
        Map latencyMap = latencyHistogram.getRangeHistogramDistribution().getRangeDistributionMap();
        Map sizeMap = sizeHistogram.getRangeHistogramDistribution().getRangeDistributionMap();
        for (Long count : latencyMap.values()) {
            Assert.assertEquals((Object)new Long(2L), (Object)count);
        }
        for (Long count : sizeMap.values()) {
            Assert.assertEquals((Object)new Long(2L), (Object)count);
        }
    }

    @Test
    public void testHistogramMetricsForDeleteMutations() {
        String tableName = "TEST-TABLE";
        Configuration conf = new Configuration();
        conf.set("phoenix.histogram.latency.ranges", "2,5,8");
        conf.set("phoenix.histogram.size.ranges", "10, 100, 1000");
        QueryServicesOptions mockOptions = (QueryServicesOptions)Mockito.mock(QueryServicesOptions.class);
        ((QueryServicesOptions)Mockito.doReturn((Object)true).when((Object)mockOptions)).isTableLevelMetricsEnabled();
        ((QueryServicesOptions)Mockito.doReturn((Object)tableName).when((Object)mockOptions)).getAllowedListTableNames();
        ((QueryServicesOptions)Mockito.doReturn((Object)conf).when((Object)mockOptions)).getConfiguration();
        TableMetricsManager tableMetricsManager = new TableMetricsManager(mockOptions);
        TableMetricsManager.setInstance((TableMetricsManager)tableMetricsManager);
        TableMetricsManager.updateLatencyHistogramForMutations((String)tableName, (long)1L, (boolean)false);
        MutationMetricQueue.MutationMetric metric = new MutationMetricQueue.MutationMetric(0L, 0L, 5L, 0L, 0L, 0L, 0L, 0L, 1L, 5L, 0L, 0L, 0L, 0L, 0L, 0L, 0L);
        TableMetricsManager.updateSizeHistogramMetricsForMutations((String)tableName, (long)metric.getTotalMutationsSizeBytes().getValue(), (boolean)false);
        TableMetricsManager.updateLatencyHistogramForMutations((String)tableName, (long)2L, (boolean)false);
        metric = new MutationMetricQueue.MutationMetric(0L, 0L, 10L, 0L, 0L, 0L, 0L, 0L, 1L, 10L, 0L, 0L, 0L, 0L, 0L, 0L, 0L);
        TableMetricsManager.updateSizeHistogramMetricsForMutations((String)tableName, (long)metric.getTotalMutationsSizeBytes().getValue(), (boolean)false);
        TableMetricsManager.updateLatencyHistogramForMutations((String)tableName, (long)4L, (boolean)false);
        metric = new MutationMetricQueue.MutationMetric(0L, 0L, 50L, 0L, 0L, 0L, 0L, 0L, 1L, 50L, 0L, 0L, 0L, 0L, 0L, 0L, 0L);
        TableMetricsManager.updateSizeHistogramMetricsForMutations((String)tableName, (long)metric.getTotalMutationsSizeBytes().getValue(), (boolean)false);
        TableMetricsManager.updateLatencyHistogramForMutations((String)tableName, (long)5L, (boolean)false);
        metric = new MutationMetricQueue.MutationMetric(0L, 0L, 100L, 0L, 0L, 0L, 0L, 0L, 1L, 100L, 0L, 0L, 0L, 0L, 0L, 0L, 0L);
        TableMetricsManager.updateSizeHistogramMetricsForMutations((String)tableName, (long)metric.getTotalMutationsSizeBytes().getValue(), (boolean)false);
        TableMetricsManager.updateLatencyHistogramForMutations((String)tableName, (long)6L, (boolean)false);
        metric = new MutationMetricQueue.MutationMetric(0L, 0L, 500L, 0L, 0L, 0L, 0L, 0L, 1L, 500L, 0L, 0L, 0L, 0L, 0L, 0L, 0L);
        TableMetricsManager.updateSizeHistogramMetricsForMutations((String)tableName, (long)metric.getTotalMutationsSizeBytes().getValue(), (boolean)false);
        TableMetricsManager.updateLatencyHistogramForMutations((String)tableName, (long)8L, (boolean)false);
        metric = new MutationMetricQueue.MutationMetric(0L, 0L, 1000L, 0L, 0L, 0L, 0L, 0L, 1L, 1000L, 0L, 0L, 0L, 0L, 0L, 0L, 0L);
        TableMetricsManager.updateSizeHistogramMetricsForMutations((String)tableName, (long)metric.getTotalMutationsSizeBytes().getValue(), (boolean)false);
        LatencyHistogram latencyHistogram = TableMetricsManager.getDeleteLatencyHistogramForTable((String)tableName);
        SizeHistogram sizeHistogram = TableMetricsManager.getDeleteSizeHistogramForTable((String)tableName);
        Map latencyMap = latencyHistogram.getRangeHistogramDistribution().getRangeDistributionMap();
        Map sizeMap = sizeHistogram.getRangeHistogramDistribution().getRangeDistributionMap();
        for (Long count : latencyMap.values()) {
            Assert.assertEquals((Object)new Long(2L), (Object)count);
        }
        for (Long count : sizeMap.values()) {
            Assert.assertEquals((Object)new Long(2L), (Object)count);
        }
    }

    @Test
    public void testHistogramMetricsForQuery() {
        String tableName = "TEST-TABLE";
        Configuration conf = new Configuration();
        conf.set("phoenix.histogram.latency.ranges", "2,5,8");
        conf.set("phoenix.histogram.size.ranges", "10, 100, 1000");
        QueryServicesOptions mockOptions = (QueryServicesOptions)Mockito.mock(QueryServicesOptions.class);
        ((QueryServicesOptions)Mockito.doReturn((Object)true).when((Object)mockOptions)).isTableLevelMetricsEnabled();
        ((QueryServicesOptions)Mockito.doReturn((Object)tableName).when((Object)mockOptions)).getAllowedListTableNames();
        ((QueryServicesOptions)Mockito.doReturn((Object)conf).when((Object)mockOptions)).getConfiguration();
        TableMetricsManager tableMetricsManager = new TableMetricsManager(mockOptions);
        TableMetricsManager.setInstance((TableMetricsManager)tableMetricsManager);
        TableMetricsManager.updateHistogramMetricsForQueryLatency((String)tableName, (long)1L, (boolean)true);
        TableMetricsManager.updateHistogramMetricsForQueryScanBytes((long)5L, (String)tableName, (boolean)true);
        TableMetricsManager.updateHistogramMetricsForQueryLatency((String)tableName, (long)2L, (boolean)false);
        TableMetricsManager.updateHistogramMetricsForQueryScanBytes((long)10L, (String)tableName, (boolean)false);
        TableMetricsManager.updateHistogramMetricsForQueryLatency((String)tableName, (long)4L, (boolean)true);
        TableMetricsManager.updateHistogramMetricsForQueryScanBytes((long)50L, (String)tableName, (boolean)true);
        TableMetricsManager.updateHistogramMetricsForQueryLatency((String)tableName, (long)5L, (boolean)false);
        TableMetricsManager.updateHistogramMetricsForQueryScanBytes((long)100L, (String)tableName, (boolean)false);
        TableMetricsManager.updateHistogramMetricsForQueryLatency((String)tableName, (long)7L, (boolean)true);
        TableMetricsManager.updateHistogramMetricsForQueryScanBytes((long)500L, (String)tableName, (boolean)true);
        TableMetricsManager.updateHistogramMetricsForQueryLatency((String)tableName, (long)8L, (boolean)false);
        TableMetricsManager.updateHistogramMetricsForQueryScanBytes((long)1000L, (String)tableName, (boolean)false);
        LatencyHistogram latencyHistogram = TableMetricsManager.getQueryLatencyHistogramForTable((String)tableName);
        SizeHistogram sizeHistogram = TableMetricsManager.getQuerySizeHistogramForTable((String)tableName);
        Map latencyMap = latencyHistogram.getRangeHistogramDistribution().getRangeDistributionMap();
        Map sizeMap = sizeHistogram.getRangeHistogramDistribution().getRangeDistributionMap();
        for (Long count : latencyMap.values()) {
            Assert.assertEquals((Object)new Long(2L), (Object)count);
        }
        for (Long count : sizeMap.values()) {
            Assert.assertEquals((Object)new Long(2L), (Object)count);
        }
        LatencyHistogram pointLookupLtHisto = TableMetricsManager.getPointLookupLatencyHistogramForTable((String)tableName);
        SizeHistogram pointLookupSizeHisto = TableMetricsManager.getPointLookupSizeHistogramForTable((String)tableName);
        Map pointLookupLtMap = pointLookupLtHisto.getRangeHistogramDistribution().getRangeDistributionMap();
        Map pointLookupSizeMap = pointLookupSizeHisto.getRangeHistogramDistribution().getRangeDistributionMap();
        for (Long count : pointLookupLtMap.values()) {
            Assert.assertEquals((Object)new Long(1L), (Object)count);
        }
        for (Long count : pointLookupSizeMap.values()) {
            Assert.assertEquals((Object)new Long(1L), (Object)count);
        }
        LatencyHistogram rangeScanLtHisto = TableMetricsManager.getRangeScanLatencyHistogramForTable((String)tableName);
        SizeHistogram rangeScanSizeHisto = TableMetricsManager.getRangeScanSizeHistogramForTable((String)tableName);
        Map rangeScanLtMap = rangeScanLtHisto.getRangeHistogramDistribution().getRangeDistributionMap();
        Map rangeScanSizeMap = rangeScanSizeHisto.getRangeHistogramDistribution().getRangeDistributionMap();
        for (Long count : rangeScanLtMap.values()) {
            Assert.assertEquals((Object)new Long(1L), (Object)count);
        }
        for (Long count : rangeScanSizeMap.values()) {
            Assert.assertEquals((Object)new Long(1L), (Object)count);
        }
    }

    @Test
    public void testTableMetricsNull() {
        String tableName = "TEST-TABLE";
        String badTableName = "NOT-ALLOWED-TABLE";
        QueryServicesOptions mockOptions = (QueryServicesOptions)Mockito.mock(QueryServicesOptions.class);
        ((QueryServicesOptions)Mockito.doReturn((Object)true).when((Object)mockOptions)).isTableLevelMetricsEnabled();
        ((QueryServicesOptions)Mockito.doReturn((Object)tableName).when((Object)mockOptions)).getAllowedListTableNames();
        TableMetricsManager tableMetricsManager = new TableMetricsManager(mockOptions);
        TableMetricsManager.setInstance((TableMetricsManager)tableMetricsManager);
        Assert.assertNull((Object)TableMetricsManager.getQueryLatencyHistogramForTable((String)badTableName));
    }

    private static class PushMetrics
    implements Runnable {
        private final Map<String, Map<MetricType, Long>> map;

        public PushMetrics(Map<String, Map<MetricType, Long>> map) {
            this.map = map;
        }

        @Override
        public void run() {
            TableMetricsManager.pushMetricsFromConnInstanceMethod(this.map);
        }
    }
}

