/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.monitoring;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.phoenix.monitoring.MetricType;
import org.apache.phoenix.monitoring.PhoenixTableMetric;
import org.apache.phoenix.monitoring.TableMetricsManager;
import org.junit.Assert;

public class TableLevelMetricsTestData {
    public static final String[] tableNames = new String[]{"T0001", "T0002", "T0003"};
    public static Map<String, Map<MetricType, Long>>[] tableMetricsMap = new Map[tableNames.length];
    public static final long[] mutationBatchSizeCounter = new long[]{90L, 100L, 150L};
    public static final long[] upsertMutationBytesCounter = new long[]{100L, 200L, 250L};
    public static final long[] upsertMutationSqlCounter = new long[]{100L, 200L, 300L};
    public static final long[] deleteMutationByesCounter = new long[]{100L, 200L, 150L};
    public static final long[] deleteMutationSqlCounter = new long[]{100L, 200L, 140L};
    public static final long[] mutationSqlCounter = new long[]{200L, 400L, 600L};
    public static final long[] mutationSqlCommitTimeCounter = new long[]{150L, 300L, 100L};
    public static final long[] taskEndToEndTimeCounter = new long[]{10L, 20L, 30L};
    public static final long[] countRowsScannedCounter = new long[]{500L, 600L, 400L};
    public static final long[] queryFailedCounter = new long[]{10L, 20L, 30L};
    public static final long[] queryTimeOutCounter = new long[]{30L, 40L, 40L};
    public static final long[] scanBytesCounter = new long[]{500L, 600L, 400L};
    public static final long[] selectPointLookUpFailedCounter = new long[]{10L, 29L, 49L};
    public static final long[] selectSqlQueryTimeCounter = new long[]{30L, 40L, 55L};
    public static final long[] selectPointLookUpSuccessCounter = new long[]{10L, 20L, 55L};
    public static final long[] selectScanSuccessCounter = new long[]{200000L, 300000L, 4444L};
    public static final long[] selectScanFailedCounter = new long[]{1000000L, 20000000L, 3455L};
    public static final long[] numRpcSuccessCallsSystemCatalog = new long[]{200L, 100L, 300L};
    public static final long[] numRpcFailureCallsSystemCatalog = new long[]{100L, 200L, 300L};
    public static final long[] timeTakenForRpcCallsSystemCatalog = new long[]{500L, 600L, 370L};

    public static void populateMetrics() {
        int i;
        for (i = 0; i < tableMetricsMap.length; ++i) {
            TableLevelMetricsTestData.tableMetricsMap[i] = new HashMap<String, Map<MetricType, Long>>();
        }
        for (i = 0; i < tableNames.length; ++i) {
            HashMap<MetricType, Long> metrics = new HashMap<MetricType, Long>();
            metrics.put(MetricType.MUTATION_BATCH_SIZE, mutationBatchSizeCounter[i]);
            metrics.put(MetricType.UPSERT_MUTATION_BYTES, upsertMutationBytesCounter[i]);
            metrics.put(MetricType.UPSERT_MUTATION_SQL_COUNTER, upsertMutationSqlCounter[i]);
            metrics.put(MetricType.DELETE_MUTATION_BYTES, deleteMutationByesCounter[i]);
            metrics.put(MetricType.DELETE_MUTATION_SQL_COUNTER, deleteMutationSqlCounter[i]);
            metrics.put(MetricType.MUTATION_SQL_COUNTER, mutationSqlCounter[i]);
            metrics.put(MetricType.MUTATION_COMMIT_TIME, mutationSqlCommitTimeCounter[i]);
            metrics.put(MetricType.TASK_END_TO_END_TIME, taskEndToEndTimeCounter[i]);
            metrics.put(MetricType.COUNT_ROWS_SCANNED, countRowsScannedCounter[i]);
            metrics.put(MetricType.QUERY_FAILED_COUNTER, queryFailedCounter[i]);
            metrics.put(MetricType.QUERY_TIMEOUT_COUNTER, queryTimeOutCounter[i]);
            metrics.put(MetricType.SCAN_BYTES, scanBytesCounter[i]);
            metrics.put(MetricType.SELECT_POINTLOOKUP_SUCCESS_SQL_COUNTER, selectPointLookUpSuccessCounter[i]);
            metrics.put(MetricType.SELECT_POINTLOOKUP_FAILED_SQL_COUNTER, selectPointLookUpFailedCounter[i]);
            metrics.put(MetricType.SELECT_SQL_QUERY_TIME, selectSqlQueryTimeCounter[i]);
            metrics.put(MetricType.SELECT_SCAN_SUCCESS_SQL_COUNTER, selectScanSuccessCounter[i]);
            metrics.put(MetricType.SELECT_SCAN_FAILED_SQL_COUNTER, selectScanFailedCounter[i]);
            tableMetricsMap[i].put(tableNames[i], metrics);
            metrics.put(MetricType.NUM_SYSTEM_TABLE_RPC_SUCCESS, numRpcSuccessCallsSystemCatalog[i]);
            metrics.put(MetricType.NUM_SYSTEM_TABLE_RPC_FAILURES, numRpcFailureCallsSystemCatalog[i]);
            metrics.put(MetricType.TIME_SPENT_IN_SYSTEM_TABLE_RPC_CALLS, timeTakenForRpcCallsSystemCatalog[i]);
        }
    }

    public void verifyMetricsInjection(int noOfTables) {
        Map map = TableMetricsManager.getTableMetricsMethod();
        Assert.assertFalse((map == null || map.isEmpty() ? 1 : 0) != 0);
        for (int i = 0; i < noOfTables; ++i) {
            System.out.println("CURRENTLY ON: " + tableNames[i]);
            Assert.assertTrue((boolean)map.containsKey(tableNames[i]));
            List tableMetric = (List)map.get(tableNames[i]);
            for (PhoenixTableMetric metric : tableMetric) {
                if (metric.getMetricType().equals((Object)MetricType.MUTATION_BATCH_SIZE)) {
                    Assert.assertEquals((long)mutationBatchSizeCounter[i], (long)metric.getValue());
                }
                if (metric.getMetricType().equals((Object)MetricType.UPSERT_MUTATION_BYTES)) {
                    Assert.assertEquals((long)upsertMutationBytesCounter[i], (long)metric.getValue());
                }
                if (metric.getMetricType().equals((Object)MetricType.UPSERT_MUTATION_SQL_COUNTER)) {
                    Assert.assertEquals((long)upsertMutationSqlCounter[i], (long)metric.getValue());
                }
                if (metric.getMetricType().equals((Object)MetricType.DELETE_MUTATION_BYTES)) {
                    Assert.assertEquals((long)deleteMutationByesCounter[i], (long)metric.getValue());
                }
                if (metric.getMetricType().equals((Object)MetricType.DELETE_MUTATION_SQL_COUNTER)) {
                    Assert.assertEquals((long)deleteMutationSqlCounter[i], (long)metric.getValue());
                }
                if (metric.getMetricType().equals((Object)MetricType.MUTATION_SQL_COUNTER)) {
                    Assert.assertEquals((long)mutationSqlCounter[i], (long)metric.getValue());
                }
                if (metric.getMetricType().equals((Object)MetricType.MUTATION_COMMIT_TIME)) {
                    Assert.assertEquals((long)mutationSqlCommitTimeCounter[i], (long)metric.getValue());
                }
                if (metric.getMetricType().equals((Object)MetricType.TASK_END_TO_END_TIME)) {
                    Assert.assertEquals((long)taskEndToEndTimeCounter[i], (long)metric.getValue());
                }
                if (metric.getMetricType().equals((Object)MetricType.COUNT_ROWS_SCANNED)) {
                    Assert.assertEquals((long)countRowsScannedCounter[i], (long)metric.getValue());
                }
                if (metric.getMetricType().equals((Object)MetricType.QUERY_FAILED_COUNTER)) {
                    Assert.assertEquals((long)queryFailedCounter[i], (long)metric.getValue());
                }
                if (metric.getMetricType().equals((Object)MetricType.QUERY_TIMEOUT_COUNTER)) {
                    Assert.assertEquals((long)queryTimeOutCounter[i], (long)metric.getValue());
                }
                if (metric.getMetricType().equals((Object)MetricType.SCAN_BYTES)) {
                    Assert.assertEquals((long)scanBytesCounter[i], (long)metric.getValue());
                }
                if (metric.getMetricType().equals((Object)MetricType.SELECT_POINTLOOKUP_SUCCESS_SQL_COUNTER)) {
                    Assert.assertEquals((long)selectPointLookUpSuccessCounter[i], (long)metric.getValue());
                }
                if (metric.getMetricType().equals((Object)MetricType.SELECT_POINTLOOKUP_FAILED_SQL_COUNTER)) {
                    Assert.assertEquals((long)selectPointLookUpFailedCounter[i], (long)metric.getValue());
                }
                if (metric.getMetricType().equals((Object)MetricType.SELECT_SQL_QUERY_TIME)) {
                    Assert.assertEquals((long)selectSqlQueryTimeCounter[i], (long)metric.getValue());
                }
                if (metric.getMetricType().equals((Object)MetricType.SELECT_SCAN_FAILED_SQL_COUNTER)) {
                    Assert.assertEquals((long)selectScanFailedCounter[i], (long)metric.getValue());
                }
                if (!metric.getMetricType().equals((Object)MetricType.SELECT_SCAN_SUCCESS_SQL_COUNTER)) continue;
                Assert.assertEquals((long)selectScanSuccessCounter[i], (long)metric.getValue());
            }
        }
    }
}

