/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.monitoring;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.phoenix.monitoring.SizeHistogram;
import org.junit.Assert;
import org.junit.Test;

public class SizeHistogramTest {
    @Test
    public void testSizeHistogramRangeOverride() {
        Configuration conf = new Configuration();
        conf.set("phoenix.histogram.size.ranges", "1, 100, 1000");
        SizeHistogram histogram = new SizeHistogram("PhoenixReadBytesHisto", "histogram for read bytes", conf);
        long[] ranges = histogram.getRanges();
        Assert.assertNotNull((Object)ranges);
        Assert.assertEquals((long)3L, (long)ranges.length);
        Assert.assertEquals((long)1L, (long)ranges[0]);
        Assert.assertEquals((long)100L, (long)ranges[1]);
        Assert.assertEquals((long)1000L, (long)ranges[2]);
    }

    @Test
    public void testEveryRangeInDefaultRange() {
        Configuration conf = new Configuration();
        String histoName = "PhoenixReadBytesHisto";
        conf.unset("phoenix.histogram.size.ranges");
        SizeHistogram histogram = new SizeHistogram(histoName, "histogram for read bytes", conf);
        Assert.assertEquals((Object)histoName, (Object)histogram.getName());
        Assert.assertEquals((Object)SizeHistogram.DEFAULT_RANGE, (Object)histogram.getRanges());
        histogram.add(5L);
        histogram.add(50L);
        histogram.add(500L);
        histogram.add(5000L);
        histogram.add(50000L);
        histogram.add(500000L);
        histogram.add(5000000L);
        histogram.add(50000000L);
        Map distribution = histogram.getRangeHistogramDistribution().getRangeDistributionMap();
        HashMap<String, Long> expectedMap = new HashMap<String, Long>();
        expectedMap.put("0,10", 1L);
        expectedMap.put("10,100", 1L);
        expectedMap.put("100,1000", 1L);
        expectedMap.put("1000,10000", 1L);
        expectedMap.put("10000,100000", 1L);
        expectedMap.put("100000,1000000", 1L);
        expectedMap.put("1000000,10000000", 1L);
        expectedMap.put("10000000,100000000", 1L);
        Assert.assertEquals(expectedMap, (Object)distribution);
    }
}

