/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.monitoring;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.jdbc.PhoenixDriver;
import org.apache.phoenix.monitoring.PhoenixMetricsIT;
import org.apache.phoenix.monitoring.PhoenixTableLevelMetricsIT;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.query.ConfigurationFactory;
import org.apache.phoenix.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.phoenix.util.InstanceResolver;
import org.apache.phoenix.util.PhoenixRuntime;
import org.apache.phoenix.util.ReadOnlyProps;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NeedsOwnMiniClusterTest.class})
public class PhoenixTableLevelAllowedTablesIT
extends BaseTest {
    private static final String ALLOWED_TABLE_1 = PhoenixTableLevelAllowedTablesIT.generateUniqueName();
    private static final String ALLOWED_TABLE_2 = PhoenixTableLevelAllowedTablesIT.generateUniqueName();

    @BeforeClass
    public static void doSetup() throws Exception {
        final Configuration conf = HBaseConfiguration.create();
        conf.set("phoenix.monitoring.tableMetrics.enabled", String.valueOf(true));
        conf.set("phoenix.query.request.metrics.enabled", String.valueOf(true));
        conf.set("phoenix.monitoring.allowedTableNames.list", ALLOWED_TABLE_1 + "," + ALLOWED_TABLE_2);
        InstanceResolver.clearSingletons();
        InstanceResolver.getSingleton(ConfigurationFactory.class, (Object)new ConfigurationFactory(){

            public Configuration getConfiguration() {
                return conf;
            }

            public Configuration getConfiguration(Configuration confToClone) {
                Configuration copy = new Configuration(conf);
                copy.addResource(confToClone);
                return copy;
            }
        });
        PhoenixTableLevelAllowedTablesIT.setUpTestDriver(new ReadOnlyProps((Map)ImmutableMap.of()));
        DriverManager.registerDriver((Driver)PhoenixDriver.INSTANCE);
    }

    @Test
    public void testAllowedListingFunctionality() throws Exception {
        ResultSet rs;
        Throwable throwable;
        Statement stmt2;
        String tableName = PhoenixTableLevelAllowedTablesIT.generateUniqueName();
        String ddl = "CREATE TABLE " + tableName + " (K VARCHAR NOT NULL PRIMARY KEY, V VARCHAR)";
        try (Connection ddlConn = DriverManager.getConnection(PhoenixTableLevelAllowedTablesIT.getUrl());){
            stmt2 = ddlConn.createStatement();
            throwable = null;
            try {
                stmt2.execute(ddl);
                String dml = "UPSERT INTO " + tableName + " VALUES (?, ?)";
                try (PreparedStatement preparedStatement = ddlConn.prepareStatement(dml);){
                    for (int i = 1; i <= 10; ++i) {
                        preparedStatement.setString(1, "key" + i);
                        preparedStatement.setString(2, "value" + i);
                        preparedStatement.executeUpdate();
                    }
                    ddlConn.commit();
                }
            }
            catch (Throwable dml) {
                throwable = dml;
                throw dml;
            }
            finally {
                if (stmt2 != null) {
                    if (throwable != null) {
                        try {
                            stmt2.close();
                        }
                        catch (Throwable dml) {
                            throwable.addSuppressed(dml);
                        }
                    } else {
                        stmt2.close();
                    }
                }
            }
        }
        Assert.assertTrue((boolean)PhoenixRuntime.getPhoenixTableClientMetrics().isEmpty());
        var5_4 = null;
        try (Connection conn = DriverManager.getConnection(PhoenixTableLevelAllowedTablesIT.getUrl());){
            PhoenixMetricsIT.createTableAndInsertValues(ALLOWED_TABLE_1, false, false, 10, true, conn, false);
        }
        catch (Throwable stmt2) {
            var5_4 = stmt2;
            throw stmt2;
        }
        conn = DriverManager.getConnection(PhoenixTableLevelAllowedTablesIT.getUrl());
        var5_4 = null;
        try {
            stmt2 = conn.createStatement();
            throwable = null;
            try {
                String query = "SELECT * FROM " + ALLOWED_TABLE_1;
                rs = stmt2.executeQuery(query);
                while (rs.next()) {
                }
                Assert.assertFalse((boolean)PhoenixRuntime.getPhoenixTableClientMetrics().isEmpty());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stmt2 != null) {
                    if (throwable != null) {
                        try {
                            stmt2.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        stmt2.close();
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            var5_4 = throwable4;
            throw throwable4;
        }
        finally {
            if (conn != null) {
                if (var5_4 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable5) {
                        var5_4.addSuppressed(throwable5);
                    }
                } else {
                    conn.close();
                }
            }
        }
        PhoenixTableLevelMetricsIT.assertSelectQueryTableMetrics(ALLOWED_TABLE_1, false, 1L, 0L, 1L, 0L, 0L, true, 0L, 0L, rs);
    }
}

