/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.monitoring;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.metrics2.AbstractMetric;
import org.apache.hbase.thirdparty.com.google.common.base.Joiner;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.com.google.common.collect.Sets;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDriver;
import org.apache.phoenix.jdbc.PhoenixResultSet;
import org.apache.phoenix.log.LogLevel;
import org.apache.phoenix.monitoring.BasePhoenixMetricsIT;
import org.apache.phoenix.monitoring.CombinableMetric;
import org.apache.phoenix.monitoring.CombinableMetricImpl;
import org.apache.phoenix.monitoring.GlobalClientMetrics;
import org.apache.phoenix.monitoring.GlobalMetric;
import org.apache.phoenix.monitoring.GlobalMetricImpl;
import org.apache.phoenix.monitoring.GlobalPhoenixMetricsTestSink;
import org.apache.phoenix.monitoring.MetricType;
import org.apache.phoenix.monitoring.ReadMetricQueue;
import org.apache.phoenix.util.EnvironmentEdge;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.PhoenixRuntime;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={NeedsOwnMiniClusterTest.class})
public class PhoenixMetricsIT
extends BasePhoenixMetricsIT {
    private static final Logger LOGGER = LoggerFactory.getLogger(PhoenixMetricsIT.class);
    private static final String DDL = "CREATE TABLE IF NOT EXISTS %s (  A CHAR(18) NOT NULL,   B VARCHAR(30) NOT NULL,   C VARCHAR(255) NOT NULL,   D VARCHAR(255) NOT NULL,   E VARBINARY,   F INTEGER,   G BOOLEAN,   H VARCHAR(30),   I DATE,   J DATE,   CONSTRAINT PK PRIMARY KEY (A, B, C, D)) IMMUTABLE_ROWS=true, VERSIONS=1, MULTI_TENANT=true, DISABLE_TABLE_SOR=true, TTL=864000";
    private static final String UPSERT_VALUES_DML = "UPSERT INTO %s (A, B, C, D, F, G, I) VALUES (?, ?, ?, ?, ?, ?, ?)";
    private static final String UPSERT_SELECT_DML = "UPSERT INTO %s (A, B, C, D) SELECT A, B, C, D FROM %s";
    private static final String POINT_DELETE_DML = "DELETE FROM %s WHERE A=? AND B=? AND C=? AND D=? AND G=FALSE";
    private static final String DELETE_ALL_DML = "DELETE FROM %s";
    private static final List<MetricType> mutationMetricsToSkip = Lists.newArrayList((Object[])new MetricType[]{MetricType.MUTATION_COMMIT_TIME, MetricType.UPSERT_COMMIT_TIME, MetricType.DELETE_COMMIT_TIME, MetricType.MUTATION_BATCH_COUNTER, MetricType.SQL_QUERY_PARSING_TIME_MS});
    private static final List<MetricType> readMetricsToSkip = Lists.newArrayList((Object[])new MetricType[]{MetricType.TASK_QUEUE_WAIT_TIME, MetricType.TASK_EXECUTION_TIME, MetricType.TASK_END_TO_END_TIME, MetricType.COUNT_MILLS_BETWEEN_NEXTS});
    private static final String CUSTOM_URL_STRING = "SESSION";
    private static final AtomicInteger numConnections = new AtomicInteger(0);
    static final String POINT_LOOKUP_SELECT_QUERY = "SELECT J, G, E, (NOW() - I)*24*60*60*1000 FROM %s WHERE A='keyA1' AND B='keyB1' AND C='keyC1' AND D='keyD1'";
    static final String RANGE_SCAN_SELECT_QUERY = "SELECT A, B, C FROM %s WHERE A='keyA1' AND B='keyB1' AND C > 'keyC0'";
    public static final long SCAN_BYTES_DELTA = 1L;
    public static final long TASK_EXECUTION_TIME_DELTA = 10L;
    public static final long MEMORY_CHUNK_BYTES_DELTA = 100L;

    @Test
    public void testResetGlobalPhoenixMetrics() throws Exception {
        PhoenixMetricsIT.resetGlobalMetrics();
        for (GlobalMetric m : PhoenixRuntime.getGlobalPhoenixClientMetrics()) {
            Assert.assertTrue((boolean)(m instanceof GlobalMetricImpl));
            Assert.assertEquals((long)0L, (long)m.getValue());
            Assert.assertEquals((long)0L, (long)m.getNumberOfSamples());
        }
        Assert.assertTrue((boolean)this.verifyMetricsFromSink());
    }

    @Test
    public void testGlobalPhoenixMetricsForQueries() throws Exception {
        String tableName = PhoenixMetricsIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(PhoenixMetricsIT.getUrl());){
            PhoenixMetricsIT.createTableAndInsertValues(tableName, true, false, 10, true, conn, false);
        }
        PhoenixMetricsIT.resetGlobalMetrics();
        conn = DriverManager.getConnection(PhoenixMetricsIT.getUrl());
        String query = "SELECT * FROM " + tableName;
        ResultSet rs = conn.createStatement().executeQuery(query);
        while (rs.next()) {
            rs.getString(1);
            rs.getString(2);
        }
        Assert.assertEquals((long)1L, (long)GlobalClientMetrics.GLOBAL_NUM_PARALLEL_SCANS.getMetric().getValue());
        Assert.assertEquals((long)1L, (long)GlobalClientMetrics.GLOBAL_SELECT_SQL_COUNTER.getMetric().getValue());
        Assert.assertEquals((long)0L, (long)GlobalClientMetrics.GLOBAL_REJECTED_TASK_COUNTER.getMetric().getValue());
        Assert.assertEquals((long)0L, (long)GlobalClientMetrics.GLOBAL_QUERY_TIMEOUT_COUNTER.getMetric().getValue());
        Assert.assertEquals((long)0L, (long)GlobalClientMetrics.GLOBAL_FAILED_QUERY_COUNTER.getMetric().getValue());
        Assert.assertEquals((long)0L, (long)GlobalClientMetrics.GLOBAL_SPOOL_FILE_COUNTER.getMetric().getValue());
        Assert.assertEquals((long)0L, (long)GlobalClientMetrics.GLOBAL_MUTATION_BATCH_SIZE.getMetric().getValue());
        Assert.assertEquals((long)0L, (long)GlobalClientMetrics.GLOBAL_MUTATION_BYTES.getMetric().getValue());
        Assert.assertEquals((long)0L, (long)GlobalClientMetrics.GLOBAL_MUTATION_BATCH_FAILED_COUNT.getMetric().getValue());
        Assert.assertEquals((long)0L, (long)GlobalClientMetrics.GLOBAL_MUTATION_INDEX_COMMIT_FAILURE_COUNT.getMetric().getValue());
        Assert.assertTrue((GlobalClientMetrics.GLOBAL_SCAN_BYTES.getMetric().getValue() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((GlobalClientMetrics.GLOBAL_QUERY_TIME.getMetric().getValue() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((GlobalClientMetrics.GLOBAL_TASK_END_TO_END_TIME.getMetric().getValue() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((GlobalClientMetrics.GLOBAL_TASK_EXECUTION_TIME.getMetric().getValue() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((GlobalClientMetrics.GLOBAL_HBASE_COUNT_RPC_CALLS.getMetric().getValue() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((GlobalClientMetrics.GLOBAL_HBASE_COUNT_MILLS_BETWEEN_NEXTS.getMetric().getValue() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((GlobalClientMetrics.GLOBAL_HBASE_COUNT_BYTES_REGION_SERVER_RESULTS.getMetric().getValue() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((GlobalClientMetrics.GLOBAL_HBASE_COUNT_SCANNED_REGIONS.getMetric().getValue() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.verifyMetricsFromSink());
    }

    @Test
    public void testGlobalPhoenixMetricsForMutations() throws Exception {
        String tableName = PhoenixMetricsIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(PhoenixMetricsIT.getUrl());){
            PhoenixMetricsIT.createTableAndInsertValues(tableName, true, false, 10, true, conn, false);
        }
        Assert.assertEquals((long)10L, (long)GlobalClientMetrics.GLOBAL_MUTATION_BATCH_SIZE.getMetric().getValue());
        Assert.assertEquals((long)10L, (long)GlobalClientMetrics.GLOBAL_MUTATION_SQL_COUNTER.getMetric().getValue());
        Assert.assertTrue((GlobalClientMetrics.GLOBAL_MUTATION_BYTES.getMetric().getValue() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((GlobalClientMetrics.GLOBAL_MUTATION_COMMIT_TIME.getMetric().getValue() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)GlobalClientMetrics.GLOBAL_NUM_PARALLEL_SCANS.getMetric().getValue());
        Assert.assertEquals((long)0L, (long)GlobalClientMetrics.GLOBAL_SELECT_SQL_COUNTER.getMetric().getValue());
        Assert.assertEquals((long)0L, (long)GlobalClientMetrics.GLOBAL_REJECTED_TASK_COUNTER.getMetric().getValue());
        Assert.assertEquals((long)0L, (long)GlobalClientMetrics.GLOBAL_QUERY_TIMEOUT_COUNTER.getMetric().getValue());
        Assert.assertEquals((long)0L, (long)GlobalClientMetrics.GLOBAL_FAILED_QUERY_COUNTER.getMetric().getValue());
        Assert.assertEquals((long)0L, (long)GlobalClientMetrics.GLOBAL_SPOOL_FILE_COUNTER.getMetric().getValue());
        Assert.assertEquals((long)0L, (long)GlobalClientMetrics.GLOBAL_MUTATION_BATCH_FAILED_COUNT.getMetric().getValue());
        Assert.assertEquals((long)0L, (long)GlobalClientMetrics.GLOBAL_MUTATION_INDEX_COMMIT_FAILURE_COUNT.getMetric().getValue());
        Assert.assertTrue((boolean)this.verifyMetricsFromSink());
    }

    @Test
    public void testGlobalPhoenixMetricsForUpsertSelect() throws Exception {
        String tableFrom = PhoenixMetricsIT.generateUniqueName();
        String tableTo = PhoenixMetricsIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(PhoenixMetricsIT.getUrl());){
            PhoenixMetricsIT.createTableAndInsertValues(tableFrom, true, false, 10, true, conn, false);
        }
        PhoenixMetricsIT.resetGlobalMetrics();
        String ddl = String.format(DDL, tableTo);
        try (Connection conn = DriverManager.getConnection(PhoenixMetricsIT.getUrl());
             Statement stmt = conn.createStatement();){
            stmt.execute(ddl);
            PhoenixMetricsIT.resetGlobalMetrics();
            stmt.executeUpdate(String.format(UPSERT_SELECT_DML, tableTo, tableFrom));
            conn.commit();
        }
        Assert.assertEquals((long)10L, (long)GlobalClientMetrics.GLOBAL_MUTATION_BATCH_SIZE.getMetric().getValue());
        Assert.assertEquals((long)1L, (long)GlobalClientMetrics.GLOBAL_MUTATION_SQL_COUNTER.getMetric().getValue());
        Assert.assertEquals((long)1L, (long)GlobalClientMetrics.GLOBAL_NUM_PARALLEL_SCANS.getMetric().getValue());
        Assert.assertEquals((long)0L, (long)GlobalClientMetrics.GLOBAL_QUERY_TIME.getMetric().getValue());
        Assert.assertTrue((GlobalClientMetrics.GLOBAL_SCAN_BYTES.getMetric().getValue() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((GlobalClientMetrics.GLOBAL_MUTATION_BYTES.getMetric().getValue() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((GlobalClientMetrics.GLOBAL_MUTATION_COMMIT_TIME.getMetric().getValue() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)GlobalClientMetrics.GLOBAL_SELECT_SQL_COUNTER.getMetric().getValue());
        Assert.assertEquals((long)0L, (long)GlobalClientMetrics.GLOBAL_REJECTED_TASK_COUNTER.getMetric().getValue());
        Assert.assertEquals((long)0L, (long)GlobalClientMetrics.GLOBAL_QUERY_TIMEOUT_COUNTER.getMetric().getValue());
        Assert.assertEquals((long)0L, (long)GlobalClientMetrics.GLOBAL_FAILED_QUERY_COUNTER.getMetric().getValue());
        Assert.assertEquals((long)0L, (long)GlobalClientMetrics.GLOBAL_SPOOL_FILE_COUNTER.getMetric().getValue());
        Assert.assertEquals((long)0L, (long)GlobalClientMetrics.GLOBAL_MUTATION_BATCH_FAILED_COUNT.getMetric().getValue());
        Assert.assertEquals((long)0L, (long)GlobalClientMetrics.GLOBAL_MUTATION_INDEX_COMMIT_FAILURE_COUNT.getMetric().getValue());
        Assert.assertTrue((GlobalClientMetrics.GLOBAL_HBASE_COUNT_RPC_CALLS.getMetric().getValue() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((GlobalClientMetrics.GLOBAL_HBASE_COUNT_MILLS_BETWEEN_NEXTS.getMetric().getValue() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((GlobalClientMetrics.GLOBAL_HBASE_COUNT_BYTES_REGION_SERVER_RESULTS.getMetric().getValue() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((GlobalClientMetrics.GLOBAL_HBASE_COUNT_SCANNED_REGIONS.getMetric().getValue() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.verifyMetricsFromSink());
    }

    static void resetGlobalMetrics() {
        for (GlobalMetric m : PhoenixRuntime.getGlobalPhoenixClientMetrics()) {
            m.reset();
        }
    }

    private boolean verifyMetricsFromSink() {
        HashMap<String, Long> expectedMetrics = new HashMap<String, Long>();
        for (GlobalMetric m : PhoenixRuntime.getGlobalPhoenixClientMetrics()) {
            expectedMetrics.put(m.getMetricType().name(), m.getValue());
        }
        for (int i = 0; i < 5; ++i) {
            LOGGER.info("Verifying Global Metrics from Hadoop Sink, Retry: " + (i + 1));
            if (this.verifyMetricsFromSinkOnce(expectedMetrics)) {
                LOGGER.info("Values from Hadoop Metrics Sink match actual values");
                return true;
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean verifyMetricsFromSinkOnce(Map<String, Long> expectedMetrics) {
        Object object = GlobalPhoenixMetricsTestSink.lock;
        synchronized (object) {
            for (AbstractMetric metric : GlobalPhoenixMetricsTestSink.metrics) {
                long actualValue;
                Long value;
                if (!expectedMetrics.containsKey(metric.name()) || (value = expectedMetrics.get(metric.name())) == null) continue;
                long expectedValue = value;
                if (expectedValue != (actualValue = metric.value().longValue())) {
                    LOGGER.warn("Metric from Hadoop Sink: " + metric.name() + " didn't match expected.");
                    return false;
                }
                expectedMetrics.remove(metric.name());
            }
        }
        Assert.assertEquals((String)"Metric expected but not present in Hadoop Metrics Sink (GlobalPhoenixMetricsTestSink)", (long)0L, (long)expectedMetrics.size());
        return true;
    }

    static void createTableAndInsertValues(String tableName, boolean resetGlobalMetricsAfterTableCreate, boolean resetTableMetricsAfterTableCreate, int numRows, boolean commit, Connection conn, boolean batchUpserts) throws SQLException {
        try (Statement stmt = conn.createStatement();){
            stmt.execute(String.format(DDL, tableName));
        }
        conn.commit();
        if (resetGlobalMetricsAfterTableCreate) {
            PhoenixMetricsIT.resetGlobalMetrics();
        }
        if (resetTableMetricsAfterTableCreate) {
            PhoenixRuntime.clearTableLevelMetrics();
        }
        stmt = conn.prepareStatement(String.format(UPSERT_VALUES_DML, tableName));
        var8_8 = null;
        try {
            for (int i = 1; i <= numRows; ++i) {
                stmt.setString(1, "keyA" + i);
                stmt.setString(2, "keyB" + i);
                stmt.setString(3, "keyC" + i);
                stmt.setString(4, "keyD" + i);
                stmt.setBoolean(6, false);
                if (i % 2 == 0) {
                    stmt.setInt(5, i);
                    stmt.setDate(7, new Date(System.currentTimeMillis()));
                } else {
                    stmt.setNull(5, 4);
                    stmt.setNull(7, 91);
                }
                if (batchUpserts) {
                    stmt.addBatch();
                    if (i % 3 != 0) continue;
                    stmt.executeBatch();
                    continue;
                }
                stmt.executeUpdate();
            }
            if (batchUpserts) {
                stmt.executeBatch();
            }
            if (commit) {
                conn.commit();
            }
        }
        catch (Throwable throwable) {
            var8_8 = throwable;
            throw throwable;
        }
        finally {
            if (stmt != null) {
                if (var8_8 != null) {
                    try {
                        stmt.close();
                    }
                    catch (Throwable throwable) {
                        var8_8.addSuppressed(throwable);
                    }
                } else {
                    stmt.close();
                }
            }
        }
    }

    static void createTableAndRunUpsertSelect(String destTableName, String sourceTableName, boolean resetGlobalMetricsAfterTableCreate, boolean resetTableMetricsAfterTableCreate, boolean commit, Connection conn) throws SQLException {
        try (Statement stmt = conn.createStatement();){
            stmt.execute(String.format(DDL, destTableName));
        }
        conn.commit();
        if (resetGlobalMetricsAfterTableCreate) {
            PhoenixMetricsIT.resetGlobalMetrics();
        }
        if (resetTableMetricsAfterTableCreate) {
            PhoenixRuntime.clearTableLevelMetrics();
        }
        stmt = conn.createStatement();
        var7_7 = null;
        try {
            stmt.executeUpdate(String.format(UPSERT_SELECT_DML, destTableName, sourceTableName));
        }
        catch (Throwable throwable) {
            var7_7 = throwable;
            throw throwable;
        }
        finally {
            if (stmt != null) {
                if (var7_7 != null) {
                    try {
                        stmt.close();
                    }
                    catch (Throwable throwable) {
                        var7_7.addSuppressed(throwable);
                    }
                } else {
                    stmt.close();
                }
            }
        }
        if (commit) {
            conn.commit();
        }
    }

    static void doPointDeleteFromTable(String tableName, Connection conn) throws SQLException {
        try (PreparedStatement stmt = conn.prepareStatement(String.format(POINT_DELETE_DML, tableName));){
            stmt.setString(1, "keyA1");
            stmt.setString(2, "keyB1");
            stmt.setString(3, "keyC1");
            stmt.setString(4, "keyD1");
            stmt.executeUpdate();
        }
    }

    static void doDeleteAllFromTable(String tableName, Connection conn) throws SQLException {
        try (Statement stmt = conn.createStatement();){
            stmt.executeUpdate(String.format(DELETE_ALL_DML, tableName));
        }
    }

    @Test
    public void testOverallQueryMetricsForSelect() throws Exception {
        String tableName = PhoenixMetricsIT.generateUniqueName();
        String ddl = "CREATE TABLE " + tableName + " (K VARCHAR NOT NULL PRIMARY KEY, V VARCHAR) SALT_BUCKETS = 6";
        Connection conn = DriverManager.getConnection(PhoenixMetricsIT.getUrl());
        conn.createStatement().execute(ddl);
    }

    @Test
    public void testMetricsLargeQuery() throws Exception {
        String tableName = "MY_TABLE";
        String ddl = "CREATE TABLE " + tableName + " (K VARCHAR NOT NULL PRIMARY KEY, V VARCHAR)";
        Connection conn = DriverManager.getConnection(PhoenixMetricsIT.getUrl());
        conn.createStatement().execute(ddl);
        long numRows = 18750L;
        this.insertRowsInTable(tableName, numRows);
        String query = "SELECT * FROM " + tableName;
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery(query);
        while (rs.next()) {
        }
        rs.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetricsForSelectFetchResultsTimeout() throws SQLException {
        String tableName = PhoenixMetricsIT.generateUniqueName();
        int queryTimeout = 10;
        try (Connection conn = DriverManager.getConnection(PhoenixMetricsIT.getUrl());
             Statement stmt = conn.createStatement();){
            PhoenixMetricsIT.createTableAndInsertValues(tableName, true, true, 10, true, conn, false);
            stmt.setQueryTimeout(10);
            ResultSet rs = stmt.executeQuery(String.format("SELECT * FROM %s", tableName));
            MyClock clock = new MyClock(10L, 20000L);
            EnvironmentEdgeManager.injectEdge((EnvironmentEdge)clock);
            try {
                rs.next();
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.OPERATION_TIMED_OUT.getErrorCode(), (long)e.getErrorCode());
            }
            Map overallReadMetrics = PhoenixRuntime.getOverAllReadRequestMetricInfo((ResultSet)rs);
            Assert.assertEquals((long)1L, (long)((Long)overallReadMetrics.get(MetricType.QUERY_TIMEOUT_COUNTER)));
            Assert.assertEquals((long)1L, (long)GlobalClientMetrics.GLOBAL_QUERY_TIMEOUT_COUNTER.getMetric().getValue());
        }
        finally {
            EnvironmentEdgeManager.reset();
        }
    }

    @Test
    public void testReadMetricsForSelect() throws Exception {
        String tableName = PhoenixMetricsIT.generateUniqueName();
        long numSaltBuckets = 6L;
        String ddl = "CREATE TABLE " + tableName + " (K VARCHAR NOT NULL PRIMARY KEY, V VARCHAR) SALT_BUCKETS = " + numSaltBuckets;
        Connection conn = DriverManager.getConnection(PhoenixMetricsIT.getUrl());
        conn.createStatement().execute(ddl);
        long numRows = 1000L;
        long numExpectedTasks = numSaltBuckets;
        this.insertRowsInTable(tableName, numRows);
        String query = "SELECT * FROM " + tableName;
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery(query);
        PhoenixResultSet resultSetBeingTested = rs.unwrap(PhoenixResultSet.class);
        this.changeInternalStateForTesting(resultSetBeingTested);
        while (resultSetBeingTested.next()) {
        }
        resultSetBeingTested.close();
        HashSet expectedTableNames = Sets.newHashSet((Object[])new String[]{tableName});
        this.assertReadMetricValuesForSelectSql(Lists.newArrayList((Object[])new Long[]{numRows}), Lists.newArrayList((Object[])new Long[]{numExpectedTasks}), resultSetBeingTested, expectedTableNames);
    }

    @Test
    public void testExecuteQuerySubMetricsForSelect() throws Exception {
        String tableName = PhoenixMetricsIT.generateUniqueName();
        String index1Name = PhoenixMetricsIT.generateUniqueName() + "_IDX1";
        String index2Name = PhoenixMetricsIT.generateUniqueName() + "_IDX2";
        String index3Name = PhoenixMetricsIT.generateUniqueName() + "_IDX3";
        long numSaltBuckets = 50L;
        try (Connection conn = DriverManager.getConnection(PhoenixMetricsIT.getUrl());){
            String ddl = "CREATE TABLE " + tableName + " (ID INTEGER NOT NULL PRIMARY KEY, CATEGORY VARCHAR(50), PRICE DECIMAL(12,2), QUANTITY INTEGER) SALT_BUCKETS = " + numSaltBuckets;
            conn.createStatement().execute(ddl);
            String idx1 = "CREATE INDEX " + index1Name + " ON " + tableName + " (CATEGORY, PRICE)";
            String idx2 = "CREATE INDEX " + index2Name + " ON " + tableName + " (PRICE, QUANTITY)";
            String idx3 = "CREATE INDEX " + index3Name + " ON " + tableName + " (QUANTITY, CATEGORY)";
            conn.createStatement().execute(idx1);
            conn.createStatement().execute(idx2);
            conn.createStatement().execute(idx3);
            PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?, ?, ?, ?)");
            String[] categories = new String[]{"A", "B", "C", "D", "E"};
            for (int i = 1; i <= 2000; ++i) {
                stmt.setInt(1, i);
                stmt.setString(2, categories[i % categories.length]);
                stmt.setBigDecimal(3, new BigDecimal(i / 23));
                stmt.setInt(4, i % 200 + 1);
                stmt.executeUpdate();
            }
            conn.commit();
            String selectQuery = "SELECT   CATEGORY,   COUNT(*) as total_count,   AVG(PRICE) as avg_price,   SUM(QUANTITY) as total_quantity FROM " + tableName + " WHERE   CATEGORY IN (?, ?, ?, ?, ?) GROUP BY CATEGORY ORDER BY   SUM(PRICE * QUANTITY) DESC";
            PreparedStatement queryStmt = conn.prepareStatement(selectQuery);
            queryStmt.setString(1, "A");
            queryStmt.setString(2, "B");
            queryStmt.setString(3, "C");
            queryStmt.setString(4, "D");
            queryStmt.setString(5, "E");
            ResultSet rs = queryStmt.executeQuery();
            PhoenixResultSet phoenixResultSet = rs.unwrap(PhoenixResultSet.class);
            Map overallReadMetrics = PhoenixRuntime.getOverAllReadRequestMetricInfo((ResultSet)rs);
            Assert.assertTrue((String)"Query compiler time should have been greater than zero", ((Long)overallReadMetrics.get(MetricType.QUERY_COMPILER_TIME_MS) > 0L ? 1 : 0) != 0);
            Assert.assertTrue((String)"Query optimizer time should have been greater than zero", ((Long)overallReadMetrics.get(MetricType.QUERY_OPTIMIZER_TIME_MS) > 0L ? 1 : 0) != 0);
            Assert.assertTrue((String)"Query Result Itr time should have been greater than zero", ((Long)overallReadMetrics.get(MetricType.QUERY_RESULT_ITR_TIME_MS) > 0L ? 1 : 0) != 0);
        }
    }

    @Test
    public void testMetricsForUpsert() throws Exception {
        String tableName = PhoenixMetricsIT.generateUniqueName();
        String ddl = "CREATE TABLE " + tableName + " (K VARCHAR NOT NULL PRIMARY KEY, V VARCHAR) SALT_BUCKETS = 6";
        Connection ddlConn = DriverManager.getConnection(PhoenixMetricsIT.getUrl());
        ddlConn.createStatement().execute(ddl);
        ddlConn.close();
        int numRows = 10;
        Connection conn = this.insertRowsInTable(tableName, numRows);
        PhoenixConnection pConn = conn.unwrap(PhoenixConnection.class);
        Map mutationMetrics = PhoenixRuntime.getWriteMetricInfoForMutationsSinceLastReset((Connection)pConn);
        for (Map.Entry entry : mutationMetrics.entrySet()) {
            String t = (String)entry.getKey();
            Assert.assertEquals((String)"Table names didn't match!", (Object)tableName, (Object)t);
            Map p = (Map)entry.getValue();
            Assert.assertEquals((String)"There should have been eighteen metrics", (long)18L, (long)p.size());
            boolean mutationBatchSizePresent = false;
            boolean mutationCommitTimePresent = false;
            boolean mutationBytesPresent = false;
            boolean mutationBatchFailedPresent = false;
            boolean mutationBatchCounterPresent = false;
            for (Map.Entry metric : p.entrySet()) {
                MetricType metricType = (MetricType)metric.getKey();
                long metricValue = (Long)metric.getValue();
                if (metricType.equals((Object)MetricType.MUTATION_BATCH_SIZE)) {
                    Assert.assertEquals((String)"Mutation batch sizes didn't match!", (long)numRows, (long)metricValue);
                    mutationBatchSizePresent = true;
                    continue;
                }
                if (metricType.equals((Object)MetricType.MUTATION_COMMIT_TIME)) {
                    Assert.assertTrue((String)"Mutation commit time should be greater than zero", (metricValue > 0L ? 1 : 0) != 0);
                    mutationCommitTimePresent = true;
                    continue;
                }
                if (metricType.equals((Object)MetricType.MUTATION_BYTES)) {
                    Assert.assertTrue((String)"Mutation bytes size should be greater than zero", (metricValue > 0L ? 1 : 0) != 0);
                    mutationBytesPresent = true;
                    continue;
                }
                if (metricType.equals((Object)MetricType.MUTATION_BATCH_FAILED_SIZE)) {
                    Assert.assertEquals((String)"Zero failed mutations expected", (long)0L, (long)metricValue);
                    mutationBatchFailedPresent = true;
                    continue;
                }
                if (!metricType.equals((Object)MetricType.MUTATION_BATCH_COUNTER)) continue;
                Assert.assertEquals((String)"Mutation batch success count should be greater than zero", (long)1L, (long)metricValue);
                mutationBatchCounterPresent = true;
            }
            Assert.assertTrue((boolean)mutationBatchSizePresent);
            Assert.assertTrue((boolean)mutationCommitTimePresent);
            Assert.assertTrue((boolean)mutationBytesPresent);
            Assert.assertTrue((boolean)mutationBatchFailedPresent);
            Assert.assertTrue((boolean)mutationBatchCounterPresent);
        }
        Map readMetrics = PhoenixRuntime.getReadMetricInfoForMutationsSinceLastReset((Connection)pConn);
        Assert.assertEquals((String)"Read metrics should be empty", (long)0L, (long)readMetrics.size());
    }

    @Test
    public void testMetricsForUpsertSelect() throws Exception {
        String tableName1 = PhoenixMetricsIT.generateUniqueName();
        long table1SaltBuckets = 6L;
        String ddl = "CREATE TABLE " + tableName1 + " (K VARCHAR NOT NULL PRIMARY KEY, V VARCHAR) SALT_BUCKETS = " + table1SaltBuckets;
        Connection ddlConn = DriverManager.getConnection(PhoenixMetricsIT.getUrl());
        ddlConn.createStatement().execute(ddl);
        ddlConn.close();
        int numRows = 10;
        this.insertRowsInTable(tableName1, numRows);
        String tableName2 = PhoenixMetricsIT.generateUniqueName();
        ddl = "CREATE TABLE " + tableName2 + " (K VARCHAR NOT NULL PRIMARY KEY, V VARCHAR) SALT_BUCKETS = 10";
        ddlConn = DriverManager.getConnection(PhoenixMetricsIT.getUrl());
        ddlConn.createStatement().execute(ddl);
        ddlConn.close();
        Connection conn = DriverManager.getConnection(PhoenixMetricsIT.getUrl());
        String upsertSelect = "UPSERT INTO " + tableName2 + " SELECT * FROM " + tableName1;
        conn.createStatement().executeUpdate(upsertSelect);
        conn.commit();
        PhoenixConnection pConn = conn.unwrap(PhoenixConnection.class);
        Map mutationMetrics = PhoenixRuntime.getWriteMetricInfoForMutationsSinceLastReset((Connection)pConn);
        PhoenixMetricsIT.assertMutationMetrics(tableName2, numRows, true, mutationMetrics);
        Map readMetrics = PhoenixRuntime.getReadMetricInfoForMutationsSinceLastReset((Connection)pConn);
        this.assertReadMetricsForMutatingSql(tableName1, table1SaltBuckets, readMetrics);
    }

    @Test
    public void testMetricsForDelete() throws Exception {
        String tableName = PhoenixMetricsIT.generateUniqueName();
        long tableSaltBuckets = 6L;
        String ddl = "CREATE TABLE " + tableName + " (K VARCHAR NOT NULL PRIMARY KEY, V VARCHAR) SALT_BUCKETS = " + tableSaltBuckets;
        try (Connection ddlConn = DriverManager.getConnection(PhoenixMetricsIT.getUrl());){
            ddlConn.createStatement().execute(ddl);
        }
        int numRows = 10;
        this.insertRowsInTable(tableName, numRows);
        try (Connection conn = DriverManager.getConnection(PhoenixMetricsIT.getUrl());){
            String delete = "DELETE FROM " + tableName;
            conn.createStatement().execute(delete);
            conn.commit();
            Map mutationMetrics = PhoenixRuntime.getWriteMetricInfoForMutationsSinceLastReset((Connection)conn);
            PhoenixMetricsIT.assertMutationMetrics(tableName, numRows, false, mutationMetrics);
            Map readMetrics = PhoenixRuntime.getReadMetricInfoForMutationsSinceLastReset((Connection)conn);
            this.assertReadMetricsForMutatingSql(tableName, tableSaltBuckets, readMetrics);
        }
    }

    @Test
    public void testNoMetricsCollectedForConnection() throws Exception {
        String tableName = PhoenixMetricsIT.generateUniqueName();
        long tableSaltBuckets = 6L;
        String ddl = "CREATE TABLE " + tableName + " (K VARCHAR NOT NULL PRIMARY KEY, V VARCHAR) SALT_BUCKETS = " + tableSaltBuckets;
        Connection ddlConn = DriverManager.getConnection(PhoenixMetricsIT.getUrl());
        ddlConn.createStatement().execute(ddl);
        ddlConn.close();
        int numRows = 10;
        this.insertRowsInTable(tableName, numRows);
        Properties props = new Properties();
        props.setProperty("phoenix.query.request.metrics.enabled", "false");
        props.setProperty("phoenix.log.level", LogLevel.OFF.name());
        Connection conn = DriverManager.getConnection(PhoenixMetricsIT.getUrl(), props);
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + tableName);
        while (rs.next()) {
        }
        rs.close();
        Map readMetrics = PhoenixRuntime.getRequestReadMetricInfo((ResultSet)rs);
        Assert.assertTrue((String)"No read metrics should have been generated", (readMetrics.size() == 0 ? 1 : 0) != 0);
        conn.createStatement().executeUpdate("UPSERT INTO " + tableName + " VALUES ('KEY', 'VALUE')");
        conn.commit();
        Map writeMetrics = PhoenixRuntime.getWriteMetricInfoForMutationsSinceLastReset((Connection)conn);
        Assert.assertTrue((String)"No write metrics should have been generated", (writeMetrics.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testMetricsForUpsertWithAutoCommit() throws Exception {
        String tableName = PhoenixMetricsIT.generateUniqueName();
        long tableSaltBuckets = 6L;
        String ddl = "CREATE TABLE " + tableName + " (K VARCHAR NOT NULL PRIMARY KEY, V VARCHAR) SALT_BUCKETS = " + tableSaltBuckets;
        try (Connection ddlConn = DriverManager.getConnection(PhoenixMetricsIT.getUrl());){
            ddlConn.createStatement().execute(ddl);
        }
        String upsert = "UPSERT INTO " + tableName + " VALUES (?, ?)";
        int numRows = 10;
        Map mutationMetricsForAutoCommitOff = null;
        try (Connection conn = DriverManager.getConnection(PhoenixMetricsIT.getUrl());){
            conn.setAutoCommit(false);
            this.upsertRows(upsert, numRows, conn);
            conn.commit();
            mutationMetricsForAutoCommitOff = PhoenixRuntime.getWriteMetricInfoForMutationsSinceLastReset((Connection)conn);
        }
        Map mutationMetricsAutoCommitOn = null;
        try (Connection conn = DriverManager.getConnection(PhoenixMetricsIT.getUrl());){
            conn.setAutoCommit(true);
            this.upsertRows(upsert, numRows, conn);
            mutationMetricsAutoCommitOn = PhoenixRuntime.getWriteMetricInfoForMutationsSinceLastReset((Connection)conn);
        }
        this.assertMetricsAreSame(mutationMetricsForAutoCommitOff, mutationMetricsAutoCommitOn, mutationMetricsToSkip);
    }

    private void upsertRows(String upsert, int numRows, Connection conn) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(upsert);
        for (int i = 1; i <= numRows; ++i) {
            stmt.setString(1, "key" + i);
            stmt.setString(2, "value" + i);
            stmt.executeUpdate();
        }
    }

    @Test
    public void testMetricsForDeleteWithAutoCommit() throws Exception {
        String tableName = PhoenixMetricsIT.generateUniqueName();
        long tableSaltBuckets = 6L;
        String ddl = "CREATE TABLE " + tableName + " (K VARCHAR NOT NULL PRIMARY KEY, V VARCHAR) SALT_BUCKETS = " + tableSaltBuckets;
        try (Connection ddlConn = DriverManager.getConnection(PhoenixMetricsIT.getUrl());){
            ddlConn.createStatement().execute(ddl);
        }
        String upsert = "UPSERT INTO " + tableName + " VALUES (?, ?)";
        int numRows = 10;
        try (Connection conn = DriverManager.getConnection(PhoenixMetricsIT.getUrl());){
            conn.setAutoCommit(false);
            this.upsertRows(upsert, numRows, conn);
            conn.commit();
        }
        String delete = "DELETE FROM " + tableName;
        Map deleteMetricsWithAutoCommitOff = null;
        try (Connection conn = DriverManager.getConnection(PhoenixMetricsIT.getUrl());){
            conn.setAutoCommit(false);
            conn.createStatement().executeUpdate(delete);
            deleteMetricsWithAutoCommitOff = PhoenixRuntime.getWriteMetricInfoForMutationsSinceLastReset((Connection)conn);
        }
        conn = DriverManager.getConnection(PhoenixMetricsIT.getUrl());
        var10_17 = null;
        try {
            conn.setAutoCommit(false);
            this.upsertRows(upsert, numRows, conn);
            conn.commit();
        }
        catch (Throwable throwable) {
            var10_17 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var10_17 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var10_17.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
        Map deleteMetricsWithAutoCommitOn = null;
        try (Connection conn = DriverManager.getConnection(PhoenixMetricsIT.getUrl());){
            conn.setAutoCommit(true);
            conn.createStatement().executeUpdate(delete);
            deleteMetricsWithAutoCommitOn = PhoenixRuntime.getWriteMetricInfoForMutationsSinceLastReset((Connection)conn);
        }
        this.assertMetricsAreSame(deleteMetricsWithAutoCommitOff, deleteMetricsWithAutoCommitOn, mutationMetricsToSkip);
    }

    @Test
    public void testMetricsForUpsertSelectWithAutoCommit() throws Exception {
        PhoenixConnection pConn;
        String tableName1 = PhoenixMetricsIT.generateUniqueName();
        long table1SaltBuckets = 6L;
        String ddl = "CREATE TABLE " + tableName1 + " (K BIGINT NOT NULL PRIMARY KEY ROW_TIMESTAMP, V VARCHAR) SALT_BUCKETS = " + table1SaltBuckets + ", IMMUTABLE_ROWS = true";
        Connection ddlConn = DriverManager.getConnection(PhoenixMetricsIT.getUrl());
        ddlConn.createStatement().execute(ddl);
        ddlConn.close();
        int numRows = 10;
        String dml = "UPSERT INTO " + tableName1 + " VALUES (?, ?)";
        try (Connection conn = DriverManager.getConnection(PhoenixMetricsIT.getUrl());){
            PreparedStatement stmt = conn.prepareStatement(dml);
            for (int i = 1; i <= numRows; ++i) {
                stmt.setLong(1, i);
                stmt.setString(2, "value" + i);
                stmt.executeUpdate();
            }
            conn.commit();
        }
        String tableName2 = PhoenixMetricsIT.generateUniqueName();
        ddl = "CREATE TABLE " + tableName2 + " (K BIGINT NOT NULL PRIMARY KEY ROW_TIMESTAMP, V VARCHAR) SALT_BUCKETS = 10, IMMUTABLE_ROWS = true";
        ddlConn = DriverManager.getConnection(PhoenixMetricsIT.getUrl());
        ddlConn.createStatement().execute(ddl);
        String indexName = PhoenixMetricsIT.generateUniqueName();
        ddl = "CREATE INDEX " + indexName + " ON " + tableName2 + " (V)";
        ddlConn.createStatement().execute(ddl);
        ddlConn.close();
        String upsertSelect = "UPSERT INTO " + tableName2 + " SELECT * FROM " + tableName1;
        Map mutationMetricsAutoCommitOff = null;
        Map readMetricsAutoCommitOff = null;
        try (Connection conn = DriverManager.getConnection(PhoenixMetricsIT.getUrl());){
            conn.setAutoCommit(false);
            conn.createStatement().executeUpdate(upsertSelect);
            conn.commit();
            PhoenixConnection pConn2 = conn.unwrap(PhoenixConnection.class);
            mutationMetricsAutoCommitOff = PhoenixRuntime.getWriteMetricInfoForMutationsSinceLastReset((Connection)pConn2);
            readMetricsAutoCommitOff = PhoenixRuntime.getReadMetricInfoForMutationsSinceLastReset((Connection)pConn2);
        }
        Map mutationMetricsAutoCommitOn = null;
        Map readMetricsAutoCommitOn = null;
        int autoCommitBatchSize = numRows + 1;
        Properties props = new Properties();
        props.setProperty("UpsertBatchSize", Integer.toString(autoCommitBatchSize));
        try (Connection conn = DriverManager.getConnection(PhoenixMetricsIT.getUrl(), props);){
            conn.setAutoCommit(true);
            conn.createStatement().executeUpdate(upsertSelect);
            pConn = conn.unwrap(PhoenixConnection.class);
            mutationMetricsAutoCommitOn = PhoenixRuntime.getWriteMetricInfoForMutationsSinceLastReset((Connection)pConn);
            readMetricsAutoCommitOn = PhoenixRuntime.getReadMetricInfoForMutationsSinceLastReset((Connection)pConn);
        }
        this.assertMetricsAreSame(mutationMetricsAutoCommitOff, mutationMetricsAutoCommitOn, mutationMetricsToSkip);
        this.assertMetricsAreSame(readMetricsAutoCommitOff, readMetricsAutoCommitOn, readMetricsToSkip);
        autoCommitBatchSize = numRows - 1;
        props = new Properties();
        props.setProperty("UpsertBatchSize", Integer.toString(autoCommitBatchSize));
        conn = DriverManager.getConnection(PhoenixMetricsIT.getUrl(), props);
        var18_27 = null;
        try {
            conn.setAutoCommit(true);
            conn.createStatement().executeUpdate(upsertSelect);
            pConn = conn.unwrap(PhoenixConnection.class);
            mutationMetricsAutoCommitOn = PhoenixRuntime.getWriteMetricInfoForMutationsSinceLastReset((Connection)pConn);
            readMetricsAutoCommitOn = PhoenixRuntime.getReadMetricInfoForMutationsSinceLastReset((Connection)pConn);
        }
        catch (Throwable pConn3) {
            var18_27 = pConn3;
            throw pConn3;
        }
        finally {
            if (conn != null) {
                if (var18_27 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable pConn3) {
                        var18_27.addSuppressed(pConn3);
                    }
                } else {
                    conn.close();
                }
            }
        }
        this.assertMetricsAreSame(mutationMetricsAutoCommitOff, mutationMetricsAutoCommitOn, mutationMetricsToSkip);
        this.assertMetricsAreSame(readMetricsAutoCommitOff, readMetricsAutoCommitOn, readMetricsToSkip);
        autoCommitBatchSize = numRows;
        props = new Properties();
        props.setProperty("UpsertBatchSize", Integer.toString(autoCommitBatchSize));
        conn = DriverManager.getConnection(PhoenixMetricsIT.getUrl(), props);
        var18_27 = null;
        try {
            conn.setAutoCommit(true);
            conn.createStatement().executeUpdate(upsertSelect);
            pConn = conn.unwrap(PhoenixConnection.class);
            mutationMetricsAutoCommitOn = PhoenixRuntime.getWriteMetricInfoForMutationsSinceLastReset((Connection)pConn);
            readMetricsAutoCommitOn = PhoenixRuntime.getReadMetricInfoForMutationsSinceLastReset((Connection)pConn);
        }
        catch (Throwable pConn4) {
            var18_27 = pConn4;
            throw pConn4;
        }
        finally {
            if (conn != null) {
                if (var18_27 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable pConn4) {
                        var18_27.addSuppressed(pConn4);
                    }
                } else {
                    conn.close();
                }
            }
        }
        this.assertMetricsAreSame(mutationMetricsAutoCommitOff, mutationMetricsAutoCommitOn, mutationMetricsToSkip);
        this.assertMetricsAreSame(readMetricsAutoCommitOff, readMetricsAutoCommitOn, readMetricsToSkip);
        autoCommitBatchSize = 2;
        props = new Properties();
        props.setProperty("UpsertBatchSize", Integer.toString(autoCommitBatchSize));
        conn = DriverManager.getConnection(PhoenixMetricsIT.getUrl(), props);
        var18_27 = null;
        try {
            conn.setAutoCommit(true);
            conn.createStatement().executeUpdate(upsertSelect);
            pConn = conn.unwrap(PhoenixConnection.class);
            mutationMetricsAutoCommitOn = PhoenixRuntime.getWriteMetricInfoForMutationsSinceLastReset((Connection)pConn);
            readMetricsAutoCommitOn = PhoenixRuntime.getReadMetricInfoForMutationsSinceLastReset((Connection)pConn);
        }
        catch (Throwable throwable) {
            var18_27 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var18_27 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var18_27.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
        this.assertMetricsAreSame(mutationMetricsAutoCommitOff, mutationMetricsAutoCommitOn, mutationMetricsToSkip);
        this.assertMetricsAreSame(readMetricsAutoCommitOff, readMetricsAutoCommitOff, readMetricsToSkip);
    }

    @Test
    public void testMutationMetricsWhenUpsertingToMultipleTables() throws Exception {
        try (Connection conn = DriverManager.getConnection(PhoenixMetricsIT.getUrl());){
            String table1 = PhoenixMetricsIT.generateUniqueName();
            PhoenixMetricsIT.createTableAndInsertValues(table1, false, false, 10, true, conn, false);
            String table2 = PhoenixMetricsIT.generateUniqueName();
            PhoenixMetricsIT.createTableAndInsertValues(table2, false, false, 10, true, conn, false);
            String table3 = PhoenixMetricsIT.generateUniqueName();
            PhoenixMetricsIT.createTableAndInsertValues(table3, false, false, 10, true, conn, false);
            Map mutationMetrics = PhoenixRuntime.getWriteMetricInfoForMutationsSinceLastReset((Connection)conn);
            Assert.assertTrue((String)("Mutation metrics not present for " + table1), (mutationMetrics.get(table1) != null ? 1 : 0) != 0);
            Assert.assertTrue((String)("Mutation metrics not present for " + table2), (mutationMetrics.get(table2) != null ? 1 : 0) != 0);
            Assert.assertTrue((String)("Mutation metrics not present for " + table3), (mutationMetrics.get(table3) != null ? 1 : 0) != 0);
            this.assertMetricsHaveSameValues((Map)mutationMetrics.get(table1), (Map)mutationMetrics.get(table2), mutationMetricsToSkip);
            this.assertMetricsHaveSameValues((Map)mutationMetrics.get(table1), (Map)mutationMetrics.get(table3), mutationMetricsToSkip);
        }
    }

    @Test
    public void createViewWithWhereConditionNoConnLeak() throws SQLException {
        PhoenixMetricsIT.resetGlobalMetrics();
        String tableName = PhoenixMetricsIT.generateUniqueName();
        String viewName = PhoenixMetricsIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(PhoenixMetricsIT.getUrl());){
            conn.createStatement().execute("CREATE TABLE " + tableName + " (K INTEGER PRIMARY KEY, V VARCHAR(10))");
            conn.createStatement().execute("CREATE VIEW " + viewName + " AS SELECT * FROM " + tableName + " WHERE K = 1");
        }
        Assert.assertTrue((boolean)PhoenixRuntime.areGlobalClientMetricsBeingCollected());
        Assert.assertEquals((long)0L, (long)GlobalClientMetrics.GLOBAL_OPEN_PHOENIX_CONNECTIONS.getMetric().getValue());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void testClosingConnectionClearsMetrics() throws Exception {
        Connection conn = null;
        try {
            conn = DriverManager.getConnection(PhoenixMetricsIT.getUrl());
            PhoenixMetricsIT.createTableAndInsertValues(PhoenixMetricsIT.generateUniqueName(), false, false, 10, true, conn, false);
            Assert.assertTrue((String)"Mutation metrics not present", (PhoenixRuntime.getWriteMetricInfoForMutationsSinceLastReset((Connection)conn).size() > 0 ? 1 : 0) != 0);
            if (conn == null) return;
        }
        catch (Throwable throwable) {
            if (conn == null) throw throwable;
            conn.close();
            Assert.assertTrue((String)"Closing connection didn't clear metrics", (PhoenixRuntime.getWriteMetricInfoForMutationsSinceLastReset((Connection)conn).size() == 0 ? 1 : 0) != 0);
            throw throwable;
        }
        conn.close();
        Assert.assertTrue((String)"Closing connection didn't clear metrics", (PhoenixRuntime.getWriteMetricInfoForMutationsSinceLastReset((Connection)conn).size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testMetricsForUpsertingIntoImmutableTableWithIndices() throws Exception {
        String dataTable = PhoenixMetricsIT.generateUniqueName();
        String tableDdl = "CREATE TABLE " + dataTable + " (K1 VARCHAR NOT NULL, K2 VARCHAR NOT NULL, V1 INTEGER, V2 INTEGER, V3 INTEGER CONSTRAINT NAME_PK PRIMARY KEY(K1, K2)) IMMUTABLE_ROWS = true";
        String index1 = PhoenixMetricsIT.generateUniqueName() + "_IDX";
        String index1Ddl = "CREATE INDEX " + index1 + " ON " + dataTable + " (V1) include (V2)";
        String index2 = PhoenixMetricsIT.generateUniqueName() + "_IDX";
        String index2Ddl = "CREATE INDEX " + index2 + " ON " + dataTable + " (V2) include (V3)";
        String index3 = PhoenixMetricsIT.generateUniqueName() + "_IDX";
        String index3Ddl = "CREATE INDEX " + index3 + " ON " + dataTable + " (V3) include (V1)";
        try (Connection conn = DriverManager.getConnection(PhoenixMetricsIT.getUrl());){
            conn.createStatement().execute(tableDdl);
            conn.createStatement().execute(index1Ddl);
            conn.createStatement().execute(index2Ddl);
            conn.createStatement().execute(index3Ddl);
        }
        String upsert = "UPSERT INTO " + dataTable + " VALUES (?, ?, ?, ?, ?)";
        try (Connection conn = DriverManager.getConnection(PhoenixMetricsIT.getUrl());){
            PreparedStatement stmt = conn.prepareStatement(upsert);
            for (int i = 1; i < 10; ++i) {
                stmt.setString(1, "key1" + i);
                stmt.setString(2, "key2" + i);
                stmt.setInt(3, i);
                stmt.setInt(4, i);
                stmt.setInt(5, i);
                stmt.executeUpdate();
            }
            conn.commit();
            Map metrics = PhoenixRuntime.getWriteMetricInfoForMutationsSinceLastReset((Connection)conn);
            Assert.assertTrue((((Map)metrics.get(dataTable)).size() > 0 ? 1 : 0) != 0);
            Assert.assertTrue((((Map)metrics.get(index1)).size() > 0 ? 1 : 0) != 0);
            Assert.assertTrue((((Map)metrics.get(index2)).size() > 0 ? 1 : 0) != 0);
            this.assertMetricsHaveSameValues((Map)metrics.get(index1), (Map)metrics.get(index2), mutationMetricsToSkip);
            Assert.assertTrue((((Map)metrics.get(index3)).size() > 0 ? 1 : 0) != 0);
            this.assertMetricsHaveSameValues((Map)metrics.get(index1), (Map)metrics.get(index3), mutationMetricsToSkip);
        }
    }

    @Test
    public void testOpenConnectionsCounter() throws Exception {
        long numOpenConnections = GlobalClientMetrics.GLOBAL_OPEN_PHOENIX_CONNECTIONS.getMetric().getValue();
        try (Connection conn = DriverManager.getConnection(PhoenixMetricsIT.getUrl());){
            Assert.assertEquals((long)(numOpenConnections + 1L), (long)GlobalClientMetrics.GLOBAL_OPEN_PHOENIX_CONNECTIONS.getMetric().getValue());
        }
        Assert.assertEquals((long)numOpenConnections, (long)GlobalClientMetrics.GLOBAL_OPEN_PHOENIX_CONNECTIONS.getMetric().getValue());
    }

    private void createTableAndInsertValues(boolean commit, int numRows, Connection conn, String tableName) throws SQLException {
        String ddl = "CREATE TABLE " + tableName + " (K VARCHAR NOT NULL PRIMARY KEY, V VARCHAR)";
        conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + tableName + " VALUES (?, ?)";
        PreparedStatement stmt = conn.prepareStatement(dml);
        for (int i = 1; i <= numRows; ++i) {
            stmt.setString(1, "key" + i);
            stmt.setString(2, "value" + i);
            stmt.executeUpdate();
        }
        if (commit) {
            conn.commit();
        }
    }

    private void assertMetricsAreSame(Map<String, Map<MetricType, Long>> metric1, Map<String, Map<MetricType, Long>> metric2, List<MetricType> metricsToSkip) {
        Assert.assertTrue((String)"The two metrics have different or unequal number of table names ", (boolean)metric1.keySet().equals(metric2.keySet()));
        for (Map.Entry<String, Map<MetricType, Long>> entry : metric1.entrySet()) {
            Map<MetricType, Long> metricNameValueMap1 = entry.getValue();
            Map<MetricType, Long> metricNameValueMap2 = metric2.get(entry.getKey());
            this.assertMetricsHaveSameValues(metricNameValueMap1, metricNameValueMap2, metricsToSkip);
        }
    }

    private void assertMetricsHaveSameValues(Map<MetricType, Long> metricNameValueMap1, Map<MetricType, Long> metricNameValueMap2, List<MetricType> metricsToSkip) {
        Assert.assertTrue((String)"The two metrics have different or unequal number of metric names ", (boolean)metricNameValueMap1.keySet().equals(metricNameValueMap2.keySet()));
        for (Map.Entry<MetricType, Long> entry : metricNameValueMap1.entrySet()) {
            MetricType metricType = entry.getKey();
            if (metricsToSkip.contains(metricType)) continue;
            Assert.assertEquals((String)("Unequal values for metric " + metricType), (Object)entry.getValue(), (Object)metricNameValueMap2.get(metricType));
        }
    }

    private void changeInternalStateForTesting(PhoenixResultSet rs) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        TestReadMetricsQueue testMetricsQueue = new TestReadMetricsQueue(LogLevel.OFF, true);
        Field rsQueueField = PhoenixResultSet.class.getDeclaredField("readMetricsQueue");
        rsQueueField.setAccessible(true);
        rsQueueField.set(rs, (Object)testMetricsQueue);
        StatementContext ctx = rs.getContext();
        Field ctxQueueField = StatementContext.class.getDeclaredField("readMetricsQueue");
        ctxQueueField.setAccessible(true);
        ctxQueueField.set(ctx, (Object)testMetricsQueue);
    }

    private void assertReadMetricValuesForSelectSql(ArrayList<Long> numRows, ArrayList<Long> numExpectedTasks, PhoenixResultSet resultSetBeingTested, Set<String> expectedTableNames) throws SQLException {
        Map metrics = PhoenixRuntime.getRequestReadMetricInfo((ResultSet)resultSetBeingTested);
        int counter = 0;
        for (Map.Entry entry : metrics.entrySet()) {
            String tableName = (String)entry.getKey();
            expectedTableNames.remove(tableName);
            Map metricValues = (Map)entry.getValue();
            boolean taskCounterMetricsPresent = false;
            boolean taskExecutionTimeMetricsPresent = false;
            boolean memoryMetricsPresent = false;
            for (Map.Entry pair : metricValues.entrySet()) {
                MetricType metricType = (MetricType)pair.getKey();
                long metricValue = (Long)pair.getValue();
                long numTask = numExpectedTasks.get(counter);
                if (metricType.equals((Object)MetricType.TASK_EXECUTED_COUNTER)) {
                    Assert.assertEquals((long)numTask, (long)metricValue);
                    taskCounterMetricsPresent = true;
                    continue;
                }
                if (metricType.equals((Object)MetricType.TASK_EXECUTION_TIME)) {
                    Assert.assertEquals((long)(numTask * 10L), (long)metricValue);
                    taskExecutionTimeMetricsPresent = true;
                    continue;
                }
                if (!metricType.equals((Object)MetricType.MEMORY_CHUNK_BYTES)) continue;
                Assert.assertEquals((long)(numTask * 100L), (long)metricValue);
                memoryMetricsPresent = true;
            }
            ++counter;
            Assert.assertTrue((boolean)taskCounterMetricsPresent);
            Assert.assertTrue((boolean)taskExecutionTimeMetricsPresent);
            Assert.assertTrue((boolean)memoryMetricsPresent);
        }
        PhoenixRuntime.resetMetrics((ResultSet)resultSetBeingTested);
        Assert.assertTrue((String)("Metrics not found tables " + Joiner.on((String)",").join(expectedTableNames)), (expectedTableNames.size() == 0 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetConnectionsForSameUrlConcurrently() throws Exception {
        String zkQuorum = "localhost:" + PhoenixMetricsIT.getUtility().getZkCluster().getClientPort();
        String url = "jdbc:phoenix+zk:" + zkQuorum;
        ExecutorService exec = Executors.newFixedThreadPool(10);
        try {
            Object c;
            int i;
            GlobalClientMetrics.GLOBAL_HCONNECTIONS_COUNTER.getMetric().reset();
            GlobalClientMetrics.GLOBAL_QUERY_SERVICES_COUNTER.getMetric().reset();
            Assert.assertEquals((long)0L, (long)GlobalClientMetrics.GLOBAL_HCONNECTIONS_COUNTER.getMetric().getValue());
            Assert.assertEquals((long)0L, (long)GlobalClientMetrics.GLOBAL_QUERY_SERVICES_COUNTER.getMetric().getValue());
            ArrayList<GetConnectionCallable> callables = new ArrayList<GetConnectionCallable>(100);
            ArrayList<Future<Connection>> futures = new ArrayList<Future<Connection>>(100);
            int expectedHConnections = numConnections.get() > 0 ? 0 : 1;
            for (i = 1; i <= 100; ++i) {
                c = new GetConnectionCallable(url);
                callables.add((GetConnectionCallable)c);
                futures.add(exec.submit(c));
            }
            for (i = 0; i < futures.size(); ++i) {
                c = (Connection)((Future)futures.get(i)).get();
                try {
                    c.close();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Assert.assertEquals((long)expectedHConnections, (long)GlobalClientMetrics.GLOBAL_HCONNECTIONS_COUNTER.getMetric().getValue());
            Assert.assertEquals((long)expectedHConnections, (long)GlobalClientMetrics.GLOBAL_QUERY_SERVICES_COUNTER.getMetric().getValue());
        }
        finally {
            exec.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetConnectionsThrottledForSameUrl() throws Exception {
        int attemptedPhoenixConnections = 11;
        int maxConnections = attemptedPhoenixConnections - 1;
        ArrayList connections = Lists.newArrayList();
        String zkQuorum = "localhost:" + PhoenixMetricsIT.getUtility().getZkCluster().getClientPort();
        String url = "jdbc:phoenix+zk:" + zkQuorum + ':' + CUSTOM_URL_STRING + '=' + "throttletest";
        Properties props = new Properties();
        props.setProperty("phoenix.client.connection.max.allowed.connections", Integer.toString(maxConnections));
        GlobalClientMetrics.GLOBAL_HCONNECTIONS_COUNTER.getMetric().reset();
        GlobalClientMetrics.GLOBAL_QUERY_SERVICES_COUNTER.getMetric().reset();
        GlobalClientMetrics.GLOBAL_PHOENIX_CONNECTIONS_ATTEMPTED_COUNTER.getMetric().reset();
        GlobalClientMetrics.GLOBAL_PHOENIX_CONNECTIONS_THROTTLED_COUNTER.getMetric().reset();
        boolean wasThrottled = false;
        try {
            for (int k = 0; k < attemptedPhoenixConnections; ++k) {
                connections.add(DriverManager.getConnection(url, props));
            }
        }
        catch (SQLException se) {
            wasThrottled = true;
            Assert.assertEquals((long)SQLExceptionCode.NEW_CONNECTION_THROTTLED.getErrorCode(), (long)se.getErrorCode());
        }
        finally {
            for (Connection c : connections) {
                c.close();
            }
        }
        Assert.assertEquals((long)1L, (long)GlobalClientMetrics.GLOBAL_QUERY_SERVICES_COUNTER.getMetric().getValue());
        Assert.assertTrue((String)"No connection was throttled!", (boolean)wasThrottled);
        Assert.assertEquals((long)1L, (long)GlobalClientMetrics.GLOBAL_PHOENIX_CONNECTIONS_THROTTLED_COUNTER.getMetric().getValue());
        Assert.assertEquals((long)maxConnections, (long)connections.size());
        Assert.assertTrue((String)"Not all connections were attempted!", ((long)attemptedPhoenixConnections <= GlobalClientMetrics.GLOBAL_PHOENIX_CONNECTIONS_ATTEMPTED_COUNTER.getMetric().getValue() ? 1 : 0) != 0);
        connections.clear();
        try {
            for (int k = 0; k < maxConnections; ++k) {
                connections.add(DriverManager.getConnection(url, props));
            }
        }
        catch (SQLException se) {
            if (se.getErrorCode() == SQLExceptionCode.NEW_CONNECTION_THROTTLED.getErrorCode()) {
                Assert.fail((String)"Connection was throttled when it shouldn't be!");
            }
        }
        finally {
            for (Connection c : connections) {
                c.close();
            }
        }
        Assert.assertEquals((long)maxConnections, (long)connections.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetConnectionsFailedCounter() throws Exception {
        int attemptedPhoenixConnections = 7;
        int maxConnections = attemptedPhoenixConnections - 4;
        ArrayList connections = Lists.newArrayList();
        String zkQuorum = "localhost:" + PhoenixMetricsIT.getUtility().getZkCluster().getClientPort();
        String url = "jdbc:phoenix+zk:" + zkQuorum + ':' + CUSTOM_URL_STRING + '=' + "FailedCounterTest";
        Properties props = new Properties();
        props.setProperty("phoenix.client.connection.max.allowed.connections", Integer.toString(maxConnections));
        Properties props1 = new Properties(props);
        props1.setProperty("CurrentSCN", Integer.toString(-1));
        Properties props2 = new Properties(props);
        props2.setProperty("phoenix.log.level", "notKnown");
        GlobalClientMetrics.GLOBAL_QUERY_SERVICES_COUNTER.getMetric().reset();
        GlobalClientMetrics.GLOBAL_PHOENIX_CONNECTIONS_ATTEMPTED_COUNTER.getMetric().reset();
        GlobalClientMetrics.GLOBAL_PHOENIX_CONNECTIONS_THROTTLED_COUNTER.getMetric().reset();
        GlobalClientMetrics.GLOBAL_FAILED_PHOENIX_CONNECTIONS.getMetric().reset();
        try {
            for (int i = 0; i < attemptedPhoenixConnections; ++i) {
                try {
                    if (i == 0) {
                        connections.add(DriverManager.getConnection(url, props2));
                        continue;
                    }
                    if (i % 3 == 0) {
                        connections.add(DriverManager.getConnection(url, props1));
                        continue;
                    }
                    connections.add(DriverManager.getConnection(url, props));
                    continue;
                }
                catch (SQLException se) {
                    if (i == 0) {
                        Assert.assertEquals((long)0L, (long)se.getErrorCode());
                        continue;
                    }
                    if (i % 3 == 0) {
                        Assert.assertEquals((long)SQLExceptionCode.INVALID_SCN.getErrorCode(), (long)se.getErrorCode());
                        continue;
                    }
                    Assert.assertEquals((long)SQLExceptionCode.NEW_CONNECTION_THROTTLED.getErrorCode(), (long)se.getErrorCode());
                }
            }
        }
        finally {
            for (Connection c : connections) {
                c.close();
            }
        }
        Assert.assertEquals((long)1L, (long)GlobalClientMetrics.GLOBAL_QUERY_SERVICES_COUNTER.getMetric().getValue());
        Assert.assertEquals((long)1L, (long)GlobalClientMetrics.GLOBAL_PHOENIX_CONNECTIONS_THROTTLED_COUNTER.getMetric().getValue());
        Assert.assertEquals((long)3L, (long)GlobalClientMetrics.GLOBAL_FAILED_PHOENIX_CONNECTIONS.getMetric().getValue());
        Assert.assertTrue((String)"Not all connections were attempted!", ((long)attemptedPhoenixConnections <= GlobalClientMetrics.GLOBAL_PHOENIX_CONNECTIONS_ATTEMPTED_COUNTER.getMetric().getValue() ? 1 : 0) != 0);
        props1.setProperty("zookeeper.session.timeout", Integer.toString(100));
        props1.setProperty("hbase.client.retries.number", Integer.toString(2));
        props1.setProperty("zookeeper.recovery.retry", Integer.toString(2));
        try {
            DriverManager.getConnection("jdbc:phoenix+zk:jdbcthisIsBadZk", props1);
        }
        catch (Exception e) {
            Assert.assertEquals((long)4L, (long)GlobalClientMetrics.GLOBAL_FAILED_PHOENIX_CONNECTIONS.getMetric().getValue());
            Assert.assertEquals((long)(attemptedPhoenixConnections + 1), (long)GlobalClientMetrics.GLOBAL_PHOENIX_CONNECTIONS_ATTEMPTED_COUNTER.getMetric().getValue());
            return;
        }
        Assert.fail();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetConnectionsForDifferentTenantsConcurrently() throws Exception {
        String zkQuorum = "localhost:" + PhoenixMetricsIT.getUtility().getZkCluster().getClientPort();
        String url = "jdbc:phoenix+zk:" + zkQuorum;
        ExecutorService exec = Executors.newFixedThreadPool(10);
        try {
            int i;
            GlobalClientMetrics.GLOBAL_HCONNECTIONS_COUNTER.getMetric().reset();
            GlobalClientMetrics.GLOBAL_QUERY_SERVICES_COUNTER.getMetric().reset();
            Assert.assertEquals((long)0L, (long)GlobalClientMetrics.GLOBAL_HCONNECTIONS_COUNTER.getMetric().getValue());
            Assert.assertEquals((long)0L, (long)GlobalClientMetrics.GLOBAL_QUERY_SERVICES_COUNTER.getMetric().getValue());
            int expectedHConnections = numConnections.get() > 0 ? 0 : 1;
            ArrayList<GetConnectionCallable> callables = new ArrayList<GetConnectionCallable>(100);
            ArrayList<Future<Connection>> futures = new ArrayList<Future<Connection>>(100);
            for (i = 1; i <= 100; ++i) {
                String tenantUrl = url + ';' + "TenantId" + '=' + i;
                GetConnectionCallable c = new GetConnectionCallable(tenantUrl + ";");
                callables.add(c);
                futures.add(exec.submit(c));
            }
            for (i = 0; i < futures.size(); ++i) {
                Connection c = (Connection)((Future)futures.get(i)).get();
                try {
                    c.close();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Assert.assertEquals((long)expectedHConnections, (long)GlobalClientMetrics.GLOBAL_HCONNECTIONS_COUNTER.getMetric().getValue());
            Assert.assertEquals((long)expectedHConnections, (long)GlobalClientMetrics.GLOBAL_QUERY_SERVICES_COUNTER.getMetric().getValue());
        }
        finally {
            exec.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetConnectionsWithDifferentJDBCParamsConcurrently() throws Exception {
        int i;
        DriverManager.registerDriver((Driver)PhoenixDriver.INSTANCE);
        ExecutorService exec = Executors.newFixedThreadPool(4);
        String zkQuorum = "localhost:" + PhoenixMetricsIT.getUtility().getZkCluster().getClientPort();
        String baseUrl = "jdbc:phoenix+zk:" + zkQuorum;
        int numConnections = 20;
        ArrayList<GetConnectionCallable> callables = new ArrayList<GetConnectionCallable>(numConnections);
        ArrayList<Future<Connection>> futures = new ArrayList<Future<Connection>>(numConnections);
        try {
            GlobalClientMetrics.GLOBAL_HCONNECTIONS_COUNTER.getMetric().reset();
            GlobalClientMetrics.GLOBAL_QUERY_SERVICES_COUNTER.getMetric().reset();
            Assert.assertEquals((long)0L, (long)GlobalClientMetrics.GLOBAL_HCONNECTIONS_COUNTER.getMetric().getValue());
            Assert.assertEquals((long)0L, (long)GlobalClientMetrics.GLOBAL_QUERY_SERVICES_COUNTER.getMetric().getValue());
            for (i = 1; i <= numConnections; ++i) {
                String customUrl = baseUrl + ':' + CUSTOM_URL_STRING + '=' + i;
                GetConnectionCallable c = new GetConnectionCallable(customUrl + ";");
                callables.add(c);
                futures.add(exec.submit(c));
            }
            for (i = 0; i < futures.size(); ++i) {
                ((Future)futures.get(i)).get();
            }
            Assert.assertEquals((long)numConnections, (long)GlobalClientMetrics.GLOBAL_HCONNECTIONS_COUNTER.getMetric().getValue());
            Assert.assertEquals((long)numConnections, (long)GlobalClientMetrics.GLOBAL_QUERY_SERVICES_COUNTER.getMetric().getValue());
        }
        finally {
            exec.shutdownNow();
            for (i = 0; i < futures.size(); ++i) {
                try {
                    Connection c = (Connection)((Future)futures.get(i)).get();
                    c.unwrap(PhoenixConnection.class).getQueryServices().close();
                    c.close();
                    continue;
                }
                catch (Exception exception) {}
            }
        }
    }

    @Test
    public void testQueryParsingTimeForUpsertAndSelect() throws Exception {
        String whereStr;
        String tableName1 = PhoenixMetricsIT.generateUniqueName();
        String tableName2 = PhoenixMetricsIT.generateUniqueName();
        int sourceNumRows = 1;
        Connection conn = DriverManager.getConnection(PhoenixMetricsIT.getUrl());
        String ddl1 = "CREATE TABLE " + tableName1 + " (ID INTEGER NOT NULL PRIMARY KEY, CATEGORY VARCHAR(30), REGION VARCHAR(30), DISTRICT VARCHAR(30))";
        conn.createStatement().execute(ddl1);
        String ddl2 = "CREATE TABLE " + tableName2 + " (ID INTEGER NOT NULL PRIMARY KEY, CATEGORY VARCHAR(30), REGION VARCHAR(30), DISTRICT VARCHAR(30))";
        conn.createStatement().execute(ddl2);
        String upsert1 = "UPSERT INTO " + tableName1 + " (ID, CATEGORY, REGION, DISTRICT) VALUES (?, ?, ?, ?)";
        PreparedStatement pstmt1 = conn.prepareStatement(upsert1);
        for (int i = 0; i < sourceNumRows; ++i) {
            pstmt1.setInt(1, i);
            pstmt1.setString(2, "CATEGORY_" + i % 1);
            pstmt1.setString(3, "REGION_" + i % 1);
            pstmt1.setString(4, "DISTRICT_" + i % 1);
            pstmt1.execute();
        }
        conn.commit();
        String whereCaluse = whereStr = "   REGION IN ('REGION_0', 'REGION_1', 'REGION_2', 'REGION_3', 'REGION_4', 'REGION_5')    AND CATEGORY IN ('CATEGORY_0', 'CATEGORY_1', 'CATEGORY_2', 'CATEGORY_3')    AND DISTRICT IN ('DISTRICT_0', 'DISTRICT_1', 'DISTRICT_2', 'DISTRICT_3') ";
        for (int i = 0; i < 50; ++i) {
            whereCaluse = whereCaluse + "AND " + whereStr;
        }
        String queryStr = " SELECT    ID, REGION FROM " + tableName1 + " WHERE " + whereCaluse;
        PhoenixRuntime.resetMetrics((Connection)conn);
        String upsertSelectQuery = "UPSERT INTO " + tableName2 + " " + queryStr;
        conn = DriverManager.getConnection(PhoenixMetricsIT.getUrl());
        PreparedStatement Sstmt = conn.prepareStatement(upsertSelectQuery);
        Sstmt.executeUpdate();
        conn.commit();
        Map mutationMetrics = PhoenixRuntime.getWriteMetricInfoForMutationsSinceLastReset((Connection)conn);
        long parsingTime = (Long)((Map)mutationMetrics.get(tableName2)).get(MetricType.SQL_QUERY_PARSING_TIME_MS);
        Assert.assertTrue((String)"parsing time should be greater than zero", (parsingTime > 0L ? 1 : 0) != 0);
        ResultSet rs = conn.createStatement().executeQuery(queryStr);
        Map overallReadMetrics = PhoenixRuntime.getOverAllReadRequestMetricInfo((ResultSet)rs);
        Assert.assertTrue((String)"Query parsing time should be greater than zero", ((Long)overallReadMetrics.get(MetricType.SQL_QUERY_PARSING_TIME_MS) > 0L ? 1 : 0) != 0);
        conn.close();
    }

    private static class GetConnectionCallable
    implements Callable<Connection> {
        private final String url;

        GetConnectionCallable(String url) {
            this.url = url;
        }

        @Override
        public Connection call() throws Exception {
            Connection c = DriverManager.getConnection(this.url);
            if (!this.url.contains(PhoenixMetricsIT.CUSTOM_URL_STRING)) {
                numConnections.incrementAndGet();
            }
            return c;
        }
    }

    private class TestReadMetricsQueue
    extends ReadMetricQueue {
        public TestReadMetricsQueue(LogLevel connectionLogLevel, boolean isRequestMetricsEnabled) {
            super(isRequestMetricsEnabled, connectionLogLevel);
        }

        public CombinableMetric getMetric(MetricType type) {
            switch (type) {
                case SCAN_BYTES: {
                    return new CombinableMetricImpl(type){

                        public void change(long delta) {
                            super.change(1L);
                        }
                    };
                }
                case TASK_EXECUTION_TIME: {
                    return new CombinableMetricImpl(type){

                        public void change(long delta) {
                            super.change(10L);
                        }
                    };
                }
                case MEMORY_CHUNK_BYTES: {
                    return new CombinableMetricImpl(type){

                        public void change(long delta) {
                            super.change(100L);
                        }
                    };
                }
            }
            return super.getMetric(type);
        }
    }

    private static class MyClock
    extends EnvironmentEdge {
        private long time;
        private final long delay;

        public MyClock(long time, long delay) {
            this.time = time;
            this.delay = delay;
        }

        public long currentTime() {
            long currentTime = this.time;
            this.time += this.delay;
            return currentTime;
        }
    }
}

