/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.monitoring;

import java.util.Map;
import org.apache.phoenix.log.LogLevel;
import org.apache.phoenix.monitoring.MetricType;
import org.apache.phoenix.monitoring.OverAllQueryMetrics;
import org.apache.phoenix.util.EnvironmentEdge;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OverAllQueryMetricsTest {
    private OverAllQueryMetrics overAllQueryMetrics;
    private static final long numParallelScans = 10L;
    private static final long delta = 1000L;
    private static final int queryTimeouts = 5;
    private static final int queryFailures = 8;
    private static final int cacheRefreshesDueToSplits = 15;

    @Before
    public void getFreshMetricsObject() {
        this.overAllQueryMetrics = new OverAllQueryMetrics(true, LogLevel.TRACE);
        this.populateMetrics(this.overAllQueryMetrics, 10L, 5, 8, 15);
    }

    @After
    public void reset() {
        EnvironmentEdgeManager.reset();
    }

    @Test
    public void testQueryWatchTimer() {
        Assert.assertEquals((long)0L, (long)this.overAllQueryMetrics.getWallClockTimeMs());
        MyClock clock = new MyClock(10L, 1000L);
        EnvironmentEdgeManager.injectEdge((EnvironmentEdge)clock);
        this.overAllQueryMetrics.startQuery();
        this.overAllQueryMetrics.endQuery();
        Assert.assertEquals((long)1000L, (long)this.overAllQueryMetrics.getWallClockTimeMs());
        this.overAllQueryMetrics.endQuery();
        Assert.assertEquals((long)1000L, (long)this.overAllQueryMetrics.getWallClockTimeMs());
    }

    @Test
    public void testResultSetWatch() {
        Assert.assertEquals((long)0L, (long)this.overAllQueryMetrics.getResultSetTimeMs());
        MyClock clock = new MyClock(10L, 1000L);
        EnvironmentEdgeManager.injectEdge((EnvironmentEdge)clock);
        this.overAllQueryMetrics.startResultSetWatch();
        this.overAllQueryMetrics.stopResultSetWatch();
        Assert.assertEquals((long)1000L, (long)this.overAllQueryMetrics.getResultSetTimeMs());
        this.overAllQueryMetrics.stopResultSetWatch();
        Assert.assertEquals((long)1000L, (long)this.overAllQueryMetrics.getResultSetTimeMs());
    }

    @Test
    public void testPublish() {
        MyClock clock = new MyClock(10L, 1000L);
        EnvironmentEdgeManager.injectEdge((EnvironmentEdge)clock);
        this.overAllQueryMetrics.startQuery();
        this.overAllQueryMetrics.startResultSetWatch();
        this.assertPublishedMetrics(this.overAllQueryMetrics.publish(), 10L, 5L, 8L, 15L, 0L, 1000L, 1000L, 1000L, 1000L);
        this.overAllQueryMetrics.endQuery();
        this.overAllQueryMetrics.stopResultSetWatch();
        this.assertPublishedMetrics(this.overAllQueryMetrics.publish(), 10L, 5L, 8L, 15L, 2000L, 1000L, 1000L, 1000L, 1000L);
    }

    @Test
    public void testReset() {
        this.assertPublishedMetrics(this.overAllQueryMetrics.publish(), 10L, 5L, 8L, 15L, 0L, 1000L, 1000L, 1000L, 1000L);
        this.overAllQueryMetrics.reset();
        this.assertPublishedMetrics(this.overAllQueryMetrics.publish(), 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L);
    }

    @Test
    public void testCombine() {
        OverAllQueryMetrics otherMetrics = new OverAllQueryMetrics(true, LogLevel.TRACE);
        long otherNumParallelScans = 9L;
        int otherQueryTimeouts = 8;
        int otherQueryFailures = 7;
        int otherCacheRefreshes = 6;
        this.populateMetrics(otherMetrics, 9L, 8, 7, 6);
        OverAllQueryMetrics finalMetricObj = this.overAllQueryMetrics.combine(otherMetrics);
        this.assertPublishedMetrics(finalMetricObj.publish(), 19L, 13L, 15L, 21L, 0L, 2000L, 2000L, 2000L, 2000L);
    }

    @Test
    public void testNoOpRequestMetricsIfRequestMetricsDisabled() {
        OverAllQueryMetrics noOpMetrics = new OverAllQueryMetrics(false, LogLevel.OFF);
        this.populateMetrics(noOpMetrics, 10L, 5, 8, 15);
        Map noOpMap = noOpMetrics.publish();
        Assert.assertEquals((long)1L, (long)noOpMap.size());
        Assert.assertEquals((long)0L, (long)((Long)noOpMap.get(MetricType.NO_OP_METRIC)));
    }

    private void populateMetrics(OverAllQueryMetrics metricsObj, long numParallelScansSetting, int queryTimeoutsSetting, int queryFailuresSetting, int cacheRefreshesDueToSplitsSetting) {
        int i;
        metricsObj.updateNumParallelScans(numParallelScansSetting);
        for (i = 0; i < queryTimeoutsSetting; ++i) {
            metricsObj.queryTimedOut();
        }
        for (i = 0; i < queryFailuresSetting; ++i) {
            metricsObj.queryFailed();
        }
        for (i = 0; i < cacheRefreshesDueToSplitsSetting; ++i) {
            metricsObj.cacheRefreshedDueToSplits();
        }
        metricsObj.setQueryCompilerTimeMS(1000L);
        metricsObj.setQueryOptimizerTimeMS(1000L);
        metricsObj.setQueryResultItrTimeMS(1000L);
        metricsObj.setQueryParsingTimeMS(1000L);
    }

    private void assertPublishedMetrics(Map<MetricType, Long> metrics, long expectedNumParallelScans, long expectedQueryTimeouts, long expectedQueryFailures, long expectedCacheRefreshes, long expectedElapsedTime, long expectedQueryCompilerTimeMS, long expectedQueryOptimizerTimeMS, long expectedQueryResultItrSetTimeMS, long expectedQueryParsingTime) {
        Assert.assertEquals((long)expectedNumParallelScans, (long)metrics.get(MetricType.NUM_PARALLEL_SCANS));
        Assert.assertEquals((long)expectedQueryTimeouts, (long)metrics.get(MetricType.QUERY_TIMEOUT_COUNTER));
        Assert.assertEquals((long)expectedQueryFailures, (long)metrics.get(MetricType.QUERY_FAILED_COUNTER));
        Assert.assertEquals((long)expectedCacheRefreshes, (long)metrics.get(MetricType.CACHE_REFRESH_SPLITS_COUNTER));
        Assert.assertEquals((long)expectedElapsedTime, (long)metrics.get(MetricType.WALL_CLOCK_TIME_MS));
        Assert.assertEquals((long)expectedElapsedTime, (long)metrics.get(MetricType.RESULT_SET_TIME_MS));
        Assert.assertEquals((long)expectedQueryCompilerTimeMS, (long)metrics.get(MetricType.QUERY_COMPILER_TIME_MS));
        Assert.assertEquals((long)expectedQueryOptimizerTimeMS, (long)metrics.get(MetricType.QUERY_OPTIMIZER_TIME_MS));
        Assert.assertEquals((long)expectedQueryResultItrSetTimeMS, (long)metrics.get(MetricType.QUERY_RESULT_ITR_TIME_MS));
        Assert.assertEquals((long)expectedQueryParsingTime, (long)metrics.get(MetricType.SQL_QUERY_PARSING_TIME_MS));
    }

    private static class MyClock
    extends EnvironmentEdge {
        private long time;
        private long delta;

        public MyClock(long time, long delta) {
            this.time = time;
            this.delta = delta;
        }

        public long currentTime() {
            long prevTime = this.time;
            this.time += this.delta;
            return prevTime;
        }
    }
}

