/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.monitoring;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.phoenix.monitoring.LatencyHistogram;
import org.junit.Assert;
import org.junit.Test;

public class LatencyHistogramTest {
    @Test
    public void testLatencyHistogramRangeOverride() {
        String histoName = "PhoenixGetLatencyHisto";
        Configuration conf = new Configuration();
        conf.set("phoenix.histogram.latency.ranges", "2, 5, 8");
        LatencyHistogram histogram = new LatencyHistogram(histoName, "histogram for GET operation latency", conf);
        Assert.assertEquals((Object)histoName, (Object)histogram.getName());
        long[] ranges = histogram.getRanges();
        Assert.assertNotNull((Object)ranges);
        Assert.assertEquals((long)3L, (long)ranges.length);
        Assert.assertEquals((long)2L, (long)ranges[0]);
        Assert.assertEquals((long)5L, (long)ranges[1]);
        Assert.assertEquals((long)8L, (long)ranges[2]);
    }

    @Test
    public void testEveryRangeInDefaultRange() {
        Configuration conf = new Configuration();
        String histoName = "PhoenixGetLatencyHisto";
        conf.unset("phoenix.histogram.latency.ranges");
        LatencyHistogram histogram = new LatencyHistogram(histoName, "histogram for GET operation latency", conf);
        Assert.assertEquals((Object)histoName, (Object)histogram.getName());
        Assert.assertEquals((Object)LatencyHistogram.DEFAULT_RANGE, (Object)histogram.getRanges());
        histogram.add(1L);
        histogram.add(2L);
        histogram.add(3L);
        histogram.add(5L);
        histogram.add(20L);
        histogram.add(60L);
        histogram.add(200L);
        histogram.add(600L);
        histogram.add(2000L);
        histogram.add(6000L);
        histogram.add(20000L);
        histogram.add(45000L);
        histogram.add(90000L);
        histogram.add(200000L);
        histogram.add(450000L);
        histogram.add(900000L);
        Map distribution = histogram.getRangeHistogramDistribution().getRangeDistributionMap();
        HashMap<String, Long> expectedMap = new HashMap<String, Long>();
        expectedMap.put("0,1", 1L);
        expectedMap.put("1,3", 2L);
        expectedMap.put("3,10", 1L);
        expectedMap.put("10,30", 1L);
        expectedMap.put("30,100", 1L);
        expectedMap.put("100,300", 1L);
        expectedMap.put("300,1000", 1L);
        expectedMap.put("1000,3000", 1L);
        expectedMap.put("3000,10000", 1L);
        expectedMap.put("10000,30000", 1L);
        expectedMap.put("30000,60000", 1L);
        expectedMap.put("60000,120000", 1L);
        expectedMap.put("120000,300000", 1L);
        expectedMap.put("300000,600000", 1L);
        Assert.assertEquals(expectedMap, (Object)distribution);
    }
}

