/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.monitoring;

import java.util.HashMap;
import org.apache.hadoop.metrics2.lib.DynamicMetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableFastCounter;
import org.apache.hadoop.metrics2.lib.MutableHistogram;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.hbase.index.metrics.GlobalIndexCheckerSourceImpl;
import org.apache.phoenix.hbase.index.metrics.MetricsIndexerSourceImpl;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.ReadOnlyProps;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class IndexMetricsIT
extends ParallelStatsDisabledIT {
    private static final String TABLE_NAME = "MyTable";
    private static final String INDEX_NAME = "MyIndex";
    public static final int TIME_VAL = 10;

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap props = Maps.newHashMapWithExpectedSize((int)3);
        props.put("phoenix.task.handling.initial.delay.ms", Long.toString(Long.MAX_VALUE));
        props.put("phoenix.scanner.lease.renew.enabled", String.valueOf(false));
        IndexMetricsIT.setUpTestDriver(new ReadOnlyProps(props.entrySet().iterator()));
    }

    @Test
    public void testIndexRegionObserverCounterMetrics() {
        MetricsIndexerSourceImpl metricSource = new MetricsIndexerSourceImpl();
        DynamicMetricsRegistry registry = metricSource.getMetricsRegistry();
        metricSource.incrementNumSlowIndexPrepareCalls(TABLE_NAME);
        IndexMetricsIT.verifyCounter("slowIndexPrepareCalls", registry);
        IndexMetricsIT.verifyCounter(this.getTableCounterName("slowIndexPrepareCalls"), registry);
        metricSource.incrementNumSlowIndexWriteCalls(TABLE_NAME);
        IndexMetricsIT.verifyCounter("slowIndexWriteCalls", registry);
        IndexMetricsIT.verifyCounter(this.getTableCounterName("slowIndexWriteCalls"), registry);
        metricSource.incrementNumSlowPostDeleteCalls(TABLE_NAME);
        IndexMetricsIT.verifyCounter("slowPostDeleteCalls", registry);
        IndexMetricsIT.verifyCounter(this.getTableCounterName("slowPostDeleteCalls"), registry);
        metricSource.incrementNumSlowPostOpenCalls(TABLE_NAME);
        IndexMetricsIT.verifyCounter("slowPostOpenCalls", registry);
        IndexMetricsIT.verifyCounter(this.getTableCounterName("slowPostOpenCalls"), registry);
        metricSource.incrementNumSlowPostPutCalls(TABLE_NAME);
        IndexMetricsIT.verifyCounter("slowPostPutCalls", registry);
        IndexMetricsIT.verifyCounter(this.getTableCounterName("slowPostPutCalls"), registry);
        metricSource.incrementNumSlowPreWALRestoreCalls(TABLE_NAME);
        IndexMetricsIT.verifyCounter("slowPreWALRestoreCalls", registry);
        IndexMetricsIT.verifyCounter(this.getTableCounterName("slowPreWALRestoreCalls"), registry);
        metricSource.incrementPostIndexUpdateFailures(TABLE_NAME);
        IndexMetricsIT.verifyCounter("postIndexUpdateFailure", registry);
        IndexMetricsIT.verifyCounter(this.getTableCounterName("postIndexUpdateFailure"), registry);
        metricSource.incrementPreIndexUpdateFailures(TABLE_NAME);
        IndexMetricsIT.verifyCounter("preIndexUpdateFailure", registry);
        IndexMetricsIT.verifyCounter(this.getTableCounterName("preIndexUpdateFailure"), registry);
        metricSource.incrementSlowDuplicateKeyCheckCalls(TABLE_NAME);
        IndexMetricsIT.verifyCounter("slowDuplicateKeyCheckCalls", registry);
        IndexMetricsIT.verifyCounter(this.getTableCounterName("slowDuplicateKeyCheckCalls"), registry);
    }

    @Test
    public void testIndexRegionObserverHistogramMetrics() {
        MetricsIndexerSourceImpl metricSource = new MetricsIndexerSourceImpl();
        DynamicMetricsRegistry registry = metricSource.getMetricsRegistry();
        metricSource.updateDuplicateKeyCheckTime(TABLE_NAME, 10L);
        IndexMetricsIT.verifyHistogram("duplicateKeyCheckTime", registry);
        IndexMetricsIT.verifyHistogram(this.getTableCounterName("duplicateKeyCheckTime"), registry);
        metricSource.updateIndexPrepareTime(TABLE_NAME, 10L);
        IndexMetricsIT.verifyHistogram("indexPrepareTime", registry);
        IndexMetricsIT.verifyHistogram(this.getTableCounterName("indexPrepareTime"), registry);
        metricSource.updateIndexWriteTime(TABLE_NAME, 10L);
        IndexMetricsIT.verifyHistogram("indexWriteTime", registry);
        IndexMetricsIT.verifyHistogram(this.getTableCounterName("indexWriteTime"), registry);
        metricSource.updatePostDeleteTime(TABLE_NAME, 10L);
        IndexMetricsIT.verifyHistogram("postDeleteTime", registry);
        IndexMetricsIT.verifyHistogram(this.getTableCounterName("postDeleteTime"), registry);
        metricSource.updatePostIndexUpdateTime(TABLE_NAME, 10L);
        IndexMetricsIT.verifyHistogram("postIndexUpdateTime", registry);
        IndexMetricsIT.verifyHistogram(this.getTableCounterName("postIndexUpdateTime"), registry);
        metricSource.updatePostIndexUpdateFailureTime(TABLE_NAME, 10L);
        IndexMetricsIT.verifyHistogram("postIndexUpdateFailureTime", registry);
        IndexMetricsIT.verifyHistogram(this.getTableCounterName("postIndexUpdateFailureTime"), registry);
        metricSource.updatePostOpenTime(TABLE_NAME, 10L);
        IndexMetricsIT.verifyHistogram("postOpenTime", registry);
        IndexMetricsIT.verifyHistogram(this.getTableCounterName("postOpenTime"), registry);
        metricSource.updatePostPutTime(TABLE_NAME, 10L);
        IndexMetricsIT.verifyHistogram("postPutTime", registry);
        IndexMetricsIT.verifyHistogram(this.getTableCounterName("postPutTime"), registry);
        metricSource.updatePreIndexUpdateTime(TABLE_NAME, 10L);
        IndexMetricsIT.verifyHistogram("preIndexUpdateTime", registry);
        IndexMetricsIT.verifyHistogram(this.getTableCounterName("preIndexUpdateTime"), registry);
        metricSource.updatePreIndexUpdateFailureTime(TABLE_NAME, 10L);
        IndexMetricsIT.verifyHistogram("postIndexUpdateFailureTime", registry);
        IndexMetricsIT.verifyHistogram(this.getTableCounterName("postIndexUpdateFailureTime"), registry);
        metricSource.updatePreWALRestoreTime(TABLE_NAME, 10L);
        IndexMetricsIT.verifyHistogram("preWALRestoreTime", registry);
        IndexMetricsIT.verifyHistogram(this.getTableCounterName("preWALRestoreTime"), registry);
    }

    @Test
    public void testGlobalIndexCheckerCounterMetrics() {
        GlobalIndexCheckerSourceImpl metricSource = new GlobalIndexCheckerSourceImpl();
        DynamicMetricsRegistry registry = metricSource.getMetricsRegistry();
        metricSource.incrementIndexInspections(INDEX_NAME);
        IndexMetricsIT.verifyCounter("indexInspections", registry);
        IndexMetricsIT.verifyCounter(this.getIndexCounterName("indexInspections"), registry);
        metricSource.incrementIndexRepairFailures(INDEX_NAME);
        IndexMetricsIT.verifyCounter("indexRepairFailures", registry);
        IndexMetricsIT.verifyCounter(this.getIndexCounterName("indexRepairFailures"), registry);
        metricSource.incrementIndexRepairs(INDEX_NAME);
        IndexMetricsIT.verifyCounter("indexRepairs", registry);
        IndexMetricsIT.verifyCounter(this.getIndexCounterName("indexRepairs"), registry);
    }

    @Test
    public void testGlobalIndexCheckerHistogramMetrics() {
        GlobalIndexCheckerSourceImpl metricSource = new GlobalIndexCheckerSourceImpl();
        DynamicMetricsRegistry registry = metricSource.getMetricsRegistry();
        metricSource.updateIndexRepairTime(INDEX_NAME, 10L);
        IndexMetricsIT.verifyHistogram("indexRepairTime", registry);
        IndexMetricsIT.verifyHistogram(this.getIndexCounterName("indexRepairTime"), registry);
        metricSource.updateIndexRepairFailureTime(INDEX_NAME, 10L);
        IndexMetricsIT.verifyHistogram("indexRepairFailureTime", registry);
        IndexMetricsIT.verifyHistogram(this.getIndexCounterName("indexRepairFailureTime"), registry);
        long ageOfUnverifiedRow = EnvironmentEdgeManager.currentTimeMillis() - 10L;
        metricSource.updateUnverifiedIndexRowAge(INDEX_NAME, ageOfUnverifiedRow);
        IndexMetricsIT.verifyHistogram("unverifiedIndexRowAge", registry, ageOfUnverifiedRow);
        IndexMetricsIT.verifyHistogram(this.getIndexCounterName("unverifiedIndexRowAge"), registry, ageOfUnverifiedRow);
    }

    public static void verifyHistogram(String counterName, DynamicMetricsRegistry registry) {
        IndexMetricsIT.verifyHistogram(counterName, registry, 10L);
    }

    public static void verifyHistogram(String counterName, DynamicMetricsRegistry registry, long max) {
        MutableHistogram histogram = registry.getHistogram(counterName);
        Assert.assertEquals((long)max, (long)histogram.getMax());
    }

    public static void verifyCounter(String counterName, DynamicMetricsRegistry registry) {
        MutableFastCounter counter = registry.getCounter(counterName, 0L);
        Assert.assertEquals((long)1L, (long)counter.value());
    }

    public static void verifyCounterWithValue(String counterName, DynamicMetricsRegistry registry, long expectedValue) {
        MutableFastCounter counter = registry.getCounter(counterName, 0L);
        Assert.assertEquals((long)expectedValue, (long)counter.value());
    }

    public static long getCounterValueByName(String counterName, DynamicMetricsRegistry registry) {
        MutableFastCounter counter = registry.getCounter(counterName, 0L);
        return counter.value();
    }

    private String getTableCounterName(String baseCounterName) {
        return baseCounterName + "." + TABLE_NAME;
    }

    private String getIndexCounterName(String baseCounterName) {
        return baseCounterName + "." + INDEX_NAME;
    }
}

