/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.monitoring;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.util.VersionInfo;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.job.HTableThreadPoolWithUtilizationStats;
import org.apache.phoenix.monitoring.BaseHTableThreadPoolMetricsIT;
import org.apache.phoenix.monitoring.HTableThreadPoolHistograms;
import org.apache.phoenix.monitoring.HTableThreadPoolMetricsManager;
import org.apache.phoenix.monitoring.HistogramDistribution;
import org.apache.phoenix.query.ConfigurationFactory;
import org.apache.phoenix.query.HTableFactory;
import org.apache.phoenix.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.phoenix.util.InstanceResolver;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={NeedsOwnMiniClusterTest.class})
@RunWith(value=Parameterized.class)
public class ExternalHTableThreadPoolMetricsIT
extends BaseHTableThreadPoolMetricsIT {
    private static final int MAX_THREADS_IN_EXTERNAL_THREAD_POOL = 10;
    private static final int QUEUE_CAPACITY_OF_EXTERNAL_THREAD_POOL = 100;
    private static final String TAG_NAME = "cluster";
    private static final Map<String, String> tagValues = new HashMap<String, String>();
    private static final String THREAD_POOL_1A = "external_thread_pool_1".toUpperCase();
    private static final String THREAD_POOL_2A = "external_thread_pool_2".toUpperCase();
    private static final String HISTOGRAM_DISABLED_THREAD_POOL = "histogram_disabled_thread_pool".toUpperCase();
    private static final String NULL_SUPPLIER_THREAD_POOL = "null_supplier_thread_pool".toUpperCase();
    private static final String NO_TAGS_THREAD_POOL = "no_tags_thread_pool".toUpperCase();
    private final String registryClassName;
    private final Properties props = new Properties();

    public ExternalHTableThreadPoolMetricsIT(String registryClassName) {
        this.registryClassName = registryClassName;
    }

    private static ThreadPoolExecutor createThreadPoolExecutor(String threadPoolName) {
        Supplier<HTableThreadPoolHistograms> supplier = ExternalHTableThreadPoolMetricsIT.getHTableThreadPoolHistogramsSupplier(threadPoolName);
        LinkedBlockingQueue workQueue = new LinkedBlockingQueue(100);
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat(threadPoolName + "-shared-pool-%d").setUncaughtExceptionHandler(Threads.LOGGING_EXCEPTION_HANDLER).build();
        return new HTableThreadPoolWithUtilizationStats(10, 10, 30L, TimeUnit.SECONDS, workQueue, threadFactory, threadPoolName, supplier){

            public void execute(Runnable command) {
                super.execute(command);
            }
        };
    }

    private static Supplier<HTableThreadPoolHistograms> getHTableThreadPoolHistogramsSupplier(final String threadPoolName) {
        Supplier<HTableThreadPoolHistograms> supplier = threadPoolName.equals(HISTOGRAM_DISABLED_THREAD_POOL) ? null : (threadPoolName.equals(NULL_SUPPLIER_THREAD_POOL) ? new Supplier<HTableThreadPoolHistograms>(){

            @Override
            public HTableThreadPoolHistograms get() {
                return null;
            }
        } : (threadPoolName.equals(NO_TAGS_THREAD_POOL) ? new Supplier<HTableThreadPoolHistograms>(){

            @Override
            public HTableThreadPoolHistograms get() {
                return new HTableThreadPoolHistograms(10L, 100L);
            }
        } : new Supplier<HTableThreadPoolHistograms>(){

            @Override
            public HTableThreadPoolHistograms get() {
                HTableThreadPoolHistograms hTableThreadPoolHistograms = new HTableThreadPoolHistograms(10L, 100L);
                hTableThreadPoolHistograms.addTag(ExternalHTableThreadPoolMetricsIT.TAG_NAME, (String)tagValues.get(threadPoolName));
                return hTableThreadPoolHistograms;
            }
        }));
        return supplier;
    }

    @BeforeClass
    public static void setUp() throws Exception {
        tagValues.put(THREAD_POOL_1A, "hbase1a");
        tagValues.put(THREAD_POOL_2A, "hbase2a");
        final Configuration conf = HBaseConfiguration.create();
        ExternalHTableThreadPoolMetricsIT.setUpConfigForMiniCluster(conf);
        InstanceResolver.clearSingletons();
        InstanceResolver.getSingleton(ConfigurationFactory.class, (Object)new ConfigurationFactory(){

            public Configuration getConfiguration() {
                return conf;
            }

            public Configuration getConfiguration(Configuration confToClone) {
                Configuration copy = new Configuration(conf);
                copy.addResource(confToClone);
                return copy;
            }
        });
        final ThreadPoolExecutor executorFor1a = ExternalHTableThreadPoolMetricsIT.createThreadPoolExecutor(THREAD_POOL_1A);
        final ThreadPoolExecutor executorFor2a = ExternalHTableThreadPoolMetricsIT.createThreadPoolExecutor(THREAD_POOL_2A);
        final ThreadPoolExecutor histogramDisabledExecutor = ExternalHTableThreadPoolMetricsIT.createThreadPoolExecutor(HISTOGRAM_DISABLED_THREAD_POOL);
        final ThreadPoolExecutor nullSupplierExecutor = ExternalHTableThreadPoolMetricsIT.createThreadPoolExecutor(NULL_SUPPLIER_THREAD_POOL);
        final ThreadPoolExecutor defaultExecutor = ExternalHTableThreadPoolMetricsIT.createThreadPoolExecutor(NO_TAGS_THREAD_POOL);
        InstanceResolver.getSingleton(HTableFactory.class, (Object)new HTableFactory.HTableFactoryImpl(){

            public Table getTable(byte[] tableName, Connection connection, ExecutorService pool) throws IOException {
                if (Bytes.toString((byte[])tableName).startsWith(HISTOGRAM_DISABLED_THREAD_POOL)) {
                    return super.getTable(tableName, connection, (ExecutorService)histogramDisabledExecutor);
                }
                if (Bytes.toString((byte[])tableName).startsWith(NULL_SUPPLIER_THREAD_POOL)) {
                    return super.getTable(tableName, connection, (ExecutorService)nullSupplierExecutor);
                }
                if (Bytes.toString((byte[])tableName).startsWith(THREAD_POOL_1A)) {
                    return super.getTable(tableName, connection, (ExecutorService)executorFor1a);
                }
                if (Bytes.toString((byte[])tableName).startsWith(THREAD_POOL_2A)) {
                    return super.getTable(tableName, connection, (ExecutorService)executorFor2a);
                }
                return super.getTable(tableName, connection, (ExecutorService)defaultExecutor);
            }
        });
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("phoenix.tests.minicluster.nummasters", "2");
        ExternalHTableThreadPoolMetricsIT.setUpTestDriver(new ReadOnlyProps(props));
    }

    @Before
    public void testCaseSetup() {
        this.props.setProperty("hbase.client.registry.impl", this.registryClassName);
    }

    @After
    public void cleanup() throws Exception {
        HTableThreadPoolMetricsManager.clearHTableThreadPoolHistograms();
        this.props.clear();
    }

    @Parameterized.Parameters(name="ExternalHTableThreadPoolMetricsIT_registryClassName={0}")
    public static synchronized Collection<String> data() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("org.apache.hadoop.hbase.client.ZKConnectionRegistry");
        if (VersionInfo.compareVersion((String)VersionInfo.getVersion(), (String)"2.3.0") >= 0) {
            list.add("org.apache.hadoop.hbase.client.MasterRegistry");
        }
        if (VersionInfo.compareVersion((String)VersionInfo.getVersion(), (String)"2.5.0") >= 0) {
            list.add("org.apache.hadoop.hbase.client.RpcConnectionRegistry");
        }
        return list;
    }

    @Test
    public void testHistogramsPerHTableThreadPool() throws Exception {
        HashMap<String, String> expectedTagKeyValues;
        Map<String, List<HistogramDistribution>> htableThreadPoolHistograms;
        String tableName = THREAD_POOL_1A + "." + ExternalHTableThreadPoolMetricsIT.generateUniqueName();
        String url = QueryUtil.getConnectionUrl((Properties)this.props, (Configuration)utility.getConfiguration());
        try (java.sql.Connection conn = driver.connect(url, this.props);){
            this.createTableAndUpsertData(conn, tableName);
            htableThreadPoolHistograms = this.runQueryAndGetHistograms(conn, tableName);
            this.assertHTableThreadPoolUsed(htableThreadPoolHistograms, THREAD_POOL_1A);
            Assert.assertNull(htableThreadPoolHistograms.get(THREAD_POOL_2A));
            expectedTagKeyValues = new HashMap<String, String>();
            expectedTagKeyValues.put(TAG_NAME, tagValues.get(THREAD_POOL_1A));
            this.assertHistogramTags(htableThreadPoolHistograms, expectedTagKeyValues, THREAD_POOL_1A);
        }
        tableName = THREAD_POOL_2A + "." + ExternalHTableThreadPoolMetricsIT.generateUniqueName();
        conn = driver.connect(url, this.props);
        var5_4 = null;
        try {
            this.createTableAndUpsertData(conn, tableName);
            htableThreadPoolHistograms = this.runQueryAndGetHistograms(conn, tableName);
            this.assertHTableThreadPoolUsed(htableThreadPoolHistograms, THREAD_POOL_2A);
            this.assertHTableThreadPoolNotUsed(htableThreadPoolHistograms, THREAD_POOL_1A);
            expectedTagKeyValues = new HashMap();
            expectedTagKeyValues.put(TAG_NAME, tagValues.get(THREAD_POOL_1A));
            this.assertHistogramTags(htableThreadPoolHistograms, expectedTagKeyValues, THREAD_POOL_1A);
            expectedTagKeyValues.put(TAG_NAME, tagValues.get(THREAD_POOL_2A));
            this.assertHistogramTags(htableThreadPoolHistograms, expectedTagKeyValues, THREAD_POOL_2A);
        }
        catch (Throwable throwable) {
            var5_4 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var5_4 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var5_4.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    @Test
    public void testHistogramDisabled() throws Exception {
        String tableName = HISTOGRAM_DISABLED_THREAD_POOL + "." + ExternalHTableThreadPoolMetricsIT.generateUniqueName();
        String url = QueryUtil.getConnectionUrl((Properties)this.props, (Configuration)utility.getConfiguration());
        try (java.sql.Connection conn = driver.connect(url, this.props);){
            this.createTableAndUpsertData(conn, tableName);
            Map<String, List<HistogramDistribution>> htableThreadPoolHistograms = this.runQueryAndGetHistograms(conn, tableName);
            Assert.assertNull(htableThreadPoolHistograms.get(HISTOGRAM_DISABLED_THREAD_POOL));
        }
    }

    @Test
    public void testNullHistogramSupplier() throws Exception {
        String tableName = NULL_SUPPLIER_THREAD_POOL + "." + ExternalHTableThreadPoolMetricsIT.generateUniqueName();
        String url = QueryUtil.getConnectionUrl((Properties)this.props, (Configuration)utility.getConfiguration());
        try (java.sql.Connection conn = driver.connect(url, this.props);){
            this.createTableAndUpsertData(conn, tableName);
            Map<String, List<HistogramDistribution>> htableThreadPoolHistograms = this.runQueryAndGetHistograms(conn, tableName);
            Assert.assertNull(htableThreadPoolHistograms.get(NULL_SUPPLIER_THREAD_POOL));
        }
    }

    @Test
    public void testHistogramsWithoutTags() throws Exception {
        String tableName = ExternalHTableThreadPoolMetricsIT.generateUniqueName();
        String url = QueryUtil.getConnectionUrl((Properties)this.props, (Configuration)utility.getConfiguration());
        try (java.sql.Connection conn = driver.connect(url, this.props);){
            this.createTableAndUpsertData(conn, tableName);
            Map<String, List<HistogramDistribution>> htableThreadPoolHistograms = this.runQueryAndGetHistograms(conn, tableName);
            this.assertHTableThreadPoolUsed(htableThreadPoolHistograms, NO_TAGS_THREAD_POOL);
            this.assertHistogramTags(htableThreadPoolHistograms, new HashMap<String, String>(), NO_TAGS_THREAD_POOL);
        }
    }
}

