/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.monitoring;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.phoenix.jdbc.PhoenixDriver;
import org.apache.phoenix.monitoring.MetricType;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.ReadOnlyProps;
import org.junit.Assert;
import org.junit.BeforeClass;

public abstract class BasePhoenixMetricsIT
extends BaseTest {
    static final int MAX_RETRIES = 5;
    static final List<MetricType> mutationMetricsToSkip = Lists.newArrayList((Object[])new MetricType[]{MetricType.MUTATION_COMMIT_TIME});
    static final List<MetricType> readMetricsToSkip = Lists.newArrayList((Object[])new MetricType[]{MetricType.TASK_QUEUE_WAIT_TIME, MetricType.TASK_EXECUTION_TIME, MetricType.TASK_END_TO_END_TIME, MetricType.COUNT_MILLS_BETWEEN_NEXTS});
    static final String CUSTOM_URL_STRING = "SESSION";
    static final AtomicInteger numConnections = new AtomicInteger(0);

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap props = Maps.newHashMapWithExpectedSize((int)3);
        props.put("phoenix.task.handling.initial.delay.ms", Long.toString(Long.MAX_VALUE));
        props.put("phoenix.query.request.metrics.enabled", String.valueOf(true));
        props.put("phoenix.scanner.lease.renew.enabled", String.valueOf(false));
        BasePhoenixMetricsIT.setUpTestDriver(new ReadOnlyProps(props.entrySet().iterator()));
        DriverManager.registerDriver((Driver)PhoenixDriver.INSTANCE);
    }

    Connection insertRowsInTable(String tableName, long numRows) throws SQLException {
        String dml = "UPSERT INTO " + tableName + " VALUES (?, ?)";
        Connection conn = DriverManager.getConnection(BasePhoenixMetricsIT.getUrl());
        PreparedStatement stmt = conn.prepareStatement(dml);
        int i = 1;
        while ((long)i <= numRows) {
            stmt.setString(1, "key" + i);
            stmt.setString(2, "value" + i);
            stmt.executeUpdate();
            ++i;
        }
        conn.commit();
        return conn;
    }

    void assertReadMetricsForMutatingSql(String tableName, long tableSaltBuckets, Map<String, Map<MetricType, Long>> readMetrics) {
        Assert.assertTrue((String)"No read metrics present when there should have been!", (readMetrics.size() > 0 ? 1 : 0) != 0);
        int numTables = 0;
        for (Map.Entry<String, Map<MetricType, Long>> entry : readMetrics.entrySet()) {
            String t = entry.getKey();
            Assert.assertEquals((String)"Table name didn't match for read metrics", (Object)tableName, (Object)t);
            ++numTables;
            Map<MetricType, Long> p = entry.getValue();
            Assert.assertTrue((String)"No read metrics present when there should have been", (p.size() > 0 ? 1 : 0) != 0);
            for (Map.Entry<MetricType, Long> metric : p.entrySet()) {
                MetricType metricType = metric.getKey();
                long metricValue = metric.getValue();
                if (metricType.equals((Object)MetricType.TASK_EXECUTED_COUNTER)) {
                    Assert.assertEquals((long)tableSaltBuckets, (long)metricValue);
                    continue;
                }
                if (!metricType.equals((Object)MetricType.SCAN_BYTES)) continue;
                Assert.assertTrue((String)"Scan bytes read should be greater than zero", (metricValue > 0L ? 1 : 0) != 0);
            }
        }
        Assert.assertEquals((String)("There should have been read metrics only for one table: " + tableName), (long)1L, (long)numTables);
    }

    static void assertMutationMetrics(String tableName, int numRows, boolean isUpsert, Map<String, Map<MetricType, Long>> mutationMetrics) {
        for (Map.Entry<String, Map<MetricType, Long>> entry : mutationMetrics.entrySet()) {
            String t = entry.getKey();
            Assert.assertEquals((String)"Table names didn't match!", (Object)tableName, (Object)t);
            Map<MetricType, Long> p = entry.getValue();
            Assert.assertEquals((String)"There should have been eighteen metrics", (long)18L, (long)p.size());
            boolean mutationBatchSizePresent = false;
            boolean mutationCommitTimePresent = false;
            boolean mutationBytesPresent = false;
            boolean mutationBatchFailedPresent = false;
            boolean upsertBatchFailedSizePresent = false;
            boolean deleteBatchFailedSizePresent = false;
            boolean upsertBatchFailedCounterPresent = false;
            boolean deleteBatchFailedCounterPresent = false;
            boolean deleteMutationBytesPresent = false;
            boolean upsertMutationBytesPresent = false;
            boolean indexCommitFailureSizePresent = false;
            boolean deleteMutationSqlCounterPresent = false;
            boolean upsertMutationSqlCounterPresent = false;
            boolean upsertCommitTimeCounterPresent = false;
            boolean deleteCommitTimeCounterPresent = false;
            boolean mutationBatchCounterPresent = false;
            for (Map.Entry<MetricType, Long> metric : p.entrySet()) {
                MetricType metricType = metric.getKey();
                long metricValue = metric.getValue();
                if (metricType.equals((Object)MetricType.MUTATION_BATCH_SIZE)) {
                    Assert.assertEquals((String)"Mutation batch sizes didn't match!", (long)numRows, (long)metricValue);
                    mutationBatchSizePresent = true;
                    continue;
                }
                if (metricType.equals((Object)MetricType.MUTATION_COMMIT_TIME)) {
                    Assert.assertTrue((String)"Mutation commit time should be greater than zero", (metricValue > 0L ? 1 : 0) != 0);
                    mutationCommitTimePresent = true;
                    continue;
                }
                if (metricType.equals((Object)MetricType.MUTATION_BYTES)) {
                    Assert.assertTrue((String)"Mutation bytes size should be greater than zero", (metricValue > 0L ? 1 : 0) != 0);
                    mutationBytesPresent = true;
                    continue;
                }
                if (metricType.equals((Object)MetricType.MUTATION_BATCH_FAILED_SIZE)) {
                    Assert.assertEquals((String)"Zero failed mutations expected", (long)0L, (long)metricValue);
                    mutationBatchFailedPresent = true;
                    continue;
                }
                if (metricType.equals((Object)MetricType.UPSERT_BATCH_FAILED_SIZE)) {
                    Assert.assertEquals((String)"Zero failed upsert mutations size expected", (long)0L, (long)metricValue);
                    upsertBatchFailedSizePresent = true;
                    continue;
                }
                if (metricType.equals((Object)MetricType.DELETE_BATCH_FAILED_SIZE)) {
                    Assert.assertEquals((String)"Zero failed delete mutations size expected", (long)0L, (long)metricValue);
                    deleteBatchFailedSizePresent = true;
                    continue;
                }
                if (metricType.equals((Object)MetricType.UPSERT_BATCH_FAILED_COUNTER)) {
                    Assert.assertEquals((String)"Zero failed upsert mutations counter expected", (long)0L, (long)metricValue);
                    upsertBatchFailedCounterPresent = true;
                    continue;
                }
                if (metricType.equals((Object)MetricType.DELETE_BATCH_FAILED_COUNTER)) {
                    Assert.assertEquals((String)"Zero failed delete mutations counter expected", (long)0L, (long)metricValue);
                    deleteBatchFailedCounterPresent = true;
                    continue;
                }
                if (metricType.equals((Object)MetricType.DELETE_MUTATION_BYTES)) {
                    if (isUpsert) {
                        Assert.assertEquals((String)"Zero delete mutation bytes size expected", (long)0L, (long)metricValue);
                    } else {
                        Assert.assertTrue((String)"Delete mutation bytes size should be greater than zero", (metricValue > 0L ? 1 : 0) != 0);
                    }
                    deleteMutationBytesPresent = true;
                    continue;
                }
                if (metricType.equals((Object)MetricType.UPSERT_MUTATION_BYTES)) {
                    if (isUpsert) {
                        Assert.assertTrue((String)"Upsert mutation bytes size should be greater than zero", (metricValue > 0L ? 1 : 0) != 0);
                    } else {
                        Assert.assertEquals((String)"Zero Upsert mutation bytes size expected", (long)0L, (long)metricValue);
                    }
                    upsertMutationBytesPresent = true;
                    continue;
                }
                if (metricType.equals((Object)MetricType.INDEX_COMMIT_FAILURE_SIZE)) {
                    Assert.assertEquals((String)"Zero index commit failures expected", (long)0L, (long)metricValue);
                    indexCommitFailureSizePresent = true;
                    continue;
                }
                if (metricType.equals((Object)MetricType.DELETE_MUTATION_SQL_COUNTER)) {
                    if (isUpsert) {
                        Assert.assertEquals((String)"Zero delete mutations sql counter expected", (long)0L, (long)metricValue);
                    } else {
                        Assert.assertTrue((String)"Delete mutations sql counter should be greater than zero", (metricValue > 0L ? 1 : 0) != 0);
                    }
                    deleteMutationSqlCounterPresent = true;
                    continue;
                }
                if (metricType.equals((Object)MetricType.UPSERT_MUTATION_SQL_COUNTER)) {
                    if (isUpsert) {
                        Assert.assertTrue((String)"Upsert mutation sql counter should be greater than zero", (metricValue > 0L ? 1 : 0) != 0);
                    } else {
                        Assert.assertEquals((String)"Zero upsert mutations sql counter expected", (long)0L, (long)metricValue);
                    }
                    upsertMutationSqlCounterPresent = true;
                    continue;
                }
                if (metricType.equals((Object)MetricType.UPSERT_COMMIT_TIME)) {
                    if (isUpsert) {
                        Assert.assertTrue((String)"Upsert commit time counter should be greater than zero", (metricValue > 0L ? 1 : 0) != 0);
                    } else {
                        Assert.assertEquals((String)"Zero upsert commit time counter expected", (long)0L, (long)metricValue);
                    }
                    upsertCommitTimeCounterPresent = true;
                    continue;
                }
                if (metricType.equals((Object)MetricType.DELETE_COMMIT_TIME)) {
                    if (!isUpsert) {
                        Assert.assertTrue((String)"delete commit time counter should be greater than zero", (metricValue > 0L ? 1 : 0) != 0);
                    } else {
                        Assert.assertEquals((String)"Zero delete commit time counter expected", (long)0L, (long)metricValue);
                    }
                    deleteCommitTimeCounterPresent = true;
                    continue;
                }
                if (!metricType.equals((Object)MetricType.MUTATION_BATCH_COUNTER)) continue;
                Assert.assertTrue((String)"mutation batch success counter should be greater than zero", (metricValue > 0L ? 1 : 0) != 0);
                mutationBatchCounterPresent = true;
            }
            Assert.assertTrue((boolean)mutationBatchSizePresent);
            Assert.assertTrue((boolean)mutationCommitTimePresent);
            Assert.assertTrue((boolean)mutationBytesPresent);
            Assert.assertTrue((boolean)mutationBatchFailedPresent);
            Assert.assertTrue((boolean)deleteMutationBytesPresent);
            Assert.assertTrue((boolean)upsertMutationBytesPresent);
            Assert.assertTrue((boolean)indexCommitFailureSizePresent);
            Assert.assertTrue((boolean)deleteMutationSqlCounterPresent);
            Assert.assertTrue((boolean)upsertMutationSqlCounterPresent);
            Assert.assertTrue((boolean)upsertBatchFailedSizePresent);
            Assert.assertTrue((boolean)deleteBatchFailedSizePresent);
            Assert.assertTrue((boolean)upsertBatchFailedCounterPresent);
            Assert.assertTrue((boolean)deleteBatchFailedCounterPresent);
            Assert.assertTrue((boolean)upsertCommitTimeCounterPresent);
            Assert.assertTrue((boolean)deleteCommitTimeCounterPresent);
            Assert.assertTrue((boolean)mutationBatchCounterPresent);
        }
    }
}

