/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.monitoring;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.hbase.thirdparty.com.google.common.collect.UnmodifiableIterator;
import org.apache.phoenix.monitoring.HTableThreadPoolHistograms;
import org.apache.phoenix.monitoring.HistogramDistribution;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.util.PhoenixRuntime;
import org.junit.Assert;

public class BaseHTableThreadPoolMetricsIT
extends BaseTest {
    private static final int ROWS_TO_LOAD_INITIALLY = 10000;

    protected void assertHistogramTags(Map<String, List<HistogramDistribution>> htableThreadPoolHistograms, Map<String, String> expectedTagKeyValues, String histogramKey) throws SQLException {
        List<HistogramDistribution> histograms = htableThreadPoolHistograms.get(histogramKey);
        Assert.assertEquals((long)2L, (long)histograms.size());
        for (HistogramDistribution histogram : histograms) {
            ImmutableMap tags = histogram.getTags();
            Assert.assertEquals(expectedTagKeyValues.keySet(), tags.keySet());
            for (Map.Entry tag : tags.entrySet()) {
                String tagName = (String)tag.getKey();
                Assert.assertEquals((Object)expectedTagKeyValues.get(tagName), tags.get(tagName));
            }
        }
    }

    protected void assertHTableThreadPoolUsed(Map<String, List<HistogramDistribution>> htableThreadPoolHistograms, String histogramKey) {
        boolean foundActiveThreadsCountHistogram = false;
        boolean foundQueueSizeHistogram = false;
        List<HistogramDistribution> histograms = htableThreadPoolHistograms.get(histogramKey);
        Assert.assertEquals((long)2L, (long)histograms.size());
        for (HistogramDistribution histogram : histograms) {
            if (histogram.getHistoName().equals(HTableThreadPoolHistograms.HistogramName.ActiveThreadsCount.name())) {
                Assert.assertTrue((10000 <= ((Long)histogram.getPercentileDistributionMap().get((Object)"_num_ops")).intValue() ? 1 : 0) != 0);
                foundActiveThreadsCountHistogram = true;
                continue;
            }
            if (!histogram.getHistoName().equals(HTableThreadPoolHistograms.HistogramName.QueueSize.name())) continue;
            foundQueueSizeHistogram = true;
        }
        Assert.assertTrue((boolean)foundActiveThreadsCountHistogram);
        Assert.assertTrue((boolean)foundQueueSizeHistogram);
    }

    protected void assertHTableThreadPoolNotUsed(Map<String, List<HistogramDistribution>> htableThreadPoolHistograms, String histogramKey) {
        boolean foundActiveThreadsCountHistogram = false;
        boolean foundQueueSizeHistogram = false;
        List<HistogramDistribution> histograms = htableThreadPoolHistograms.get(histogramKey);
        Assert.assertEquals((long)2L, (long)histograms.size());
        for (HistogramDistribution histogram : histograms) {
            if (histogram.getHistoName().equals(HTableThreadPoolHistograms.HistogramName.ActiveThreadsCount.name())) {
                foundActiveThreadsCountHistogram = true;
            } else if (histogram.getHistoName().equals(HTableThreadPoolHistograms.HistogramName.QueueSize.name())) {
                foundQueueSizeHistogram = true;
            }
            Assert.assertFalse((boolean)histogram.getPercentileDistributionMap().isEmpty());
            UnmodifiableIterator unmodifiableIterator = histogram.getPercentileDistributionMap().values().iterator();
            while (unmodifiableIterator.hasNext()) {
                long value = (Long)unmodifiableIterator.next();
                Assert.assertEquals((long)0L, (long)value);
            }
        }
        Assert.assertTrue((boolean)foundActiveThreadsCountHistogram);
        Assert.assertTrue((boolean)foundQueueSizeHistogram);
    }

    protected Map<String, List<HistogramDistribution>> runQueryAndGetHistograms(Connection conn, String tableName) throws SQLException {
        Map htableThreadPoolHistograms;
        try (Statement stmt = conn.createStatement();){
            stmt.setFetchSize(1);
            try (ResultSet rs = stmt.executeQuery("SELECT * FROM " + tableName);){
                int rowsRead = 0;
                PhoenixRuntime.getHTableThreadPoolHistograms();
                while (rs.next()) {
                    ++rowsRead;
                }
                Assert.assertEquals((long)10000L, (long)rowsRead);
                htableThreadPoolHistograms = PhoenixRuntime.getHTableThreadPoolHistograms();
            }
        }
        return htableThreadPoolHistograms;
    }

    protected void createTableAndUpsertData(Connection conn, String tableName) throws SQLException {
        try (Statement stmt = conn.createStatement();){
            stmt.execute("CREATE TABLE " + tableName + " (k VARCHAR NOT NULL PRIMARY KEY, v VARCHAR)");
        }
        stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?, ?)");
        var4_4 = null;
        try {
            for (int i = 1; i <= 10000; ++i) {
                stmt.setString(1, "k" + i);
                stmt.setString(2, "v" + i);
                stmt.executeUpdate();
            }
            conn.commit();
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (stmt != null) {
                if (var4_4 != null) {
                    try {
                        stmt.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    stmt.close();
                }
            }
        }
    }
}

