/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.memory;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.phoenix.SystemExitRule;
import org.apache.phoenix.coprocessor.GroupedAggregateRegionObserver;
import org.apache.phoenix.memory.ChildMemoryManager;
import org.apache.phoenix.memory.GlobalMemoryManager;
import org.apache.phoenix.memory.InsufficientMemoryException;
import org.apache.phoenix.memory.MemoryManager;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Mockito;

public class MemoryManagerTest {
    @ClassRule
    public static final SystemExitRule SYSTEM_EXIT_RULE = new SystemExitRule();

    @Test
    public void testOverGlobalMemoryLimit() throws Exception {
        GlobalMemoryManager gmm = new GlobalMemoryManager(250L);
        try {
            gmm.allocate(300L);
            Assert.fail();
        }
        catch (InsufficientMemoryException insufficientMemoryException) {
            // empty catch block
        }
        ChildMemoryManager rmm1 = new ChildMemoryManager((MemoryManager)gmm, 100);
        ChildMemoryManager rmm2 = new ChildMemoryManager((MemoryManager)gmm, 100);
        MemoryManager.MemoryChunk c1 = rmm1.allocate(100L);
        MemoryManager.MemoryChunk c2 = rmm2.allocate(100L);
        try {
            rmm2.allocate(100L);
            Assert.fail();
        }
        catch (InsufficientMemoryException insufficientMemoryException) {
            // empty catch block
        }
        c1.close();
        c2.close();
        Assert.assertTrue((rmm1.getAvailableMemory() == rmm1.getMaxMemory() ? 1 : 0) != 0);
    }

    @Test
    public void testChildDecreaseAllocation() throws Exception {
        MemoryManager gmm = (MemoryManager)Mockito.spy((Object)new GlobalMemoryManager(100L));
        ChildMemoryManager rmm1 = new ChildMemoryManager(gmm, 100);
        ChildMemoryManager rmm2 = new ChildMemoryManager(gmm, 10);
        MemoryManager.MemoryChunk c1 = rmm1.allocate(50L);
        MemoryManager.MemoryChunk c2 = rmm2.allocate(5L, 50L);
        Assert.assertTrue((c2.getSize() == 10L ? 1 : 0) != 0);
        c1.close();
        Assert.assertTrue((rmm1.getAvailableMemory() == rmm1.getMaxMemory() ? 1 : 0) != 0);
        c2.close();
        Assert.assertTrue((rmm2.getAvailableMemory() == rmm2.getMaxMemory() ? 1 : 0) != 0);
        Assert.assertTrue((gmm.getAvailableMemory() == gmm.getMaxMemory() ? 1 : 0) != 0);
    }

    @Test
    public void testOverChildMemoryLimit() throws Exception {
        GlobalMemoryManager gmm = new GlobalMemoryManager(100L);
        ChildMemoryManager rmm1 = new ChildMemoryManager((MemoryManager)gmm, 25);
        ChildMemoryManager rmm2 = new ChildMemoryManager((MemoryManager)gmm, 25);
        ChildMemoryManager rmm3 = new ChildMemoryManager((MemoryManager)gmm, 25);
        ChildMemoryManager rmm4 = new ChildMemoryManager((MemoryManager)gmm, 35);
        MemoryManager.MemoryChunk c1 = rmm1.allocate(20L);
        MemoryManager.MemoryChunk c2 = rmm2.allocate(20L);
        try {
            rmm1.allocate(10L);
            Assert.fail();
        }
        catch (InsufficientMemoryException insufficientMemoryException) {
            // empty catch block
        }
        MemoryManager.MemoryChunk c3 = rmm3.allocate(25L);
        c1.close();
        MemoryManager.MemoryChunk c4 = rmm1.allocate(10L);
        MemoryManager.MemoryChunk c5 = rmm1.allocate(15L);
        MemoryManager.MemoryChunk c6 = rmm4.allocate(25L);
        try {
            rmm4.allocate(10L);
            Assert.fail();
        }
        catch (InsufficientMemoryException insufficientMemoryException) {
            // empty catch block
        }
        c2.close();
        MemoryManager.MemoryChunk c7 = rmm4.allocate(10L);
        try {
            rmm4.allocate(1L);
            Assert.fail();
        }
        catch (InsufficientMemoryException insufficientMemoryException) {
            // empty catch block
        }
        try {
            rmm2.allocate(25L);
            Assert.fail();
        }
        catch (InsufficientMemoryException insufficientMemoryException) {
            // empty catch block
        }
        c3.close();
        c4.close();
        c5.close();
        c6.close();
        c7.close();
        Assert.assertTrue((rmm1.getAvailableMemory() == rmm1.getMaxMemory() ? 1 : 0) != 0);
        Assert.assertTrue((rmm2.getAvailableMemory() == rmm2.getMaxMemory() ? 1 : 0) != 0);
        Assert.assertTrue((rmm3.getAvailableMemory() == rmm3.getMaxMemory() ? 1 : 0) != 0);
        Assert.assertTrue((rmm4.getAvailableMemory() == rmm4.getMaxMemory() ? 1 : 0) != 0);
    }

    @Test
    public void testConcurrentAllocation() throws Exception {
        int THREADS = 100;
        final GlobalMemoryManager gmm = new GlobalMemoryManager((long)(THREADS * 1000));
        final AtomicInteger count = new AtomicInteger(0);
        final CountDownLatch barrier = new CountDownLatch(THREADS);
        final CountDownLatch barrier2 = new CountDownLatch(THREADS);
        final CountDownLatch signal = new CountDownLatch(1);
        for (int i = 0; i < THREADS; ++i) {
            new Thread(new Runnable(){
                List<MemoryManager.MemoryChunk> chunks = new ArrayList<MemoryManager.MemoryChunk>();

                @Override
                public void run() {
                    try {
                        while (true) {
                            Thread.sleep(1L);
                            this.chunks.add(gmm.allocate(10L));
                            count.incrementAndGet();
                        }
                    }
                    catch (InsufficientMemoryException e) {
                        barrier.countDown();
                        try {
                            signal.await();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        for (MemoryManager.MemoryChunk chunk : this.chunks) {
                            chunk.close();
                        }
                        barrier2.countDown();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }).start();
        }
        barrier.await();
        Assert.assertTrue((gmm.getAvailableMemory() == 0L ? 1 : 0) != 0);
        signal.countDown();
        barrier2.await();
        Assert.assertTrue((gmm.getAvailableMemory() == gmm.getMaxMemory() ? 1 : 0) != 0);
    }

    @Test
    public void testCorrectnessOfChunkAllocation() throws Exception {
        int i = 1000;
        while (i < Integer.MAX_VALUE) {
            long result = GroupedAggregateRegionObserver.sizeOfUnorderedGroupByMap((int)(i = (int)((float)i * 1.5f)), (int)100);
            Assert.assertTrue((String)"Size for GroupByMap is negative", (result > 0L ? 1 : 0) != 0);
        }
    }
}

