/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce.util;

import java.sql.SQLException;
import java.util.List;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.mapreduce.index.BaseIndexTest;
import org.apache.phoenix.mapreduce.util.IndexColumnNames;
import org.apache.phoenix.parse.HintNode;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.util.QueryUtil;
import org.junit.Assert;
import org.junit.Test;

public class IndexColumnNamesTest
extends BaseIndexTest {
    private static final String DYNAMIC_COL_DDL = "CREATE TABLE IF NOT EXISTS PRECISION_NAME_TEST\n(\n    CHAR_TEST CHAR(15) NOT NULL primary key,\n    VARCHAR_TEST VARCHAR(1),\n    DECIMAL_TEST DECIMAL(10,2),\n    BINARY_TEST BINARY(11),\n    VARCHAR_UNSPEC VARCHAR,\n    DEC_UNSPEC DECIMAL\n)";
    private static final String DYNAMIC_COL_IDX_DDL = "CREATE INDEX PRECISION_NAME_IDX_TEST ON PRECISION_NAME_TEST(VARCHAR_TEST) INCLUDE (CHAR_TEST,DECIMAL_TEST,BINARY_TEST,VARCHAR_UNSPEC,DEC_UNSPEC)";

    @Test
    public void testGetColumnNames() {
        IndexColumnNames indexColumnNames = new IndexColumnNames(this.pDataTable, this.pIndexTable);
        Assert.assertEquals((Object)"[ID, PK_PART2, 0.NAME, 0.ZIP]", (Object)indexColumnNames.getDataColNames().toString());
        Assert.assertEquals((Object)"[:ID, :PK_PART2, 0:NAME, 0:ZIP]", (Object)indexColumnNames.getIndexColNames().toString());
        Assert.assertEquals((Object)"[:ID, :PK_PART2, 0:NAME]", (Object)indexColumnNames.getIndexPkColNames().toString());
        Assert.assertEquals((Object)"[ID, PK_PART2]", (Object)indexColumnNames.getDataPkColNames().toString());
        Assert.assertEquals((Object)"[0.NAME, 0.ZIP]", (Object)indexColumnNames.getDataNonPkColNames().toString());
        Assert.assertEquals((Object)"[\"ID\" INTEGER, \"PK_PART2\" TINYINT, \"NAME\" VARCHAR, \"ZIP\" BIGINT]", (Object)indexColumnNames.getDynamicDataCols().toString());
        Assert.assertEquals((Object)"[\":ID\" INTEGER, \":PK_PART2\" TINYINT, \"0:NAME\" VARCHAR, \"0:ZIP\" BIGINT]", (Object)indexColumnNames.getDynamicIndexCols().toString());
        Assert.assertEquals((Object)"UPSERT /*+ NO_INDEX */  INTO TEST_SCHEMA.TEST_INDEX_COLUMN_NAMES_UTIL (\"ID\" INTEGER, \"PK_PART2\" TINYINT, \"NAME\" VARCHAR, \"ZIP\" BIGINT) VALUES (?, ?, ?, ?)", (Object)QueryUtil.constructUpsertStatement((String)"TEST_SCHEMA.TEST_INDEX_COLUMN_NAMES_UTIL", (List)indexColumnNames.getDynamicDataCols(), (HintNode.Hint)HintNode.Hint.NO_INDEX));
    }

    @Test
    public void testGetDynamicColPrecision() throws SQLException {
        this.conn.createStatement().execute(DYNAMIC_COL_DDL);
        this.conn.createStatement().execute(DYNAMIC_COL_IDX_DDL);
        PhoenixConnection pconn = this.conn.unwrap(PhoenixConnection.class);
        this.pDataTable = pconn.getTable(new PTableKey(pconn.getTenantId(), "PRECISION_NAME_TEST"));
        this.pIndexTable = pconn.getTable(new PTableKey(pconn.getTenantId(), "PRECISION_NAME_IDX_TEST"));
        IndexColumnNames indexColumnNames = new IndexColumnNames(this.pDataTable, this.pIndexTable);
        Assert.assertEquals((Object)"[\"CHAR_TEST\" CHAR(15), \"VARCHAR_TEST\" VARCHAR(1), \"DECIMAL_TEST\" DECIMAL(10,2), \"BINARY_TEST\" BINARY(11), \"VARCHAR_UNSPEC\" VARCHAR, \"DEC_UNSPEC\" DECIMAL]", (Object)indexColumnNames.getDynamicDataCols().toString());
        Assert.assertEquals((Object)"[\":CHAR_TEST\" CHAR(15), \"0:VARCHAR_TEST\" VARCHAR(1), \"0:DECIMAL_TEST\" DECIMAL(10,2), \"0:BINARY_TEST\" BINARY(11), \"0:VARCHAR_UNSPEC\" VARCHAR, \"0:DEC_UNSPEC\" DECIMAL]", (Object)indexColumnNames.getDynamicIndexCols().toString());
    }
}

