/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce.bulkload;

import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.mapreduce.bulkload.TableRowkeyPair;
import org.junit.Assert;
import org.junit.Test;

public class TestTableRowkeyPair {
    @Test
    public void testRowkeyPair() throws IOException {
        this.testsRowsKeys("first", "aa", "first", "aa", 0);
        this.testsRowsKeys("first", "aa", "first", "ab", -1);
        this.testsRowsKeys("second", "aa", "first", "aa", 1);
        this.testsRowsKeys("first", "aa", "first", "aaa", -1);
        this.testsRowsKeys("first", "bb", "first", "aaaa", 1);
    }

    private void testsRowsKeys(String aTable, String akey, String bTable, String bkey, int expectedSignum) throws IOException {
        ImmutableBytesWritable arowkey = new ImmutableBytesWritable(Bytes.toBytes((String)akey));
        TableRowkeyPair pair1 = new TableRowkeyPair(aTable, arowkey);
        ImmutableBytesWritable browkey = new ImmutableBytesWritable(Bytes.toBytes((String)bkey));
        TableRowkeyPair pair2 = new TableRowkeyPair(bTable, browkey);
        TableRowkeyPair.Comparator comparator = new TableRowkeyPair.Comparator();
        try (ByteArrayOutputStream baosA = new ByteArrayOutputStream();
             ByteArrayOutputStream baosB = new ByteArrayOutputStream();){
            pair1.write((DataOutput)new DataOutputStream(baosA));
            pair2.write((DataOutput)new DataOutputStream(baosB));
            Assert.assertEquals((long)expectedSignum, (long)this.signum(pair1.compareTo(pair2)));
            Assert.assertEquals((long)expectedSignum, (long)this.signum(comparator.compare(baosA.toByteArray(), 0, baosA.size(), baosB.toByteArray(), 0, baosB.size())));
            Assert.assertEquals((long)expectedSignum, (long)(-this.signum(comparator.compare(baosB.toByteArray(), 0, baosB.size(), baosA.toByteArray(), 0, baosA.size()))));
        }
    }

    private int signum(int i) {
        return i > 0 ? 1 : (i == 0 ? 0 : -1);
    }
}

