/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce;

import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.mapreduce.PhoenixServerBuildIndexInputFormat;
import org.apache.phoenix.mapreduce.index.IndexScrutinyTool;
import org.apache.phoenix.mapreduce.util.PhoenixConfigurationUtil;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class PhoenixServerBuildIndexInputFormatIT
extends ParallelStatsDisabledIT {
    @Test
    public void testQueryPlanWithSource() throws Exception {
        Configuration conf = new Configuration(PhoenixServerBuildIndexInputFormatIT.getUtility().getConfiguration());
        String schemaName = PhoenixServerBuildIndexInputFormatIT.generateUniqueName();
        String dataTableName = PhoenixServerBuildIndexInputFormatIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        String indexTableName = PhoenixServerBuildIndexInputFormatIT.generateUniqueName();
        String indexTableFullName = SchemaUtil.getTableName((String)schemaName, (String)indexTableName);
        String viewName = PhoenixServerBuildIndexInputFormatIT.generateUniqueName();
        String viewFullName = SchemaUtil.getTableName((String)schemaName, (String)viewName);
        String viewIndexName = PhoenixServerBuildIndexInputFormatIT.generateUniqueName();
        String viewIndexFullName = SchemaUtil.getTableName((String)schemaName, (String)viewIndexName);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(PhoenixServerBuildIndexInputFormatIT.getUrl(), props);){
            conn.createStatement().execute("CREATE TABLE " + dataTableFullName + " (ID INTEGER NOT NULL PRIMARY KEY, VAL1 INTEGER, VAL2 INTEGER) ");
            conn.createStatement().execute(String.format("CREATE INDEX %s ON %s (VAL1) INCLUDE (VAL2)", indexTableName, dataTableFullName));
            conn.createStatement().execute("CREATE VIEW " + viewFullName + " AS SELECT * FROM " + dataTableFullName);
            conn.commit();
            conn.createStatement().execute(String.format("CREATE INDEX %s ON %s (VAL1) INCLUDE (VAL2)", viewIndexName, viewFullName));
            PhoenixConfigurationUtil.setIndexToolDataTableName((Configuration)conf, (String)dataTableFullName);
            PhoenixConfigurationUtil.setIndexToolIndexTableName((Configuration)conf, (String)indexTableFullName);
            this.assertTableSource(conf, conn);
            PhoenixConfigurationUtil.setIndexToolSourceTable((Configuration)conf, (IndexScrutinyTool.SourceTable)IndexScrutinyTool.SourceTable.INDEX_TABLE_SOURCE);
            this.assertTableSource(conf, conn);
            PhoenixConfigurationUtil.setIndexToolDataTableName((Configuration)conf, (String)viewFullName);
            PhoenixConfigurationUtil.setIndexToolIndexTableName((Configuration)conf, (String)viewIndexFullName);
            PhoenixConfigurationUtil.setIndexToolSourceTable((Configuration)conf, (IndexScrutinyTool.SourceTable)IndexScrutinyTool.SourceTable.DATA_TABLE_SOURCE);
            this.assertTableSource(conf, conn);
            PhoenixConfigurationUtil.setIndexToolSourceTable((Configuration)conf, (IndexScrutinyTool.SourceTable)IndexScrutinyTool.SourceTable.INDEX_TABLE_SOURCE);
            this.assertTableSource(conf, conn);
        }
    }

    private void assertTableSource(Configuration conf, Connection conn) throws Exception {
        String dataTableFullName = PhoenixConfigurationUtil.getIndexToolDataTableName((Configuration)conf);
        String indexTableFullName = PhoenixConfigurationUtil.getIndexToolIndexTableName((Configuration)conf);
        IndexScrutinyTool.SourceTable sourceTable = PhoenixConfigurationUtil.getIndexToolSourceTable((Configuration)conf);
        boolean fromIndex = sourceTable.equals((Object)IndexScrutinyTool.SourceTable.INDEX_TABLE_SOURCE);
        PTable pDataTable = conn.unwrap(PhoenixConnection.class).getTable(dataTableFullName);
        PTable pIndexTable = conn.unwrap(PhoenixConnection.class).getTable(indexTableFullName);
        PhoenixServerBuildIndexInputFormat inputFormat = new PhoenixServerBuildIndexInputFormat();
        QueryPlan queryPlan = inputFormat.getQueryPlan((JobContext)Job.getInstance(), conf);
        PTable actual = queryPlan.getTableRef().getTable();
        if (!fromIndex) {
            Assert.assertEquals((Object)pDataTable, (Object)actual);
        } else {
            Assert.assertEquals((Object)pIndexTable, (Object)actual);
        }
    }
}

