/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.phoenix.mapreduce.FormatToBytesWritableMapper;
import org.apache.phoenix.mapreduce.ImportPreUpsertKeyValueProcessor;
import org.apache.phoenix.mapreduce.util.PhoenixConfigurationUtil;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PIntegerArray;
import org.apache.phoenix.schema.types.PUnsignedInt;
import org.apache.phoenix.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.ColumnInfo;
import org.junit.Assert;
import org.junit.Test;

public class FormatToBytesWritableMapperTest {
    @Test
    public void testBuildColumnInfoList() {
        ImmutableList columnInfoList = ImmutableList.of((Object)new ColumnInfo("idCol", PInteger.INSTANCE.getSqlType()), (Object)new ColumnInfo("unsignedIntCol", PUnsignedInt.INSTANCE.getSqlType()), (Object)new ColumnInfo("stringArrayCol", PIntegerArray.INSTANCE.getSqlType()));
        Configuration conf = new Configuration();
        FormatToBytesWritableMapper.configureColumnInfoList((Configuration)conf, (List)columnInfoList);
        List fromConfig = FormatToBytesWritableMapper.buildColumnInfoList((Configuration)conf);
        Assert.assertEquals((Object)columnInfoList, (Object)fromConfig);
    }

    @Test
    public void testBuildColumnInfoList_ContainingNulls() {
        ArrayList columnInfoListWithNull = Lists.newArrayList((Object[])new ColumnInfo[]{new ColumnInfo("idCol", PInteger.INSTANCE.getSqlType()), null, new ColumnInfo("unsignedIntCol", PUnsignedInt.INSTANCE.getSqlType()), new ColumnInfo("stringArrayCol", PIntegerArray.INSTANCE.getSqlType())});
        Configuration conf = new Configuration();
        FormatToBytesWritableMapper.configureColumnInfoList((Configuration)conf, (List)columnInfoListWithNull);
        List fromConfig = FormatToBytesWritableMapper.buildColumnInfoList((Configuration)conf);
        Assert.assertEquals((Object)columnInfoListWithNull, (Object)fromConfig);
    }

    @Test
    public void testLoadPreUpdateProcessor() {
        Configuration conf = new Configuration();
        conf.setClass("phoenix.mapreduce.import.kvprocessor", MockUpsertProcessor.class, ImportPreUpsertKeyValueProcessor.class);
        ImportPreUpsertKeyValueProcessor processor = PhoenixConfigurationUtil.loadPreUpsertProcessor((Configuration)conf);
        Assert.assertEquals(MockUpsertProcessor.class, processor.getClass());
    }

    @Test
    public void testLoadPreUpdateProcessor_NotConfigured() {
        Configuration conf = new Configuration();
        ImportPreUpsertKeyValueProcessor processor = PhoenixConfigurationUtil.loadPreUpsertProcessor((Configuration)conf);
        Assert.assertEquals(FormatToBytesWritableMapper.DefaultImportPreUpsertKeyValueProcessor.class, processor.getClass());
    }

    @Test(expected=IllegalStateException.class)
    public void testLoadPreUpdateProcessor_ClassNotFound() {
        Configuration conf = new Configuration();
        conf.set("phoenix.mapreduce.import.kvprocessor", "MyUndefinedClass");
        PhoenixConfigurationUtil.loadPreUpsertProcessor((Configuration)conf);
    }

    static class MockUpsertProcessor
    implements ImportPreUpsertKeyValueProcessor {
        MockUpsertProcessor() {
        }

        public List<Cell> preUpsert(byte[] rowKey, List<Cell> keyValues) {
            throw new UnsupportedOperationException("Not yet implemented");
        }
    }
}

