/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.phoenix.mapreduce.CsvBulkImportUtil;
import org.apache.phoenix.mapreduce.ImportPreUpsertKeyValueProcessor;
import org.apache.phoenix.mapreduce.util.PhoenixConfigurationUtil;
import org.junit.Assert;
import org.junit.Test;

public class CsvBulkImportUtilTest {
    @Test
    public void testInitCsvImportJob() throws IOException {
        Configuration conf = new Configuration();
        char delimiter = '\u0001';
        char quote = '\u0002';
        char escape = '!';
        CsvBulkImportUtil.initCsvImportJob((Configuration)conf, (char)delimiter, (Character)Character.valueOf(quote), (Character)Character.valueOf(escape), null, null);
        File tempFile = File.createTempFile("test-config", ".xml");
        FileOutputStream fileOutputStream = new FileOutputStream(tempFile);
        conf.writeXml((OutputStream)fileOutputStream);
        fileOutputStream.close();
        Configuration deserialized = new Configuration();
        deserialized.addResource((InputStream)new FileInputStream(tempFile));
        Assert.assertEquals((Object)Character.valueOf('\u0001'), (Object)CsvBulkImportUtil.getCharacter((Configuration)deserialized, (String)"phoenix.mapreduce.import.fielddelimiter"));
        Assert.assertEquals((Object)Character.valueOf('\u0002'), (Object)CsvBulkImportUtil.getCharacter((Configuration)deserialized, (String)"phoenix.mapreduce.import.quotechar"));
        Assert.assertEquals((Object)Character.valueOf('!'), (Object)CsvBulkImportUtil.getCharacter((Configuration)deserialized, (String)"phoenix.mapreduce.import.escapechar"));
        Assert.assertNull((Object)deserialized.get("phoenix.mapreduce.import.arraydelimiter"));
        tempFile.delete();
    }

    @Test
    public void testConfigurePreUpsertProcessor() {
        Configuration conf = new Configuration();
        CsvBulkImportUtil.configurePreUpsertProcessor((Configuration)conf, MockProcessor.class);
        ImportPreUpsertKeyValueProcessor processor = PhoenixConfigurationUtil.loadPreUpsertProcessor((Configuration)conf);
        Assert.assertEquals(MockProcessor.class, processor.getClass());
    }

    @Test
    public void testGetAndSetChar_BasicChar() {
        Configuration conf = new Configuration();
        CsvBulkImportUtil.setChar((Configuration)conf, (String)"conf.key", (Character)Character.valueOf('|'));
        Assert.assertEquals((Object)Character.valueOf('|'), (Object)CsvBulkImportUtil.getCharacter((Configuration)conf, (String)"conf.key"));
    }

    @Test
    public void testGetAndSetChar_NonPrintableChar() {
        Configuration conf = new Configuration();
        CsvBulkImportUtil.setChar((Configuration)conf, (String)"conf.key", (Character)Character.valueOf('\u0001'));
        Assert.assertEquals((Object)Character.valueOf('\u0001'), (Object)CsvBulkImportUtil.getCharacter((Configuration)conf, (String)"conf.key"));
    }

    @Test
    public void testGetChar_NotPresent() {
        Configuration conf = new Configuration();
        Assert.assertNull((Object)CsvBulkImportUtil.getCharacter((Configuration)conf, (String)"conf.key"));
    }

    public static class MockProcessor
    implements ImportPreUpsertKeyValueProcessor {
        public List<Cell> preUpsert(byte[] rowKey, List<Cell> keyValues) {
            throw new UnsupportedOperationException("Not yet implemented");
        }
    }
}

