/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.phoenix.end2end.ConnectionQueryServicesTestImpl;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.jdbc.ConnectionInfo;
import org.apache.phoenix.jdbc.PhoenixEmbeddedDriver;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.query.ConnectionlessQueryServicesImpl;
import org.apache.phoenix.query.QueryServices;
import org.apache.phoenix.query.QueryServicesTestImpl;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.ReadOnlyProps;

@ThreadSafe
public class PhoenixTestDriver
extends PhoenixEmbeddedDriver {
    private final ReadOnlyProps overrideProps;
    private final QueryServices queryServices;
    private final Map<ConnectionInfo, ConnectionQueryServices> connectionQueryServicesMap = new HashMap<ConnectionInfo, ConnectionQueryServices>();
    @GuardedBy(value="closeLock")
    private volatile boolean closed = false;
    private final ReadWriteLock closeLock = new ReentrantReadWriteLock();

    public PhoenixTestDriver() {
        this(ReadOnlyProps.EMPTY_PROPS);
    }

    public PhoenixTestDriver(ReadOnlyProps props) {
        this.overrideProps = props;
        this.queryServices = new QueryServicesTestImpl(this.getDefaultProps(), this.overrideProps);
    }

    public QueryServices getQueryServices() throws SQLException {
        this.lockInterruptibly(LockMode.READ);
        try {
            this.checkClosed();
            QueryServices queryServices = this.queryServices;
            return queryServices;
        }
        finally {
            this.unlock(LockMode.READ);
        }
    }

    public boolean acceptsURL(String url) throws SQLException {
        return super.acceptsURL(url) && PhoenixTestDriver.isTestUrl((String)url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection connect(String url, Properties info) throws SQLException {
        this.lockInterruptibly(LockMode.READ);
        try {
            this.checkClosed();
            Connection connection = super.connect(url, info);
            return connection;
        }
        finally {
            this.unlock(LockMode.READ);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionQueryServices getConnectionQueryServices(String url, Properties infoIn) throws SQLException {
        this.lockInterruptibly(LockMode.READ);
        try {
            this.checkClosed();
            Properties info = PropertiesUtil.deepCopy((Properties)infoIn);
            ConnectionInfo connInfo = ConnectionInfo.create((String)url, null, (Properties)info);
            Object connectionQueryServices = this.connectionQueryServicesMap.get(connInfo);
            if (connectionQueryServices != null) {
                ConnectionQueryServices connectionQueryServices2 = connectionQueryServices;
                return connectionQueryServices2;
            }
            info.putAll((Map<?, ?>)connInfo.asProps().asMap());
            connectionQueryServices = connInfo.isConnectionless() ? new ConnectionlessQueryServicesImpl(this.queryServices, connInfo, info) : new ConnectionQueryServicesTestImpl(this.queryServices, connInfo, info);
            connectionQueryServices.init(url, info);
            this.connectionQueryServicesMap.put(connInfo, (ConnectionQueryServices)connectionQueryServices);
            Object object = connectionQueryServices;
            return object;
        }
        finally {
            this.unlock(LockMode.READ);
        }
    }

    public void cleanUpCQSICache() throws SQLException {
        this.lockInterruptibly(LockMode.WRITE);
        try {
            for (ConnectionQueryServices service : this.connectionQueryServicesMap.values()) {
                service.close();
            }
            this.connectionQueryServicesMap.clear();
        }
        finally {
            this.unlock(LockMode.WRITE);
        }
    }

    @GuardedBy(value="closeLock")
    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("The Phoenix jdbc test driver has been closed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        this.lockInterruptibly(LockMode.WRITE);
        try {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        finally {
            this.unlock(LockMode.WRITE);
        }
        try {
            for (ConnectionQueryServices cqs : this.connectionQueryServicesMap.values()) {
                cqs.close();
            }
        }
        finally {
            ThreadPoolExecutor executor = this.queryServices.getExecutor();
            try {
                this.queryServices.close();
            }
            finally {
                if (executor != null) {
                    executor.shutdownNow();
                }
                this.connectionQueryServicesMap.clear();
            }
        }
    }

    private void lockInterruptibly(LockMode mode) throws SQLException {
        Preconditions.checkNotNull((Object)((Object)mode));
        switch (mode) {
            case READ: {
                try {
                    this.closeLock.readLock().lockInterruptibly();
                    break;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.INTERRUPTED_EXCEPTION).setRootCause((Throwable)e).build().buildException();
                }
            }
            case WRITE: {
                try {
                    this.closeLock.writeLock().lockInterruptibly();
                    break;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.INTERRUPTED_EXCEPTION).setRootCause((Throwable)e).build().buildException();
                }
            }
        }
    }

    private void unlock(LockMode mode) {
        Preconditions.checkNotNull((Object)((Object)mode));
        switch (mode) {
            case READ: {
                this.closeLock.readLock().unlock();
                break;
            }
            case WRITE: {
                this.closeLock.writeLock().unlock();
            }
        }
    }

    private static enum LockMode {
        READ,
        WRITE;

    }
}

