/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.query.BaseConnectionlessQueryTest;
import org.junit.Assert;
import org.junit.Test;

public class PhoenixResultSetMetadataTest
extends BaseConnectionlessQueryTest {
    @Test
    public void testColumnDisplaySize() throws Exception {
        Connection conn = DriverManager.getConnection(PhoenixResultSetMetadataTest.getUrl());
        conn.createStatement().execute("CREATE TABLE T (pk1 CHAR(15) not null, pk2 VARCHAR not null,  v1 VARCHAR(15), v2 DATE, v3 VARCHAR CONSTRAINT pk PRIMARY KEY (pk1, pk2)) ");
        ResultSet rs = conn.createStatement().executeQuery("SELECT pk1, pk2, v1, v2, CAST(null AS varchar) FROM T");
        Assert.assertEquals((long)15L, (long)rs.getMetaData().getColumnDisplaySize(1));
        Assert.assertEquals((long)40L, (long)rs.getMetaData().getColumnDisplaySize(2));
        Assert.assertEquals((long)15L, (long)rs.getMetaData().getColumnDisplaySize(3));
        Assert.assertEquals((long)conn.unwrap(PhoenixConnection.class).getDatePattern().length(), (long)rs.getMetaData().getColumnDisplaySize(4));
        Assert.assertEquals((long)40L, (long)rs.getMetaData().getColumnDisplaySize(5));
    }

    @Test
    public void testNullTypeName() throws Exception {
        Connection conn = DriverManager.getConnection(PhoenixResultSetMetadataTest.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("select null");
        Assert.assertEquals((Object)"NULL", (Object)rs.getMetaData().getColumnTypeName(1));
    }

    @Test
    public void testCaseSensitiveExpression() throws Exception {
        Connection conn = DriverManager.getConnection(PhoenixResultSetMetadataTest.getUrl());
        conn.createStatement().execute("CREATE TABLE T (pk1 CHAR(15) not null, pk2 VARCHAR not null,  \"v1\" VARCHAR(15), v2 DATE, \"v3\" VARCHAR CONSTRAINT pk PRIMARY KEY (pk1, pk2)) ");
        ResultSet rs = conn.createStatement().executeQuery("SELECT pk1 AS testalias1, pk2 AS \"testalias2\", \"v1\" AS \"testalias3\", v2, \"v3\" FROM T");
        Assert.assertEquals((Object)"PK1", (Object)rs.getMetaData().getColumnName(1));
        Assert.assertEquals((Object)"TESTALIAS1", (Object)rs.getMetaData().getColumnLabel(1));
        Assert.assertFalse((boolean)rs.getMetaData().isCaseSensitive(1));
        Assert.assertEquals((Object)"PK2", (Object)rs.getMetaData().getColumnName(2));
        Assert.assertEquals((Object)"testalias2", (Object)rs.getMetaData().getColumnLabel(2));
        Assert.assertTrue((boolean)rs.getMetaData().isCaseSensitive(2));
        Assert.assertEquals((Object)"v1", (Object)rs.getMetaData().getColumnName(3));
        Assert.assertEquals((Object)"testalias3", (Object)rs.getMetaData().getColumnLabel(3));
        Assert.assertTrue((boolean)rs.getMetaData().isCaseSensitive(3));
        Assert.assertEquals((Object)"V2", (Object)rs.getMetaData().getColumnName(4));
        Assert.assertEquals((Object)"V2", (Object)rs.getMetaData().getColumnLabel(4));
        Assert.assertFalse((boolean)rs.getMetaData().isCaseSensitive(4));
        Assert.assertEquals((Object)"v3", (Object)rs.getMetaData().getColumnName(5));
        Assert.assertEquals((Object)"v3", (Object)rs.getMetaData().getColumnLabel(5));
        Assert.assertTrue((boolean)rs.getMetaData().isCaseSensitive(5));
    }

    @Test
    public void testLabel() throws Exception {
        Connection conn = DriverManager.getConnection(PhoenixResultSetMetadataTest.getUrl());
        conn.createStatement().execute("CREATE TABLE T (pk1 CHAR(15) not null, pk2 VARCHAR not null,  v1 VARCHAR(15), v2 DATE, v3 VARCHAR CONSTRAINT pk PRIMARY KEY (pk1, pk2)) ");
        ResultSet rs = conn.createStatement().executeQuery("SELECT pk1 AS testalias1, pk2, v1 AS testalias2, v2 FROM T");
        Assert.assertEquals((Object)"PK1", (Object)rs.getMetaData().getColumnName(1));
        Assert.assertEquals((Object)"TESTALIAS1", (Object)rs.getMetaData().getColumnLabel(1));
        Assert.assertEquals((Object)"PK2", (Object)rs.getMetaData().getColumnName(2));
        Assert.assertEquals((Object)"PK2", (Object)rs.getMetaData().getColumnLabel(2));
        Assert.assertEquals((Object)"V1", (Object)rs.getMetaData().getColumnName(3));
        Assert.assertEquals((Object)"TESTALIAS2", (Object)rs.getMetaData().getColumnLabel(3));
        Assert.assertEquals((Object)"V2", (Object)rs.getMetaData().getColumnName(4));
        Assert.assertEquals((Object)"V2", (Object)rs.getMetaData().getColumnLabel(4));
    }

    @Test
    public void testSummandExpression() throws Exception {
        Connection conn = DriverManager.getConnection(PhoenixResultSetMetadataTest.getUrl());
        conn.createStatement().execute("CREATE TABLE T (pk1 CHAR(15) not null, pk2 INTEGER not null,  v1 VARCHAR(15), v2 DATE, v3 VARCHAR CONSTRAINT pk PRIMARY KEY (pk1, pk2)) ");
        ResultSet rs = conn.createStatement().executeQuery("SELECT 3+pk2 FROM T");
        Assert.assertEquals((Object)"(3 + PK2)", (Object)rs.getMetaData().getColumnName(1));
        Assert.assertEquals((Object)"(3 + PK2)", (Object)rs.getMetaData().getColumnLabel(1));
        rs = conn.createStatement().executeQuery("SELECT 3+pk2 AS sum FROM T");
        Assert.assertEquals((Object)"(3 + PK2)", (Object)rs.getMetaData().getColumnName(1));
        Assert.assertEquals((Object)"SUM", (Object)rs.getMetaData().getColumnLabel(1));
    }

    @Test
    public void testSqrtExpression() throws Exception {
        Connection conn = DriverManager.getConnection(PhoenixResultSetMetadataTest.getUrl());
        conn.createStatement().execute("CREATE TABLE T (pk1 CHAR(15) not null, pk2 INTEGER not null,  v1 VARCHAR(15), v2 DATE, v3 VARCHAR CONSTRAINT pk PRIMARY KEY (pk1, pk2)) ");
        ResultSet rs = conn.createStatement().executeQuery("SELECT SQRT(3+pk2) FROM T");
        Assert.assertEquals((Object)"SQRT((3 + PK2))", (Object)rs.getMetaData().getColumnName(1));
        Assert.assertEquals((Object)"SQRT((3 + PK2))", (Object)rs.getMetaData().getColumnLabel(1));
        rs = conn.createStatement().executeQuery("SELECT SQRT(3+pk2) AS \"sqrt\" FROM T");
        Assert.assertEquals((Object)"SQRT((3 + PK2))", (Object)rs.getMetaData().getColumnName(1));
        Assert.assertEquals((Object)"sqrt", (Object)rs.getMetaData().getColumnLabel(1));
    }

    @Test
    public void testView() throws Exception {
        Connection conn = DriverManager.getConnection(PhoenixResultSetMetadataTest.getUrl());
        conn.createStatement().execute("CREATE TABLE IF NOT EXISTS S.T (A INTEGER PRIMARY KEY, B INTEGER, C VARCHAR, D INTEGER)");
        conn.createStatement().execute("CREATE VIEW IF NOT EXISTS S.V (VA INTEGER, VB INTEGER) AS SELECT * FROM S.T WHERE A=2");
        conn.createStatement().execute("UPSERT INTO S.V (A, B, C, D, VA, VB) VALUES (2, 200, 'def', -20, 91, 101)");
        conn.createStatement().execute("ALTER VIEW S.V DROP COLUMN C");
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM S.V");
        Assert.assertEquals((Object)"A", (Object)rs.getMetaData().getColumnName(1));
        Assert.assertEquals((Object)"A", (Object)rs.getMetaData().getColumnLabel(1));
        Assert.assertEquals((Object)"B", (Object)rs.getMetaData().getColumnName(2));
        Assert.assertEquals((Object)"B", (Object)rs.getMetaData().getColumnLabel(2));
        Assert.assertEquals((Object)"C", (Object)rs.getMetaData().getColumnName(3));
        Assert.assertEquals((Object)"C", (Object)rs.getMetaData().getColumnLabel(3));
        Assert.assertEquals((Object)"D", (Object)rs.getMetaData().getColumnName(4));
        Assert.assertEquals((Object)"D", (Object)rs.getMetaData().getColumnLabel(4));
        Assert.assertEquals((Object)"VA", (Object)rs.getMetaData().getColumnName(5));
        Assert.assertEquals((Object)"VA", (Object)rs.getMetaData().getColumnLabel(5));
        Assert.assertEquals((Object)"VB", (Object)rs.getMetaData().getColumnName(6));
        Assert.assertEquals((Object)"VB", (Object)rs.getMetaData().getColumnLabel(6));
    }
}

