/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.query.BaseConnectionlessQueryTest;
import org.junit.Assert;
import org.junit.Test;

public class PhoenixPreparedStatementTest
extends BaseConnectionlessQueryTest {
    @Test
    public void testSetParameter_InvalidIndex() throws Exception {
        Properties connectionProperties = new Properties();
        Connection connection = DriverManager.getConnection(PhoenixPreparedStatementTest.getUrl(), connectionProperties);
        PreparedStatement stmt = connection.prepareStatement("UPSERT INTO " + ATABLE + " (organization_id, entity_id, a_integer) VALUES (?,?,?)");
        stmt.setString(1, "AAA");
        stmt.setString(2, "BBB");
        stmt.setInt(3, 1);
        try {
            stmt.setString(4, "Invalid bind column");
            Assert.fail((String)"Setting a value for a column that doesn't exist should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            stmt.setString(-1, "Invalid bind column");
            Assert.fail((String)"Setting a value for a column that doesn't exist should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Test
    public void testMutationUsingExecuteQueryShouldFail() throws Exception {
        Properties connectionProperties = new Properties();
        Connection connection = DriverManager.getConnection(PhoenixPreparedStatementTest.getUrl(), connectionProperties);
        PreparedStatement stmt = connection.prepareStatement("DELETE FROM " + ATABLE);
        try {
            stmt.executeQuery();
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.EXECUTE_QUERY_NOT_APPLICABLE.getErrorCode(), (long)e.getErrorCode());
        }
    }

    @Test
    public void testQueriesUsingExecuteUpdateShouldFail() throws Exception {
        Properties connectionProperties = new Properties();
        Connection connection = DriverManager.getConnection(PhoenixPreparedStatementTest.getUrl(), connectionProperties);
        PreparedStatement stmt = connection.prepareStatement("SELECT * FROM " + ATABLE);
        try {
            stmt.executeUpdate();
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.EXECUTE_UPDATE_NOT_APPLICABLE.getErrorCode(), (long)e.getErrorCode());
        }
    }
}

