/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.util.VersionInfo;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.jdbc.ConnectionInfo;
import org.apache.phoenix.jdbc.MasterConnectionInfo;
import org.apache.phoenix.jdbc.PhoenixDriver;
import org.apache.phoenix.jdbc.RPCConnectionInfo;
import org.apache.phoenix.jdbc.ZKConnectionInfo;
import org.apache.phoenix.query.HBaseFactoryProvider;
import org.apache.phoenix.util.ReadOnlyProps;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class PhoenixEmbeddedDriverTest {
    @Test
    public void testGetZKConnectionInfo() throws SQLException {
        Configuration config = HBaseFactoryProvider.getConfigurationFactory().getConfiguration();
        config.set("hbase.client.registry.impl", "org.apache.hadoop.hbase.client.ZKConnectionRegistry");
        String defaultQuorum = config.get("hbase.zookeeper.quorum");
        for (String protocol : new String[]{"phoenix", "phoenix+zk"}) {
            String[] urls = new String[]{null, "", "jdbc:" + protocol + "", "jdbc:" + protocol + ";test=true", "jdbc:" + protocol + ":localhost", "localhost", "localhost;", "jdbc:" + protocol + ":localhost:123", "jdbc:" + protocol + ":localhost:123;foo=bar", "localhost:123", "jdbc:" + protocol + ":localhost:123:/hbase", "jdbc:" + protocol + ":localhost:123:/foo-bar", "jdbc:" + protocol + ":localhost:123:/foo-bar;foo=bas", "localhost:123:/foo-bar", "jdbc:" + protocol + ":localhost:/hbase", "jdbc:" + protocol + ":localhost:/foo-bar", "jdbc:" + protocol + ":localhost:/foo-bar;test=true", "localhost:/foo-bar", "jdbc:" + protocol + ":v1,v2,v3", "jdbc:" + protocol + ":v1,v2,v3;", "jdbc:" + protocol + ":v1,v2,v3;test=true", "v1,v2,v3", "jdbc:" + protocol + ":v1,v2,v3:/hbase", "jdbc:" + protocol + ":v1,v2,v3:/hbase;test=true", "v1,v2,v3:/foo-bar", "jdbc:" + protocol + ":v1,v2,v3:123:/hbase", "v1,v2,v3:123:/hbase", "jdbc:" + protocol + ":v1,v2,v3:123:/hbase;test=false", "jdbc:" + protocol + ":v1,v2,v3:123:/hbase:user/principal:/user.keytab;test=false", "jdbc:" + protocol + ":v1,v2,v3:123:/foo-bar:user/principal:/user.keytab;test=false", "jdbc:" + protocol + ":v1,v2,v3:123:user/principal:/user.keytab;test=false", "jdbc:" + protocol + ":v1,v2,v3:user/principal:/user.keytab;test=false", "jdbc:" + protocol + ":v1,v2,v3:/hbase:user/principal:/user.keytab;test=false", "jdbc:" + protocol + ":v1,v2,v3:LongRunningQueries;test=false", "jdbc:" + protocol + ":v1,v2,v3:345:LongRunningQueries;test=false", "jdbc:" + protocol + ":localhost:1234:user:C:\\user.keytab", "jdbc:" + protocol + ":v1,v2,v3:345:/hbase:user1:C:\\Documents and Settings\\user1\\user1.keytab;test=false"};
            String[][] partsList = new String[][]{{defaultQuorum + ":2181", null, "/hbase"}, {defaultQuorum + ":2181", null, "/hbase"}, {defaultQuorum + ":2181", null, "/hbase"}, new String[0], {"localhost:2181", null, "/hbase"}, {"localhost:2181", null, "/hbase"}, {"localhost:2181", null, "/hbase"}, {"localhost:123", null, "/hbase"}, {"localhost:123", null, "/hbase"}, {"localhost:123", null, "/hbase"}, {"localhost:123", null, "/hbase"}, {"localhost:123", null, "/foo-bar"}, {"localhost:123", null, "/foo-bar"}, {"localhost:123", null, "/foo-bar"}, {"localhost:2181", null, "/hbase"}, {"localhost:2181", null, "/foo-bar"}, {"localhost:2181", null, "/foo-bar"}, {"localhost:2181", null, "/foo-bar"}, {"v1:2181,v2:2181,v3:2181", null, "/hbase"}, {"v1:2181,v2:2181,v3:2181", null, "/hbase"}, {"v1:2181,v2:2181,v3:2181", null, "/hbase"}, {"v1:2181,v2:2181,v3:2181", null, "/hbase"}, {"v1:2181,v2:2181,v3:2181", null, "/hbase"}, {"v1:2181,v2:2181,v3:2181", null, "/hbase"}, {"v1:2181,v2:2181,v3:2181", null, "/foo-bar"}, {"v1:123,v2:123,v3:123", null, "/hbase"}, {"v1:123,v2:123,v3:123", null, "/hbase"}, {"v1:123,v2:123,v3:123", null, "/hbase"}, {"v1:123,v2:123,v3:123", null, "/hbase", "user/principal", "/user.keytab"}, {"v1:123,v2:123,v3:123", null, "/foo-bar", "user/principal", "/user.keytab"}, {"v1:123,v2:123,v3:123", null, "/hbase", "user/principal", "/user.keytab"}, {"v1:2181,v2:2181,v3:2181", null, "/hbase", "user/principal", "/user.keytab"}, {"v1:2181,v2:2181,v3:2181", null, "/hbase", "user/principal", "/user.keytab"}, {"v1:2181,v2:2181,v3:2181", null, "/hbase", "LongRunningQueries"}, {"v1:345,v2:345,v3:345", null, "/hbase", "LongRunningQueries"}, {"localhost:1234", null, "/hbase", "user", "C:\\user.keytab"}, {"v1:345,v2:345,v3:345", null, "/hbase", "user1", "C:\\Documents and Settings\\user1\\user1.keytab"}};
            Assert.assertEquals((long)urls.length, (long)partsList.length);
            for (int i = 0; i < urls.length; ++i) {
                int pos = 0;
                try {
                    ZKConnectionInfo info = (ZKConnectionInfo)ConnectionInfo.create((String)urls[i], (Configuration)config, null, null);
                    String[] parts = partsList[i];
                    if (parts.length > pos) {
                        Assert.assertEquals((Object)parts[pos], (Object)info.getZkHosts());
                    }
                    if (parts.length > ++pos) {
                        Assert.assertEquals((Object)parts[pos], (Object)info.getZkPort());
                    }
                    if (parts.length > ++pos) {
                        Assert.assertEquals((Object)parts[pos], (Object)info.getZkRootNode());
                    }
                    if (parts.length > ++pos) {
                        Assert.assertEquals((Object)parts[pos], (Object)info.getPrincipal());
                    }
                    if (parts.length <= ++pos) continue;
                    Assert.assertEquals((Object)parts[pos], (Object)info.getKeytab());
                    continue;
                }
                catch (AssertionError e) {
                    throw new AssertionError((Object)("For \"" + urls[i] + " at position: " + pos + "\": " + ((Throwable)((Object)e)).getMessage()));
                }
            }
        }
    }

    @Test
    public void testGetMasterConnectionInfo() throws SQLException {
        Assume.assumeTrue((VersionInfo.compareVersion((String)VersionInfo.getVersion(), (String)"2.3.0") >= 0 ? 1 : 0) != 0);
        Configuration config = HBaseFactoryProvider.getConfigurationFactory().getConfiguration();
        config.set("hbase.client.registry.impl", "org.apache.hadoop.hbase.client.MasterRegistry");
        String defaultMasters = "defaultmaster1:1243,defaultmaster2:2345";
        config.set("hbase.masters", defaultMasters);
        String[] urls = new String[]{null, "", "jdbc:phoenix+master", "jdbc:phoenix+master;test=true", "jdbc:phoenix", "jdbc:phoenix+master:localhost", "localhost", "localhost;", "localhost:123", "localhost,localhost2:123;", "localhost\\:123", "localhost\\:123:", "localhost\\:123::", "localhost\\:123:::", "localhost\\:123::::", "localhost\\:123:::::", "localhost\\:123:345::::", "localhost,localhost2\\:123;", "localhost,localhost2\\:123:456", "localhost,localhost2\\:123:456;test=false", "localhost\\:123:::user/principal:/user.keytab", "localhost\\:123:::LongRunningQueries", "localhost\\:123:::LongRunningQueries:", "localhost\\:123:::LongRunningQueries::", "localhost\\:123:::user/principal:C:\\user.keytab", "localhost\\:123:::user/principal:C:\\Documents and Settings\\user1\\user1.keytab"};
        String[][] partsList = new String[][]{{defaultMasters}, {defaultMasters}, {defaultMasters}, {defaultMasters}, {defaultMasters}, {"localhost:16000"}, {"localhost:16000"}, {"localhost:16000"}, {"localhost:123"}, {"localhost2:123,localhost:123"}, {"localhost:123"}, {"localhost:123"}, {"localhost:123"}, {"localhost:123"}, {"localhost:123"}, {"localhost:123"}, {"localhost:123"}, {"localhost2:123,localhost:16000"}, {"localhost2:123,localhost:456"}, {"localhost2:123,localhost:456"}, {"localhost:123", "user/principal", "/user.keytab"}, {"localhost:123", "LongRunningQueries", null}, {"localhost:123", "LongRunningQueries", null}, {"localhost:123", "LongRunningQueries", null}, {"localhost:123", "user/principal", "C:\\user.keytab"}, {"localhost:123", "user/principal", "C:\\Documents and Settings\\user1\\user1.keytab"}};
        Assert.assertEquals((long)urls.length, (long)partsList.length);
        for (int i = 0; i < urls.length; ++i) {
            try {
                Configuration testConfig = new Configuration(config);
                MasterConnectionInfo info = (MasterConnectionInfo)ConnectionInfo.create((String)urls[i], (Configuration)testConfig, null, null);
                String[] parts = partsList[i];
                Assert.assertEquals((Object)parts[0], (Object)info.getBoostrapServers());
                if (parts.length > 1) {
                    Assert.assertEquals((Object)parts[1], (Object)info.getPrincipal());
                } else {
                    Assert.assertNull((Object)info.getPrincipal());
                }
                if (parts.length > 2) {
                    Assert.assertEquals((Object)parts[2], (Object)info.getKeytab());
                    continue;
                }
                Assert.assertNull((Object)info.getKeytab());
                continue;
            }
            catch (AssertionError e) {
                throw new AssertionError((Object)("For \"" + urls[i] + ": " + ((Throwable)((Object)e)).getMessage()));
            }
        }
    }

    @Test
    public void testGetRPCConnectionInfo() throws SQLException {
        Assume.assumeTrue((VersionInfo.compareVersion((String)VersionInfo.getVersion(), (String)"2.5.0") >= 0 ? 1 : 0) != 0);
        Configuration config = HBaseFactoryProvider.getConfigurationFactory().getConfiguration();
        config.set("hbase.client.registry.impl", "org.apache.hadoop.hbase.client.RpcConnectionRegistry");
        String defaultBoostraps = "defaultmaster1:1243,defaultmaster2:2345";
        config.set("hbase.client.bootstrap.servers", defaultBoostraps);
        String[] urls = new String[]{null, "", "jdbc:phoenix+rpc", "jdbc:phoenix+rpc\";test=true", "jdbc:phoenix", "jdbc:phoenix+rpc\":localhost", "localhost", "localhost;", "localhost:123", "localhost,localhost2:123;", "localhost\\:123", "localhost\\:123:", "localhost\\:123::", "localhost\\:123:::", "localhost\\:123::::", "localhost\\:123:::::", "localhost\\:123:345::::", "localhost,localhost2\\:123;", "localhost,localhost2\\:123:456", "localhost,localhost2\\:123:456;test=false", "localhost\\:123:::user/principal:/user.keytab", "localhost\\:123:::LongRunningQueries", "localhost\\:123:::LongRunningQueries:", "localhost\\:123:::LongRunningQueries::", "localhost\\:123:::user/principal:C:\\user.keytab", "localhost\\:123:::user/principal:C:\\Documents and Settings\\user1\\user1.keytab"};
        String[][] partsList = new String[][]{{defaultBoostraps}, {defaultBoostraps}, {defaultBoostraps}, {defaultBoostraps}, {defaultBoostraps}, {"localhost"}, {"localhost"}, {"localhost"}, {"localhost:123"}, {"localhost2:123,localhost:123"}, {"localhost:123"}, {"localhost:123"}, {"localhost:123"}, {"localhost:123"}, {"localhost:123"}, {"localhost:123"}, {"localhost:123"}, {"localhost,localhost2:123"}, {"localhost2:123,localhost:456"}, {"localhost2:123,localhost:456"}, {"localhost:123", "user/principal", "/user.keytab"}, {"localhost:123", "LongRunningQueries", null}, {"localhost:123", "LongRunningQueries", null}, {"localhost:123", "LongRunningQueries", null}, {"localhost:123", "user/principal", "C:\\user.keytab"}, {"localhost:123", "user/principal", "C:\\Documents and Settings\\user1\\user1.keytab"}};
        Assert.assertEquals((long)urls.length, (long)partsList.length);
        for (int i = 0; i < urls.length; ++i) {
            try {
                Configuration testConfig = new Configuration(config);
                RPCConnectionInfo info = (RPCConnectionInfo)ConnectionInfo.create((String)urls[i], (Configuration)testConfig, null, null);
                String[] parts = partsList[i];
                Assert.assertEquals((Object)parts[0], (Object)info.getBoostrapServers());
                if (parts.length > 1) {
                    Assert.assertEquals((Object)parts[1], (Object)info.getPrincipal());
                } else {
                    Assert.assertNull((Object)info.getPrincipal());
                }
                if (parts.length > 2) {
                    Assert.assertEquals((Object)parts[2], (Object)info.getKeytab());
                    continue;
                }
                Assert.assertNull((Object)info.getKeytab());
                continue;
            }
            catch (AssertionError e) {
                throw new AssertionError((Object)("For \"" + urls[i] + ": " + ((Throwable)((Object)e)).getMessage()));
            }
        }
    }

    @Test
    public void testNegativeGetConnectionInfo() throws SQLException {
        String[] urls;
        for (String url : urls = new String[]{"jdbc:phoenix:v1:1,v2:2,v3:3", "jdbc:phoenix:v1:1,v2:2,v3:3;test=true", "jdbc:phoenix:v1,v2,v3:-1:/hbase;test=true", "jdbc:phoenix:v1,v2,v3:-1", "jdbc:phoenix+zk:v1:1,v2:2,v3:3", "jdbc:phoenix+zk:v1:1,v2:2,v3:3;test=true", "jdbc:phoenix+zk:v1,v2,v3:-1:/hbase;test=true", "jdbc:phoenix+zk:v1,v2,v3:-1"}) {
            try {
                ConnectionInfo.create((String)url, null, null);
                throw new AssertionError((Object)("Expected exception for \"" + url + "\""));
            }
            catch (SQLException e) {
                try {
                    Assert.assertEquals((Object)SQLExceptionCode.MALFORMED_CONNECTION_URL.getSQLState(), (Object)e.getSQLState());
                }
                catch (AssertionError ae) {
                    throw new AssertionError((Object)("For \"" + url + "\": " + ((Throwable)((Object)ae)).getMessage()));
                }
            }
        }
    }

    @Test
    public void testRPCNegativeGetConnectionInfo() throws SQLException {
        String[] urls;
        Assume.assumeTrue((VersionInfo.compareVersion((String)VersionInfo.getVersion(), (String)"2.5.0") >= 0 ? 1 : 0) != 0);
        for (String url : urls = new String[]{"jdbc:phoenix+rpc:v1:1,v2:2,v3:3", "jdbc:phoenix+rpc:v1:1,v2:2,v3:3;test=true", "jdbc:phoenix+rpc:v1,v2,v3:-1:/hbase;test=true", "jdbc:phoenix+rpc:v1,v2,v3:-1", "jdbc:phoenix+master:v1:1,v2:2,v3:3", "jdbc:phoenix+master:v1:1,v2:2,v3:3;test=true", "jdbc:phoenix+master:v1,v2,v3:-1:/hbase;test=true", "jdbc:phoenix+master:v1,v2,v3:-1", "jdbc:phoenix+rpc:localhost,localhost2\\:123:456:rootNode", "jdbc:phoenix+rpc:localhost,localhost2\\:123:456:rootNode:prinicpial:keystore", "jdbc:phoenix+rpc:localhost,localhost2\\:123:456:prinicpial", "jdbc:phoenix+rpc:localhost,localhost2\\:123:456:prinicpial:keystore", "jdbc:phoenix+master:localhost,localhost2\\:123:456:rootNode", "jdbc:phoenix+master:localhost,localhost2\\:123:456:rootNode:prinicpial:keystore", "jdbc:phoenix+master:localhost,localhost2\\:123:456:prinicpial", "jdbc:phoenix+master:localhost,localhost2\\:123:456:prinicpial:keystore"}) {
            try {
                ConnectionInfo.create((String)url, null, null);
                throw new AssertionError((Object)("Expected exception for \"" + url + "\""));
            }
            catch (SQLException e) {
                try {
                    Assert.assertEquals((Object)SQLExceptionCode.MALFORMED_CONNECTION_URL.getSQLState(), (Object)e.getSQLState());
                }
                catch (AssertionError ae) {
                    throw new AssertionError((Object)("For \"" + url + "\": " + ((Throwable)((Object)ae)).getMessage()));
                }
            }
        }
    }

    @Test
    public void testMasterDefaults() throws SQLException {
        Configuration config2;
        Assume.assumeTrue((VersionInfo.compareVersion((String)VersionInfo.getVersion(), (String)"2.3.0") >= 0 ? 1 : 0) != 0);
        try {
            config2 = HBaseFactoryProvider.getConfigurationFactory().getConfiguration();
            config2.set("hbase.client.registry.impl", "org.apache.hadoop.hbase.client.MasterRegistry");
            ConnectionInfo.create((String)"jdbc:phoenix+master", (Configuration)config2, null, null);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (SQLException config2) {
            // empty catch block
        }
        config2 = HBaseFactoryProvider.getConfigurationFactory().getConfiguration();
        config2.set("hbase.client.registry.impl", "org.apache.hadoop.hbase.client.MasterRegistry");
        config2.set("hbase.master.hostname", "master.hostname");
        MasterConnectionInfo info = (MasterConnectionInfo)ConnectionInfo.create((String)"jdbc:phoenix+master", (Configuration)config2, null, null);
        Assert.assertEquals((Object)info.getBoostrapServers(), (Object)"master.hostname:16000");
        config2 = HBaseFactoryProvider.getConfigurationFactory().getConfiguration();
        config2.set("hbase.client.registry.impl", "org.apache.hadoop.hbase.client.MasterRegistry");
        config2.set("hbase.master.hostname", "master.hostname");
        config2.set("hbase.master.port", "17000");
        info = (MasterConnectionInfo)ConnectionInfo.create((String)"jdbc:phoenix", (Configuration)config2, null, null);
        Assert.assertEquals((Object)info.getBoostrapServers(), (Object)"master.hostname:17000");
        config2 = HBaseFactoryProvider.getConfigurationFactory().getConfiguration();
        config2.set("hbase.client.registry.impl", "org.apache.hadoop.hbase.client.MasterRegistry");
        config2.set("hbase.master.hostname", "master.hostname");
        config2.set("hbase.master.port", "17000");
        config2.set("hbase.masters", "master1:123,master2:234,master3:345");
        info = (MasterConnectionInfo)ConnectionInfo.create((String)"jdbc:phoenix", (Configuration)config2, null, null);
        Assert.assertEquals((Object)info.getBoostrapServers(), (Object)"master1:123,master2:234,master3:345");
        config2 = HBaseFactoryProvider.getConfigurationFactory().getConfiguration();
        config2.set("hbase.client.registry.impl", "org.apache.hadoop.hbase.client.MasterRegistry");
        config2.set("hbase.master.port", "17000");
        info = (MasterConnectionInfo)ConnectionInfo.create((String)"jdbc:phoenix+master:master1.from.url,master2.from.url", (Configuration)config2, null, null);
        Assert.assertEquals((Object)info.getBoostrapServers(), (Object)"master1.from.url:17000,master2.from.url:17000");
        config2 = HBaseFactoryProvider.getConfigurationFactory().getConfiguration();
        config2.set("hbase.client.registry.impl", "org.apache.hadoop.hbase.client.MasterRegistry");
        config2.set("hbase.master.port", "17000");
        info = (MasterConnectionInfo)ConnectionInfo.create((String)"jdbc:phoenix+master:master1.from.url\\:123,master2.from.url", (Configuration)config2, null, null);
        Assert.assertEquals((Object)info.getBoostrapServers(), (Object)"master1.from.url:123,master2.from.url:17000");
        config2 = HBaseFactoryProvider.getConfigurationFactory().getConfiguration();
        config2.set("hbase.client.registry.impl", "org.apache.hadoop.hbase.client.MasterRegistry");
        config2.set("hbase.master.hostname", "master.hostname");
        config2.set("hbase.master.port", "17000");
        config2.set("hbase.masters", "master1:123,master2:234,master3:345");
        info = (MasterConnectionInfo)ConnectionInfo.create((String)"jdbc:phoenix:master1.from.url\\:123,master2.from.url:18000", (Configuration)config2, null, null);
        Assert.assertEquals((Object)info.getBoostrapServers(), (Object)"master1.from.url:123,master2.from.url:18000");
        config2 = HBaseFactoryProvider.getConfigurationFactory().getConfiguration();
        config2.set("hbase.client.registry.impl", "org.apache.hadoop.hbase.client.MasterRegistry");
        config2.set("hbase.master.hostname", "master.hostname");
        config2.set("hbase.master.port", "17000");
        config2.set("hbase.masters", "master1:123,master2:234,master3:345");
        info = (MasterConnectionInfo)ConnectionInfo.create((String)"jdbc:phoenix:master1.from.url\\:123,master2.from.url\\:234:18000", (Configuration)config2, null, null);
        Assert.assertEquals((Object)info.getBoostrapServers(), (Object)"master1.from.url:123,master2.from.url:234");
    }

    @Test
    public void testRPCDefaults() throws SQLException {
        Configuration config2;
        Assume.assumeTrue((VersionInfo.compareVersion((String)VersionInfo.getVersion(), (String)"2.5.0") >= 0 ? 1 : 0) != 0);
        try {
            config2 = HBaseFactoryProvider.getConfigurationFactory().getConfiguration();
            config2.set("hbase.client.registry.impl", "org.apache.hadoop.hbase.client.RpcConnectionRegistry");
            ConnectionInfo.create((String)"jdbc:phoenix+rpc", (Configuration)config2, null, null);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (SQLException config2) {
            // empty catch block
        }
        config2 = HBaseFactoryProvider.getConfigurationFactory().getConfiguration();
        config2.set("hbase.client.registry.impl", "org.apache.hadoop.hbase.client.RpcConnectionRegistry");
        config2.set("hbase.client.bootstrap.servers", "bootstrap1\\:123,boostrap2\\:234");
        RPCConnectionInfo info = (RPCConnectionInfo)ConnectionInfo.create((String)"jdbc:phoenix+rpc", (Configuration)config2, null, null);
        Assert.assertEquals((Object)info.getBoostrapServers(), (Object)"bootstrap1\\:123,boostrap2\\:234");
        config2 = HBaseFactoryProvider.getConfigurationFactory().getConfiguration();
        config2.set("hbase.client.registry.impl", "org.apache.hadoop.hbase.client.RpcConnectionRegistry");
        info = (RPCConnectionInfo)ConnectionInfo.create((String)"jdbc:phoenix+rpc:bootstrap1.from.url,bootstrap2.from.url", (Configuration)config2, null, null);
        Assert.assertEquals((Object)info.getBoostrapServers(), (Object)"bootstrap1.from.url,bootstrap2.from.url");
        config2 = HBaseFactoryProvider.getConfigurationFactory().getConfiguration();
        config2.set("hbase.client.registry.impl", "org.apache.hadoop.hbase.client.RpcConnectionRegistry");
        info = (RPCConnectionInfo)ConnectionInfo.create((String)"jdbc:phoenix+rpc:bootstrap1.from.url\\:123,bootstrap2.from.url\\::234", (Configuration)config2, null, null);
        Assert.assertEquals((Object)info.getBoostrapServers(), (Object)"bootstrap1.from.url:123,bootstrap2.from.url:234");
        config2 = HBaseFactoryProvider.getConfigurationFactory().getConfiguration();
        config2.set("hbase.client.registry.impl", "org.apache.hadoop.hbase.client.RpcConnectionRegistry");
        config2.set("hbase.masters", "master1:123,master2:234,master3:345");
        info = (RPCConnectionInfo)ConnectionInfo.create((String)"jdbc:phoenix+rpc", (Configuration)config2, null, null);
        Assert.assertEquals((Object)info.getBoostrapServers(), (Object)"master1:123,master2:234,master3:345");
    }

    @Test
    public void testNotAccept() throws Exception {
        PhoenixDriver driver = new PhoenixDriver();
        Assert.assertFalse((boolean)driver.acceptsURL("jdbc:phoenix://localhost"));
        Assert.assertFalse((boolean)driver.acceptsURL("jdbc:phoenix:localhost;test=true;bar=foo"));
        Assert.assertFalse((boolean)driver.acceptsURL("jdbc:phoenix:localhost;test=true"));
        Assert.assertTrue((boolean)driver.acceptsURL("jdbc:phoenix:localhost:123"));
        Assert.assertTrue((boolean)driver.acceptsURL("jdbc:phoenix:localhost:123;untest=true"));
        Assert.assertTrue((boolean)driver.acceptsURL("jdbc:phoenix:localhost:123;untest=true;foo=bar"));
        DriverManager.deregisterDriver((Driver)driver);
    }

    @Test
    public void testPrincipalsMatching() throws Exception {
        Assert.assertTrue((boolean)ConnectionInfo.isSameName((String)"user@EXAMPLE.COM", (String)"user@EXAMPLE.COM"));
        Assert.assertTrue((boolean)ConnectionInfo.isSameName((String)"user/localhost@EXAMPLE.COM", (String)"user/localhost@EXAMPLE.COM"));
        Assert.assertTrue((boolean)ConnectionInfo.isSameName((String)"user/localhost@EXAMPLE.COM", (String)"user/_HOST@EXAMPLE.COM", (String)"localhost"));
        Assert.assertFalse((boolean)ConnectionInfo.isSameName((String)"user/foobar@EXAMPLE.COM", (String)"user/_HOST@EXAMPLE.COM", (String)"localhost"));
        Assert.assertFalse((boolean)ConnectionInfo.isSameName((String)"user@EXAMPLE.COM", (String)"user/_HOST@EXAMPLE.COM", (String)"localhost"));
        Assert.assertFalse((boolean)ConnectionInfo.isSameName((String)"user@FOO", (String)"user@BAR"));
        Assert.assertTrue((boolean)ConnectionInfo.isSameName((String)"user@APACHE.ORG", (String)"user", null, (String)"APACHE.ORG"));
        Assert.assertTrue((boolean)ConnectionInfo.isSameName((String)"user/localhost@APACHE.ORG", (String)"user/localhost", null, (String)"APACHE.ORG"));
        Assert.assertFalse((boolean)ConnectionInfo.isSameName((String)"user@APACHE.NET", (String)"user", null, (String)"APACHE.ORG"));
        Assert.assertFalse((boolean)ConnectionInfo.isSameName((String)"user/localhost@APACHE.NET", (String)"user/localhost", null, (String)"APACHE.ORG"));
        Assert.assertTrue((boolean)ConnectionInfo.isSameName((String)"user@APACHE.ORG", (String)"user@APACHE.ORG", null, (String)"APACHE.ORG"));
        Assert.assertTrue((boolean)ConnectionInfo.isSameName((String)"user/localhost@APACHE.ORG", (String)"user/localhost@APACHE.ORG", null, (String)"APACHE.ORG"));
        Assert.assertTrue((boolean)ConnectionInfo.isSameName((String)"user/localhost@APACHE.ORG", (String)"user/_HOST", (String)"localhost", (String)"APACHE.ORG"));
        Assert.assertTrue((boolean)ConnectionInfo.isSameName((String)"user/foobar@APACHE.ORG", (String)"user/_HOST", (String)"foobar", (String)"APACHE.ORG"));
        Assert.assertFalse((boolean)ConnectionInfo.isSameName((String)"user/localhost@APACHE.NET", (String)"user/_HOST", (String)"localhost", (String)"APACHE.ORG"));
        Assert.assertFalse((boolean)ConnectionInfo.isSameName((String)"user/foobar@APACHE.NET", (String)"user/_HOST", (String)"foobar", (String)"APACHE.ORG"));
    }

    @Test
    public void testMasterIPv6() throws SQLException {
        Configuration config2;
        Assume.assumeTrue((VersionInfo.compareVersion((String)VersionInfo.getVersion(), (String)"2.3.0") >= 0 ? 1 : 0) != 0);
        try {
            config2 = HBaseFactoryProvider.getConfigurationFactory().getConfiguration();
            config2.set("hbase.client.registry.impl", "org.apache.hadoop.hbase.client.MasterRegistry");
            ConnectionInfo.create((String)"jdbc:phoenix+master", (Configuration)config2, null, null);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (SQLException config2) {
            // empty catch block
        }
        config2 = HBaseFactoryProvider.getConfigurationFactory().getConfiguration();
        config2.set("hbase.client.registry.impl", "org.apache.hadoop.hbase.client.MasterRegistry");
        config2.set("hbase.master.port", "17000");
        MasterConnectionInfo info = (MasterConnectionInfo)ConnectionInfo.create((String)"jdbc:phoenix+master:[::1],[\\:\\:2]", (Configuration)config2, null, null);
        Assert.assertEquals((Object)info.getBoostrapServers(), (Object)"[::1]:17000,[::2]:17000");
        config2 = HBaseFactoryProvider.getConfigurationFactory().getConfiguration();
        config2.set("hbase.client.registry.impl", "org.apache.hadoop.hbase.client.MasterRegistry");
        info = (MasterConnectionInfo)ConnectionInfo.create((String)"jdbc:phoenix+master:[::1]\\:123,[\\:\\:2]\\:234", (Configuration)config2, null, null);
        Assert.assertEquals((Object)info.getBoostrapServers(), (Object)"[::1]:123,[::2]:234");
    }

    @Test
    public void testRPCIPv6() throws SQLException {
        Assume.assumeTrue((VersionInfo.compareVersion((String)VersionInfo.getVersion(), (String)"2.5.0") >= 0 ? 1 : 0) != 0);
        Configuration config = HBaseFactoryProvider.getConfigurationFactory().getConfiguration();
        config.set("hbase.client.registry.impl", "org.apache.hadoop.hbase.client.RpcConnectionRegistry");
        RPCConnectionInfo info = (RPCConnectionInfo)ConnectionInfo.create((String)"jdbc:phoenix+rpc:[::1]\\:123,[\\:\\:2]\\::234", (Configuration)config, null, null);
        Assert.assertEquals((Object)"[::1]:123,[::2]:234", (Object)info.getBoostrapServers());
    }

    @Test
    public void testZkIPv6() throws Exception {
        ConnectionInfo connectionInfo = ConnectionInfo.create((String)"jdbc:phoenix+zk:[::1],127.23.45.678\\:7634,v3\\:1,host123.48576\\:723:/hbase;test=true", null, null);
        ReadOnlyProps props = connectionInfo.asProps();
        Assert.assertEquals((Object)"127.23.45.678:7634,[::1]:2181,host123.48576:723,v3:1", (Object)props.get("hbase.zookeeper.quorum"));
        connectionInfo = ConnectionInfo.create((String)"jdbc:phoenix+zk:[::1]\\:2181,127.23.45.678\\:7634,v3\\:1,host123.48576\\:723:/hbase;test=true", null, null);
        props = connectionInfo.asProps();
        Assert.assertEquals((Object)"127.23.45.678:7634,[::1]:2181,host123.48576:723,v3:1", (Object)props.get("hbase.zookeeper.quorum"));
        connectionInfo = ConnectionInfo.create((String)"jdbc:phoenix+zk:[fe:80::],127.23.45.678\\:7634,v3\\:1,host123.48576\\:723:/hbase;test=true", null, null);
        props = connectionInfo.asProps();
        Assert.assertEquals((Object)"127.23.45.678:7634,[fe:80::]:2181,host123.48576:723,v3:1", (Object)props.get("hbase.zookeeper.quorum"));
        connectionInfo = ConnectionInfo.create((String)"jdbc:phoenix+zk:[fe:80::]\\:2181,127.23.45.678\\:7634,v3\\:1,host123.48576\\:723:/hbase;test=true", null, null);
        props = connectionInfo.asProps();
        Assert.assertEquals((Object)"127.23.45.678:7634,[fe:80::]:2181,host123.48576:723,v3:1", (Object)props.get("hbase.zookeeper.quorum"));
        connectionInfo = ConnectionInfo.create((String)"jdbc:phoenix+zk:[fe\\:80\\:\\:],127.23.45.678\\:7634,v3\\:1,host123.48576\\:723:/hbase;test=true", null, null);
        props = connectionInfo.asProps();
        Assert.assertEquals((Object)"127.23.45.678:7634,[fe:80::]:2181,host123.48576:723,v3:1", (Object)props.get("hbase.zookeeper.quorum"));
        connectionInfo = ConnectionInfo.create((String)"jdbc:phoenix+zk:[fe\\:80\\:\\:]\\:2181,127.23.45.678\\:7634,v3\\:1,host123.48576\\:723:/hbase;test=true", null, null);
        props = connectionInfo.asProps();
        Assert.assertEquals((Object)"127.23.45.678:7634,[fe:80::]:2181,host123.48576:723,v3:1", (Object)props.get("hbase.zookeeper.quorum"));
        connectionInfo = ConnectionInfo.create((String)"jdbc:phoenix+zk:[fe:80::2]\\:2181,[2001:db8:3c4d:15::1a2f:1a2b]\\:7634,v3\\:1,host123.48576\\:723:/hbase;test=true", null, null);
        props = connectionInfo.asProps();
        Assert.assertEquals((Object)"[2001:db8:3c4d:15::1a2f:1a2b]:7634,[fe:80::2]:2181,host123.48576:723,v3:1", (Object)props.get("hbase.zookeeper.quorum"));
        connectionInfo = ConnectionInfo.create((String)"jdbc:phoenix+zk:[fe:80::2]\\:2181,[2001\\:db8\\:3c4d\\:15\\:\\:1a2f\\:1a2b]\\:7634,v3\\:1,host123.48576\\:723:/hbase;test=true", null, null);
        props = connectionInfo.asProps();
        Assert.assertEquals((Object)"[2001:db8:3c4d:15::1a2f:1a2b]:7634,[fe:80::2]:2181,host123.48576:723,v3:1", (Object)props.get("hbase.zookeeper.quorum"));
    }

    @Test
    public void testZkQuorumConfigs() throws Exception {
        ConnectionInfo connectionInfo = ConnectionInfo.create((String)"jdbc:phoenix+zk:localhost\\:2181,127.23.45.678\\:7634,v3\\:1,host123.48576\\:723:/hbase;test=true", null, null);
        ReadOnlyProps props = connectionInfo.asProps();
        Assert.assertEquals((Object)"127.23.45.678:7634,host123.48576:723,localhost:2181,v3:1", (Object)props.get("hbase.zookeeper.quorum"));
        Assert.assertEquals((Object)"127.23.45.678:7634,host123.48576:723,localhost:2181,v3:1", (Object)props.get("hbase.client.zookeeper.quorum"));
        connectionInfo = ConnectionInfo.create((String)"jdbc:phoenix:localhost\\:2181,127.23.45.678\\:7634,v3\\:1,host123.48576\\:723:/hbase;test=true", null, null);
        props = connectionInfo.asProps();
        Assert.assertEquals((Object)"127.23.45.678:7634,host123.48576:723,localhost:2181,v3:1", (Object)props.get("hbase.zookeeper.quorum"));
        Assert.assertEquals((Object)"127.23.45.678:7634,host123.48576:723,localhost:2181,v3:1", (Object)props.get("hbase.client.zookeeper.quorum"));
        connectionInfo = ConnectionInfo.create((String)"jdbc:phoenix:localhost,v3,127.23.45.678,host987:12345:/hbase;test=true", null, null);
        props = connectionInfo.asProps();
        Assert.assertEquals((Object)"127.23.45.678:12345,host987:12345,localhost:12345,v3:12345", (Object)props.get("hbase.zookeeper.quorum"));
        Assert.assertEquals((Object)"127.23.45.678:12345,host987:12345,localhost:12345,v3:12345", (Object)props.get("hbase.client.zookeeper.quorum"));
        Assume.assumeTrue((VersionInfo.compareVersion((String)VersionInfo.getVersion(), (String)"2.5.0") >= 0 ? 1 : 0) != 0);
        connectionInfo = ConnectionInfo.create((String)"jdbc:phoenix+rpc:localhost\\:2181,127.23.45.678\\:7634,v3\\:1,host123.48576\\:723::;test=true", null, null);
        props = connectionInfo.asProps();
        Assert.assertNull((Object)props.get("hbase.zookeeper.quorum"));
        Assert.assertNull((Object)props.get("hbase.client.zookeeper.quorum"));
    }
}

