/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDriver;
import org.apache.phoenix.jdbc.PhoenixTestDriver;
import org.apache.phoenix.query.BaseConnectionlessQueryTest;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class PhoenixDriverTest
extends BaseConnectionlessQueryTest {
    @Test
    public void testFirstConnectionWhenPropsHasTenantId() throws Exception {
        Properties props = new Properties();
        String tenantId = "00Dxx0000001234";
        props.put("TenantId", "00Dxx0000001234");
        Connection connection = new PhoenixTestDriver().connect(PhoenixDriverTest.getUrl(), props);
        Assert.assertEquals((Object)"00Dxx0000001234", (Object)connection.getClientInfo("TenantId"));
    }

    @Test
    public void testFirstConnectionWhenUrlHasTenantId() throws Exception {
        String tenantId = "00Dxx0000001234";
        String url = PhoenixDriverTest.getUrl() + ";" + "TenantId" + "=" + "00Dxx0000001234";
        PhoenixTestDriver driver = new PhoenixTestDriver();
        driver.connect(url, new Properties());
    }

    @Test
    public void testMaxMutationSizeSetCorrectly() throws SQLException {
        Properties connectionProperties = new Properties();
        connectionProperties.setProperty("phoenix.mutate.maxSize", "100");
        connectionProperties.setProperty("phoenix.mutate.immutableRows", "100");
        Connection connection = DriverManager.getConnection(PhoenixDriverTest.getUrl(), connectionProperties);
        PreparedStatement stmt = connection.prepareStatement("upsert into " + ATABLE + " (organization_id, entity_id, a_integer) values (?,?,?)");
        try {
            for (int i = 0; i < 200; ++i) {
                stmt.setString(1, "AAAA" + i);
                stmt.setString(2, "BBBB" + i);
                stmt.setInt(3, 1);
                stmt.execute();
            }
            Assert.fail((String)"Upsert should have failed since the number of upserts (200) is greater than the MAX_MUTATION_SIZE_ATTRIB (100)");
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.MAX_MUTATION_SIZE_EXCEEDED.getErrorCode(), (long)e.getErrorCode());
        }
    }

    @Test
    public void testMaxMutationSizeInBytesSetCorrectly() throws Exception {
        Properties connectionProperties = new Properties();
        connectionProperties.setProperty("phoenix.mutate.batchSizeBytes", "100");
        PhoenixConnection connection = (PhoenixConnection)DriverManager.getConnection(PhoenixDriverTest.getUrl(), connectionProperties);
        Assert.assertEquals((long)100L, (long)connection.getMutateBatchSizeBytes());
        Assert.assertEquals((long)100L, (long)connection.getMutationState().getBatchSizeBytes());
    }

    @Test
    public void testDisallowNegativeScn() {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.setProperty("CurrentSCN", String.valueOf(-100));
        try {
            DriverManager.getConnection(PhoenixDriverTest.getUrl(), props);
            Assert.fail((String)"Creating a phoenix connection with negative scn is not allowed");
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.INVALID_SCN.getErrorCode(), (long)e.getErrorCode());
        }
    }

    @Ignore
    @Test
    public void testDisallowIsolationLevel() throws SQLException {
        Connection conn = DriverManager.getConnection(PhoenixDriverTest.getUrl());
        conn.setTransactionIsolation(0);
        conn.setTransactionIsolation(1);
        conn.setTransactionIsolation(2);
        try {
            conn = DriverManager.getConnection(PhoenixDriverTest.getUrl());
            conn.setTransactionIsolation(4);
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.TX_MUST_BE_ENABLED_TO_SET_ISOLATION_LEVEL.getErrorCode(), (long)e.getErrorCode());
        }
        try {
            conn = DriverManager.getConnection(PhoenixDriverTest.getUrl());
            conn.setTransactionIsolation(8);
            Assert.fail();
        }
        catch (SQLFeatureNotSupportedException e) {
            // empty catch block
        }
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.setProperty("phoenix.transactions.enabled", Boolean.toString(true));
        conn = DriverManager.getConnection(PhoenixDriverTest.getUrl(), props);
        conn.setTransactionIsolation(4);
        try {
            conn.setTransactionIsolation(8);
            Assert.fail();
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    @Test
    public void testInvalidURL() throws Exception {
        Class.forName(PhoenixDriver.class.getName());
        try {
            DriverManager.getConnection("any text whatever you want to put here");
            Assert.fail((String)"Should have failed due to invalid driver");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

