/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.jdbc.HAURLInfo;
import org.apache.phoenix.jdbc.HighAvailabilityTestingUtility;
import org.apache.phoenix.jdbc.ParallelPhoenixContext;
import org.apache.phoenix.jdbc.ParallelPhoenixUtil;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class ParallelPhoenixUtilTest {
    ParallelPhoenixUtil util = ParallelPhoenixUtil.INSTANCE;
    private static final ParallelPhoenixContext context = new ParallelPhoenixContext(new Properties(), null, HighAvailabilityTestingUtility.getListOfSingleThreadExecutorServices(), null, (HAURLInfo)Mockito.mock(HAURLInfo.class));

    @Test
    public void getAnyOfNonExceptionallySingleFutureTest() throws Exception {
        String value = "done";
        CompletableFuture<String> future = CompletableFuture.completedFuture(value);
        ArrayList<CompletableFuture<String>> futures = new ArrayList<CompletableFuture<String>>();
        futures.add(future);
        String result = (String)this.util.getAnyOfNonExceptionally(futures, context);
        Assert.assertEquals((Object)value, (Object)result);
    }

    @Test
    public void getAnyOfNonExceptionallyAllFailedFutureTest() throws Exception {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(new RuntimeException("Err"));
        ArrayList futures = new ArrayList();
        futures.add(future);
        try {
            this.util.getAnyOfNonExceptionally(futures, context);
            Assert.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Test
    public void getAnyOfNonExceptionallyMultipleFuturesTest() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        Executor delayedExecutor = this.getLatchedMockExecutor(latch);
        CompletableFuture<String> future1 = CompletableFuture.supplyAsync(() -> "1", delayedExecutor);
        CompletableFuture<String> future2 = CompletableFuture.supplyAsync(() -> "2", delayedExecutor);
        CompletableFuture<String> future3 = CompletableFuture.supplyAsync(() -> "3");
        CompletableFuture<String> future4 = CompletableFuture.supplyAsync(() -> "4", delayedExecutor);
        ArrayList<CompletableFuture<String>> futures = new ArrayList<CompletableFuture<String>>();
        futures.add(future1);
        futures.add(future2);
        futures.add(future3);
        futures.add(future4);
        String result = (String)this.util.getAnyOfNonExceptionally(futures, context);
        Assert.assertEquals((Object)"3", (Object)result);
    }

    @Test
    public void getAnyOfNonExceptionallyTimeoutTest() throws Exception {
        CompletableFuture future1 = new CompletableFuture();
        future1.completeExceptionally(new RuntimeException("Err"));
        CompletableFuture<String> future2 = CompletableFuture.supplyAsync(() -> {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                throw new CompletionException(e);
            }
            return "Success";
        });
        ArrayList futures = new ArrayList();
        futures.add(future1);
        futures.add(future2);
        Properties props = new Properties();
        props.setProperty("phoenix.ha.parallel.operation.timeout.ms", "2000");
        ParallelPhoenixContext ctx = new ParallelPhoenixContext(props, null, HighAvailabilityTestingUtility.getListOfSingleThreadExecutorServices(), null, (HAURLInfo)Mockito.mock(HAURLInfo.class));
        long startTime = EnvironmentEdgeManager.currentTime();
        try {
            this.util.getAnyOfNonExceptionally(futures, ctx);
            Assert.fail((String)"Should've timedout");
        }
        catch (SQLException e) {
            long elapsedTime = EnvironmentEdgeManager.currentTime() - startTime;
            Assert.assertTrue((elapsedTime >= 2000L ? 1 : 0) != 0);
            Assert.assertEquals((long)SQLExceptionCode.OPERATION_TIMED_OUT.getErrorCode(), (long)e.getErrorCode());
        }
    }

    @Test
    public void getAnyOfNonExceptionallyFailedFuturesFinishFirstTest() throws Exception {
        CountDownLatch latch1 = new CountDownLatch(1);
        CountDownLatch latch2 = new CountDownLatch(1);
        Executor executor1 = this.getLatchedMockExecutor(latch1);
        Executor executor2 = this.getLatchedMockExecutor(latch2);
        CompletableFuture<String> future1 = CompletableFuture.supplyAsync(() -> {
            throw new RuntimeException();
        }, executor1);
        CompletableFuture<String> future2 = CompletableFuture.supplyAsync(() -> {
            throw new RuntimeException();
        }, executor1);
        CompletableFuture<String> future3 = CompletableFuture.supplyAsync(() -> "3", executor2);
        CompletableFuture<String> future4 = CompletableFuture.supplyAsync(() -> {
            throw new RuntimeException();
        }, executor1);
        ArrayList<CompletableFuture<String>> futures = new ArrayList<CompletableFuture<String>>();
        futures.add(future1);
        futures.add(future2);
        futures.add(future3);
        futures.add(future4);
        latch1.countDown();
        Thread.sleep(1000L);
        latch2.countDown();
        String result = (String)this.util.getAnyOfNonExceptionally(futures, context);
        Assert.assertEquals((Object)"3", (Object)result);
    }

    private Executor getLatchedMockExecutor(CountDownLatch latch) {
        Executor delayedExecutor = (Executor)Mockito.mock(Executor.class);
        ((Executor)Mockito.doAnswer(invocation -> {
            Thread thread = new Thread(() -> {
                try {
                    latch.await(5L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException();
                }
                ((Runnable)invocation.getArguments()[0]).run();
            });
            thread.start();
            return null;
        }).when((Object)delayedExecutor)).execute((Runnable)ArgumentMatchers.any(Runnable.class));
        return delayedExecutor;
    }
}

