/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hbase.client.replication.ReplicationAdmin;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.jdbc.HighAvailabilityGroup;
import org.apache.phoenix.jdbc.HighAvailabilityPolicy;
import org.apache.phoenix.jdbc.HighAvailabilityTestingUtility;
import org.apache.phoenix.jdbc.ParallelPhoenixNullComparingResultSet;
import org.apache.phoenix.jdbc.ParallelPhoenixResultSetFactory;
import org.apache.phoenix.jdbc.PhoenixDriver;
import org.apache.phoenix.monitoring.GlobalClientMetrics;
import org.apache.phoenix.util.PropertiesUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={NeedsOwnMiniClusterTest.class})
public class ParallelPhoenixNullComparingResultSetIT {
    private static final Logger LOG = LoggerFactory.getLogger(ParallelPhoenixNullComparingResultSetIT.class);
    private static final HighAvailabilityTestingUtility.HBaseTestingUtilityPair CLUSTERS = new HighAvailabilityTestingUtility.HBaseTestingUtilityPair();
    private static final Properties PROPERTIES = new Properties();
    private static final String tableName = ParallelPhoenixNullComparingResultSetIT.class.getSimpleName();
    private static final AtomicInteger intCounter = new AtomicInteger();
    private static final String selectFormat = "SELECT v FROM %s WHERE id = %d";
    private static String jdbcUrl;
    private static HighAvailabilityGroup haGroup;
    @Rule
    public final Timeout globalTimeout = new Timeout(300L, TimeUnit.SECONDS);

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        String haGroupName = ParallelPhoenixNullComparingResultSetIT.class.getSimpleName();
        CLUSTERS.start();
        DriverManager.registerDriver((Driver)PhoenixDriver.INSTANCE);
        PROPERTIES.setProperty("phoenix.ha.group.name", haGroupName);
        PROPERTIES.setProperty("phoenix.parallel.resultSet.type", ParallelPhoenixResultSetFactory.ParallelPhoenixResultSetType.PARALLEL_PHOENIX_NULL_COMPARING_RESULT_SET.getName());
        PROPERTIES.setProperty("phoenix.ha.parallel.operation.timeout.ms", "3000");
        CLUSTERS.initClusterRole(haGroupName, HighAvailabilityPolicy.PARALLEL);
        jdbcUrl = CLUSTERS.getJdbcHAUrl();
        haGroup = HighAvailabilityTestingUtility.getHighAvailibilityGroup(jdbcUrl, PROPERTIES);
        LOG.info("Initialized haGroup {} with URL {}", (Object)haGroup.getGroupInfo().getName(), (Object)jdbcUrl);
        CLUSTERS.createTableOnClusterPair(haGroup, tableName, false);
        ReplicationAdmin admin = new ReplicationAdmin(CLUSTERS.getHBaseCluster1().getConfiguration());
        admin.removePeer("1");
        ReplicationAdmin admin2 = new ReplicationAdmin(CLUSTERS.getHBaseCluster2().getConfiguration());
        admin2.removePeer("1");
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        haGroup.close();
        DriverManager.deregisterDriver((Driver)PhoenixDriver.INSTANCE);
        CLUSTERS.close();
    }

    @Before
    public void init() {
        GlobalClientMetrics.GLOBAL_HA_PARALLEL_CONNECTION_ERROR_COUNTER.getMetric().reset();
    }

    @Test
    public void testRowOnCluster1() throws SQLException {
        this.testRowOnCluster(CLUSTERS.getURL(1, haGroup.getRoleRecord().getRegistryType()));
    }

    @Test
    public void testRowOnCluster2() throws SQLException {
        this.testRowOnCluster(CLUSTERS.getURL(2, haGroup.getRoleRecord().getRegistryType()));
    }

    private void testRowOnCluster(String clusterUrl) throws SQLException {
        int id = intCounter.incrementAndGet();
        int v = 1000 + id;
        this.addRowToCluster(clusterUrl, tableName, id, v);
        this.readIdAndVerifyValue(tableName, id, v);
    }

    @Test
    public void testReadCluster1Down() throws Exception {
        int id = intCounter.incrementAndGet();
        int v = 1000 + id;
        this.addRowToCluster2(tableName, id, v);
        HighAvailabilityTestingUtility.HBaseTestingUtilityPair.doTestWhenOneHBaseDown(CLUSTERS.getHBaseCluster1(), () -> {
            CLUSTERS.logClustersStates();
            this.readIdAndVerifyValue(tableName, id, v);
            this.readNonExistentRowAndVerify(tableName, intCounter.incrementAndGet());
            this.readNonExistentRowAndVerifyErrorOnSingleNull(tableName, intCounter.incrementAndGet());
        });
    }

    @Test
    public void testReadCluster2Down() throws Exception {
        int id = intCounter.incrementAndGet();
        int v = 1000 + id;
        this.addRowToCluster1(tableName, id, v);
        HighAvailabilityTestingUtility.HBaseTestingUtilityPair.doTestWhenOneHBaseDown(CLUSTERS.getHBaseCluster2(), () -> {
            CLUSTERS.logClustersStates();
            this.readIdAndVerifyValue(tableName, id, v);
            this.readNonExistentRowAndVerify(tableName, intCounter.incrementAndGet());
            this.readNonExistentRowAndVerifyErrorOnSingleNull(tableName, intCounter.incrementAndGet());
        });
    }

    @Test
    public void testReadNonExistentRow() throws SQLException {
        this.readNonExistentRowAndVerify(tableName, intCounter.incrementAndGet());
    }

    private void addRowToCluster1(String tableName, int id, int v) throws SQLException {
        this.addRowToCluster(CLUSTERS.getURL(1, haGroup.getRoleRecord().getRegistryType()), tableName, id, v);
    }

    private void addRowToCluster2(String tableName, int id, int v) throws SQLException {
        this.addRowToCluster(CLUSTERS.getURL(2, haGroup.getRoleRecord().getRegistryType()), tableName, id, v);
    }

    private void addRowToCluster(String url, String tableName, int id, int v) throws SQLException {
        String jdbcUrl = CLUSTERS.getJdbcUrl(haGroup, url);
        try (Connection conn = DriverManager.getConnection(jdbcUrl, PROPERTIES);){
            Statement stmt = conn.createStatement();
            stmt.executeUpdate(String.format("UPSERT INTO %s VALUES(%d, %d)", tableName, id, v));
            conn.commit();
        }
    }

    private void readIdAndVerifyValue(String tableName, int id, int v) throws SQLException {
        try (Connection conn = DriverManager.getConnection(jdbcUrl, PROPERTIES);
             ResultSet rs = conn.createStatement().executeQuery(String.format(selectFormat, tableName, id));){
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)v, (long)rs.getInt(1));
            Assert.assertTrue((boolean)(rs instanceof ParallelPhoenixNullComparingResultSet));
        }
    }

    private void readNonExistentRowAndVerify(String tableName, int id) throws SQLException {
        try (Connection conn = DriverManager.getConnection(jdbcUrl, PROPERTIES);
             ResultSet rs = conn.createStatement().executeQuery(String.format(selectFormat, tableName, id));){
            Assert.assertFalse((boolean)rs.next());
            Assert.assertTrue((boolean)(rs instanceof ParallelPhoenixNullComparingResultSet));
        }
    }

    private void readNonExistentRowAndVerifyErrorOnSingleNull(String tableName, int id) throws SQLException {
        Properties props = PropertiesUtil.deepCopy((Properties)PROPERTIES);
        props.setProperty("phoenix.parallel.nullComparingRs.errorOnSingleNull", "true");
        try (Connection conn = DriverManager.getConnection(jdbcUrl, props);
             ResultSet rs = conn.createStatement().executeQuery(String.format(selectFormat, tableName, id));){
            Assert.assertTrue((boolean)(rs instanceof ParallelPhoenixNullComparingResultSet));
            try {
                rs.next();
                Assert.fail((String)"RS should've errored on single null");
            }
            catch (SQLException e) {
                LOG.debug("Exception", (Throwable)e);
                Assert.assertEquals((long)e.getErrorCode(), (long)SQLExceptionCode.HA_READ_FROM_CLUSTER_FAILED_ON_NULL.getErrorCode());
            }
        }
        Assert.assertEquals((long)1L, (long)GlobalClientMetrics.GLOBAL_HA_PARALLEL_CONNECTION_ERROR_COUNTER.getMetric().getValue());
    }
}

