/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.util.List;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.phoenix.jdbc.ClusterRoleRecord;
import org.apache.phoenix.jdbc.HAURLInfo;
import org.apache.phoenix.jdbc.HighAvailabilityGroup;
import org.apache.phoenix.jdbc.ParallelPhoenixContext;
import org.apache.phoenix.jdbc.PhoenixHAExecutorServiceProvider;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class ParallelPhoenixContextTest {
    List<PhoenixHAExecutorServiceProvider.PhoenixHAClusterExecutorServices> executorList;

    @Before
    public void init() {
        this.executorList = Lists.newArrayList((Object[])new PhoenixHAExecutorServiceProvider.PhoenixHAClusterExecutorServices[]{new PhoenixHAExecutorServiceProvider.PhoenixHAClusterExecutorServices((ExecutorService)new TrackingThreadPoolExecutor(), (ExecutorService)new TrackingThreadPoolExecutor()), new PhoenixHAExecutorServiceProvider.PhoenixHAClusterExecutorServices((ExecutorService)new TrackingThreadPoolExecutor(), (ExecutorService)new TrackingThreadPoolExecutor())});
    }

    @Test
    public void testContructionFailsWithLessThan2ThreadPools() {
        try {
            ParallelPhoenixContext context = new ParallelPhoenixContext(new Properties(), (HighAvailabilityGroup)Mockito.mock(HighAvailabilityGroup.class), (List)Lists.newArrayList((Object[])new PhoenixHAExecutorServiceProvider.PhoenixHAClusterExecutorServices[]{(PhoenixHAExecutorServiceProvider.PhoenixHAClusterExecutorServices)Mockito.mock(PhoenixHAExecutorServiceProvider.PhoenixHAClusterExecutorServices.class)}), null, (HAURLInfo)Mockito.mock(HAURLInfo.class));
            Assert.fail((String)"Should not construct with less than 2 ThreadPools");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testPool1OutOfCapacity() throws Exception {
        HighAvailabilityGroup.HAGroupInfo haGroupInfo = new HighAvailabilityGroup.HAGroupInfo("test", "test1", "test2");
        ParallelPhoenixContext context = new ParallelPhoenixContext(new Properties(), new HighAvailabilityGroup(haGroupInfo, (Properties)Mockito.mock(Properties.class), (ClusterRoleRecord)Mockito.mock(ClusterRoleRecord.class), HighAvailabilityGroup.State.READY), this.executorList, (List)Lists.newArrayList((Object[])new Boolean[]{Boolean.FALSE, Boolean.TRUE}), (HAURLInfo)Mockito.mock(HAURLInfo.class));
        CompletableFuture future1 = context.chainOnConn1(() -> true);
        Assert.assertTrue((boolean)future1.isCompletedExceptionally());
        Assert.assertEquals((long)0L, (long)((TrackingThreadPoolExecutor)this.executorList.get((int)0).getExecutorService()).tasksExecuted.get());
        Assert.assertEquals((long)0L, (long)((TrackingThreadPoolExecutor)this.executorList.get((int)1).getExecutorService()).tasksExecuted.get());
        CompletableFuture future2 = context.chainOnConn2(() -> true);
        Assert.assertTrue((boolean)((Boolean)future2.get()));
        Assert.assertEquals((long)0L, (long)((TrackingThreadPoolExecutor)this.executorList.get((int)0).getExecutorService()).tasksExecuted.get());
        Assert.assertEquals((long)1L, (long)((TrackingThreadPoolExecutor)this.executorList.get((int)1).getExecutorService()).tasksExecuted.get());
    }

    @Test
    public void testPool2OutOfCapacity() throws Exception {
        HighAvailabilityGroup.HAGroupInfo haGroupInfo = new HighAvailabilityGroup.HAGroupInfo("test", "test1", "test2");
        ParallelPhoenixContext context = new ParallelPhoenixContext(new Properties(), new HighAvailabilityGroup(haGroupInfo, (Properties)Mockito.mock(Properties.class), (ClusterRoleRecord)Mockito.mock(ClusterRoleRecord.class), HighAvailabilityGroup.State.READY), this.executorList, (List)Lists.newArrayList((Object[])new Boolean[]{Boolean.TRUE, Boolean.FALSE}), (HAURLInfo)Mockito.mock(HAURLInfo.class));
        CompletableFuture future1 = context.chainOnConn1(() -> true);
        Assert.assertTrue((boolean)((Boolean)future1.get()));
        Assert.assertEquals((long)1L, (long)((TrackingThreadPoolExecutor)this.executorList.get((int)0).getExecutorService()).tasksExecuted.get());
        Assert.assertEquals((long)0L, (long)((TrackingThreadPoolExecutor)this.executorList.get((int)1).getExecutorService()).tasksExecuted.get());
        CompletableFuture future2 = context.chainOnConn2(() -> true);
        Assert.assertTrue((boolean)future2.isCompletedExceptionally());
        Assert.assertEquals((long)1L, (long)((TrackingThreadPoolExecutor)this.executorList.get((int)0).getExecutorService()).tasksExecuted.get());
        Assert.assertEquals((long)0L, (long)((TrackingThreadPoolExecutor)this.executorList.get((int)1).getExecutorService()).tasksExecuted.get());
    }

    @Test
    public void testPoolsHaveCapacity() throws Exception {
        ParallelPhoenixContext context = new ParallelPhoenixContext(new Properties(), (HighAvailabilityGroup)Mockito.mock(HighAvailabilityGroup.class), this.executorList, (List)Lists.newArrayList((Object[])new Boolean[]{Boolean.TRUE, Boolean.TRUE}), (HAURLInfo)Mockito.mock(HAURLInfo.class));
        CompletableFuture future1 = context.chainOnConn1(() -> true);
        Assert.assertTrue((boolean)((Boolean)future1.get()));
        Assert.assertEquals((long)1L, (long)((TrackingThreadPoolExecutor)this.executorList.get((int)0).getExecutorService()).tasksExecuted.get());
        Assert.assertEquals((long)0L, (long)((TrackingThreadPoolExecutor)this.executorList.get((int)1).getExecutorService()).tasksExecuted.get());
        CompletableFuture future2 = context.chainOnConn2(() -> true);
        Assert.assertTrue((boolean)((Boolean)future2.get()));
        Assert.assertEquals((long)1L, (long)((TrackingThreadPoolExecutor)this.executorList.get((int)0).getExecutorService()).tasksExecuted.get());
        Assert.assertEquals((long)1L, (long)((TrackingThreadPoolExecutor)this.executorList.get((int)1).getExecutorService()).tasksExecuted.get());
    }

    private static class TrackingThreadPoolExecutor
    extends ThreadPoolExecutor {
        AtomicInteger tasksExecuted = new AtomicInteger();

        public TrackingThreadPoolExecutor() {
            super(1, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        }

        @Override
        public void execute(Runnable r) {
            super.execute(r);
            this.tasksExecuted.incrementAndGet();
        }
    }
}

