/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.sql.Connection;
import java.sql.Date;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.shaded.com.google.common.collect.Lists;
import org.apache.hadoop.hbase.util.VersionInfo;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.jdbc.ClusterRoleRecord;
import org.apache.phoenix.jdbc.HighAvailabilityGroup;
import org.apache.phoenix.jdbc.HighAvailabilityPolicy;
import org.apache.phoenix.jdbc.HighAvailabilityTestingUtility;
import org.apache.phoenix.jdbc.ParallelPhoenixConnectionIT;
import org.apache.phoenix.jdbc.ParallelPhoenixResultSetFactory;
import org.apache.phoenix.jdbc.PhoenixDriver;
import org.apache.phoenix.query.BaseTest;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={NeedsOwnMiniClusterTest.class})
@RunWith(value=Parameterized.class)
public class ParallelPhoenixConnectionWorkflowIT {
    private static final Logger LOG = LoggerFactory.getLogger(ParallelPhoenixConnectionIT.class);
    private static final HighAvailabilityTestingUtility.HBaseTestingUtilityPair CLUSTERS = new HighAvailabilityTestingUtility.HBaseTestingUtilityPair();
    private static final Properties GLOBAL_PROPERTIES = new Properties();
    private static final String tableName = BaseTest.generateUniqueName();
    private static final String USER_CONDITION = "USER_ID=? and USER_TYPE=? and WORK_ID=?";
    private static final String KEY_CONDITION = "USER_ID=? and USER_TYPE=? and WORK_ID=? and MY_KEY=?";
    private static final String KEY_CONDITION_FOR_BATCH_GET = "USER_ID=? and USER_TYPE=? and WORK_ID=? and MY_KEY IN ";
    private static final String KEY_CONDITION_FOR_BATCH_DELETE = "USER_ID=? and USER_TYPE=? and WORK_ID=? and MY_KEY IN ";
    private static final String UPSERT_SQL = "UPSERT INTO " + tableName + "(USER_ID, USER_TYPE, WORK_ID, MY_KEY, MY_VALUE, SIZE, NEXT_CHUNK, LOCALE, CREATED_DATE, EXPIRY_DATE) values (?,?,?,?,?,?,?,?,?,?)";
    private static final String SELECT_KEY_SQL = "SELECT EXPIRY_DATE, NEXT_CHUNK, MY_VALUE, CREATED_DATE FROM " + tableName + " WHERE " + "USER_ID=? and USER_TYPE=? and WORK_ID=? and MY_KEY=?";
    private static final String SELECT_KEY_BATCH_SQL = "SELECT EXPIRY_DATE, NEXT_CHUNK, MY_VALUE, CREATED_DATE, MY_KEY FROM " + tableName + " WHERE " + "USER_ID=? and USER_TYPE=? and WORK_ID=? and MY_KEY IN ";
    private static final String SELECT_EXISTS_KEY_SQL = "SELECT EXPIRY_DATE, CREATED_DATE FROM " + tableName + " WHERE " + "USER_ID=? and USER_TYPE=? and WORK_ID=? and MY_KEY=?";
    private static final String SELECT_USER_SQL = "SELECT MY_KEY FROM " + tableName + " WHERE " + "USER_ID=? and USER_TYPE=? and WORK_ID=?";
    private static final String DELETE_KEY_SQL = "DELETE FROM " + tableName + " WHERE " + "USER_ID=? and USER_TYPE=? and WORK_ID=? and MY_KEY=?" + " AND NEXT_CHUNK = FALSE";
    private static final String DELETE_KEY_BATCH_SQL = "DELETE FROM " + tableName + " WHERE " + "USER_ID=? and USER_TYPE=? and WORK_ID=? and MY_KEY IN ";
    private static final String DELETE_USER_SQL = "DELETE FROM " + tableName + " WHERE " + "USER_ID=? and USER_TYPE=? and WORK_ID=?";
    private static final String USER_ID = "usr000000000000001";
    private static final String WORK_ID = "workId";
    private static final Instant NOW = Instant.now();
    private static List<Connection> CONNECTIONS = null;
    @Rule
    public TestName testName = new TestName();
    private Properties clientProperties;
    private String jdbcHAUrl;
    private HighAvailabilityGroup haGroup;
    private ClusterRoleRecord.RegistryType registryType;

    @Parameterized.Parameters(name="ParallelPhoenixConnectionWorkflowIT_resultSetType={0}, registryType={1}")
    public static Collection<Object[]> data() {
        return Arrays.asList({ParallelPhoenixResultSetFactory.ParallelPhoenixResultSetType.PARALLEL_PHOENIX_RESULT_SET.getName(), ClusterRoleRecord.RegistryType.ZK}, {ParallelPhoenixResultSetFactory.ParallelPhoenixResultSetType.PARALLEL_PHOENIX_NULL_COMPARING_RESULT_SET.getName(), ClusterRoleRecord.RegistryType.ZK}, {ParallelPhoenixResultSetFactory.ParallelPhoenixResultSetType.PARALLEL_PHOENIX_RESULT_SET.getName(), ClusterRoleRecord.RegistryType.MASTER}, {ParallelPhoenixResultSetFactory.ParallelPhoenixResultSetType.PARALLEL_PHOENIX_NULL_COMPARING_RESULT_SET.getName(), ClusterRoleRecord.RegistryType.MASTER}, {ParallelPhoenixResultSetFactory.ParallelPhoenixResultSetType.PARALLEL_PHOENIX_RESULT_SET.getName(), ClusterRoleRecord.RegistryType.RPC}, {ParallelPhoenixResultSetFactory.ParallelPhoenixResultSetType.PARALLEL_PHOENIX_NULL_COMPARING_RESULT_SET.getName(), ClusterRoleRecord.RegistryType.RPC}, {ParallelPhoenixResultSetFactory.ParallelPhoenixResultSetType.PARALLEL_PHOENIX_RESULT_SET.getName(), null}, {ParallelPhoenixResultSetFactory.ParallelPhoenixResultSetType.PARALLEL_PHOENIX_NULL_COMPARING_RESULT_SET.getName(), null});
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        CLUSTERS.start();
        DriverManager.registerDriver((Driver)PhoenixDriver.INSTANCE);
        GLOBAL_PROPERTIES.setProperty("phoenix.ha.group.name", HighAvailabilityPolicy.PARALLEL.name());
        String ddl = String.format("CREATE TABLE IF NOT EXISTS %s (  \n  USER_ID CHAR(18) NOT NULL,  \n  USER_TYPE VARCHAR NOT NULL,  \n  WORK_ID VARCHAR NOT NULL,  \n  MY_KEY VARCHAR NOT NULL,  \n  MY_VALUE VARBINARY,  \n  SIZE INTEGER,\n  NEXT_CHUNK BOOLEAN,\n  LOCALE VARCHAR,  \n  CREATED_DATE DATE,\n  EXPIRY_DATE DATE,\n  CONSTRAINT PK_DATA PRIMARY KEY   \n  (  \n    USER_ID,  \n    USER_TYPE,  \n    WORK_ID,  \n    MY_KEY  \n  )  \n) IMMUTABLE_ROWS=true, VERSIONS=1, REPLICATION_SCOPE=1", tableName);
        CONNECTIONS = Lists.newArrayList((Object[])new Connection[]{ParallelPhoenixConnectionWorkflowIT.getConnection(CLUSTERS.getJdbcUrl(CLUSTERS.getZkUrl1())), ParallelPhoenixConnectionWorkflowIT.getConnection(CLUSTERS.getJdbcUrl(CLUSTERS.getZkUrl2()))});
        for (Connection conn : CONNECTIONS) {
            try (Statement statement = conn.createStatement();){
                statement.execute(ddl);
            }
            conn.commit();
        }
        CLUSTERS.checkReplicationComplete();
        try (Connection connection = ParallelPhoenixConnectionWorkflowIT.getConnection(CLUSTERS.getJdbcUrl(CLUSTERS.getZkUrl1()));){
            ParallelPhoenixConnectionWorkflowIT.loadData(connection, USER_ID, WORK_ID, 100, 20);
        }
        CLUSTERS.checkReplicationComplete();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        for (Connection conn : CONNECTIONS) {
            conn.close();
        }
        DriverManager.deregisterDriver((Driver)PhoenixDriver.INSTANCE);
        CLUSTERS.close();
    }

    private static void loadData(Connection connection, String userId, String workId, int rows, int batchSize) throws SQLException {
        Integer counter = 0;
        for (int i = 0; i < rows; ++i) {
            try (PreparedStatement ps = connection.prepareStatement(UPSERT_SQL);){
                ps.setString(1, userId);
                ps.setString(2, "USER_TYPE");
                ps.setString(3, workId);
                Integer n = counter;
                Integer n2 = counter = Integer.valueOf(counter + 1);
                ps.setString(4, String.valueOf(n));
                ps.setBytes(5, new byte[]{counter.byteValue()});
                ps.setInt(6, 1);
                ps.setBoolean(7, false);
                ps.setString(8, "US_EN");
                ps.setTimestamp(9, Timestamp.from(NOW));
                ps.setTimestamp(10, Timestamp.from(NOW.plusSeconds(3600L)));
                int result = ps.executeUpdate();
                if (result != 1) {
                    throw new RuntimeException("Phoenix error: upsert count is not one. It is " + result);
                }
            }
            if (connection.getAutoCommit() || counter % batchSize != 0) continue;
            connection.commit();
        }
        if (!connection.getAutoCommit()) {
            connection.commit();
        }
    }

    public ParallelPhoenixConnectionWorkflowIT(String resultSetType, ClusterRoleRecord.RegistryType registryType) {
        GLOBAL_PROPERTIES.setProperty("phoenix.parallel.resultSet.type", resultSetType);
        this.registryType = registryType;
    }

    @Before
    public void setup() throws Exception {
        if (this.registryType == ClusterRoleRecord.RegistryType.RPC) {
            Assume.assumeTrue((VersionInfo.compareVersion((String)VersionInfo.getVersion(), (String)"2.5.0") >= 0 ? 1 : 0) != 0);
        }
        String haGroupName = this.testName.getMethodName();
        this.clientProperties = new Properties(GLOBAL_PROPERTIES);
        this.clientProperties.setProperty("phoenix.ha.group.name", haGroupName);
        if (this.registryType == null) {
            CLUSTERS.initClusterRole(haGroupName, HighAvailabilityPolicy.PARALLEL);
        } else {
            CLUSTERS.initClusterRole(haGroupName, HighAvailabilityPolicy.PARALLEL, this.registryType);
        }
        this.jdbcHAUrl = CLUSTERS.getJdbcHAUrl();
        this.haGroup = HighAvailabilityTestingUtility.getHighAvailibilityGroup(this.jdbcHAUrl, this.clientProperties);
        LOG.info("Initialized haGroup {} with URL {}", (Object)this.haGroup.getGroupInfo().getName(), (Object)this.jdbcHAUrl);
    }

    @Test
    public void testBatchWrite() throws SQLException {
        int rowsToWrite = 100;
        String userId = StringUtils.rightPad((String)BaseTest.generateUniqueName(), (int)15).substring(0, 15);
        String workId = this.testName.getMethodName();
        Connection connection = this.getParallelConnection();
        Object object = null;
        try {
            connection.setAutoCommit(false);
            ParallelPhoenixConnectionWorkflowIT.loadData(connection, userId, workId, rowsToWrite, 20);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (connection != null) {
                if (object != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    connection.close();
                }
            }
        }
        CLUSTERS.checkReplicationComplete();
        String query = String.format("SELECT COUNT(*) FROM %s WHERE WORK_ID = '%s' AND USER_ID = '%s'", tableName, workId, userId);
        for (Connection conn : CONNECTIONS) {
            Statement statement = conn.createStatement();
            Throwable throwable = null;
            try {
                ResultSet rs = statement.executeQuery(query);
                Throwable throwable2 = null;
                try {
                    Assert.assertTrue((boolean)rs.next());
                    Assert.assertEquals((long)rowsToWrite, (long)rs.getInt(1));
                    Assert.assertFalse((boolean)rs.next());
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (rs == null) continue;
                    if (throwable2 != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    rs.close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (statement == null) continue;
                if (throwable != null) {
                    try {
                        statement.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                statement.close();
            }
        }
    }

    @Test
    public void testSinglePut() throws SQLException {
        Throwable throwable;
        String userId = StringUtils.rightPad((String)BaseTest.generateUniqueName(), (int)15).substring(0, 15);
        String workId = this.testName.getMethodName();
        try (Connection connection = this.getParallelConnection();){
            throwable = null;
            try (PreparedStatement ps = connection.prepareStatement(UPSERT_SQL);){
                ps.setString(1, userId);
                ps.setString(2, "USER_TYPE");
                ps.setString(3, workId);
                ps.setString(4, "123");
                ps.setBytes(5, userId.getBytes());
                ps.setInt(6, 1);
                ps.setBoolean(7, false);
                ps.setString(8, "LOCALE");
                Instant now = Instant.now();
                ps.setTimestamp(9, Timestamp.from(now));
                ps.setTimestamp(10, Timestamp.from(now.plusSeconds(3600L)));
                int result = ps.executeUpdate();
                Assert.assertEquals((long)1L, (long)result);
            }
            catch (Throwable now) {
                throwable = now;
                throw now;
            }
        }
        CLUSTERS.checkReplicationComplete();
        for (Connection conn : CONNECTIONS) {
            Statement statement = conn.createStatement();
            throwable = null;
            try {
                ResultSet rs = statement.executeQuery(String.format("SELECT * FROM %s WHERE WORK_ID = '%s' AND USER_ID = '%s'", tableName, workId, userId));
                Throwable throwable2 = null;
                try {
                    Assert.assertTrue((boolean)rs.next());
                    Assert.assertEquals((Object)"123", (Object)rs.getString(4));
                    Assert.assertFalse((boolean)rs.next());
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (rs == null) continue;
                    if (throwable2 != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    rs.close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (statement == null) continue;
                if (throwable != null) {
                    try {
                        statement.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                statement.close();
            }
        }
    }

    @Test
    public void testSingleDelete() throws SQLException {
        Throwable throwable;
        Throwable throwable2;
        Statement statement;
        String userId = StringUtils.rightPad((String)BaseTest.generateUniqueName(), (int)15).substring(0, 15);
        String workId = this.testName.getMethodName();
        ParallelPhoenixConnectionWorkflowIT.loadData(CLUSTERS.getCluster1Connection(this.haGroup), userId, workId, 10, 10);
        CLUSTERS.checkReplicationComplete();
        for (Connection connection : CONNECTIONS) {
            statement = connection.createStatement();
            throwable2 = null;
            try {
                ResultSet rs = statement.executeQuery(String.format("SELECT COUNT(*) FROM %s WHERE USER_ID='%s'", tableName, userId));
                throwable = null;
                try {
                    Assert.assertTrue((boolean)rs.next());
                    Assert.assertEquals((long)10L, (long)rs.getInt(1));
                    Assert.assertFalse((boolean)rs.next());
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                finally {
                    if (rs == null) continue;
                    if (throwable != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        continue;
                    }
                    rs.close();
                }
            }
            catch (Throwable rs) {
                throwable2 = rs;
                throw rs;
            }
            finally {
                if (statement == null) continue;
                if (throwable2 != null) {
                    try {
                        statement.close();
                    }
                    catch (Throwable rs) {
                        throwable2.addSuppressed(rs);
                    }
                    continue;
                }
                statement.close();
            }
        }
        Throwable throwable4 = null;
        try (Connection connection = this.getParallelConnection();){
            throwable2 = null;
            try (PreparedStatement statement2 = connection.prepareStatement(DELETE_KEY_SQL);){
                statement2.setString(1, userId);
                statement2.setString(2, "USER_TYPE");
                statement2.setString(3, workId);
                statement2.setString(4, String.valueOf(1));
                int result = statement2.executeUpdate();
                Assert.assertEquals((long)1L, (long)result);
            }
            catch (Throwable result) {
                throwable2 = result;
                throw result;
            }
        }
        catch (Throwable statement2) {
            Throwable throwable5 = statement2;
            throw statement2;
        }
        CLUSTERS.checkReplicationComplete();
        for (Connection connection : CONNECTIONS) {
            statement = connection.createStatement();
            throwable2 = null;
            try {
                ResultSet rs = statement.executeQuery(String.format("SELECT COUNT(*) FROM %s WHERE USER_ID='%s'", tableName, userId));
                throwable = null;
                try {
                    Assert.assertTrue((boolean)rs.next());
                    Assert.assertEquals((long)9L, (long)rs.getInt(1));
                    Assert.assertFalse((boolean)rs.next());
                }
                catch (Throwable throwable6) {
                    throwable = throwable6;
                    throw throwable6;
                }
                finally {
                    if (rs == null) continue;
                    if (throwable != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable7) {
                            throwable.addSuppressed(throwable7);
                        }
                        continue;
                    }
                    rs.close();
                }
            }
            catch (Throwable throwable8) {
                throwable2 = throwable8;
                throw throwable8;
            }
            finally {
                if (statement == null) continue;
                if (throwable2 != null) {
                    try {
                        statement.close();
                    }
                    catch (Throwable throwable9) {
                        throwable2.addSuppressed(throwable9);
                    }
                    continue;
                }
                statement.close();
            }
        }
    }

    @Test
    public void testBatchDelete() throws SQLException {
        Throwable throwable;
        Statement statement;
        String userId = StringUtils.rightPad((String)BaseTest.generateUniqueName(), (int)15).substring(0, 15);
        String workId = this.testName.getMethodName();
        ParallelPhoenixConnectionWorkflowIT.loadData(CLUSTERS.getCluster1Connection(this.haGroup), userId, workId, 10, 10);
        CLUSTERS.checkReplicationComplete();
        try (Connection connection = this.getParallelConnection();){
            statement = connection.prepareStatement(DELETE_KEY_BATCH_SQL + "(?,?,?,?,?)");
            throwable = null;
            try {
                statement.setString(1, userId);
                statement.setString(2, "USER_TYPE");
                statement.setString(3, workId);
                statement.setString(4, String.valueOf(1));
                statement.setString(5, String.valueOf(2));
                statement.setString(6, String.valueOf(3));
                statement.setString(7, String.valueOf(4));
                statement.setString(8, String.valueOf(5));
                statement.executeUpdate();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (statement != null) {
                    if (throwable != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        statement.close();
                    }
                }
            }
        }
        CLUSTERS.checkReplicationComplete();
        for (Connection conn : CONNECTIONS) {
            statement = conn.createStatement();
            throwable = null;
            try {
                ResultSet rs = statement.executeQuery(String.format("SELECT COUNT(*) FROM %s WHERE USER_ID='%s'", tableName, userId));
                Throwable throwable4 = null;
                try {
                    Assert.assertTrue((boolean)rs.next());
                    Assert.assertEquals((long)5L, (long)rs.getInt(1));
                    Assert.assertFalse((boolean)rs.next());
                }
                catch (Throwable throwable5) {
                    throwable4 = throwable5;
                    throw throwable5;
                }
                finally {
                    if (rs == null) continue;
                    if (throwable4 != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable6) {
                            throwable4.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    rs.close();
                }
            }
            catch (Throwable throwable7) {
                throwable = throwable7;
                throw throwable7;
            }
            finally {
                if (statement == null) continue;
                if (throwable != null) {
                    try {
                        statement.close();
                    }
                    catch (Throwable throwable8) {
                        throwable.addSuppressed(throwable8);
                    }
                    continue;
                }
                statement.close();
            }
        }
    }

    @Test
    public void testGroupDelete() throws SQLException {
        Throwable throwable;
        Statement statement;
        String userId = StringUtils.rightPad((String)BaseTest.generateUniqueName(), (int)15).substring(0, 15);
        String workId1 = this.testName.getMethodName();
        ParallelPhoenixConnectionWorkflowIT.loadData(CLUSTERS.getCluster1Connection(this.haGroup), userId, workId1, 10, 10);
        String workId2 = this.testName.getMethodName() + "2";
        ParallelPhoenixConnectionWorkflowIT.loadData(CLUSTERS.getCluster1Connection(this.haGroup), userId, workId2, 10, 10);
        CLUSTERS.checkReplicationComplete();
        try (Connection connection = this.getParallelConnection();){
            statement = connection.prepareStatement(DELETE_USER_SQL);
            throwable = null;
            try {
                statement.setString(1, userId);
                statement.setString(2, "USER_TYPE");
                statement.setString(3, workId2);
                int n = statement.executeUpdate();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (statement != null) {
                    if (throwable != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        statement.close();
                    }
                }
            }
        }
        CLUSTERS.checkReplicationComplete();
        for (Connection conn : CONNECTIONS) {
            statement = conn.createStatement();
            throwable = null;
            try {
                ResultSet rs = statement.executeQuery(String.format("SELECT COUNT(*) FROM %s WHERE USER_ID='%s'", tableName, userId));
                Throwable throwable4 = null;
                try {
                    Assert.assertTrue((boolean)rs.next());
                    Assert.assertEquals((long)10L, (long)rs.getInt(1));
                    Assert.assertFalse((boolean)rs.next());
                }
                catch (Throwable throwable5) {
                    throwable4 = throwable5;
                    throw throwable5;
                }
                finally {
                    if (rs == null) continue;
                    if (throwable4 != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable6) {
                            throwable4.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    rs.close();
                }
            }
            catch (Throwable throwable7) {
                throwable = throwable7;
                throw throwable7;
            }
            finally {
                if (statement == null) continue;
                if (throwable != null) {
                    try {
                        statement.close();
                    }
                    catch (Throwable throwable8) {
                        throwable.addSuppressed(throwable8);
                    }
                    continue;
                }
                statement.close();
            }
        }
    }

    @Test
    public void testGetKey() throws SQLException {
        try (Connection conn = this.getParallelConnection();
             PreparedStatement statement = conn.prepareStatement(SELECT_KEY_SQL);){
            statement.setString(1, USER_ID);
            statement.setString(2, "USER_TYPE");
            statement.setString(3, WORK_ID);
            statement.setString(4, "3");
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertArrayEquals((byte[])new byte[]{Integer.valueOf(4).byteValue()}, (byte[])rs.getBytes(3));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testKeyExists() throws SQLException {
        try (Connection conn = this.getParallelConnection();
             PreparedStatement statement = conn.prepareStatement(SELECT_EXISTS_KEY_SQL);){
            statement.setString(1, USER_ID);
            statement.setString(2, "USER_TYPE");
            statement.setString(3, WORK_ID);
            statement.setString(4, "3");
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Date expiryDate = rs.getDate("EXPIRY_DATE");
            Assert.assertEquals((Object)Date.from(NOW.plusSeconds(3600L)), (Object)expiryDate);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testGetKeysBatch() throws SQLException {
        try (Connection conn = this.getParallelConnection();
             PreparedStatement statement = conn.prepareStatement(SELECT_KEY_BATCH_SQL + "(?,?,?)");){
            statement.setString(1, USER_ID);
            statement.setString(2, "USER_TYPE");
            statement.setString(3, WORK_ID);
            statement.setString(4, "3");
            statement.setString(5, "6");
            statement.setString(6, "71");
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertArrayEquals((byte[])new byte[]{Integer.valueOf(4).byteValue()}, (byte[])rs.getBytes(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertArrayEquals((byte[])new byte[]{Integer.valueOf(7).byteValue()}, (byte[])rs.getBytes(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertArrayEquals((byte[])new byte[]{Integer.valueOf(72).byteValue()}, (byte[])rs.getBytes(3));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testGetAllKeys() throws SQLException {
        try (Connection conn = this.getParallelConnection();
             PreparedStatement statement = conn.prepareStatement(SELECT_USER_SQL);){
            statement.setString(1, USER_ID);
            statement.setString(2, "USER_TYPE");
            statement.setString(3, WORK_ID);
            ResultSet rs = statement.executeQuery();
            ArrayList keys = Lists.newArrayListWithCapacity((int)100);
            for (int i = 0; i < 100; ++i) {
                keys.add(String.valueOf(i));
            }
            keys.sort(String::compareTo);
            for (String key : keys) {
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)key, (Object)rs.getString(1));
            }
            Assert.assertFalse((boolean)rs.next());
        }
    }

    private Connection getParallelConnection() throws SQLException {
        Connection connection = DriverManager.getConnection(this.jdbcHAUrl, this.clientProperties);
        connection.setAutoCommit(true);
        return connection;
    }

    private static Connection getConnection(String url) throws SQLException {
        return DriverManager.getConnection(url, new Properties());
    }
}

